/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotManager;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSnapshotManager
extends TableTestBase {
    static final DataFile REPLACEMENT_FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a-replacement.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();
    static final DataFile CONFLICT_FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a-conflict.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSnapshotManager(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testCherryPickDynamicOverwrite() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((ReplacePartitions)this.table.newReplacePartitions().addFile(REPLACEMENT_FILE_A).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)this.table.snapshots());
        Assert.assertEquals((String)"Should find the staged overwrite snapshot", (Object)"overwrite", (Object)staged.operation());
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().cherrypick(staged.snapshotId()).commit();
        Assert.assertNotEquals((String)"Should not fast-forward", (long)staged.snapshotId(), (long)this.table.currentSnapshot().snapshotId());
        this.validateTableFiles((Table)this.table, FILE_B, REPLACEMENT_FILE_A);
    }

    @Test
    public void testCherryPickDynamicOverwriteWithoutParent() {
        Assert.assertNull((String)"Table should not have a current snapshot", (Object)this.table.currentSnapshot());
        ((ReplacePartitions)this.table.newReplacePartitions().addFile(REPLACEMENT_FILE_A).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)this.table.snapshots());
        Assert.assertEquals((String)"Should find the staged overwrite snapshot", (Object)"overwrite", (Object)staged.operation());
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().cherrypick(staged.snapshotId()).commit();
        Assert.assertNotEquals((String)"Should not fast-forward", (long)staged.snapshotId(), (long)this.table.currentSnapshot().snapshotId());
        this.validateTableFiles((Table)this.table, FILE_B, REPLACEMENT_FILE_A);
    }

    @Test
    public void testCherryPickDynamicOverwriteConflict() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((ReplacePartitions)this.table.newReplacePartitions().addFile(REPLACEMENT_FILE_A).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)this.table.snapshots());
        Assert.assertEquals((String)"Should find the staged overwrite snapshot", (Object)"overwrite", (Object)staged.operation());
        this.table.newAppend().appendFile(CONFLICT_FILE_A).commit();
        long lastSnapshotId = this.table.currentSnapshot().snapshotId();
        AssertHelpers.assertThrows((String)"Should reject partition replacement when a partition has been modified", ValidationException.class, (String)"Cannot cherry-pick replace partitions with changed partition", () -> this.table.manageSnapshots().cherrypick(staged.snapshotId()).commit());
        Assert.assertEquals((String)"Failed cherry-pick should not change the table state", (long)lastSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        this.validateTableFiles((Table)this.table, FILE_A, CONFLICT_FILE_A);
    }

    @Test
    public void testCherryPickDynamicOverwriteDeleteConflict() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((ReplacePartitions)this.table.newReplacePartitions().addFile(REPLACEMENT_FILE_A).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)this.table.snapshots());
        Assert.assertEquals((String)"Should find the staged overwrite snapshot", (Object)"overwrite", (Object)staged.operation());
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newDelete().deleteFile(FILE_A).commit();
        long lastSnapshotId = this.table.currentSnapshot().snapshotId();
        AssertHelpers.assertThrows((String)"Should reject partition replacement when a partition has been modified", ValidationException.class, (String)"Missing required files to delete", () -> this.table.manageSnapshots().cherrypick(staged.snapshotId()).commit());
        Assert.assertEquals((String)"Failed cherry-pick should not change the table state", (long)lastSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        this.validateTableFiles((Table)this.table, FILE_B);
    }

    @Test
    public void testCherryPickFromBranch() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long branchSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newReplacePartitions().addFile(REPLACEMENT_FILE_A).commit();
        long replaceSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().rollbackTo(branchSnapshotId).commit();
        long lastSnapshotId = this.table.currentSnapshot().snapshotId();
        AssertHelpers.assertThrows((String)"Should reject partition replacement when a partition has been modified", ValidationException.class, (String)"Cannot cherry-pick overwrite not based on an ancestor of the current state", () -> this.table.manageSnapshots().cherrypick(replaceSnapshotId).commit());
        Assert.assertEquals((String)"Failed cherry-pick should not change the table state", (long)lastSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        this.validateTableFiles((Table)this.table, FILE_A);
    }

    @Test
    public void testCherryPickOverwrite() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((OverwriteFiles)this.table.newOverwrite().deleteFile(FILE_A).addFile(REPLACEMENT_FILE_A).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)this.table.snapshots());
        Assert.assertEquals((String)"Should find the staged overwrite snapshot", (Object)"overwrite", (Object)staged.operation());
        this.table.newAppend().appendFile(FILE_B).commit();
        long lastSnapshotId = this.table.currentSnapshot().snapshotId();
        AssertHelpers.assertThrows((String)"Should reject partition replacement when a partition has been modified", ValidationException.class, (String)"not append, dynamic overwrite, or fast-forward", () -> this.table.manageSnapshots().cherrypick(staged.snapshotId()).commit());
        Assert.assertEquals((String)"Failed cherry-pick should not change the table state", (long)lastSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        this.validateTableFiles((Table)this.table, FILE_A, FILE_B);
    }

    @Test
    public void testCreateBranch() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createBranch("branch1", snapshotId).commit();
        SnapshotRef expectedBranch = this.table.ops().refresh().ref("branch1");
        Assert.assertTrue((expectedBranch != null && expectedBranch.equals((Object)SnapshotRef.branchBuilder((long)snapshotId).build()) ? 1 : 0) != 0);
    }

    @Test
    public void testCreateBranchFailsWhenRefAlreadyExists() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createBranch("branch1", snapshotId).commit();
        AssertHelpers.assertThrows((String)"Creating branch which already exists should fail", IllegalArgumentException.class, (String)"Ref branch1 already exists", () -> this.table.manageSnapshots().createBranch("branch1", snapshotId).commit());
        AssertHelpers.assertThrows((String)"Creating branch which already exists should fail", IllegalArgumentException.class, (String)"Ref branch2 already exists", () -> this.table.manageSnapshots().createBranch("branch2", snapshotId).createBranch("branch2", snapshotId).commit());
    }

    @Test
    public void testCreateTag() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createTag("tag1", snapshotId).commit();
        SnapshotRef expectedTag = this.table.ops().refresh().ref("tag1");
        Assert.assertTrue((expectedTag != null && expectedTag.equals((Object)SnapshotRef.tagBuilder((long)snapshotId).build()) ? 1 : 0) != 0);
    }

    @Test
    public void testCreateTagFailsWhenRefAlreadyExists() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createTag("tag1", snapshotId).commit();
        AssertHelpers.assertThrows((String)"Creating tag which already exists should fail", IllegalArgumentException.class, (String)"Ref tag1 already exists", () -> this.table.manageSnapshots().createTag("tag1", snapshotId).commit());
        AssertHelpers.assertThrows((String)"Creating branch which already exists should fail", IllegalArgumentException.class, (String)"Ref tag2 already exists", () -> this.table.manageSnapshots().createTag("tag2", snapshotId).createTag("tag2", snapshotId).commit());
    }

    @Test
    public void testRemoveBranch() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createBranch("branch1", snapshotId).commit();
        this.table.manageSnapshots().removeBranch("branch1").commit();
        TableMetadata updated = this.table.ops().refresh();
        SnapshotRef expectedBranch = updated.ref("branch1");
        Assert.assertNull((Object)expectedBranch);
        this.table.manageSnapshots().createBranch("branch2", snapshotId).removeBranch("branch2").commit();
        updated = this.table.ops().refresh();
        Assert.assertNull((Object)updated.ref("branch2"));
    }

    @Test
    public void testRemovingNonExistingBranchFails() {
        AssertHelpers.assertThrows((String)"Trying to remove non-existent branch should fail", IllegalArgumentException.class, (String)"Branch does not exist: non-existing", () -> this.table.manageSnapshots().removeBranch("non-existing").commit());
    }

    @Test
    public void testRemovingMainBranchFails() {
        AssertHelpers.assertThrows((String)"Removing main should fail", IllegalArgumentException.class, (String)"Cannot remove main branch", () -> this.table.manageSnapshots().removeBranch("main").commit());
    }

    @Test
    public void testRemoveTag() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createTag("tag1", snapshotId).commit();
        this.table.manageSnapshots().removeTag("tag1").commit();
        TableMetadata updated = this.table.ops().refresh();
        SnapshotRef expectedTag = updated.ref("tag1");
        Assert.assertNull((Object)expectedTag);
        this.table.manageSnapshots().createTag("tag2", snapshotId).removeTag("tag2").commit();
        Assert.assertEquals((Object)updated, (Object)this.table.ops().refresh());
        Assert.assertNull((Object)updated.ref("tag2"));
    }

    @Test
    public void testRemovingNonExistingTagFails() {
        AssertHelpers.assertThrows((String)"Removing a non-existing tag should fail", IllegalArgumentException.class, (String)"Tag does not exist: non-existing", () -> this.table.manageSnapshots().removeTag("non-existing").commit());
    }

    @Test
    public void testReplaceBranch() {
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_A).set("wap.id", "123")).stageOnly()).commit();
        Snapshot firstSnapshot = (Snapshot)Iterables.getOnlyElement((Iterable)this.table.snapshots());
        this.table.manageSnapshots().createBranch("branch1", firstSnapshot.snapshotId()).commit();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "456")).stageOnly()).commit();
        Snapshot secondSnapshot = (Snapshot)Iterables.get((Iterable)this.table.snapshots(), (int)1);
        this.table.manageSnapshots().createBranch("branch2", secondSnapshot.snapshotId()).commit();
        this.table.manageSnapshots().replaceBranch("branch1", "branch2").commit();
        Assert.assertEquals((long)this.table.ops().refresh().ref("branch1").snapshotId(), (long)secondSnapshot.snapshotId());
    }

    @Test
    public void testReplaceBranchNonExistingTargetBranchFails() {
        AssertHelpers.assertThrows((String)"Replacing a non-existing branch should fail", IllegalArgumentException.class, (String)"Target branch does not exist: non-existing", () -> this.table.manageSnapshots().replaceBranch("non-existing", "other-branch").commit());
    }

    @Test
    public void testReplaceBranchNonExistingSourceFails() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createBranch("branch1", snapshotId).commit();
        AssertHelpers.assertThrows((String)"Replacing where the source ref does not exist should fail", IllegalArgumentException.class, (String)"Ref does not exist: non-existing", () -> this.table.manageSnapshots().replaceBranch("branch1", "non-existing").commit());
    }

    @Test
    public void testFastForward() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        Assert.assertEquals((long)this.table.currentSnapshot().snapshotId(), (long)1L);
        this.table.manageSnapshots().createBranch("new-branch-at-staged-snapshot", 2L).commit();
        this.table.manageSnapshots().fastForwardBranch("main", "new-branch-at-staged-snapshot").commit();
        Assert.assertEquals((long)this.table.currentSnapshot().snapshotId(), (long)2L);
    }

    @Test
    public void testFastForwardWhenTargetIsNotAncestorFails() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((AppendFiles)((AppendFiles)this.table.newAppend().appendFile(FILE_B).set("wap.id", "123456789")).stageOnly()).commit();
        long snapshot = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_C).commit();
        String newBranch = "new-branch-at-staged-snapshot";
        this.table.manageSnapshots().createBranch("new-branch-at-staged-snapshot", snapshot).commit();
        AssertHelpers.assertThrows((String)"Fast-forward should fail if target is not an ancestor of the source", IllegalArgumentException.class, (String)"Cannot fast-forward: main is not an ancestor of new-branch-at-staged-snapshot", () -> this.table.manageSnapshots().fastForwardBranch("main", "new-branch-at-staged-snapshot").commit());
    }

    @Test
    public void testReplaceTag() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createTag("tag1", snapshotId).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        long currentSnapshot = this.table.ops().refresh().currentSnapshot().snapshotId();
        this.table.manageSnapshots().replaceTag("tag1", currentSnapshot).commit();
        Assert.assertEquals((long)this.table.ops().refresh().ref("tag1").snapshotId(), (long)currentSnapshot);
    }

    @Test
    public void testUpdatingBranchRetention() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createBranch("branch1", snapshotId).commit();
        this.table.manageSnapshots().setMinSnapshotsToKeep("branch1", 10).setMaxSnapshotAgeMs("branch1", 20000L).commit();
        TableMetadata updated = this.table.ops().refresh();
        Assert.assertEquals((long)20000L, (long)updated.ref("branch1").maxSnapshotAgeMs());
        Assert.assertEquals((long)10L, (long)updated.ref("branch1").minSnapshotsToKeep().intValue());
        this.table.manageSnapshots().createBranch("branch2", snapshotId).setMinSnapshotsToKeep("branch2", 10).setMaxSnapshotAgeMs("branch2", 20000L).commit();
        updated = this.table.ops().refresh();
        Assert.assertEquals((long)20000L, (long)updated.ref("branch2").maxSnapshotAgeMs());
        Assert.assertEquals((long)10L, (long)updated.ref("branch2").minSnapshotsToKeep().intValue());
    }

    @Test
    public void testSettingBranchRetentionOnTagFails() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        AssertHelpers.assertThrows((String)"Setting minSnapshotsToKeep should fail for tags", IllegalArgumentException.class, (String)"Tags do not support setting minSnapshotsToKeep", () -> this.table.manageSnapshots().createTag("tag1", snapshotId).setMinSnapshotsToKeep("tag1", 10).commit());
        AssertHelpers.assertThrows((String)"Setting maxSnapshotAgeMs should fail for tags", IllegalArgumentException.class, (String)"Tags do not support setting maxSnapshotAgeMs", () -> this.table.manageSnapshots().createTag("tag1", snapshotId).setMaxSnapshotAgeMs("tag1", 10L).commit());
    }

    @Test
    public void testUpdatingBranchMaxRefAge() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        long maxRefAgeMs = 10000L;
        this.table.manageSnapshots().createBranch("branch1", snapshotId).commit();
        this.table.manageSnapshots().setMaxRefAgeMs("branch1", 10000L).commit();
        TableMetadata updated = this.table.ops().refresh();
        Assert.assertEquals((long)10000L, (long)updated.ref("branch1").maxRefAgeMs());
        Assert.assertEquals((long)10000L, (long)updated.ref("branch1").maxRefAgeMs());
    }

    @Test
    public void testUpdatingTagMaxRefAge() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        long maxRefAgeMs = 10000L;
        this.table.manageSnapshots().createTag("tag1", snapshotId).commit();
        this.table.manageSnapshots().setMaxRefAgeMs("tag1", 10000L).commit();
        TableMetadata updated = this.table.ops().refresh();
        Assert.assertEquals((long)10000L, (long)updated.ref("tag1").maxRefAgeMs());
        this.table.manageSnapshots().createTag("tag2", snapshotId).setMaxRefAgeMs("tag2", 10000L).commit();
        updated = this.table.ops().refresh();
        Assert.assertEquals((long)10000L, (long)updated.ref("tag2").maxRefAgeMs());
    }

    @Test
    public void testRenameBranch() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createBranch("branch1", snapshotId).commit();
        this.table.manageSnapshots().renameBranch("branch1", "branch2").commit();
        TableMetadata updated = this.table.ops().refresh();
        Assert.assertNull((Object)updated.ref("branch1"));
        Assert.assertEquals((Object)updated.ref("branch2"), (Object)SnapshotRef.branchBuilder((long)snapshotId).build());
        this.table.manageSnapshots().createBranch("branch3", snapshotId).renameBranch("branch3", "branch4").commit();
        updated = this.table.ops().refresh();
        Assert.assertNull((Object)updated.ref("branch3"));
        Assert.assertEquals((Object)updated.ref("branch4"), (Object)SnapshotRef.branchBuilder((long)snapshotId).build());
    }

    @Test
    public void testFailRenamingMainBranch() {
        AssertHelpers.assertThrows((String)"Renaming main branch should fail", IllegalArgumentException.class, (String)"Cannot rename main branch", () -> this.table.manageSnapshots().renameBranch("main", "some-branch").commit());
    }

    @Test
    public void testRenamingNonExistingBranchFails() {
        AssertHelpers.assertThrows((String)"Renaming non-existent branch should fail", IllegalArgumentException.class, (String)"Branch does not exist: some-missing-branch", () -> this.table.manageSnapshots().renameBranch("some-missing-branch", "some-branch").commit());
    }

    @Test
    public void testCreateReferencesAndRollback() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotPriorToRollback = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createBranch("branch1", snapshotPriorToRollback).createTag("tag1", snapshotPriorToRollback).rollbackTo(1L).commit();
        TableMetadata current = this.table.ops().current();
        Assert.assertEquals((long)current.currentSnapshot().snapshotId(), (long)1L);
        SnapshotRef actualTag = current.ref("tag1");
        SnapshotRef actualBranch = current.ref("branch1");
        Assert.assertEquals((long)1L, (long)current.currentSnapshot().snapshotId());
        Assert.assertEquals((Object)SnapshotRef.branchBuilder((long)snapshotPriorToRollback).build(), (Object)actualBranch);
        Assert.assertEquals((Object)SnapshotRef.tagBuilder((long)snapshotPriorToRollback).build(), (Object)actualTag);
    }

    @Test
    public void testCreateReferencesAndCherrypick() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long currentSnapshot = this.table.currentSnapshot().snapshotId();
        ((ReplacePartitions)this.table.newReplacePartitions().addFile(REPLACEMENT_FILE_A).stageOnly()).commit();
        Snapshot staged = (Snapshot)Iterables.getLast((Iterable)this.table.snapshots());
        this.table.manageSnapshots().createBranch("branch1", currentSnapshot).createTag("tag1", currentSnapshot).cherrypick(staged.snapshotId()).commit();
        TableMetadata current = this.table.ops().current();
        Assert.assertEquals((long)current.currentSnapshot().snapshotId(), (long)2L);
        SnapshotRef actualTag = current.ref("tag1");
        SnapshotRef actualBranch = current.ref("branch1");
        Assert.assertEquals((long)2L, (long)current.currentSnapshot().snapshotId());
        Assert.assertEquals((Object)SnapshotRef.branchBuilder((long)1L).build(), (Object)actualBranch);
        Assert.assertEquals((Object)SnapshotRef.tagBuilder((long)1L).build(), (Object)actualTag);
    }

    @Test
    public void testAttemptToRollbackToCurrentSnapshot() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long currentSnapshotTimestampPlus100 = this.table.currentSnapshot().timestampMillis() + 100L;
        this.table.manageSnapshots().rollbackToTime(currentSnapshotTimestampPlus100).commit();
        long currentSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().rollbackTo(currentSnapshotId).commit();
    }

    @Test
    public void testSnapshotManagerThroughTransaction() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot snapshotAfterFirstAppend = this.readMetadata().currentSnapshot();
        this.validateSnapshot(null, snapshotAfterFirstAppend, FILE_A);
        this.table.newAppend().appendFile(FILE_B).commit();
        this.validateSnapshot(snapshotAfterFirstAppend, this.readMetadata().currentSnapshot(), FILE_B);
        Assert.assertEquals((String)"Table should be on version 2 after appending twice", (long)2L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        Assert.assertSame((String)"Base metadata should not change when transaction is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 2 after creating transaction", (long)2L, (long)this.version().intValue());
        ManageSnapshots manageSnapshots = txn.manageSnapshots();
        Assert.assertNotNull((Object)manageSnapshots);
        Assert.assertSame((String)"Base metadata should not change when manageSnapshots is created", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 2 after creating manageSnapshots", (long)2L, (long)this.version().intValue());
        manageSnapshots.rollbackTo(snapshotAfterFirstAppend.snapshotId()).commit();
        Assert.assertSame((String)"Base metadata should not change when invoking rollbackTo", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should be on version 2 after invoking rollbackTo", (long)2L, (long)this.version().intValue());
        txn.commitTransaction();
        Assert.assertEquals((Object)snapshotAfterFirstAppend, (Object)this.readMetadata().currentSnapshot());
        this.validateSnapshot(null, snapshotAfterFirstAppend, FILE_A);
        Assert.assertEquals((String)"Table should be on version 3 after invoking rollbackTo", (long)3L, (long)this.version().intValue());
    }

    @Test
    public void testSnapshotManagerThroughTransactionMultiOperation() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot snapshotAfterFirstAppend = this.readMetadata().currentSnapshot();
        this.validateSnapshot(null, snapshotAfterFirstAppend, FILE_A);
        this.table.newAppend().appendFile(FILE_B).commit();
        this.validateSnapshot(snapshotAfterFirstAppend, this.readMetadata().currentSnapshot(), FILE_B);
        Assert.assertEquals((String)"Table should be on version 2 after appending twice", (long)2L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction txn = this.table.newTransaction();
        txn.manageSnapshots().rollbackTo(snapshotAfterFirstAppend.snapshotId()).commit();
        txn.updateProperties().set("some_prop", "some_prop_value").commit();
        Assert.assertSame((String)"Base metadata should not change when transaction is not committed", (Object)base, (Object)this.readMetadata());
        Assert.assertEquals((String)"Table should remain on version 2 when transaction is not committed", (long)2L, (long)this.version().intValue());
        txn.commitTransaction();
        Assert.assertEquals((Object)snapshotAfterFirstAppend, (Object)this.readMetadata().currentSnapshot());
        Assert.assertEquals((String)"Table should be on version 3 after invoking rollbackTo", (long)3L, (long)this.version().intValue());
    }

    @Test
    public void testSnapshotManagerInvalidParameters() throws Exception {
        Assert.assertThrows((String)"Incorrect input transaction: null", IllegalArgumentException.class, () -> new SnapshotManager(null));
    }
}

