/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.SerializableSupplier;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestSnapshotLoading
extends TableTestBase {
    private Snapshot currentSnapshot;
    private List<Snapshot> allSnapshots;
    private TableMetadata originalTableMetadata;
    private TableMetadata latestTableMetadata;
    private SerializableSupplier<List<Snapshot>> snapshotsSupplierMock;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSnapshotLoading(int formatVersion) {
        super(formatVersion);
    }

    @Before
    public void before() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        this.currentSnapshot = this.table.currentSnapshot();
        this.allSnapshots = Lists.newArrayList((Iterable)this.table.snapshots());
        SerializableSupplier<List<Snapshot>> snapshotSupplier = new SerializableSupplier<List<Snapshot>>(){

            public List<Snapshot> get() {
                return TestSnapshotLoading.this.allSnapshots;
            }
        };
        this.snapshotsSupplierMock = (SerializableSupplier)Mockito.spy((Object)snapshotSupplier);
        this.originalTableMetadata = this.table.ops().current();
        this.latestTableMetadata = TableMetadata.buildFrom((TableMetadata)this.originalTableMetadata).removeSnapshots(this.allSnapshots.stream().filter(Predicate.isEqual(this.currentSnapshot).negate()).collect(Collectors.toList())).setSnapshotsSupplier(this.snapshotsSupplierMock).discardChanges().build();
    }

    @Test
    public void testSnapshotsAreLoadedOnce() {
        this.latestTableMetadata.snapshots();
        this.latestTableMetadata.snapshots();
        this.latestTableMetadata.snapshots();
        ((SerializableSupplier)Mockito.verify(this.snapshotsSupplierMock, (VerificationMode)Mockito.times((int)1))).get();
        Assertions.assertThat((List)this.latestTableMetadata.snapshots()).containsExactlyElementsOf((Iterable)this.originalTableMetadata.snapshots());
    }

    @Test
    public void testCurrentAndMainSnapshotDoesNotLoad() {
        this.latestTableMetadata.currentSnapshot();
        this.latestTableMetadata.snapshot(this.latestTableMetadata.ref("main").snapshotId());
        ((SerializableSupplier)Mockito.verify(this.snapshotsSupplierMock, (VerificationMode)Mockito.times((int)0))).get();
    }

    @Test
    public void testUnloadedSnapshotLoadsOnce() {
        Snapshot unloadedSnapshot = this.allSnapshots.stream().filter(s -> !s.equals(this.currentSnapshot)).findFirst().get();
        this.latestTableMetadata.snapshot(unloadedSnapshot.snapshotId());
        this.latestTableMetadata.snapshot(unloadedSnapshot.snapshotId());
        ((SerializableSupplier)Mockito.verify(this.snapshotsSupplierMock, (VerificationMode)Mockito.times((int)1))).get();
    }

    @Test
    public void testCurrentTableScanDoesNotLoad() {
        this.latestTableMetadata.currentSnapshot();
        BaseTable latestTable = new BaseTable((TableOperations)new MetadataTableOperations(this.table.io(), this.latestTableMetadata), "latestTable");
        latestTable.newScan().planFiles().forEach(t -> {});
        ((SerializableSupplier)Mockito.verify(this.snapshotsSupplierMock, (VerificationMode)Mockito.times((int)0))).get();
    }

    @Test
    public void testFutureSnapshotsAreRemoved() {
        ((AbstractIntegerAssert)Assumptions.assumeThat((int)this.formatVersion).as("Future snapshots are only removed for V2 tables", new Object[0])).isGreaterThan(1);
        this.table.newFastAppend().appendFile(FILE_C).commit();
        TableMetadata futureTableMetadata = TableMetadata.buildFrom((TableMetadata)this.originalTableMetadata).removeSnapshots(this.allSnapshots.stream().filter(Predicate.isEqual(this.currentSnapshot).negate()).collect(Collectors.toList())).setSnapshotsSupplier((SerializableSupplier & Serializable)() -> ImmutableList.copyOf((Iterable)this.table.snapshots())).discardChanges().build();
        Assertions.assertThat((List)futureTableMetadata.snapshots()).containsExactlyInAnyOrderElementsOf((Iterable)this.originalTableMetadata.snapshots());
    }

    @Test
    public void testRemovedCurrentSnapshotFails() {
        List snapshotsMissingCurrent = this.allSnapshots.stream().filter(Predicate.isEqual(this.currentSnapshot).negate()).collect(Collectors.toList());
        TableMetadata tableMetadata = TableMetadata.buildFrom((TableMetadata)this.originalTableMetadata).removeSnapshots(this.allSnapshots.stream().filter(Predicate.isEqual(this.currentSnapshot).negate()).collect(Collectors.toList())).setSnapshotsSupplier((SerializableSupplier & Serializable)() -> snapshotsMissingCurrent).discardChanges().build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TableMetadata)tableMetadata).snapshots()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid table metadata: Cannot find current version");
    }

    @Test
    public void testRemovedRefSnapshotFails() {
        Snapshot referencedSnapshot = (Snapshot)this.allSnapshots.stream().filter(Predicate.isEqual(this.currentSnapshot).negate()).findFirst().get();
        TableMetadata tableMetadata = TableMetadata.buildFrom((TableMetadata)this.originalTableMetadata).setRef("toRemove", SnapshotRef.branchBuilder((long)referencedSnapshot.snapshotId()).build()).setSnapshotsSupplier((SerializableSupplier & Serializable)() -> Lists.newArrayList((Object[])new Snapshot[]{this.currentSnapshot})).build();
        long fakeSnapshotId = 123L;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> tableMetadata.snapshot(fakeSnapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Snapshot for reference").hasMessageEndingWith("does not exist in the existing snapshots list");
    }

    @Test
    public void testBuildingNewMetadataTriggersSnapshotLoad() {
        TableMetadata newTableMetadata = TableMetadata.buildFrom((TableMetadata)this.latestTableMetadata).removeRef("main").build();
        ((SerializableSupplier)Mockito.verify(this.snapshotsSupplierMock, (VerificationMode)Mockito.times((int)1))).get();
    }

    private static class MetadataTableOperations
    implements TableOperations {
        private final FileIO io;
        private final TableMetadata currentMetadata;

        MetadataTableOperations(FileIO io, TableMetadata currentMetadata) {
            this.io = io;
            this.currentMetadata = currentMetadata;
        }

        public TableMetadata current() {
            return this.currentMetadata;
        }

        public TableMetadata refresh() {
            throw new UnsupportedOperationException("refresh not supported for test ops implementation.");
        }

        public void commit(TableMetadata base, TableMetadata metadata) {
            throw new UnsupportedOperationException("commit not supported for test ops implementation.");
        }

        public FileIO io() {
            return this.io;
        }

        public String metadataFileLocation(String fileName) {
            throw new UnsupportedOperationException("metadataFileLocation not supported for test ops implementation.");
        }

        public LocationProvider locationProvider() {
            throw new UnsupportedOperationException("locationProvider not supported for test ops implementation.");
        }
    }
}

