/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.Files;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.LocalTableOperations;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSnapshotJson {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    public TableOperations ops = new LocalTableOperations(this.temp);

    @Test
    public void testJsonConversion() throws IOException {
        int snapshotId = 23;
        Long parentId = null;
        String manifestList = this.createManifestListWithManifestFiles(snapshotId, parentId);
        BaseSnapshot expected = new BaseSnapshot(0L, (long)snapshotId, parentId, System.currentTimeMillis(), null, null, Integer.valueOf(1), manifestList);
        String json = SnapshotParser.toJson((Snapshot)expected);
        Snapshot snapshot = SnapshotParser.fromJson((String)json);
        Assert.assertEquals((String)"Snapshot ID should match", (long)expected.snapshotId(), (long)snapshot.snapshotId());
        Assert.assertEquals((String)"Files should match", (Object)expected.allManifests(this.ops.io()), (Object)snapshot.allManifests(this.ops.io()));
        Assert.assertNull((String)"Operation should be null", (Object)snapshot.operation());
        Assert.assertNull((String)"Summary should be null", (Object)snapshot.summary());
        Assert.assertEquals((String)"Schema ID should match", (Object)1, (Object)snapshot.schemaId());
    }

    @Test
    public void testJsonConversionWithoutSchemaId() throws IOException {
        int snapshotId = 23;
        Long parentId = null;
        String manifestList = this.createManifestListWithManifestFiles(snapshotId, parentId);
        BaseSnapshot expected = new BaseSnapshot(0L, (long)snapshotId, parentId, System.currentTimeMillis(), null, null, null, manifestList);
        String json = SnapshotParser.toJson((Snapshot)expected);
        Snapshot snapshot = SnapshotParser.fromJson((String)json);
        Assert.assertEquals((String)"Snapshot ID should match", (long)expected.snapshotId(), (long)snapshot.snapshotId());
        Assert.assertEquals((String)"Files should match", (Object)expected.allManifests(this.ops.io()), (Object)snapshot.allManifests(this.ops.io()));
        Assert.assertNull((String)"Operation should be null", (Object)snapshot.operation());
        Assert.assertNull((String)"Summary should be null", (Object)snapshot.summary());
        Assert.assertNull((String)"Schema ID should be null", (Object)snapshot.schemaId());
    }

    @Test
    public void testJsonConversionWithOperation() throws IOException {
        long parentId = 1L;
        long id = 2L;
        String manifestList = this.createManifestListWithManifestFiles(id, parentId);
        BaseSnapshot expected = new BaseSnapshot(0L, id, Long.valueOf(parentId), System.currentTimeMillis(), "replace", (Map)ImmutableMap.of((Object)"files-added", (Object)"4", (Object)"files-deleted", (Object)"100"), Integer.valueOf(3), manifestList);
        String json = SnapshotParser.toJson((Snapshot)expected);
        Snapshot snapshot = SnapshotParser.fromJson((String)json);
        Assert.assertEquals((String)"Sequence number should default to 0 for v1", (long)0L, (long)snapshot.sequenceNumber());
        Assert.assertEquals((String)"Snapshot ID should match", (long)expected.snapshotId(), (long)snapshot.snapshotId());
        Assert.assertEquals((String)"Timestamp should match", (long)expected.timestampMillis(), (long)snapshot.timestampMillis());
        Assert.assertEquals((String)"Parent ID should match", (Object)expected.parentId(), (Object)snapshot.parentId());
        Assert.assertEquals((String)"Manifest list should match", (Object)expected.manifestListLocation(), (Object)snapshot.manifestListLocation());
        Assert.assertEquals((String)"Files should match", (Object)expected.allManifests(this.ops.io()), (Object)snapshot.allManifests(this.ops.io()));
        Assert.assertEquals((String)"Operation should match", (Object)expected.operation(), (Object)snapshot.operation());
        Assert.assertEquals((String)"Summary should match", (Object)expected.summary(), (Object)snapshot.summary());
        Assert.assertEquals((String)"Schema ID should match", (Object)expected.schemaId(), (Object)snapshot.schemaId());
    }

    @Test
    public void testJsonConversionWithV1Manifests() {
        long parentId = 1L;
        long id = 2L;
        long timestampMillis = System.currentTimeMillis();
        BaseSnapshot expected = new BaseSnapshot(0L, id, Long.valueOf(parentId), timestampMillis, "replace", (Map)ImmutableMap.of((Object)"files-added", (Object)"4", (Object)"files-deleted", (Object)"100"), Integer.valueOf(3), new String[]{"/tmp/manifest1.avro", "/tmp/manifest2.avro"});
        String expectedJson = String.format("{\n  \"snapshot-id\" : 2,\n  \"parent-snapshot-id\" : 1,\n  \"timestamp-ms\" : %s,\n  \"summary\" : {\n    \"operation\" : \"replace\",\n    \"files-added\" : \"4\",\n    \"files-deleted\" : \"100\"\n  },\n  \"manifests\" : [ \"/tmp/manifest1.avro\", \"/tmp/manifest2.avro\" ],\n  \"schema-id\" : 3\n}", timestampMillis);
        String json = SnapshotParser.toJson((Snapshot)expected, (boolean)true);
        Assertions.assertThat((String)json).isEqualTo(expectedJson);
        Snapshot snapshot = SnapshotParser.fromJson((String)json);
        Assertions.assertThat((Object)snapshot).isEqualTo((Object)expected);
        Assert.assertEquals((String)"Sequence number should default to 0 for v1", (long)0L, (long)snapshot.sequenceNumber());
        Assert.assertEquals((String)"Snapshot ID should match", (long)expected.snapshotId(), (long)snapshot.snapshotId());
        Assert.assertEquals((String)"Timestamp should match", (long)expected.timestampMillis(), (long)snapshot.timestampMillis());
        Assert.assertEquals((String)"Parent ID should match", (Object)expected.parentId(), (Object)snapshot.parentId());
        Assert.assertEquals((String)"Manifest list should match", (Object)expected.manifestListLocation(), (Object)snapshot.manifestListLocation());
        Assert.assertEquals((String)"Files should match", (Object)expected.allManifests(this.ops.io()), (Object)snapshot.allManifests(this.ops.io()));
        Assert.assertEquals((String)"Operation should match", (Object)expected.operation(), (Object)snapshot.operation());
        Assert.assertEquals((String)"Summary should match", (Object)expected.summary(), (Object)snapshot.summary());
        Assert.assertEquals((String)"Schema ID should match", (Object)expected.schemaId(), (Object)snapshot.schemaId());
    }

    private String createManifestListWithManifestFiles(long snapshotId, Long parentSnapshotId) throws IOException {
        File manifestList = this.temp.newFile("manifests" + UUID.randomUUID());
        manifestList.deleteOnExit();
        ImmutableList manifests = ImmutableList.of((Object)new GenericManifestFile(Files.localInput((String)"file:/tmp/manifest1.avro"), 0), (Object)new GenericManifestFile(Files.localInput((String)"file:/tmp/manifest2.avro"), 0));
        try (ManifestListWriter writer = ManifestLists.write((int)1, (OutputFile)Files.localOutput((File)manifestList), (long)snapshotId, (Long)parentSnapshotId, (long)0L);){
            writer.addAll((Iterable)manifests);
        }
        return Files.localInput((File)manifestList).location();
    }
}

