/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FindFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSnapshot
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSnapshot(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testAppendFilesFromTable() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Iterable filesToAdd = this.table.currentSnapshot().addedDataFiles(this.table.io());
        this.table.newDelete().deleteFile(FILE_A).deleteFile(FILE_B).commit();
        Snapshot oldSnapshot = this.table.currentSnapshot();
        AppendFiles fastAppend = this.table.newFastAppend();
        for (DataFile file : filesToAdd) {
            fastAppend.appendFile(file);
        }
        Snapshot newSnapshot = (Snapshot)fastAppend.apply();
        this.validateSnapshot(oldSnapshot, newSnapshot, FILE_A, FILE_B);
    }

    @Test
    public void testAppendFoundFiles() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        CloseableIterable filesToAdd = FindFiles.in((Table)this.table).inPartition(this.table.spec(), (StructLike)StaticDataTask.Row.of((Object[])new Object[]{0})).inPartition(this.table.spec(), (StructLike)StaticDataTask.Row.of((Object[])new Object[]{1})).collect();
        this.table.newDelete().deleteFile(FILE_A).deleteFile(FILE_B).commit();
        Snapshot oldSnapshot = this.table.currentSnapshot();
        AppendFiles fastAppend = this.table.newFastAppend();
        for (DataFile file : filesToAdd) {
            fastAppend.appendFile(file);
        }
        Snapshot newSnapshot = (Snapshot)fastAppend.apply();
        this.validateSnapshot(oldSnapshot, newSnapshot, FILE_A, FILE_B);
    }

    @Test
    public void testCachedDataFiles() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        DataFile secondSnapshotDataFile = this.newDataFile("data_bucket=8/data_trunc_2=aa");
        this.table.newFastAppend().appendFile(secondSnapshotDataFile).commit();
        DataFile thirdSnapshotDataFile = this.newDataFile("data_bucket=8/data_trunc_2=bb");
        this.table.newOverwrite().deleteFile(FILE_A).addFile(thirdSnapshotDataFile).commit();
        Snapshot thirdSnapshot = this.table.currentSnapshot();
        Iterable removedDataFiles = thirdSnapshot.removedDataFiles(FILE_IO);
        Assert.assertEquals((String)"Must have 1 removed data file", (long)1L, (long)Iterables.size((Iterable)removedDataFiles));
        DataFile removedDataFile = (DataFile)Iterables.getOnlyElement((Iterable)removedDataFiles);
        Assert.assertEquals((String)"Path must match", (Object)FILE_A.path(), (Object)removedDataFile.path());
        Assert.assertEquals((String)"Spec ID must match", (long)FILE_A.specId(), (long)removedDataFile.specId());
        Assert.assertEquals((String)"Partition must match", (Object)FILE_A.partition(), (Object)removedDataFile.partition());
        Iterable addedDataFiles = thirdSnapshot.addedDataFiles(FILE_IO);
        Assert.assertEquals((String)"Must have 1 added data file", (long)1L, (long)Iterables.size((Iterable)addedDataFiles));
        DataFile addedDataFile = (DataFile)Iterables.getOnlyElement((Iterable)addedDataFiles);
        Assert.assertEquals((String)"Path must match", (Object)thirdSnapshotDataFile.path(), (Object)addedDataFile.path());
        Assert.assertEquals((String)"Spec ID must match", (long)thirdSnapshotDataFile.specId(), (long)addedDataFile.specId());
        Assert.assertEquals((String)"Partition must match", (Object)thirdSnapshotDataFile.partition(), (Object)addedDataFile.partition());
    }

    @Test
    public void testCachedDeleteFiles() {
        Assume.assumeTrue((String)"Delete files only supported in V2", (this.formatVersion >= 2 ? 1 : 0) != 0);
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        int specId = this.table.spec().specId();
        DataFile secondSnapshotDataFile = this.newDataFile("data_bucket=8/data_trunc_2=aa");
        DeleteFile secondSnapshotDeleteFile = this.newDeleteFile(specId, "data_bucket=8/data_trunc_2=aa");
        this.table.newRowDelta().addRows(secondSnapshotDataFile).addDeletes(secondSnapshotDeleteFile).commit();
        DeleteFile thirdSnapshotDeleteFile = this.newDeleteFile(specId, "data_bucket=8/data_trunc_2=aa");
        ImmutableSet replacedDeleteFiles = ImmutableSet.of((Object)secondSnapshotDeleteFile);
        ImmutableSet newDeleteFiles = ImmutableSet.of((Object)thirdSnapshotDeleteFile);
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of(), (Set)replacedDeleteFiles, (Set)ImmutableSet.of(), (Set)newDeleteFiles).commit();
        Snapshot thirdSnapshot = this.table.currentSnapshot();
        Iterable removedDeleteFiles = thirdSnapshot.removedDeleteFiles(FILE_IO);
        Assert.assertEquals((String)"Must have 1 removed delete file", (long)1L, (long)Iterables.size((Iterable)removedDeleteFiles));
        DeleteFile removedDeleteFile = (DeleteFile)Iterables.getOnlyElement((Iterable)removedDeleteFiles);
        Assert.assertEquals((String)"Path must match", (Object)secondSnapshotDeleteFile.path(), (Object)removedDeleteFile.path());
        Assert.assertEquals((String)"Spec ID must match", (long)secondSnapshotDeleteFile.specId(), (long)removedDeleteFile.specId());
        Assert.assertEquals((String)"Partition must match", (Object)secondSnapshotDeleteFile.partition(), (Object)removedDeleteFile.partition());
        Iterable addedDeleteFiles = thirdSnapshot.addedDeleteFiles(FILE_IO);
        Assert.assertEquals((String)"Must have 1 added delete file", (long)1L, (long)Iterables.size((Iterable)addedDeleteFiles));
        DeleteFile addedDeleteFile = (DeleteFile)Iterables.getOnlyElement((Iterable)addedDeleteFiles);
        Assert.assertEquals((String)"Path must match", (Object)thirdSnapshotDeleteFile.path(), (Object)addedDeleteFile.path());
        Assert.assertEquals((String)"Spec ID must match", (long)thirdSnapshotDeleteFile.specId(), (long)addedDeleteFile.specId());
        Assert.assertEquals((String)"Partition must match", (Object)thirdSnapshotDeleteFile.partition(), (Object)addedDeleteFile.partition());
    }

    @Test
    public void testSequenceNumbersInAddedDataFiles() {
        long expectedSequenceNumber = 0L;
        if (this.formatVersion >= 2) {
            expectedSequenceNumber = 1L;
        }
        this.runAddedDataFileSequenceNumberTest(expectedSequenceNumber);
        if (this.formatVersion >= 2) {
            ++expectedSequenceNumber;
        }
        this.runAddedDataFileSequenceNumberTest(expectedSequenceNumber);
    }

    private void runAddedDataFileSequenceNumberTest(long expectedSequenceNumber) {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot snapshot = this.table.currentSnapshot();
        Iterable addedDataFiles = snapshot.addedDataFiles(this.table.io());
        Assert.assertEquals((String)"Sequence number mismatch in Snapshot", (long)expectedSequenceNumber, (long)snapshot.sequenceNumber());
        for (DataFile df : addedDataFiles) {
            Assert.assertEquals((String)"Data sequence number mismatch", (long)expectedSequenceNumber, (long)df.dataSequenceNumber());
            Assert.assertEquals((String)"File sequence number mismatch", (long)expectedSequenceNumber, (long)df.fileSequenceNumber());
        }
    }

    @Test
    public void testSequenceNumbersInRemovedDataFiles() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        long expectedSnapshotSequenceNumber = 0L;
        if (this.formatVersion >= 2) {
            expectedSnapshotSequenceNumber = 2L;
        }
        long expectedFileSequenceNumber = 0L;
        if (this.formatVersion >= 2) {
            expectedFileSequenceNumber = 1L;
        }
        this.runRemovedDataFileSequenceNumberTest(FILE_A, expectedSnapshotSequenceNumber, expectedFileSequenceNumber);
        if (this.formatVersion >= 2) {
            ++expectedSnapshotSequenceNumber;
        }
        this.runRemovedDataFileSequenceNumberTest(FILE_B, expectedSnapshotSequenceNumber, expectedFileSequenceNumber);
    }

    private void runRemovedDataFileSequenceNumberTest(DataFile fileToRemove, long expectedSnapshotSequenceNumber, long expectedFileSequenceNumber) {
        this.table.newDelete().deleteFile(fileToRemove).commit();
        Snapshot snapshot = this.table.currentSnapshot();
        Iterable removedDataFiles = snapshot.removedDataFiles(this.table.io());
        Assert.assertEquals((String)"Must have 1 removed data file", (long)1L, (long)Iterables.size((Iterable)removedDataFiles));
        DataFile removedDataFile = (DataFile)Iterables.getOnlyElement((Iterable)removedDataFiles);
        Assert.assertEquals((String)"Sequence number mismatch in Snapshot", (long)expectedSnapshotSequenceNumber, (long)snapshot.sequenceNumber());
        Assert.assertEquals((String)"Data sequence number mismatch", (long)expectedFileSequenceNumber, (long)removedDataFile.dataSequenceNumber());
        Assert.assertEquals((String)"File sequence number mismatch", (long)expectedFileSequenceNumber, (long)removedDataFile.fileSequenceNumber());
    }

    @Test
    public void testSequenceNumbersInAddedDeleteFiles() {
        Assume.assumeTrue((String)"Delete files only supported in V2", (this.formatVersion >= 2 ? 1 : 0) != 0);
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        int specId = this.table.spec().specId();
        this.runAddedDeleteFileSequenceNumberTest(this.newDeleteFile(specId, "data_bucket=8"), 2L);
        this.runAddedDeleteFileSequenceNumberTest(this.newDeleteFile(specId, "data_bucket=28"), 3L);
    }

    private void runAddedDeleteFileSequenceNumberTest(DeleteFile deleteFileToAdd, long expectedSequenceNumber) {
        this.table.newRowDelta().addDeletes(deleteFileToAdd).commit();
        Snapshot snapshot = this.table.currentSnapshot();
        Iterable addedDeleteFiles = snapshot.addedDeleteFiles(this.table.io());
        Assert.assertEquals((String)"Must have 1 added delete file", (long)1L, (long)Iterables.size((Iterable)addedDeleteFiles));
        DeleteFile addedDeleteFile = (DeleteFile)Iterables.getOnlyElement((Iterable)addedDeleteFiles);
        Assert.assertEquals((String)"Sequence number mismatch in Snapshot", (long)expectedSequenceNumber, (long)snapshot.sequenceNumber());
        Assert.assertEquals((String)"Data sequence number mismatch", (long)expectedSequenceNumber, (long)addedDeleteFile.dataSequenceNumber());
        Assert.assertEquals((String)"File sequence number mismatch", (long)expectedSequenceNumber, (long)addedDeleteFile.fileSequenceNumber());
    }
}

