/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Locale;
import org.apache.iceberg.SingleValueParser;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestSingleValueParser {
    @Test
    public void testValidDefaults() throws IOException {
        Object[][] typesWithDefaults;
        for (Object[] typeWithDefault : typesWithDefaults = new Object[][]{{Types.BooleanType.get(), "null"}, {Types.BooleanType.get(), "true"}, {Types.IntegerType.get(), "1"}, {Types.LongType.get(), "9999999"}, {Types.FloatType.get(), "1.23"}, {Types.DoubleType.get(), "123.456"}, {Types.DateType.get(), "\"2007-12-03\""}, {Types.TimeType.get(), "\"10:15:30\""}, {Types.TimestampType.withoutZone(), "\"2007-12-03T10:15:30\""}, {Types.TimestampType.withZone(), "\"2007-12-03T10:15:30+00:00\""}, {Types.StringType.get(), "\"foo\""}, {Types.UUIDType.get(), "\"eb26bdb1-a1d8-4aa6-990e-da940875492c\""}, {Types.FixedType.ofLength((int)2), "\"111f\""}, {Types.BinaryType.get(), "\"0000ff\""}, {Types.DecimalType.of((int)9, (int)4), "\"123.4500\""}, {Types.DecimalType.of((int)9, (int)0), "\"2\""}, {Types.DecimalType.of((int)9, (int)-20), "\"2E+20\""}, {Types.ListType.ofOptional((int)1, (Type)Types.IntegerType.get()), "[1, 2, 3]"}, {Types.MapType.ofOptional((int)2, (int)3, (Type)Types.IntegerType.get(), (Type)Types.StringType.get()), "{\"keys\": [1, 2], \"values\": [\"foo\", \"bar\"]}"}, {Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"f1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"f2", (Type)Types.StringType.get())}), "{\"4\": 1, \"5\": \"bar\"}"}, {Types.ListType.ofOptional((int)6, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)7, (String)"f1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"f2", (Type)Types.StringType.get())})), "[{\"7\": 1, \"8\": \"bar\"}, {\"7\": 2, \"8\": \"foo\"}]"}, {Types.MapType.ofOptional((int)9, (int)10, (Type)Types.IntegerType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)11, (String)"f1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)12, (String)"f2", (Type)Types.StringType.get())})), "{\"keys\": [1, 2], \"values\": [{\"11\": 1, \"12\": \"bar\"}, {\"11\": 2, \"12\": \"foo\"}]}"}, {Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)13, (String)"f1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)14, (String)"ff1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)15, (String)"ff2", (Type)Types.StringType.get())})), Types.NestedField.optional((int)16, (String)"f2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)17, (String)"ff1", (Type)Types.StringType.get()), Types.NestedField.optional((int)18, (String)"ff2", (Type)Types.IntegerType.get())}))}), "{\"13\": {\"14\": 1, \"15\": \"bar\"}, \"16\": {\"17\": \"bar\", \"18\": 1}}"}}) {
            Type type = (Type)typeWithDefault[0];
            String defaultValue = (String)typeWithDefault[1];
            String roundTripDefaultValue = TestSingleValueParser.defaultValueParseAndUnParseRoundTrip(type, defaultValue);
            TestSingleValueParser.jsonStringEquals(defaultValue.toLowerCase(Locale.ROOT), roundTripDefaultValue.toLowerCase(Locale.ROOT));
        }
    }

    @Test
    public void testInvalidFixed() {
        Types.FixedType expectedType = Types.FixedType.ofLength((int)2);
        String defaultJson = "\"111ff\"";
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> TestSingleValueParser.lambda$testInvalidFixed$0((Type)expectedType, defaultJson));
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Cannot parse default fixed[2] value"));
    }

    @Test
    public void testInvalidUUID() {
        Types.UUIDType expectedType = Types.UUIDType.get();
        String defaultJson = "\"eb26bdb1-a1d8-4aa6-990e-da940875492c-abcde\"";
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> TestSingleValueParser.lambda$testInvalidUUID$1((Type)expectedType, defaultJson));
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Cannot parse default as a uuid value"));
    }

    @Test
    public void testInvalidMap() {
        Types.MapType expectedType = Types.MapType.ofOptional((int)1, (int)2, (Type)Types.IntegerType.get(), (Type)Types.StringType.get());
        String defaultJson = "{\"keys\": [1, 2, 3], \"values\": [\"foo\", \"bar\"]}";
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> TestSingleValueParser.lambda$testInvalidMap$2((Type)expectedType, defaultJson));
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Cannot parse default as a map<int, string> value"));
    }

    @Test
    public void testInvalidDecimal() {
        Types.DecimalType expectedType = Types.DecimalType.of((int)5, (int)2);
        String defaultJson = "123.456";
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> TestSingleValueParser.lambda$testInvalidDecimal$3((Type)expectedType, defaultJson));
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Cannot parse default as a decimal(5, 2) value"));
    }

    @Test
    public void testInvalidTimestamptz() {
        Types.TimestampType expectedType = Types.TimestampType.withZone();
        String defaultJson = "\"2007-12-03T10:15:30+01:00\"";
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> TestSingleValueParser.lambda$testInvalidTimestamptz$4((Type)expectedType, defaultJson));
        Assert.assertTrue((boolean)exception.getMessage().startsWith("Cannot parse default as a timestamptz value"));
    }

    private static String defaultValueParseAndUnParseRoundTrip(Type type, String defaultValue) {
        Object javaDefaultValue = SingleValueParser.fromJson((Type)type, (String)defaultValue);
        return SingleValueParser.toJson((Type)type, (Object)javaDefaultValue);
    }

    private static void jsonStringEquals(String s1, String s2) throws IOException {
        Assert.assertEquals((Object)JsonUtil.mapper().readTree(s1), (Object)JsonUtil.mapper().readTree(s2));
    }

    private static /* synthetic */ void lambda$testInvalidTimestamptz$4(Type expectedType, String defaultJson) throws Throwable {
        TestSingleValueParser.defaultValueParseAndUnParseRoundTrip(expectedType, defaultJson);
    }

    private static /* synthetic */ void lambda$testInvalidDecimal$3(Type expectedType, String defaultJson) throws Throwable {
        TestSingleValueParser.defaultValueParseAndUnParseRoundTrip(expectedType, defaultJson);
    }

    private static /* synthetic */ void lambda$testInvalidMap$2(Type expectedType, String defaultJson) throws Throwable {
        TestSingleValueParser.defaultValueParseAndUnParseRoundTrip(expectedType, defaultJson);
    }

    private static /* synthetic */ void lambda$testInvalidUUID$1(Type expectedType, String defaultJson) throws Throwable {
        TestSingleValueParser.defaultValueParseAndUnParseRoundTrip(expectedType, defaultJson);
    }

    private static /* synthetic */ void lambda$testInvalidFixed$0(Type expectedType, String defaultJson) throws Throwable {
        TestSingleValueParser.defaultValueParseAndUnParseRoundTrip(expectedType, defaultJson);
    }
}

