/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSetStatistics
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSetStatistics(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testEmptyUpdateStatistics() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        this.table.updateStatistics().commit();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.table.ops().current());
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
    }

    @Test
    public void testEmptyTransactionalUpdateStatistics() {
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        Transaction transaction = this.table.newTransaction();
        transaction.updateStatistics().commit();
        transaction.commitTransaction();
        Assert.assertSame((String)"Base metadata should not change when commit is created", (Object)base, (Object)this.table.ops().current());
        Assert.assertEquals((String)"Table should be on version 0", (long)0L, (long)this.version().intValue());
    }

    @Test
    public void testUpdateStatistics() {
        this.table.newFastAppend().commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        long snapshotId = base.currentSnapshot().snapshotId();
        GenericStatisticsFile statisticsFile = new GenericStatisticsFile(snapshotId, "/some/statistics/file.puffin", 100L, 42L, (List)ImmutableList.of((Object)new GenericBlobMetadata("stats-type", snapshotId, base.lastSequenceNumber(), (List)ImmutableList.of((Object)1, (Object)2), (Map)ImmutableMap.of((Object)"a-property", (Object)"some-property-value"))));
        this.table.updateStatistics().setStatistics(snapshotId, (StatisticsFile)statisticsFile).commit();
        TableMetadata metadata = this.readMetadata();
        Assert.assertEquals((String)"Table should be on version 2", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Table snapshot should be the same after setting statistics file", (long)snapshotId, (long)metadata.currentSnapshot().snapshotId());
        Assert.assertEquals((String)"Table metadata should have statistics files", (Object)ImmutableList.of((Object)statisticsFile), (Object)metadata.statisticsFiles());
    }

    @Test
    public void testRemoveStatistics() {
        this.table.newFastAppend().commit();
        Assert.assertEquals((String)"Table should be on version 1", (long)1L, (long)this.version().intValue());
        TableMetadata base = this.readMetadata();
        long snapshotId = base.currentSnapshot().snapshotId();
        GenericStatisticsFile statisticsFile = new GenericStatisticsFile(snapshotId, "/some/statistics/file.puffin", 100L, 42L, (List)ImmutableList.of());
        this.table.updateStatistics().setStatistics(snapshotId, (StatisticsFile)statisticsFile).commit();
        TableMetadata metadata = this.readMetadata();
        Assert.assertEquals((String)"Table should be on version 2", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Table metadata should have statistics files", (Object)ImmutableList.of((Object)statisticsFile), (Object)metadata.statisticsFiles());
        this.table.updateStatistics().removeStatistics(snapshotId).commit();
        metadata = this.readMetadata();
        Assert.assertEquals((String)"Table should be on version 3", (long)3L, (long)this.version().intValue());
        Assert.assertEquals((String)"Table metadata should have no statistics files", (Object)ImmutableList.of(), (Object)metadata.statisticsFiles());
    }
}

