/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.junit.Test;

public class TestSequenceNumberForV2Table
extends TableTestBase {
    public TestSequenceNumberForV2Table() {
        super(2);
    }

    @Test
    public void testRewrite() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        long commitId2 = snap2.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot(snap1, snap2, 2L, new DataFile[]{FILE_B});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(2L), TestSequenceNumberForV2Table.fileSeqs(2L), TestSequenceNumberForV2Table.ids(commitId2), TestSequenceNumberForV2Table.files(FILE_B));
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.table.rewriteManifests().clusterBy(file -> "").commit();
        Snapshot snap3 = this.table.currentSnapshot();
        ManifestFile newManifest = (ManifestFile)snap3.allManifests(this.table.io()).stream().filter(manifest -> manifest.snapshotId().longValue() == snap3.snapshotId()).collect(Collectors.toList()).get(0);
        this.V2Assert.assertEquals("Snapshot sequence number should be 3", 3L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, this.readMetadata().lastSequenceNumber());
        for (ManifestEntry entry : ManifestFiles.read((ManifestFile)newManifest, (FileIO)FILE_IO).entries()) {
            if (((DataFile)entry.file()).path().equals(FILE_A.path())) {
                this.V2Assert.assertEquals("FILE_A sequence number should be 1", 1L, entry.dataSequenceNumber());
                this.V2Assert.assertEquals("FILE_A sequence number should be 1", 1L, ((DataFile)entry.file()).dataSequenceNumber());
                this.V2Assert.assertEquals("FILE_A file sequence number should be 1", 1L, entry.fileSequenceNumber());
                this.V2Assert.assertEquals("FILE_A file sequence number should be 1", 1L, ((DataFile)entry.file()).fileSequenceNumber());
            }
            if (!((DataFile)entry.file()).path().equals(FILE_B.path())) continue;
            this.V2Assert.assertEquals("FILE_b sequence number should be 2", 2L, entry.dataSequenceNumber());
            this.V2Assert.assertEquals("FILE_b sequence number should be 2", 2L, ((DataFile)entry.file()).dataSequenceNumber());
            this.V2Assert.assertEquals("FILE_B file sequence number should be 2", 2L, entry.fileSequenceNumber());
            this.V2Assert.assertEquals("FILE_B file sequence number should be 2", 2L, ((DataFile)entry.file()).fileSequenceNumber());
        }
    }

    @Test
    public void testCommitConflict() {
        AppendFiles appendA = this.table.newFastAppend();
        appendA.appendFile(FILE_A).apply();
        this.table.updateProperties().set("commit.retry.num-retries", "0").commit();
        this.table.ops().failCommits(1);
        AssertHelpers.assertThrows((String)"Should reject commit", CommitFailedException.class, (String)"Injected failure", () -> this.table.newFastAppend().appendFile(FILE_B).commit());
        this.table.updateProperties().set("commit.retry.num-retries", "5").commit();
        appendA.commit();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        AppendFiles appendFiles = this.table.newFastAppend().appendFile(FILE_C);
        appendFiles.apply();
        this.table.newFastAppend().appendFile(FILE_D).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        long commitId2 = snap2.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot(snap1, snap2, 2L, new DataFile[]{FILE_D});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(2L), TestSequenceNumberForV2Table.fileSeqs(2L), TestSequenceNumberForV2Table.ids(commitId2), TestSequenceNumberForV2Table.files(FILE_D));
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        appendFiles.commit();
        Snapshot snap3 = this.table.currentSnapshot();
        long commitId3 = snap3.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(3L), TestSequenceNumberForV2Table.fileSeqs(3L), TestSequenceNumberForV2Table.ids(commitId3), TestSequenceNumberForV2Table.files(FILE_C));
        this.validateSnapshot(snap2, snap3, 3L, new DataFile[]{FILE_C});
        this.V2Assert.assertEquals("Snapshot sequence number should be 3", 3L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testRollBack() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        long commitId2 = snap2.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot(snap1, snap2, 2L, new DataFile[]{FILE_B});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(2L), TestSequenceNumberForV2Table.fileSeqs(2L), TestSequenceNumberForV2Table.ids(commitId2), TestSequenceNumberForV2Table.files(FILE_B));
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.table.manageSnapshots().rollbackTo(commitId1).commit();
        Snapshot snap3 = this.table.currentSnapshot();
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.table.newFastAppend().appendFile(FILE_C).commit();
        Snapshot snap4 = this.table.currentSnapshot();
        long commitId4 = snap4.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot(snap3, snap4, 3L, new DataFile[]{FILE_C});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(3L), TestSequenceNumberForV2Table.fileSeqs(3L), TestSequenceNumberForV2Table.ids(commitId4), TestSequenceNumberForV2Table.files(FILE_C));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 3L, snap4.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testSingleTransaction() {
        Transaction txn = this.table.newTransaction();
        txn.newAppend().appendFile(FILE_A).commit();
        txn.commitTransaction();
        Snapshot snap = this.table.currentSnapshot();
        long commitId = snap.snapshotId();
        ManifestFile manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testConcurrentTransaction() {
        Transaction txn1 = this.table.newTransaction();
        Transaction txn2 = this.table.newTransaction();
        Transaction txn3 = this.table.newTransaction();
        Transaction txn4 = this.table.newTransaction();
        txn1.newFastAppend().appendFile(FILE_A).commit();
        txn3.newOverwrite().addFile(FILE_C).commit();
        txn4.newDelete().deleteFile(FILE_A).commit();
        txn2.newAppend().appendFile(FILE_B).commit();
        txn1.commitTransaction();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile1 = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile1, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        txn2.commitTransaction();
        Snapshot snap2 = this.table.currentSnapshot();
        long commitId2 = snap2.snapshotId();
        ManifestFile manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot(snap1, snap2, 2L, new DataFile[]{FILE_B});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(2L), TestSequenceNumberForV2Table.fileSeqs(2L), TestSequenceNumberForV2Table.ids(commitId2), TestSequenceNumberForV2Table.files(FILE_B));
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        txn3.commitTransaction();
        Snapshot snap3 = this.table.currentSnapshot();
        long commitId3 = snap3.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).stream().filter(manifest -> manifest.snapshotId() == commitId3).collect(Collectors.toList()).get(0);
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(3L), TestSequenceNumberForV2Table.fileSeqs(3L), TestSequenceNumberForV2Table.ids(commitId3), TestSequenceNumberForV2Table.files(FILE_C));
        this.validateSnapshot(snap2, snap3, 3L, new DataFile[]{FILE_C});
        this.V2Assert.assertEquals("Snapshot sequence number should be 3", 3L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, this.readMetadata().lastSequenceNumber());
        txn4.commitTransaction();
        Snapshot snap4 = this.table.currentSnapshot();
        long commitId4 = snap4.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).stream().filter(manifest -> manifest.snapshotId() == commitId4).collect(Collectors.toList()).get(0);
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId4), TestSequenceNumberForV2Table.files(FILE_A), TestSequenceNumberForV2Table.statuses(ManifestEntry.Status.DELETED));
        this.V2Assert.assertEquals("Snapshot sequence number should be 4", 4L, snap4.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 4", 4L, this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testMultipleOperationsTransaction() {
        Transaction txn = this.table.newTransaction();
        txn.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = txn.table().currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)snap1.allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 0", 0L, this.readMetadata().lastSequenceNumber());
        HashSet toAddFiles = Sets.newHashSet();
        HashSet toDeleteFiles = Sets.newHashSet();
        toAddFiles.add(FILE_B);
        toDeleteFiles.add(FILE_A);
        txn.newRewrite().rewriteFiles((Set)toDeleteFiles, (Set)toAddFiles).commit();
        txn.commitTransaction();
        Snapshot snap2 = this.table.currentSnapshot();
        long commitId2 = snap2.snapshotId();
        manifestFile = (ManifestFile)snap2.allManifests(this.table.io()).stream().filter(manifest -> manifest.snapshotId() == commitId2).collect(Collectors.toList()).get(0);
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(2L), TestSequenceNumberForV2Table.fileSeqs(2L), TestSequenceNumberForV2Table.ids(commitId2), TestSequenceNumberForV2Table.files(FILE_B));
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testExpirationInTransaction() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V2Assert.assertEquals("Should be 1 manifest list", 1, this.listManifestLists(this.table.location()).size());
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        long commitId2 = snap2.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot(snap1, snap2, 2L, new DataFile[]{FILE_B});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(2L), TestSequenceNumberForV2Table.fileSeqs(2L), TestSequenceNumberForV2Table.ids(commitId2), TestSequenceNumberForV2Table.files(FILE_B));
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V2Assert.assertEquals("Should be 2 manifest lists", 2, this.listManifestLists(this.table.location()).size());
        Transaction txn = this.table.newTransaction();
        txn.expireSnapshots().expireSnapshotId(commitId1).commit();
        txn.commitTransaction();
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V2Assert.assertEquals("Should be 1 manifest list as 1 was deleted", 1, this.listManifestLists(this.table.location()).size());
    }

    @Test
    public void testTransactionFailure() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A, FILE_B});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L, 1L), TestSequenceNumberForV2Table.fileSeqs(1L, 1L), TestSequenceNumberForV2Table.ids(commitId1, commitId1), TestSequenceNumberForV2Table.files(FILE_A, FILE_B));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.table.updateProperties().set("commit.retry.num-retries", "0").commit();
        this.table.ops().failCommits(1);
        Transaction txn = this.table.newTransaction();
        txn.newAppend().appendFile(FILE_C).commit();
        AssertHelpers.assertThrows((String)"Transaction commit should fail", CommitFailedException.class, (String)"Injected failure", () -> ((Transaction)txn).commitTransaction());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testCherryPicking() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)snap1.allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        ((AppendFiles)this.table.newAppend().appendFile(FILE_B).stageOnly()).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        Snapshot stagedSnapshot = (Snapshot)this.readMetadata().snapshots().get(1);
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, stagedSnapshot.sequenceNumber());
        this.table.newAppend().appendFile(FILE_C).commit();
        Snapshot snap3 = this.table.currentSnapshot();
        long commitId3 = snap3.snapshotId();
        manifestFile = (ManifestFile)snap3.allManifests(this.table.io()).get(0);
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(3L), TestSequenceNumberForV2Table.fileSeqs(3L), TestSequenceNumberForV2Table.ids(commitId3), TestSequenceNumberForV2Table.files(FILE_C));
        this.validateSnapshot(snap2, snap3, 3L, new DataFile[]{FILE_C});
        this.V2Assert.assertEquals("Snapshot sequence number should be 3", 3L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, this.readMetadata().lastSequenceNumber());
        this.table.manageSnapshots().cherrypick(stagedSnapshot.snapshotId()).commit();
        Snapshot snap4 = this.table.currentSnapshot();
        long commitId4 = snap4.snapshotId();
        manifestFile = (ManifestFile)this.table.currentSnapshot().allManifests(this.table.io()).get(0);
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(4L), TestSequenceNumberForV2Table.fileSeqs(4L), TestSequenceNumberForV2Table.ids(commitId4), TestSequenceNumberForV2Table.files(FILE_B));
        this.validateSnapshot(snap3, snap4, 4L, new DataFile[]{FILE_B});
        this.V2Assert.assertEquals("Snapshot sequence number should be 4", 4L, snap4.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 4", 4L, this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testCherryPickFastForward() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        long commitId1 = snap1.snapshotId();
        ManifestFile manifestFile = (ManifestFile)snap1.allManifests(this.table.io()).get(0);
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(1L), TestSequenceNumberForV2Table.fileSeqs(1L), TestSequenceNumberForV2Table.ids(commitId1), TestSequenceNumberForV2Table.files(FILE_A));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        ((AppendFiles)this.table.newAppend().appendFile(FILE_B).stageOnly()).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        Snapshot stagedSnapshot = (Snapshot)this.readMetadata().snapshots().get(1);
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, stagedSnapshot.sequenceNumber());
        this.table.manageSnapshots().cherrypick(stagedSnapshot.snapshotId()).commit();
        Snapshot snap3 = this.table.currentSnapshot();
        long commitId3 = snap3.snapshotId();
        manifestFile = (ManifestFile)snap3.allManifests(this.table.io()).get(0);
        this.validateManifest(manifestFile, TestSequenceNumberForV2Table.dataSeqs(2L), TestSequenceNumberForV2Table.fileSeqs(2L), TestSequenceNumberForV2Table.ids(commitId3), TestSequenceNumberForV2Table.files(FILE_B));
        this.validateSnapshot(snap2, snap3, 2L, new DataFile[]{FILE_B});
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
    }
}

