/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaUpdate;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaUpdate {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"preferences", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"feature2", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.FloatType.get())})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y", (Type)Types.LongType.get())})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()), (String)"string map of properties")});
    private static final Set<Integer> ALL_IDS = ImmutableSet.copyOf((Collection)TypeUtil.getProjectedIds((Schema)SCHEMA));
    private static final int SCHEMA_LAST_COLUMN_ID = 23;

    @Test
    public void testNoChanges() {
        Schema identical = new SchemaUpdate(SCHEMA, 23).apply();
        Assert.assertEquals((String)"Should not include any changes", (Object)SCHEMA.asStruct(), (Object)identical.asStruct());
    }

    @Test
    public void testDeleteFields() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"id", "data", "preferences", "preferences.feature1", "preferences.feature2", "locations", "locations.lat", "locations.long", "points", "points.x", "points.y", "doubles", "properties"});
        for (String name : columns) {
            HashSet selected = Sets.newHashSet(ALL_IDS);
            Types.NestedField nested = SCHEMA.findField(name);
            selected.remove(nested.fieldId());
            selected.removeAll(TypeUtil.getProjectedIds((Type)nested.type()));
            Schema del = (Schema)new SchemaUpdate(SCHEMA, 19).deleteColumn(name).apply();
            Assert.assertEquals((String)("Should match projection with '" + name + "' removed"), (Object)TypeUtil.project((Schema)SCHEMA, (Set)selected).asStruct(), (Object)del.asStruct());
        }
    }

    @Test
    public void testDeleteFieldsCaseSensitiveDisabled() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"Id", "Data", "Preferences", "Preferences.feature1", "Preferences.feature2", "Locations", "Locations.lat", "Locations.long", "Points", "Points.x", "Points.y", "Doubles", "Properties"});
        for (String name : columns) {
            HashSet selected = Sets.newHashSet(ALL_IDS);
            Types.NestedField nested = SCHEMA.caseInsensitiveFindField(name);
            selected.remove(nested.fieldId());
            selected.removeAll(TypeUtil.getProjectedIds((Type)nested.type()));
            Schema del = (Schema)new SchemaUpdate(SCHEMA, 19).caseSensitive(false).deleteColumn(name).apply();
            Assert.assertEquals((String)("Should match projection with '" + name + "' removed"), (Object)TypeUtil.project((Schema)SCHEMA, (Set)selected).asStruct(), (Object)del.asStruct());
        }
    }

    @Test
    public void testUpdateTypes() {
        Types.StructType expected = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"preferences", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"feature2", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"lat", (Type)Types.DoubleType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.DoubleType.get())})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y", (Type)Types.LongType.get())})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()), (String)"string map of properties")});
        Schema updated = (Schema)new SchemaUpdate(SCHEMA, 23).updateColumn("id", (Type.PrimitiveType)Types.LongType.get()).updateColumn("locations.lat", (Type.PrimitiveType)Types.DoubleType.get()).updateColumn("locations.long", (Type.PrimitiveType)Types.DoubleType.get()).apply();
        Assert.assertEquals((String)"Should convert types", (Object)expected, (Object)updated.asStruct());
    }

    @Test
    public void testUpdateTypesCaseInsensitive() {
        Types.StructType expected = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"preferences", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"feature2", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"lat", (Type)Types.DoubleType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.DoubleType.get())})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y", (Type)Types.LongType.get())})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()), (String)"string map of properties")});
        Schema updated = (Schema)new SchemaUpdate(SCHEMA, 23).caseSensitive(false).updateColumn("ID", (Type.PrimitiveType)Types.LongType.get()).updateColumn("Locations.Lat", (Type.PrimitiveType)Types.DoubleType.get()).updateColumn("Locations.Long", (Type.PrimitiveType)Types.DoubleType.get()).apply();
        Assert.assertEquals((String)"Should convert types", (Object)expected, (Object)updated.asStruct());
    }

    @Test
    public void testUpdateFailure() {
        HashSet allowedUpdates = Sets.newHashSet((Object[])new Pair[]{Pair.of((Object)Types.IntegerType.get(), (Object)Types.LongType.get()), Pair.of((Object)Types.FloatType.get(), (Object)Types.DoubleType.get()), Pair.of((Object)Types.DecimalType.of((int)9, (int)2), (Object)Types.DecimalType.of((int)18, (int)2))});
        ArrayList primitives = Lists.newArrayList((Object[])new Type.PrimitiveType[]{Types.BooleanType.get(), Types.IntegerType.get(), Types.LongType.get(), Types.FloatType.get(), Types.DoubleType.get(), Types.DateType.get(), Types.TimeType.get(), Types.TimestampType.withZone(), Types.TimestampType.withoutZone(), Types.StringType.get(), Types.UUIDType.get(), Types.BinaryType.get(), Types.FixedType.ofLength((int)3), Types.FixedType.ofLength((int)4), Types.DecimalType.of((int)9, (int)2), Types.DecimalType.of((int)9, (int)3), Types.DecimalType.of((int)18, (int)2)});
        for (Type.PrimitiveType fromType : primitives) {
            for (Type.PrimitiveType toType : primitives) {
                Schema fromSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"col", (Type)fromType)});
                if (fromType.equals((Object)toType) || allowedUpdates.contains(Pair.of((Object)fromType, (Object)toType))) {
                    Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"col", (Type)toType)});
                    Schema result = (Schema)new SchemaUpdate(fromSchema, 1).updateColumn("col", toType).apply();
                    Assert.assertEquals((String)"Should allow update", (Object)expected.asStruct(), (Object)result.asStruct());
                    continue;
                }
                String typeChange = fromType.toString() + " -> " + toType.toString();
                AssertHelpers.assertThrows((String)("Should reject update: " + typeChange), IllegalArgumentException.class, (String)("change column type: col: " + typeChange), () -> new SchemaUpdate(fromSchema, 1).updateColumn("col", toType));
            }
        }
    }

    @Test
    public void testRename() {
        Types.StructType expected = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"json", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"options", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"newfeature", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"latitude", (Type)Types.FloatType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.FloatType.get())})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"X", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y.y", (Type)Types.LongType.get())})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()), (String)"string map of properties")});
        Schema renamed = (Schema)new SchemaUpdate(SCHEMA, 23).renameColumn("data", "json").renameColumn("preferences", "options").renameColumn("preferences.feature2", "newfeature").renameColumn("locations.lat", "latitude").renameColumn("points.x", "X").renameColumn("points.y", "y.y").apply();
        Assert.assertEquals((String)"Should rename all fields", (Object)expected, (Object)renamed.asStruct());
    }

    @Test
    public void testRenameCaseInsensitive() {
        Types.StructType expected = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"json", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"options", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"newfeature", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"latitude", (Type)Types.FloatType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.FloatType.get())})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"X", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y.y", (Type)Types.LongType.get())})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()), (String)"string map of properties")});
        Schema renamed = (Schema)new SchemaUpdate(SCHEMA, 23).caseSensitive(false).renameColumn("Data", "json").renameColumn("Preferences", "options").renameColumn("Preferences.Feature2", "newfeature").renameColumn("Locations.Lat", "latitude").renameColumn("Points.x", "X").renameColumn("Points.y", "y.y").apply();
        Assert.assertEquals((String)"Should rename all fields", (Object)expected, (Object)renamed.asStruct());
    }

    @Test
    public void testAddFields() {
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"preferences", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"feature2", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.FloatType.get()), Types.NestedField.optional((int)25, (String)"alt", (Type)Types.FloatType.get())})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y", (Type)Types.LongType.get()), Types.NestedField.optional((int)26, (String)"z", (Type)Types.LongType.get()), Types.NestedField.optional((int)27, (String)"t.t", (Type)Types.LongType.get())})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()), (String)"string map of properties"), Types.NestedField.optional((int)24, (String)"toplevel", (Type)Types.DecimalType.of((int)9, (int)2))});
        Schema added = (Schema)new SchemaUpdate(SCHEMA, 23).addColumn("toplevel", (Type)Types.DecimalType.of((int)9, (int)2)).addColumn("locations", "alt", (Type)Types.FloatType.get()).addColumn("points", "z", (Type)Types.LongType.get()).addColumn("points", "t.t", (Type)Types.LongType.get()).apply();
        Assert.assertEquals((String)"Should match with added fields", (Object)expected.asStruct(), (Object)added.asStruct());
    }

    @Test
    public void testAddNestedStruct() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Types.StructType struct = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"long", (Type)Types.IntegerType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"lat", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)4, (String)"long", (Type)Types.IntegerType.get())}))});
        Schema result = (Schema)new SchemaUpdate(schema, 1).addColumn("location", (Type)struct).apply();
        Assert.assertEquals((String)"Should add struct and reassign column IDs", (Object)expected.asStruct(), (Object)result.asStruct());
    }

    @Test
    public void testAddNestedMapOfStructs() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Types.MapType map = Types.MapType.ofOptional((int)1, (int)2, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)9, (String)"lat", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"long", (Type)Types.IntegerType.get())}));
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"locations", (Type)Types.MapType.ofOptional((int)3, (int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)7, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)8, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)9, (String)"lat", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)10, (String)"long", (Type)Types.IntegerType.get())})))});
        Schema result = (Schema)new SchemaUpdate(schema, 1).addColumn("locations", (Type)map).apply();
        Assert.assertEquals((String)"Should add map and reassign column IDs", (Object)expected.asStruct(), (Object)result.asStruct());
    }

    @Test
    public void testAddNestedListOfStructs() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Types.ListType list = Types.ListType.ofOptional((int)1, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)9, (String)"lat", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"long", (Type)Types.IntegerType.get())}));
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"locations", (Type)Types.ListType.ofOptional((int)3, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"lat", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"long", (Type)Types.IntegerType.get())})))});
        Schema result = (Schema)new SchemaUpdate(schema, 1).addColumn("locations", (Type)list).apply();
        Assert.assertEquals((String)"Should add map and reassign column IDs", (Object)expected.asStruct(), (Object)result.asStruct());
    }

    @Test
    public void testAddRequiredColumn() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        AssertHelpers.assertThrows((String)"Should reject add required column if incompatible changes are not allowed", IllegalArgumentException.class, (String)"Incompatible change: cannot add required column: data", () -> new SchemaUpdate(schema, 1).addRequiredColumn("data", (Type)Types.StringType.get()));
        Schema result = (Schema)new SchemaUpdate(schema, 1).allowIncompatibleChanges().addRequiredColumn("data", (Type)Types.StringType.get()).apply();
        Assert.assertEquals((String)"Should add required column", (Object)expected.asStruct(), (Object)result.asStruct());
    }

    @Test
    public void testAddRequiredColumnCaseInsensitive() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        AssertHelpers.assertThrows((String)"Should reject add required column if same column name different case found", IllegalArgumentException.class, (String)"Cannot add column, name already exists: ID", () -> (Schema)new SchemaUpdate(schema, 1).caseSensitive(false).allowIncompatibleChanges().addRequiredColumn("ID", (Type)Types.StringType.get()).apply());
    }

    @Test
    public void testMakeColumnOptional() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Schema result = (Schema)new SchemaUpdate(schema, 1).makeColumnOptional("id").apply();
        Assert.assertEquals((String)"Should update column to be optional", (Object)expected.asStruct(), (Object)result.asStruct());
    }

    @Test
    public void testRequireColumn() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        AssertHelpers.assertThrows((String)"Should reject change to required if incompatible changes are not allowed", IllegalArgumentException.class, (String)"Cannot change column nullability: id: optional -> required", () -> new SchemaUpdate(schema, 1).requireColumn("id"));
        new SchemaUpdate(expected, 1).requireColumn("id").apply();
        Schema result = (Schema)new SchemaUpdate(schema, 1).allowIncompatibleChanges().requireColumn("id").apply();
        Assert.assertEquals((String)"Should update column to be required", (Object)expected.asStruct(), (Object)result.asStruct());
    }

    @Test
    public void testRequireColumnCaseInsensitive() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Schema result = (Schema)new SchemaUpdate(schema, 1).caseSensitive(false).allowIncompatibleChanges().requireColumn("ID").apply();
        Assert.assertEquals((String)"Should update column to be required", (Object)expected.asStruct(), (Object)result.asStruct());
    }

    @Test
    public void testMixedChanges() {
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get(), (String)"unique id"), Types.NestedField.required((int)2, (String)"json", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"options", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"feature1", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)9, (String)"newfeature", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"latitude", (Type)Types.DoubleType.get(), (String)"latitude"), Types.NestedField.optional((int)25, (String)"alt", (Type)Types.FloatType.get()), Types.NestedField.required((int)28, (String)"description", (Type)Types.StringType.get(), (String)"Location description")})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)15, (String)"X", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y.y", (Type)Types.LongType.get()), Types.NestedField.optional((int)26, (String)"z", (Type)Types.LongType.get()), Types.NestedField.optional((int)27, (String)"t.t", (Type)Types.LongType.get(), (String)"name with '.'")})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)24, (String)"toplevel", (Type)Types.DecimalType.of((int)9, (int)2))});
        Schema updated = (Schema)new SchemaUpdate(SCHEMA, 23).addColumn("toplevel", (Type)Types.DecimalType.of((int)9, (int)2)).addColumn("locations", "alt", (Type)Types.FloatType.get()).addColumn("points", "z", (Type)Types.LongType.get()).addColumn("points", "t.t", (Type)Types.LongType.get(), "name with '.'").renameColumn("data", "json").renameColumn("preferences", "options").renameColumn("preferences.feature2", "newfeature").renameColumn("locations.lat", "latitude").renameColumn("points.x", "X").renameColumn("points.y", "y.y").updateColumn("id", (Type.PrimitiveType)Types.LongType.get(), "unique id").updateColumn("locations.lat", (Type.PrimitiveType)Types.DoubleType.get()).updateColumnDoc("locations.lat", "latitude").deleteColumn("locations.long").deleteColumn("properties").makeColumnOptional("points.x").allowIncompatibleChanges().requireColumn("data").addRequiredColumn("locations", "description", (Type)Types.StringType.get(), "Location description").apply();
        Assert.assertEquals((String)"Should match with added fields", (Object)expected.asStruct(), (Object)updated.asStruct());
    }

    @Test
    public void testAmbiguousAdd() {
        AssertHelpers.assertThrows((String)"Should reject ambiguous column name", IllegalArgumentException.class, (String)"ambiguous name: preferences.booleans", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.addColumn("preferences.booleans", (Type)Types.BooleanType.get());
        });
    }

    @Test
    public void testAddAlreadyExists() {
        AssertHelpers.assertThrows((String)"Should reject column name that already exists", IllegalArgumentException.class, (String)"already exists: preferences.feature1", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.addColumn("preferences", "feature1", (Type)Types.BooleanType.get());
        });
        AssertHelpers.assertThrows((String)"Should reject column name that already exists", IllegalArgumentException.class, (String)"already exists: preferences", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.addColumn("preferences", (Type)Types.BooleanType.get());
        });
    }

    @Test
    public void testDeleteThenAdd() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"id", (Type)Types.IntegerType.get())});
        Schema updated = (Schema)new SchemaUpdate(schema, 1).deleteColumn("id").addColumn("id", Types.NestedField.optional((int)2, (String)"id", (Type)Types.IntegerType.get()).type()).apply();
        Assert.assertEquals((String)"Should match with added fields", (Object)expected.asStruct(), (Object)updated.asStruct());
    }

    @Test
    public void testDeleteThenAddNested() {
        Schema expectedNested = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"preferences", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)9, (String)"feature2", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)24, (String)"feature1", (Type)Types.BooleanType.get())}), (String)"struct of named boolean options"), Types.NestedField.required((int)4, (String)"locations", (Type)Types.MapType.ofRequired((int)10, (int)11, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"address", (Type)Types.StringType.get()), Types.NestedField.required((int)21, (String)"city", (Type)Types.StringType.get()), Types.NestedField.required((int)22, (String)"state", (Type)Types.StringType.get()), Types.NestedField.required((int)23, (String)"zip", (Type)Types.IntegerType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)12, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)13, (String)"long", (Type)Types.FloatType.get())})), (String)"map of address to coordinate"), Types.NestedField.optional((int)5, (String)"points", (Type)Types.ListType.ofOptional((int)14, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)15, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)16, (String)"y", (Type)Types.LongType.get())})), (String)"2-D cartesian points"), Types.NestedField.required((int)6, (String)"doubles", (Type)Types.ListType.ofRequired((int)17, (Type)Types.DoubleType.get())), Types.NestedField.optional((int)7, (String)"properties", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.StringType.get(), (Type)Types.StringType.get()), (String)"string map of properties")});
        Schema updatedNested = (Schema)new SchemaUpdate(SCHEMA, 23).deleteColumn("preferences.feature1").addColumn("preferences", "feature1", (Type)Types.BooleanType.get()).apply();
        Assert.assertEquals((String)"Should match with added fields", (Object)expectedNested.asStruct(), (Object)updatedNested.asStruct());
    }

    @Test
    public void testDeleteMissingColumn() {
        AssertHelpers.assertThrows((String)"Should reject delete missing column", IllegalArgumentException.class, (String)"missing column: col", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.deleteColumn("col");
        });
    }

    @Test
    public void testAddDeleteConflict() {
        AssertHelpers.assertThrows((String)"Should reject add then delete", IllegalArgumentException.class, (String)"missing column: col", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.addColumn("col", (Type)Types.IntegerType.get()).deleteColumn("col");
        });
        AssertHelpers.assertThrows((String)"Should reject add then delete", IllegalArgumentException.class, (String)"column that has additions: preferences", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.addColumn("preferences", "feature3", (Type)Types.IntegerType.get()).deleteColumn("preferences");
        });
    }

    @Test
    public void testRenameMissingColumn() {
        AssertHelpers.assertThrows((String)"Should reject rename missing column", IllegalArgumentException.class, (String)"missing column: col", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.renameColumn("col", "fail");
        });
    }

    @Test
    public void testRenameDeleteConflict() {
        AssertHelpers.assertThrows((String)"Should reject rename then delete", IllegalArgumentException.class, (String)"column that has updates: id", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.renameColumn("id", "col").deleteColumn("id");
        });
        AssertHelpers.assertThrows((String)"Should reject rename then delete", IllegalArgumentException.class, (String)"missing column: col", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.renameColumn("id", "col").deleteColumn("col");
        });
    }

    @Test
    public void testDeleteRenameConflict() {
        AssertHelpers.assertThrows((String)"Should reject delete then rename", IllegalArgumentException.class, (String)"column that will be deleted: id", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.deleteColumn("id").renameColumn("id", "identifier");
        });
    }

    @Test
    public void testUpdateMissingColumn() {
        AssertHelpers.assertThrows((String)"Should reject rename missing column", IllegalArgumentException.class, (String)"missing column: col", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.updateColumn("col", (Type.PrimitiveType)Types.DateType.get());
        });
    }

    @Test
    public void testUpdateDeleteConflict() {
        AssertHelpers.assertThrows((String)"Should reject update then delete", IllegalArgumentException.class, (String)"column that has updates: id", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.updateColumn("id", (Type.PrimitiveType)Types.LongType.get()).deleteColumn("id");
        });
    }

    @Test
    public void testDeleteUpdateConflict() {
        AssertHelpers.assertThrows((String)"Should reject delete then update", IllegalArgumentException.class, (String)"column that will be deleted: id", () -> {
            SchemaUpdate update = new SchemaUpdate(SCHEMA, 23);
            update.deleteColumn("id").updateColumn("id", (Type.PrimitiveType)Types.LongType.get());
        });
    }

    @Test
    public void testDeleteMapKey() {
        AssertHelpers.assertThrows((String)"Should reject delete map key", IllegalArgumentException.class, (String)"Cannot delete map keys", () -> new SchemaUpdate(SCHEMA, 23).deleteColumn("locations.key").apply());
    }

    @Test
    public void testAddFieldToMapKey() {
        AssertHelpers.assertThrows((String)"Should reject add sub-field to map key", IllegalArgumentException.class, (String)"Cannot add fields to map keys", () -> new SchemaUpdate(SCHEMA, 23).addColumn("locations.key", "address_line_2", (Type)Types.StringType.get()).apply());
    }

    @Test
    public void testAlterMapKey() {
        AssertHelpers.assertThrows((String)"Should reject alter sub-field of map key", IllegalArgumentException.class, (String)"Cannot alter map keys", () -> new SchemaUpdate(SCHEMA, 23).updateColumn("locations.key.zip", (Type.PrimitiveType)Types.LongType.get()).apply());
    }

    @Test
    public void testUpdateMapKey() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"m", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.IntegerType.get(), (Type)Types.DoubleType.get()))});
        AssertHelpers.assertThrows((String)"Should reject update map key", IllegalArgumentException.class, (String)"Cannot update map keys", () -> new SchemaUpdate(schema, 3).updateColumn("m.key", (Type.PrimitiveType)Types.LongType.get()).apply());
    }

    @Test
    public void testUpdateAddedColumnDoc() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"i", (Type)Types.IntegerType.get())});
        AssertHelpers.assertThrows((String)"Should reject add and update doc", IllegalArgumentException.class, (String)"Cannot update missing column", () -> new SchemaUpdate(schema, 3).addColumn("value", (Type)Types.LongType.get()).updateColumnDoc("value", "a value").apply());
    }

    @Test
    public void testUpdateDeletedColumnDoc() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"i", (Type)Types.IntegerType.get())});
        AssertHelpers.assertThrows((String)"Should reject add and update doc", IllegalArgumentException.class, (String)"Cannot update a column that will be deleted", () -> new SchemaUpdate(schema, 3).deleteColumn("i").updateColumnDoc("i", "a value").apply());
    }

    @Test
    public void testMultipleMoves() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"d", (Type)Types.IntegerType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"d", (Type)Types.IntegerType.get()), Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 4).moveFirst("d").moveFirst("c").moveAfter("b", "d").moveBefore("d", "a").apply();
        Assert.assertEquals((String)"Schema should match", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveTopLevelColumnFirst() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 2).moveFirst("data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveTopLevelColumnBeforeFirst() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 2).moveBefore("data", "id").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveTopLevelColumnAfterLast() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 2).moveAfter("id", "data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveTopLevelColumnAfter() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"ts", (Type)Types.TimestampType.withZone())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 3).moveAfter("ts", "id").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveTopLevelColumnBefore() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 3).moveBefore("ts", "data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveNestedFieldFirst() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get())}))});
        Schema actual = (Schema)new SchemaUpdate(schema, 4).moveFirst("struct.data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveNestedFieldBeforeFirst() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get())}))});
        Schema actual = (Schema)new SchemaUpdate(schema, 4).moveBefore("struct.data", "struct.count").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveNestedFieldAfterLast() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get())}))});
        Schema actual = (Schema)new SchemaUpdate(schema, 4).moveAfter("struct.count", "struct.data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveNestedFieldAfter() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone())}))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema actual = (Schema)new SchemaUpdate(schema, 5).moveAfter("struct.ts", "struct.count").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveNestedFieldBefore() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema actual = (Schema)new SchemaUpdate(schema, 5).moveBefore("struct.ts", "struct.data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveListElementField() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"list", (Type)Types.ListType.ofOptional((int)6, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())})))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"list", (Type)Types.ListType.ofOptional((int)6, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())})))});
        Schema actual = (Schema)new SchemaUpdate(schema, 6).moveBefore("list.ts", "list.data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveMapValueStructField() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"map", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())})))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"map", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())})))});
        Schema actual = (Schema)new SchemaUpdate(schema, 7).moveBefore("map.ts", "map.data").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveAddedTopLevelColumn() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 2).addColumn("ts", (Type)Types.TimestampType.withZone()).moveAfter("ts", "id").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveAddedTopLevelColumnAfterAddedColumn() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)4, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Schema actual = (Schema)new SchemaUpdate(schema, 2).addColumn("ts", (Type)Types.TimestampType.withZone()).addColumn("count", (Type)Types.LongType.get()).moveAfter("ts", "id").moveAfter("count", "ts").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveAddedNestedStructField() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema actual = (Schema)new SchemaUpdate(schema, 4).addColumn("struct", "ts", (Type)Types.TimestampType.withZone()).moveBefore("struct.ts", "struct.count").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveAddedNestedStructFieldBeforeAddedColumn() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"size", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"count", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())}))});
        Schema actual = (Schema)new SchemaUpdate(schema, 4).addColumn("struct", "ts", (Type)Types.TimestampType.withZone()).addColumn("struct", "size", (Type)Types.LongType.get()).moveBefore("struct.ts", "struct.count").moveBefore("struct.size", "struct.ts").apply();
        Assert.assertEquals((String)"Should move data first", (Object)expected.asStruct(), (Object)actual.asStruct());
    }

    @Test
    public void testMoveSelfReferenceFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        AssertHelpers.assertThrows((String)"Should fail move for a field that is not in the schema", IllegalArgumentException.class, (String)"Cannot move id before itself", () -> (Schema)new SchemaUpdate(schema, 2).moveBefore("id", "id").apply());
        AssertHelpers.assertThrows((String)"Should fail move for a field that is not in the schema", IllegalArgumentException.class, (String)"Cannot move id after itself", () -> (Schema)new SchemaUpdate(schema, 2).moveAfter("id", "id").apply());
    }

    @Test
    public void testMoveMissingColumnFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        AssertHelpers.assertThrows((String)"Should fail move for a field that is not in the schema", IllegalArgumentException.class, (String)"Cannot move missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveFirst("items").apply());
        AssertHelpers.assertThrows((String)"Should fail move for a field that is not in the schema", IllegalArgumentException.class, (String)"Cannot move missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveBefore("items", "id").apply());
        AssertHelpers.assertThrows((String)"Should fail move for a field that is not in the schema", IllegalArgumentException.class, (String)"Cannot move missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveAfter("items", "data").apply());
    }

    @Test
    public void testMoveBeforeAddFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        AssertHelpers.assertThrows((String)"Should fail move for a field that has not been added yet", IllegalArgumentException.class, (String)"Cannot move missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveFirst("ts").addColumn("ts", (Type)Types.TimestampType.withZone()).apply());
        AssertHelpers.assertThrows((String)"Should fail move for a field that has not been added yet", IllegalArgumentException.class, (String)"Cannot move missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveBefore("ts", "id").addColumn("ts", (Type)Types.TimestampType.withZone()).apply());
        AssertHelpers.assertThrows((String)"Should fail move for a field that has not been added yet", IllegalArgumentException.class, (String)"Cannot move missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveAfter("ts", "data").addColumn("ts", (Type)Types.TimestampType.withZone()).apply());
    }

    @Test
    public void testMoveMissingReferenceColumnFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        AssertHelpers.assertThrows((String)"Should fail move before a field that is not in the schema", IllegalArgumentException.class, (String)"Cannot move id before missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveBefore("id", "items").apply());
        AssertHelpers.assertThrows((String)"Should fail move after for a field that is not in the schema", IllegalArgumentException.class, (String)"Cannot move data after missing column", () -> (Schema)new SchemaUpdate(schema, 2).moveAfter("data", "items").apply());
    }

    @Test
    public void testMovePrimitiveMapKeyFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"map", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        AssertHelpers.assertThrows((String)"Should fail move for map key", IllegalArgumentException.class, (String)"Cannot move fields in non-struct type", () -> (Schema)new SchemaUpdate(schema, 5).moveBefore("map.key", "map.value").apply());
    }

    @Test
    public void testMovePrimitiveMapValueFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"map", (Type)Types.MapType.ofRequired((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0])))});
        AssertHelpers.assertThrows((String)"Should fail move for map value", IllegalArgumentException.class, (String)"Cannot move fields in non-struct type", () -> (Schema)new SchemaUpdate(schema, 5).moveBefore("map.value", "map.key").apply());
    }

    @Test
    public void testMovePrimitiveListElementFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"list", (Type)Types.ListType.ofRequired((int)4, (Type)Types.StringType.get()))});
        AssertHelpers.assertThrows((String)"Should fail move for list element", IllegalArgumentException.class, (String)"Cannot move fields in non-struct type", () -> (Schema)new SchemaUpdate(schema, 4).moveBefore("list.element", "list").apply());
    }

    @Test
    public void testMoveTopLevelBetweenStructsFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)5, (String)"y", (Type)Types.IntegerType.get())}))});
        AssertHelpers.assertThrows((String)"Should fail move between separate structs", IllegalArgumentException.class, (String)"Cannot move field a to a different struct", () -> (Schema)new SchemaUpdate(schema, 5).moveBefore("a", "struct.x").apply());
    }

    @Test
    public void testMoveBetweenStructsFails() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"b", (Type)Types.IntegerType.get())})), Types.NestedField.required((int)2, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.required((int)6, (String)"y", (Type)Types.IntegerType.get())}))});
        AssertHelpers.assertThrows((String)"Should fail move between separate structs", IllegalArgumentException.class, (String)"Cannot move field s2.x to a different struct", () -> (Schema)new SchemaUpdate(schema, 6).moveBefore("s2.x", "s1.a").apply());
    }

    @Test
    public void testAddExistingIdentifierFields() {
        Schema newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"id"}).apply();
        Assert.assertEquals((String)"add an existing field as identifier field should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
    }

    @Test
    public void testAddNewIdentifierFieldColumns() {
        Schema newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn("new_field", (Type)Types.StringType.get()).setIdentifierFields(new String[]{"id", "new_field"}).apply();
        Assert.assertEquals((String)"add column then set as identifier should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("id").fieldId(), newSchema.findField("new_field").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().setIdentifierFields(new String[]{"id", "new_field"}).addRequiredColumn("new_field", (Type)Types.StringType.get()).apply();
        Assert.assertEquals((String)"set identifier then add column should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("id").fieldId(), newSchema.findField("new_field").fieldId()}), (Object)newSchema.identifierFieldIds());
    }

    @Test
    public void testAddNestedIdentifierFieldColumns() {
        Schema newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn("required_struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)25, (String)"field", (Type)Types.StringType.get())})).apply();
        newSchema = (Schema)new SchemaUpdate(newSchema, 25).setIdentifierFields(new String[]{"required_struct.field"}).apply();
        Assert.assertEquals((String)"set existing nested field as identifier should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("required_struct.field").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn("new", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)25, (String)"field", (Type)Types.StringType.get())})).setIdentifierFields(new String[]{"new.field"}).apply();
        Assert.assertEquals((String)"set newly added nested field as identifier should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("new.field").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn("new", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)25, (String)"field", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)26, (String)"nested", (Type)Types.StringType.get())}))})).setIdentifierFields(new String[]{"new.field.nested"}).apply();
        Assert.assertEquals((String)"set newly added multi-layer nested field as identifier should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("new.field.nested").fieldId()}), (Object)newSchema.identifierFieldIds());
    }

    @Test
    public void testAddDottedIdentifierFieldColumns() {
        Schema newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn(null, "dot.field", (Type)Types.StringType.get()).setIdentifierFields(new String[]{"id", "dot.field"}).apply();
        Assert.assertEquals((String)"add a field with dot as identifier should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("id").fieldId(), newSchema.findField("dot.field").fieldId()}), (Object)newSchema.identifierFieldIds());
    }

    @Test
    public void testRemoveIdentifierFields() {
        Schema newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn("new_field", (Type)Types.StringType.get()).addRequiredColumn("new_field2", (Type)Types.StringType.get()).setIdentifierFields(new String[]{"id", "new_field", "new_field2"}).apply();
        newSchema = (Schema)new SchemaUpdate(newSchema, 23).setIdentifierFields(new String[]{"new_field", "new_field2"}).apply();
        Assert.assertEquals((String)"remove an identifier field should succeed", (Object)Sets.newHashSet((Object[])new Integer[]{newSchema.findField("new_field").fieldId(), newSchema.findField("new_field2").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(newSchema, 23).setIdentifierFields((Collection)Sets.newHashSet()).apply();
        Assert.assertEquals((String)"remove all identifier fields should succeed", (Object)Sets.newHashSet(), (Object)newSchema.identifierFieldIds());
    }

    @Test
    public void testSetIdentifierFieldsFails() {
        Schema testSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"float", (Type)Types.FloatType.get()), Types.NestedField.required((int)3, (String)"double", (Type)Types.DoubleType.get())});
        AssertHelpers.assertThrows((String)"Creating schema with nonexistent identifier fieldId should fail", IllegalArgumentException.class, (String)"Cannot add fieldId 999 as an identifier field: field does not exist", () -> new Schema(testSchema.asStruct().fields(), (Set)ImmutableSet.of((Object)999)));
        AssertHelpers.assertThrows((String)"Creating schema with optional identifier field should fail", IllegalArgumentException.class, (String)"Cannot add field id as an identifier field: not a required field", () -> new Schema(testSchema.asStruct().fields(), (Set)ImmutableSet.of((Object)1)));
        AssertHelpers.assertThrows((String)"Creating schema with float identifier field should fail", IllegalArgumentException.class, (String)"Cannot add field float as an identifier field: must not be float or double field", () -> new Schema(testSchema.asStruct().fields(), (Set)ImmutableSet.of((Object)2)));
        AssertHelpers.assertThrows((String)"Creating schema with double identifier field should fail", IllegalArgumentException.class, (String)"Cannot add field double as an identifier field: must not be float or double field", () -> new Schema(testSchema.asStruct().fields(), (Set)ImmutableSet.of((Object)3)));
        AssertHelpers.assertThrows((String)"add a field with name not exist should fail", IllegalArgumentException.class, (String)"not found in current schema or added columns", () -> (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"unknown"}).apply());
        AssertHelpers.assertThrows((String)"add a field of non-primitive type should fail", IllegalArgumentException.class, (String)"not a primitive type field", () -> (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"locations"}).apply());
        AssertHelpers.assertThrows((String)"add an optional field should fail", IllegalArgumentException.class, (String)"not a required field", () -> (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"data"}).apply());
        AssertHelpers.assertThrows((String)"add a map key nested field should fail", IllegalArgumentException.class, (String)("must not be nested in " + SCHEMA.findField("locations")), () -> (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"locations.key.zip"}).apply());
        AssertHelpers.assertThrows((String)"add a nested field in list should fail", IllegalArgumentException.class, (String)("must not be nested in " + SCHEMA.findField("points")), () -> (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"points.element.x"}).apply());
        Schema newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn("col_float", (Type)Types.FloatType.get()).addRequiredColumn("col_double", (Type)Types.DoubleType.get()).addRequiredColumn("new", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)27, (String)"fields", (Type)Types.ListType.ofRequired((int)28, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)29, (String)"nested", (Type)Types.StringType.get())})))})).addRequiredColumn("new_map", (Type)Types.MapType.ofRequired((int)31, (int)32, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)33, (String)"key_col", (Type)Types.StringType.get())}), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)34, (String)"val_col", (Type)Types.StringType.get())})), "map of address to coordinate").addRequiredColumn("required_list", (Type)Types.ListType.ofRequired((int)36, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)37, (String)"x", (Type)Types.LongType.get()), Types.NestedField.required((int)38, (String)"y", (Type)Types.LongType.get())}))).apply();
        int lastColId = 38;
        AssertHelpers.assertThrows((String)"add a nested field in list should fail", IllegalArgumentException.class, (String)("must not be nested in " + newSchema.findField("required_list")), () -> (Schema)new SchemaUpdate(newSchema, lastColId).setIdentifierFields(new String[]{"required_list.element.x"}).apply());
        AssertHelpers.assertThrows((String)"add a double field should fail", IllegalArgumentException.class, (String)"must not be float or double field", () -> (Schema)new SchemaUpdate(newSchema, lastColId).setIdentifierFields(new String[]{"col_double"}).apply());
        AssertHelpers.assertThrows((String)"add a float field should fail", IllegalArgumentException.class, (String)"must not be float or double field", () -> (Schema)new SchemaUpdate(newSchema, lastColId).setIdentifierFields(new String[]{"col_float"}).apply());
        AssertHelpers.assertThrows((String)"add a map value nested field should fail", IllegalArgumentException.class, (String)("must not be nested in " + newSchema.findField("new_map")), () -> (Schema)new SchemaUpdate(newSchema, lastColId).setIdentifierFields(new String[]{"new_map.value.val_col"}).apply());
        AssertHelpers.assertThrows((String)"add a nested field in struct of a list should fail", IllegalArgumentException.class, (String)("must not be nested in " + newSchema.findField("new.fields")), () -> (Schema)new SchemaUpdate(newSchema, lastColId).setIdentifierFields(new String[]{"new.fields.element.nested"}).apply());
        AssertHelpers.assertThrows((String)"add a nested field in an optional struct should fail", IllegalArgumentException.class, (String)("must not be nested in an optional field " + newSchema.findField("preferences")), () -> (Schema)new SchemaUpdate(newSchema, lastColId).setIdentifierFields(new String[]{"preferences.feature1"}).apply());
    }

    @Test
    public void testDeleteIdentifierFieldColumns() {
        Schema schemaWithIdentifierFields = (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"id"}).apply();
        Assert.assertEquals((String)"delete column and then reset identifier field should succeed", (Object)Sets.newHashSet(), (Object)((Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).deleteColumn("id").setIdentifierFields((Collection)Sets.newHashSet()).apply()).identifierFieldIds());
        Assert.assertEquals((String)"delete reset identifier field and then delete column should succeed", (Object)Sets.newHashSet(), (Object)((Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).setIdentifierFields((Collection)Sets.newHashSet()).deleteColumn("id").apply()).identifierFieldIds());
    }

    @Test
    public void testDeleteIdentifierFieldColumnsFails() {
        Schema schemaWithIdentifierFields = (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"id"}).apply();
        AssertHelpers.assertThrows((String)"delete an identifier column without setting identifier fields should fail", IllegalArgumentException.class, (String)"Cannot delete identifier field 1: id: required int. To force deletion, also call setIdentifierFields to update identifier fields.", () -> (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).deleteColumn("id").apply());
    }

    @Test
    public void testDeleteContainingNestedIdentifierFieldColumnsFails() {
        Schema newSchema = (Schema)new SchemaUpdate(SCHEMA, 23).allowIncompatibleChanges().addRequiredColumn("out", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)25, (String)"nested", (Type)Types.StringType.get())})).setIdentifierFields(new String[]{"out.nested"}).apply();
        AssertHelpers.assertThrows((String)"delete a struct with a nested identifier column without setting identifier fields should fail", IllegalArgumentException.class, (String)"Cannot delete field 24: out: required struct<25: nested: required string> as it will delete nested identifier field 25: nested: required string", () -> (Schema)new SchemaUpdate(newSchema, 25).deleteColumn("out").apply());
    }

    @Test
    public void testRenameIdentifierFields() {
        Schema schemaWithIdentifierFields = (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"id"}).apply();
        Schema newSchema = (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).renameColumn("id", "id2").apply();
        Assert.assertEquals((String)"rename should not affect identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{SCHEMA.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
    }

    @Test
    public void testMoveIdentifierFields() {
        Schema schemaWithIdentifierFields = (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"id"}).apply();
        Schema newSchema = (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).moveAfter("id", "locations").apply();
        Assert.assertEquals((String)"move after should not affect identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{SCHEMA.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).moveBefore("id", "locations").apply();
        Assert.assertEquals((String)"move before should not affect identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{SCHEMA.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).moveFirst("id").apply();
        Assert.assertEquals((String)"move first should not affect identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{SCHEMA.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
    }

    @Test
    public void testMoveIdentifierFieldsCaseInsensitive() {
        Schema schemaWithIdentifierFields = (Schema)new SchemaUpdate(SCHEMA, 23).setIdentifierFields(new String[]{"id"}).apply();
        Schema newSchema = (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).caseSensitive(false).moveAfter("iD", "locations").apply();
        Assert.assertEquals((String)"move after should not affect identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{SCHEMA.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).caseSensitive(false).moveBefore("ID", "locations").apply();
        Assert.assertEquals((String)"move before should not affect identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{SCHEMA.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
        newSchema = (Schema)new SchemaUpdate(schemaWithIdentifierFields, 23).caseSensitive(false).moveFirst("ID").apply();
        Assert.assertEquals((String)"move first should not affect identifier fields", (Object)Sets.newHashSet((Object[])new Integer[]{SCHEMA.findField("id").fieldId()}), (Object)newSchema.identifierFieldIds());
    }
}

