/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaUpdate;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaUnionByFieldName {
    private static List<? extends Type.PrimitiveType> primitiveTypes() {
        return Lists.newArrayList((Object[])new Type.PrimitiveType[]{Types.StringType.get(), Types.TimeType.get(), Types.TimestampType.withoutZone(), Types.TimestampType.withZone(), Types.UUIDType.get(), Types.DateType.get(), Types.BooleanType.get(), Types.BinaryType.get(), Types.DoubleType.get(), Types.IntegerType.get(), Types.FixedType.ofLength((int)10), Types.DecimalType.of((int)10, (int)2), Types.LongType.get(), Types.FloatType.get()});
    }

    private static Types.NestedField[] primitiveFields(Integer initialValue, List<? extends Type.PrimitiveType> primitiveTypes) {
        AtomicInteger atomicInteger = new AtomicInteger(initialValue);
        return (Types.NestedField[])primitiveTypes.stream().map(type -> Types.NestedField.optional((int)atomicInteger.incrementAndGet(), (String)type.toString(), (Type)Types.fromPrimitiveString((String)type.toString()))).toArray(Types.NestedField[]::new);
    }

    @Test
    public void testAddTopLevelPrimitives() {
        Schema newSchema = new Schema(TestSchemaUnionByFieldName.primitiveFields(0, TestSchemaUnionByFieldName.primitiveTypes()));
        Schema applied = (Schema)new SchemaUpdate(new Schema(new Types.NestedField[0]), 0).unionByNameWith(newSchema).apply();
        Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testAddTopLevelListOfPrimitives() {
        for (Type.PrimitiveType primitiveType : TestSchemaUnionByFieldName.primitiveTypes()) {
            Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aList", (Type)Types.ListType.ofOptional((int)2, (Type)primitiveType))});
            Schema applied = (Schema)new SchemaUpdate(new Schema(new Types.NestedField[0]), 0).unionByNameWith(newSchema).apply();
            Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
        }
    }

    @Test
    public void testAddTopLevelMapOfPrimitives() {
        for (Type.PrimitiveType primitiveType : TestSchemaUnionByFieldName.primitiveTypes()) {
            Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aMap", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)primitiveType, (Type)primitiveType))});
            Schema applied = (Schema)new SchemaUpdate(new Schema(new Types.NestedField[0]), 0).unionByNameWith(newSchema).apply();
            Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
        }
    }

    @Test
    public void testAddTopLevelStructOfPrimitives() {
        for (Type.PrimitiveType primitiveType : TestSchemaUnionByFieldName.primitiveTypes()) {
            Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"primitive", (Type)primitiveType)}))});
            Schema applied = (Schema)new SchemaUpdate(new Schema(new Types.NestedField[0]), 0).unionByNameWith(currentSchema).apply();
            Assert.assertEquals((Object)currentSchema.asStruct(), (Object)applied.asStruct());
        }
    }

    @Test
    public void testAddNestedPrimitive() {
        for (Type.PrimitiveType primitiveType : TestSchemaUnionByFieldName.primitiveTypes()) {
            Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))});
            Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"primitive", (Type)primitiveType)}))});
            Schema applied = (Schema)new SchemaUpdate(currentSchema, 1).unionByNameWith(newSchema).apply();
            Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
        }
    }

    @Test
    public void testAddNestedPrimitives() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aStruct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[0]))});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aStruct", (Type)Types.StructType.of((Types.NestedField[])TestSchemaUnionByFieldName.primitiveFields(1, TestSchemaUnionByFieldName.primitiveTypes())))});
        Schema applied = (Schema)new SchemaUpdate(currentSchema, 1).unionByNameWith(newSchema).apply();
        Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testAddNestedLists() {
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aList", (Type)Types.ListType.ofOptional((int)2, (Type)Types.ListType.ofOptional((int)3, (Type)Types.ListType.ofOptional((int)4, (Type)Types.ListType.ofOptional((int)5, (Type)Types.ListType.ofOptional((int)6, (Type)Types.ListType.ofOptional((int)7, (Type)Types.ListType.ofOptional((int)8, (Type)Types.ListType.ofOptional((int)9, (Type)Types.ListType.ofOptional((int)10, (Type)Types.DecimalType.of((int)11, (int)20)))))))))))});
        Schema applied = (Schema)new SchemaUpdate(new Schema(new Types.NestedField[0]), 0).unionByNameWith(newSchema).apply();
        Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testAddNestedStruct() {
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"struct2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"struct3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)4, (String)"struct4", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"struct5", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"struct6", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)7, (String)"aString", (Type)Types.StringType.get())}))}))}))}))}))}))});
        Schema applied = (Schema)new SchemaUpdate(new Schema(new Types.NestedField[0]), 0).unionByNameWith(newSchema).apply();
        Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testAddNestedMaps() {
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"struct", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)8, (int)9, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)10, (int)11, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)12, (int)13, (Type)Types.StringType.get(), (Type)Types.StringType.get())))))))});
        Schema applied = (Schema)new SchemaUpdate(new Schema(new Types.NestedField[0]), 0).unionByNameWith(newSchema).apply();
        Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testDetectInvalidTopLevelList() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aList", (Type)Types.ListType.ofOptional((int)2, (Type)Types.StringType.get()))});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aList", (Type)Types.ListType.ofOptional((int)2, (Type)Types.LongType.get()))});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Schema cfr_ignored_0 = (Schema)new SchemaUpdate(currentSchema, 2).unionByNameWith(newSchema).apply();
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot change column type: aList.element: string -> long");
    }

    @Test
    public void testDetectInvalidTopLevelMapValue() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aMap", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aMap", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.LongType.get()))});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Schema cfr_ignored_0 = (Schema)new SchemaUpdate(currentSchema, 3).unionByNameWith(newSchema).apply();
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot change column type: aMap.value: string -> long");
    }

    @Test
    public void testDetectInvalidTopLevelMapKey() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aMap", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aMap", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.UUIDType.get(), (Type)Types.StringType.get()))});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Schema cfr_ignored_0 = (Schema)new SchemaUpdate(currentSchema, 3).unionByNameWith(newSchema).apply();
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot change column type: aMap.key: string -> uuid");
    }

    @Test
    public void testTypePromoteIntegerToLong() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.IntegerType.get())});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.LongType.get())});
        Schema applied = (Schema)new SchemaUpdate(currentSchema, 1).unionByNameWith(newSchema).apply();
        Assert.assertEquals((long)1L, (long)applied.asStruct().fields().size());
        Assert.assertEquals((Object)Types.LongType.get(), (Object)((Types.NestedField)applied.asStruct().fields().get(0)).type());
    }

    @Test
    public void testTypePromoteFloatToDouble() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.FloatType.get())});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.DoubleType.get())});
        Schema applied = (Schema)new SchemaUpdate(currentSchema, 1).unionByNameWith(newSchema).apply();
        Assert.assertEquals((long)1L, (long)applied.asStruct().fields().size());
        Assert.assertEquals((Object)Types.DoubleType.get(), (Object)((Types.NestedField)applied.asStruct().fields().get(0)).type());
    }

    @Test
    public void testInvalidTypePromoteDoubleToFloat() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.DoubleType.get())});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.FloatType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Schema cfr_ignored_0 = (Schema)new SchemaUpdate(currentSchema, 1).unionByNameWith(newSchema).apply();
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot change column type: aCol: double -> float");
    }

    @Test
    public void testTypePromoteDecimalToFixedScaleWithWiderPrecision() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.DecimalType.of((int)20, (int)1))});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"aCol", (Type)Types.DecimalType.of((int)22, (int)1))});
        Schema applied = (Schema)new SchemaUpdate(currentSchema, 1).unionByNameWith(newSchema).apply();
        Assert.assertEquals((Object)newSchema.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testAddPrimitiveToNestedStruct() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"struct2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"list", (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"value", (Type)Types.StringType.get())})))}))}))});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"struct2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"list", (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"time", (Type)Types.TimeType.get())})))}))}))});
        Schema applied = (Schema)new SchemaUpdate(schema, 5).unionByNameWith(newSchema).apply();
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"struct2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"list", (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"value", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"time", (Type)Types.TimeType.get())})))}))}))});
        Assert.assertEquals((Object)expected.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testReplaceListWithPrimitive() {
        Schema currentSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aColumn", (Type)Types.ListType.ofOptional((int)2, (Type)Types.StringType.get()))});
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"aColumn", (Type)Types.StringType.get())});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Schema cfr_ignored_0 = (Schema)new SchemaUpdate(currentSchema, 2).unionByNameWith(newSchema).apply();
        }).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot change column type: aColumn: list<string> -> string");
    }

    @Test
    public void testMirroredSchemas() {
        Schema aSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)9, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)8, (String)"string1", (Type)Types.StringType.get())})), Types.NestedField.optional((int)6, (String)"list1", (Type)Types.ListType.ofOptional((int)7, (Type)Types.StringType.get())), Types.NestedField.optional((int)5, (String)"string2", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"string3", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"string4", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"string5", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"string6", (Type)Types.StringType.get())});
        Schema mirrored = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"string1", (Type)Types.StringType.get())})), Types.NestedField.optional((int)3, (String)"list1", (Type)Types.ListType.ofOptional((int)4, (Type)Types.StringType.get())), Types.NestedField.optional((int)5, (String)"string2", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"string3", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"string4", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"string5", (Type)Types.StringType.get()), Types.NestedField.optional((int)9, (String)"string6", (Type)Types.StringType.get())});
        Schema union = (Schema)new SchemaUpdate(aSchema, 0).unionByNameWith(mirrored).apply();
        Assert.assertEquals((Object)aSchema.asStruct(), (Object)union.asStruct());
    }

    @Test
    public void addNewTopLevelStruct() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"map1", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"string1", (Type)Types.StringType.get())}))))});
        Schema observed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"map1", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"string1", (Type)Types.StringType.get())})))), Types.NestedField.optional((int)6, (String)"struct1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)7, (String)"d1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)8, (String)"d2", (Type)Types.StringType.get())}))}))});
        Schema union = (Schema)new SchemaUpdate(schema, 5).unionByNameWith(observed).apply();
        Assert.assertEquals((Object)observed.asStruct(), (Object)union.asStruct());
    }

    @Test
    public void testAppendNestedStruct() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)4, (String)"s4", (Type)Types.StringType.get())}))}))}))});
        Schema observed = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)4, (String)"s4", (Type)Types.StringType.get())})), Types.NestedField.optional((int)5, (String)"repeat", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)6, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)7, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)8, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)9, (String)"s4", (Type)Types.StringType.get())}))}))}))}))}))}))});
        Schema applied = (Schema)new SchemaUpdate(schema, 4).unionByNameWith(observed).apply();
        Assert.assertEquals((Object)observed.asStruct(), (Object)applied.asStruct());
    }

    @Test
    public void testAppendNestedLists() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)4, (String)"list1", (Type)Types.ListType.ofOptional((int)5, (Type)Types.StringType.get()))}))}))}))});
        Schema observed = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)4, (String)"list2", (Type)Types.ListType.ofOptional((int)5, (Type)Types.StringType.get()))}))}))}))});
        Schema union = (Schema)new SchemaUpdate(schema, 5).unionByNameWith(observed).apply();
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"s1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"s2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"s3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)4, (String)"list1", (Type)Types.ListType.ofOptional((int)5, (Type)Types.StringType.get())), Types.NestedField.optional((int)6, (String)"list2", (Type)Types.ListType.ofOptional((int)7, (Type)Types.StringType.get()))}))}))}))});
        Assert.assertEquals((Object)expected.asStruct(), (Object)union.asStruct());
    }
}

