/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSchemaID
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSchemaID(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testNoChange() {
        int onlyId = this.table.schema().schemaId();
        Map<Integer, Schema> onlySchemaMap = this.schemaMap(this.table.schema());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        TestHelpers.assertSameSchemaMap(onlySchemaMap, (Map)this.table.schemas());
        Assert.assertEquals((String)"Current snapshot's schemaId should be the current", (long)this.table.schema().schemaId(), (long)this.table.currentSnapshot().schemaId().intValue());
        Assert.assertEquals((String)"Schema ids should be correct in snapshots", (Object)ImmutableList.of((Object)onlyId), (Object)Lists.transform((List)Lists.newArrayList((Iterable)this.table.snapshots()), Snapshot::schemaId));
        this.table.newDelete().deleteFile(FILE_A).commit();
        TestHelpers.assertSameSchemaMap(onlySchemaMap, (Map)this.table.schemas());
        Assert.assertEquals((String)"Current snapshot's schemaId should be the current", (long)this.table.schema().schemaId(), (long)this.table.currentSnapshot().schemaId().intValue());
        Assert.assertEquals((String)"Schema ids should be correct in snapshots", (Object)ImmutableList.of((Object)onlyId, (Object)onlyId), (Object)Lists.transform((List)Lists.newArrayList((Iterable)this.table.snapshots()), Snapshot::schemaId));
        this.table.newFastAppend().appendFile(FILE_A2).commit();
        TestHelpers.assertSameSchemaMap(onlySchemaMap, (Map)this.table.schemas());
        Assert.assertEquals((String)"Current snapshot's schemaId should be the current", (long)this.table.schema().schemaId(), (long)this.table.currentSnapshot().schemaId().intValue());
        Assert.assertEquals((String)"Schema ids should be correct in snapshots", (Object)ImmutableList.of((Object)onlyId, (Object)onlyId, (Object)onlyId), (Object)Lists.transform((List)Lists.newArrayList((Iterable)this.table.snapshots()), Snapshot::schemaId));
    }

    @Test
    public void testSchemaIdChangeInSchemaUpdate() {
        Schema originalSchema = this.table.schema();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        TestHelpers.assertSameSchemaMap(this.schemaMap(this.table.schema()), (Map)this.table.schemas());
        Assert.assertEquals((String)"Current snapshot's schemaId should be the current", (long)this.table.schema().schemaId(), (long)this.table.currentSnapshot().schemaId().intValue());
        Assert.assertEquals((String)"Schema ids should be correct in snapshots", (Object)ImmutableList.of((Object)originalSchema.schemaId()), (Object)Lists.transform((List)Lists.newArrayList((Iterable)this.table.snapshots()), Snapshot::schemaId));
        this.table.updateSchema().addColumn("data2", (Type)Types.StringType.get()).commit();
        Schema updatedSchema = new Schema(1, new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"data2", (Type)Types.StringType.get())});
        TestHelpers.assertSameSchemaMap(this.schemaMap(originalSchema, updatedSchema), (Map)this.table.schemas());
        Assert.assertEquals((String)"Current snapshot's schemaId should be old since update schema doesn't create new snapshot", (long)originalSchema.schemaId(), (long)this.table.currentSnapshot().schemaId().intValue());
        Assert.assertEquals((String)"Current schema should match", (Object)updatedSchema.asStruct(), (Object)this.table.schema().asStruct());
        Assert.assertEquals((String)"Schema ids should be correct in snapshots", (Object)ImmutableList.of((Object)originalSchema.schemaId()), (Object)Lists.transform((List)Lists.newArrayList((Iterable)this.table.snapshots()), Snapshot::schemaId));
        this.table.newDelete().deleteFile(FILE_A).commit();
        TestHelpers.assertSameSchemaMap(this.schemaMap(originalSchema, updatedSchema), (Map)this.table.schemas());
        Assert.assertEquals((String)"Current snapshot's schemaId should be the current", (long)updatedSchema.schemaId(), (long)this.table.currentSnapshot().schemaId().intValue());
        Assert.assertEquals((String)"Current schema should match", (Object)updatedSchema.asStruct(), (Object)this.table.schema().asStruct());
        Assert.assertEquals((String)"Schema ids should be correct in snapshots", (Object)ImmutableList.of((Object)originalSchema.schemaId(), (Object)updatedSchema.schemaId()), (Object)Lists.transform((List)Lists.newArrayList((Iterable)this.table.snapshots()), Snapshot::schemaId));
        this.table.newAppend().appendFile(FILE_A2).commit();
        TestHelpers.assertSameSchemaMap(this.schemaMap(originalSchema, updatedSchema), (Map)this.table.schemas());
        Assert.assertEquals((String)"Current snapshot's schemaId should be the current", (long)updatedSchema.schemaId(), (long)this.table.currentSnapshot().schemaId().intValue());
        Assert.assertEquals((String)"Current schema should match", (Object)updatedSchema.asStruct(), (Object)this.table.schema().asStruct());
        Assert.assertEquals((String)"Schema ids should be correct in snapshots", (Object)ImmutableList.of((Object)originalSchema.schemaId(), (Object)updatedSchema.schemaId(), (Object)updatedSchema.schemaId()), (Object)Lists.transform((List)Lists.newArrayList((Iterable)this.table.snapshots()), Snapshot::schemaId));
    }

    private Map<Integer, Schema> schemaMap(Schema ... schemas) {
        return Arrays.stream(schemas).collect(Collectors.toMap(Schema::schemaId, Function.identity()));
    }
}

