/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashSet;
import java.util.Objects;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSchemaAndMappingUpdate
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestSchemaAndMappingUpdate(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testAddPrimitiveColumn() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        this.table.updateSchema().addColumn("count", (Type)Types.LongType.get()).commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        this.validateUnchanged(mapping, updated);
        MappedField newMapping = updated.find(new String[]{"count"});
        Assert.assertNotNull((String)"Mapping for new column should be added", (Object)newMapping);
        Assert.assertEquals((String)"Mapping should use the assigned field ID", (Object)this.table.schema().findField("count").fieldId(), (Object)updated.find(new String[]{"count"}).id());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)updated.find(new String[]{"count"}).nestedMapping());
    }

    @Test
    public void testAddStructColumn() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        this.table.updateSchema().addColumn("location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"lat", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)2, (String)"long", (Type)Types.DoubleType.get())})).commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        this.validateUnchanged(mapping, updated);
        MappedField newMapping = updated.find(new String[]{"location"});
        Assert.assertNotNull((String)"Mapping for new column should be added", (Object)newMapping);
        Assert.assertEquals((String)"Mapping should use the assigned field ID", (Object)this.table.schema().findField("location").fieldId(), (Object)updated.find(new String[]{"location"}).id());
        Assert.assertNotNull((String)"Should contain a nested mapping", (Object)updated.find(new String[]{"location"}).nestedMapping());
        Assert.assertEquals((String)"Mapping should use the assigned field ID", (Object)this.table.schema().findField("location.lat").fieldId(), (Object)updated.find(new String[]{"location.lat"}).id());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)updated.find(new String[]{"location.lat"}).nestedMapping());
        Assert.assertEquals((String)"Mapping should use the assigned field ID", (Object)this.table.schema().findField("location.long").fieldId(), (Object)updated.find(new String[]{"location.long"}).id());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)updated.find(new String[]{"location.long"}).nestedMapping());
    }

    @Test
    public void testRenameColumn() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        this.table.updateSchema().renameColumn("id", "object_id").commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        int idColumnId = this.table.schema().findField("object_id").fieldId();
        this.validateUnchanged(Iterables.filter((Iterable)mapping.asMappedFields().fields(), field -> !Objects.equals(idColumnId, field.id())), updated);
        MappedField updatedMapping = updated.find(idColumnId);
        Assert.assertNotNull((String)"Mapping for id column should exist", (Object)updatedMapping);
        Assert.assertEquals((String)"Should add the new column name to the existing mapping", (Object)MappedField.of((Integer)idColumnId, (Iterable)ImmutableList.of((Object)"id", (Object)"object_id")), (Object)updatedMapping);
    }

    @Test
    public void testDeleteColumn() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        this.table.updateSchema().deleteColumn("id").commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        this.validateUnchanged(mapping, updated);
    }

    @Test
    public void testModificationWithMetricsMetrics() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).set("write.metadata.metrics.column.id", "full").commit();
        AssertHelpers.assertThrows((String)"Creating metrics for non-existent column fails", ValidationException.class, null, () -> this.table.updateProperties().set("schema.name-mapping.default", mappingJson).set("write.metadata.metrics.column.ids", "full").commit());
        this.table.updateSchema().renameColumn("id", "bloop").commit();
        Assert.assertNotNull((String)"Make sure the metrics config now has bloop", this.table.properties().get("write.metadata.metrics.column.bloop"));
        Assert.assertNull((String)"Make sure the metrics config no longer has id", this.table.properties().get("write.metadata.metrics.column.id"));
        this.table.updateSchema().deleteColumn("bloop").commit();
        Assert.assertNull((String)"Make sure the metrics config no longer has id", this.table.properties().get("write.metadata.metrics.column.id"));
        Assert.assertNull((String)"Make sure the metrics config no longer has bloop", this.table.properties().get("write.metadata.metrics.column.bloop"));
    }

    @Test
    public void testModificationWithParquetBloomConfig() {
        this.table.updateProperties().set("write.parquet.bloom-filter-enabled.column.id", "true").commit();
        this.table.updateSchema().renameColumn("id", "ID").commit();
        Assert.assertNotNull((String)"Parquet bloom config for new column name ID should exists", this.table.properties().get("write.parquet.bloom-filter-enabled.column.ID"));
        Assert.assertNull((String)"Parquet bloom config for old column name id should not exists", this.table.properties().get("write.parquet.bloom-filter-enabled.column.id"));
        this.table.updateSchema().deleteColumn("ID").commit();
        Assert.assertNull((String)"Parquet bloom config for dropped column name ID should not exists", this.table.properties().get("write.parquet.bloom-filter-enabled.column.ID"));
    }

    @Test
    public void testDeleteAndAddColumnReassign() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        int startIdColumnId = this.table.schema().findField("id").fieldId();
        this.table.updateSchema().deleteColumn("id").commit();
        this.table.updateSchema().addColumn("id", (Type)Types.StringType.get()).commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        int idColumnId = this.table.schema().findField("id").fieldId();
        HashSet changedIds = Sets.newHashSet((Object[])new Integer[]{startIdColumnId, idColumnId});
        this.validateUnchanged(Iterables.filter((Iterable)mapping.asMappedFields().fields(), field -> !changedIds.contains(field.id())), updated);
        MappedField newMapping = updated.find(new String[]{"id"});
        Assert.assertNotNull((String)"Mapping for id column should exist", (Object)newMapping);
        Assert.assertEquals((String)"Mapping should use the new field ID", (Object)idColumnId, (Object)newMapping.id());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)newMapping.nestedMapping());
        MappedField updatedMapping = updated.find(startIdColumnId);
        Assert.assertNotNull((String)"Mapping for original id column should exist", (Object)updatedMapping);
        Assert.assertEquals((String)"Mapping should use the original field ID", (Object)startIdColumnId, (Object)updatedMapping.id());
        Assert.assertFalse((String)"Should not use id as a name", (boolean)updatedMapping.names().contains("id"));
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)updatedMapping.nestedMapping());
    }

    @Test
    public void testDeleteAndRenameColumnReassign() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        int startIdColumnId = this.table.schema().findField("id").fieldId();
        this.table.updateSchema().deleteColumn("id").commit();
        this.table.updateSchema().renameColumn("data", "id").commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        int idColumnId = this.table.schema().findField("id").fieldId();
        HashSet changedIds = Sets.newHashSet((Object[])new Integer[]{startIdColumnId, idColumnId});
        this.validateUnchanged(Iterables.filter((Iterable)mapping.asMappedFields().fields(), field -> !changedIds.contains(field.id())), updated);
        MappedField newMapping = updated.find(new String[]{"id"});
        Assert.assertNotNull((String)"Mapping for id column should exist", (Object)newMapping);
        Assert.assertEquals((String)"Mapping should use the new field ID", (Object)idColumnId, (Object)newMapping.id());
        Assert.assertEquals((String)"Should have both names", (Object)Sets.newHashSet((Object[])new String[]{"id", "data"}), (Object)newMapping.names());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)newMapping.nestedMapping());
        MappedField updatedMapping = updated.find(startIdColumnId);
        Assert.assertNotNull((String)"Mapping for original id column should exist", (Object)updatedMapping);
        Assert.assertEquals((String)"Mapping should use the original field ID", (Object)startIdColumnId, (Object)updatedMapping.id());
        Assert.assertFalse((String)"Should not use id as a name", (boolean)updatedMapping.names().contains("id"));
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)updatedMapping.nestedMapping());
    }

    @Test
    public void testRenameAndAddColumnReassign() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        int startIdColumnId = this.table.schema().findField("id").fieldId();
        this.table.updateSchema().renameColumn("id", "object_id").commit();
        NameMapping afterRename = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((String)"Renamed column should have both names", (Object)Sets.newHashSet((Object[])new String[]{"id", "object_id"}), (Object)afterRename.find(startIdColumnId).names());
        this.table.updateSchema().renameColumn("object_id", "oid").addColumn("id", (Type)Types.StringType.get()).commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        int idColumnId = this.table.schema().findField("id").fieldId();
        HashSet changedIds = Sets.newHashSet((Object[])new Integer[]{startIdColumnId, idColumnId});
        this.validateUnchanged(Iterables.filter((Iterable)afterRename.asMappedFields().fields(), field -> !changedIds.contains(field.id())), updated);
        MappedField newMapping = updated.find(new String[]{"id"});
        Assert.assertNotNull((String)"Mapping for id column should exist", (Object)newMapping);
        Assert.assertEquals((String)"Mapping should use the new field ID", (Object)idColumnId, (Object)newMapping.id());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)newMapping.nestedMapping());
        MappedField updatedMapping = updated.find(startIdColumnId);
        Assert.assertNotNull((String)"Mapping for original id column should exist", (Object)updatedMapping);
        Assert.assertEquals((String)"Mapping should use the original field ID", (Object)startIdColumnId, (Object)updatedMapping.id());
        Assert.assertEquals((String)"Should not use id as a name", (Object)Sets.newHashSet((Object[])new String[]{"object_id", "oid"}), (Object)updatedMapping.names());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)updatedMapping.nestedMapping());
    }

    @Test
    public void testRenameAndRenameColumnReassign() {
        NameMapping mapping = MappingUtil.create((Schema)this.table.schema());
        String mappingJson = NameMappingParser.toJson((NameMapping)mapping);
        this.table.updateProperties().set("schema.name-mapping.default", mappingJson).commit();
        int startIdColumnId = this.table.schema().findField("id").fieldId();
        this.table.updateSchema().renameColumn("id", "object_id").commit();
        NameMapping afterRename = NameMappingParser.fromJson((String)((String)this.table.properties().get("schema.name-mapping.default")));
        Assert.assertEquals((String)"Renamed column should have both names", (Object)Sets.newHashSet((Object[])new String[]{"id", "object_id"}), (Object)afterRename.find(startIdColumnId).names());
        this.table.updateSchema().renameColumn("object_id", "oid").renameColumn("data", "id").commit();
        String updatedJson = (String)this.table.properties().get("schema.name-mapping.default");
        NameMapping updated = NameMappingParser.fromJson((String)updatedJson);
        int idColumnId = this.table.schema().findField("id").fieldId();
        HashSet changedIds = Sets.newHashSet((Object[])new Integer[]{startIdColumnId, idColumnId});
        this.validateUnchanged(Iterables.filter((Iterable)afterRename.asMappedFields().fields(), field -> !changedIds.contains(field.id())), updated);
        MappedField newMapping = updated.find(new String[]{"id"});
        Assert.assertNotNull((String)"Mapping for id column should exist", (Object)newMapping);
        Assert.assertEquals((String)"Renamed column should have both names", (Object)Sets.newHashSet((Object[])new String[]{"id", "data"}), (Object)newMapping.names());
        Assert.assertEquals((String)"Mapping should use the new field ID", (Object)idColumnId, (Object)newMapping.id());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)newMapping.nestedMapping());
        MappedField updatedMapping = updated.find(startIdColumnId);
        Assert.assertNotNull((String)"Mapping for original id column should exist", (Object)updatedMapping);
        Assert.assertEquals((String)"Mapping should use the original field ID", (Object)startIdColumnId, (Object)updatedMapping.id());
        Assert.assertEquals((String)"Should not use id as a name", (Object)Sets.newHashSet((Object[])new String[]{"object_id", "oid"}), (Object)updatedMapping.names());
        Assert.assertNull((String)"Should not contain a nested mapping", (Object)updatedMapping.nestedMapping());
    }

    private void validateUnchanged(NameMapping original, NameMapping updated) {
        MappedFields updatedFields = updated.asMappedFields();
        for (MappedField field : original.asMappedFields().fields()) {
            Assert.assertEquals((String)"Existing fields should not change", (Object)field, (Object)updatedFields.field(field.id().intValue()));
        }
    }

    private void validateUnchanged(Iterable<MappedField> fields, NameMapping updated) {
        MappedFields updatedFields = updated.asMappedFields();
        for (MappedField field : fields) {
            Assert.assertEquals((String)"Existing fields should not change", (Object)field, (Object)updatedFields.field(field.id().intValue()));
        }
    }
}

