/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.RandomAvroData;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestScansAndSchemaEvolution {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"part", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("part").build();
    public final int formatVersion;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestScansAndSchemaEvolution(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    private DataFile createDataFile(String partValue) throws IOException {
        List<GenericData.Record> expected = RandomAvroData.generate(SCHEMA, 100, 0L);
        InMemoryOutputFile dataFile = new InMemoryOutputFile(FileFormat.AVRO.addExtension(UUID.randomUUID().toString()));
        try (FileAppender writer = Avro.write((OutputFile)dataFile).schema(SCHEMA).named("test").build();){
            for (GenericData.Record rec : expected) {
                rec.put("part", (Object)partValue);
                writer.add((Object)rec);
            }
        }
        PartitionData partition = new PartitionData(SPEC.partitionType());
        partition.set(0, (Object)partValue);
        return DataFiles.builder((PartitionSpec)SPEC).withInputFile(dataFile.toInputFile()).withPartition((StructLike)partition).withRecordCount(100L).build();
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    @Test
    public void testPartitionSourceRename() throws IOException {
        File location = this.temp.newFolder();
        Assert.assertTrue((boolean)location.delete());
        TestTables.TestTable table = TestTables.create(location, "test", SCHEMA, SPEC, this.formatVersion);
        DataFile fileOne = this.createDataFile("one");
        DataFile fileTwo = this.createDataFile("two");
        table.newAppend().appendFile(fileOne).appendFile(fileTwo).commit();
        ArrayList tasks = Lists.newArrayList((Iterable)((TableScan)table.newScan().filter((Expression)Expressions.equal((String)"part", (Object)"one"))).planFiles());
        Assert.assertEquals((String)"Should produce 1 matching file task", (long)1L, (long)tasks.size());
        table.updateSchema().renameColumn("part", "p").commit();
        tasks = Lists.newArrayList((Iterable)((TableScan)table.newScan().filter((Expression)Expressions.equal((String)"p", (Object)"one"))).planFiles());
        Assert.assertEquals((String)"Should produce 1 matching file task", (long)1L, (long)tasks.size());
    }
}

