/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.ScanSummary;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestScanSummary
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestScanSummary(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testSnapshotTimeRangeValidation() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long secondSnapshotId = this.table.currentSnapshot().snapshotId();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.expireSnapshots().expireOlderThan(t1).commit();
        Assert.assertEquals((String)"Should have one snapshot", (long)1L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertEquals((String)"Snapshot should be the second snapshot created", (long)secondSnapshotId, (long)this.table.currentSnapshot().snapshotId());
        TableScan scan = (TableScan)((TableScan)this.table.newScan().filter((Expression)Expressions.greaterThanOrEqual((String)"dateCreated", (Object)t0))).filter((Expression)Expressions.lessThan((String)"dateCreated", (Object)t2));
        AssertHelpers.assertThrows((String)"Should fail summary because range may include expired snapshots", IllegalArgumentException.class, (String)"may include expired snapshots", () -> new ScanSummary.Builder(scan).build());
    }

    @Test
    public void testTimestampRanges() {
        long lower = 1542750188523L;
        long upper = 1542750695131L;
        Assert.assertEquals((String)"Should use inclusive bound", (Object)Pair.of((Object)Long.MIN_VALUE, (Object)upper), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.lessThanOrEqual((String)"ts_ms", (Object)upper))));
        Assert.assertEquals((String)"Should use lower value for upper bound", (Object)Pair.of((Object)Long.MIN_VALUE, (Object)upper), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.lessThanOrEqual((String)"ts_ms", (Object)(upper + 918234L)), (Object)Expressions.lessThanOrEqual((String)"ts_ms", (Object)upper))));
        Assert.assertEquals((String)"Should make upper bound inclusive", (Object)Pair.of((Object)Long.MIN_VALUE, (Object)(upper - 1L)), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.lessThan((String)"ts_ms", (Object)upper))));
        Assert.assertEquals((String)"Should use inclusive bound", (Object)Pair.of((Object)lower, (Object)Long.MAX_VALUE), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.greaterThanOrEqual((String)"ts_ms", (Object)lower))));
        Assert.assertEquals((String)"Should use upper value for lower bound", (Object)Pair.of((Object)lower, (Object)Long.MAX_VALUE), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.greaterThanOrEqual((String)"ts_ms", (Object)(lower - 918234L)), (Object)Expressions.greaterThanOrEqual((String)"ts_ms", (Object)lower))));
        Assert.assertEquals((String)"Should make lower bound inclusive", (Object)Pair.of((Object)(lower + 1L), (Object)Long.MAX_VALUE), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.greaterThan((String)"ts_ms", (Object)lower))));
        Assert.assertEquals((String)"Should set both bounds for equals", (Object)Pair.of((Object)lower, (Object)lower), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.equal((String)"ts_ms", (Object)lower))));
        Assert.assertEquals((String)"Should set both bounds", (Object)Pair.of((Object)lower, (Object)(upper - 1L)), (Object)ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.greaterThanOrEqual((String)"ts_ms", (Object)lower), (Object)Expressions.lessThan((String)"ts_ms", (Object)upper))));
        AssertHelpers.assertThrows((String)"Should reject empty ranges", IllegalArgumentException.class, (String)"No timestamps can match filters", () -> ScanSummary.timestampRange((List)ImmutableList.of((Object)Expressions.greaterThanOrEqual((String)"ts_ms", (Object)lower), (Object)Expressions.lessThan((String)"ts_ms", (Object)lower))));
    }

    @Test
    public void testToMillis() {
        long millis = 1542750947417L;
        Assert.assertEquals((long)1542750947000L, (long)ScanSummary.toMillis((long)(millis / 1000L)));
        Assert.assertEquals((long)1542750947417L, (long)ScanSummary.toMillis((long)millis));
        Assert.assertEquals((long)1542750947417L, (long)ScanSummary.toMillis((long)(millis * 1000L + 918L)));
    }
}

