/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.metrics.CommitReport;
import org.apache.iceberg.metrics.LoggingMetricsReporter;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;

public class TestScanPlanningAndReporting
extends TableTestBase {
    private final TestMetricsReporter reporter = new TestMetricsReporter();

    public TestScanPlanningAndReporting() {
        super(2);
    }

    @Test
    public void noDuplicatesInScanContext() {
        TableScanContext context = TableScanContext.empty();
        Assertions.assertThat((Object)context.metricsReporter()).isInstanceOf(LoggingMetricsReporter.class);
        MetricsReporter first = report -> {};
        MetricsReporter second = report -> {};
        context = context.reportWith(first).reportWith(first);
        Assertions.assertThat((Object)context.metricsReporter()).isSameAs((Object)first);
        context = context.reportWith(second);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((ObjectAssert)Assertions.assertThat((Object)context.metricsReporter()).as("should be a CompositeMetricsReporter", new Object[0])).extracting("reporters").asInstanceOf(InstanceOfAssertFactories.collection(MetricsReporter.class))).hasSize(2)).containsExactlyInAnyOrder((Object[])new MetricsReporter[]{first, second});
        context = context.reportWith((MetricsReporter)LoggingMetricsReporter.instance()).reportWith(second);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((ObjectAssert)Assertions.assertThat((Object)context.metricsReporter()).as("should be a CompositeMetricsReporter", new Object[0])).extracting("reporters").asInstanceOf(InstanceOfAssertFactories.collection(MetricsReporter.class))).hasSize(3)).containsExactlyInAnyOrder((Object[])new MetricsReporter[]{LoggingMetricsReporter.instance(), first, second});
    }

    @Test
    public void scanningWithMultipleReporters() throws IOException {
        String tableName = "scan-with-multiple-reporters";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).commit();
        table.refresh();
        AtomicInteger reportedCount = new AtomicInteger();
        TableScan tableScan = (TableScan)((TableScan)table.newScan().metricsReporter(MetricsReporter2 -> reportedCount.getAndIncrement())).metricsReporter(MetricsReporter2 -> reportedCount.getAndIncrement());
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(task -> {});
        }
        ScanReport scanReport = this.reporter.lastReport();
        Assertions.assertThat((Object)scanReport).isNotNull();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo(tableName);
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(1L);
        ScanMetricsResult result = scanReport.scanMetrics();
        Assertions.assertThat((Duration)result.totalPlanningDuration().totalDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((long)result.resultDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((int)reportedCount.get()).isEqualTo(2);
    }

    @Test
    public void scanningWithMultipleDataManifests() throws IOException {
        String tableName = "multiple-data-manifests";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        table.newAppend().appendFile(FILE_D).commit();
        table.refresh();
        TableScan tableScan = table.newScan();
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(task -> {});
        }
        ScanReport scanReport = this.reporter.lastReport();
        Assertions.assertThat((Object)scanReport).isNotNull();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo(tableName);
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(2L);
        ScanMetricsResult result = scanReport.scanMetrics();
        Assertions.assertThat((Duration)result.totalPlanningDuration().totalDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((long)result.resultDataFiles().value()).isEqualTo(3L);
        Assertions.assertThat((long)result.resultDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.scannedDataManifests().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.scannedDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDataManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.totalDataManifests().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.totalDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.totalFileSizeInBytes().value()).isEqualTo(30L);
        Assertions.assertThat((long)result.totalDeleteFileSizeInBytes().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDataFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDeleteFiles().value()).isEqualTo(0L);
        try (CloseableIterable fileScanTasks = ((TableScan)table.newScan().filter((Expression)Expressions.equal((String)"data", (Object)"1"))).planFiles();){
            fileScanTasks.forEach(task -> {});
        }
        scanReport = this.reporter.lastReport();
        result = scanReport.scanMetrics();
        Assertions.assertThat((Object)scanReport).isNotNull();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo(tableName);
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(2L);
        Assertions.assertThat((Duration)result.totalPlanningDuration().totalDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((long)result.resultDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.resultDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.scannedDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.scannedDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.skippedDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.totalDataManifests().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.totalDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.totalFileSizeInBytes().value()).isEqualTo(10L);
        Assertions.assertThat((long)result.totalDeleteFileSizeInBytes().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDataFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDeleteFiles().value()).isEqualTo(0L);
    }

    @Test
    public void scanningWithDeletes() throws IOException {
        TestTables.TestTable table = TestTables.create(this.tableDir, "scan-planning-with-deletes", SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C).commit();
        table.newRowDelta().addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES).commit();
        TableScan tableScan = table.newScan();
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            fileScanTasks.forEach(task -> {});
        }
        ScanReport scanReport = this.reporter.lastReport();
        Assertions.assertThat((Object)scanReport).isNotNull();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo("scan-planning-with-deletes");
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(2L);
        ScanMetricsResult result = scanReport.scanMetrics();
        Assertions.assertThat((Duration)result.totalPlanningDuration().totalDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((long)result.resultDataFiles().value()).isEqualTo(3L);
        Assertions.assertThat((long)result.resultDeleteFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.scannedDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.scannedDeleteManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.skippedDataManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.totalDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.totalDeleteManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.totalFileSizeInBytes().value()).isEqualTo(30L);
        Assertions.assertThat((long)result.totalDeleteFileSizeInBytes().value()).isEqualTo(20L);
        Assertions.assertThat((long)result.skippedDataFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.indexedDeleteFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.equalityDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.positionalDeleteFiles().value()).isEqualTo(2L);
    }

    @Test
    public void scanningWithSkippedDataFiles() throws IOException {
        String tableName = "scan-planning-with-skipped-data-files";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).appendFile(FILE_D).commit();
        table.newAppend().appendFile(FILE_B).appendFile(FILE_C).commit();
        TableScan tableScan = table.newScan();
        try (CloseableIterable fileScanTasks = ((TableScan)tableScan.filter((Expression)Expressions.equal((String)"data", (Object)"1"))).planFiles();){
            fileScanTasks.forEach(task -> {});
        }
        ScanReport scanReport = this.reporter.lastReport();
        Assertions.assertThat((Object)scanReport).isNotNull();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo(tableName);
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(2L);
        ScanMetricsResult result = scanReport.scanMetrics();
        Assertions.assertThat((long)result.skippedDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.skippedDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((Duration)result.totalPlanningDuration().totalDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((long)result.resultDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.resultDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.scannedDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.scannedDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.skippedDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.totalDataManifests().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.totalDeleteManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.totalFileSizeInBytes().value()).isEqualTo(10L);
        Assertions.assertThat((long)result.totalDeleteFileSizeInBytes().value()).isEqualTo(0L);
    }

    @Test
    public void scanningWithSkippedDeleteFiles() throws IOException {
        String tableName = "scan-planning-with-skipped-delete-files";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).appendFile(FILE_D).commit();
        table.newRowDelta().addDeletes(FILE_A_DELETES).addDeletes(FILE_D2_DELETES).commit();
        table.newRowDelta().addDeletes(FILE_B_DELETES).addDeletes(FILE_C2_DELETES).commit();
        TableScan tableScan = table.newScan();
        try (CloseableIterable fileScanTasks = ((TableScan)tableScan.filter((Expression)Expressions.equal((String)"data", (Object)"1"))).planFiles();){
            fileScanTasks.forEach(task -> {});
        }
        ScanReport scanReport = this.reporter.lastReport();
        Assertions.assertThat((Object)scanReport).isNotNull();
        Assertions.assertThat((String)scanReport.tableName()).isEqualTo(tableName);
        Assertions.assertThat((long)scanReport.snapshotId()).isEqualTo(3L);
        ScanMetricsResult result = scanReport.scanMetrics();
        Assertions.assertThat((Duration)result.totalPlanningDuration().totalDuration()).isGreaterThan((Comparable)Duration.ZERO);
        Assertions.assertThat((long)result.resultDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.resultDeleteFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.skippedDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.skippedDeleteFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.scannedDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.scannedDeleteManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.skippedDataManifests().value()).isEqualTo(0L);
        Assertions.assertThat((long)result.skippedDeleteManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.totalDataManifests().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.totalDeleteManifests().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.totalFileSizeInBytes().value()).isEqualTo(10L);
        Assertions.assertThat((long)result.totalDeleteFileSizeInBytes().value()).isEqualTo(10L);
        Assertions.assertThat((long)result.indexedDeleteFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.equalityDeleteFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.positionalDeleteFiles().value()).isEqualTo(0L);
    }

    @Test
    public void scanningWithEqualityAndPositionalDeleteFiles() throws IOException {
        String tableName = "scan-planning-with-eq-and-pos-delete-files";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).commit();
        table.newRowDelta().addDeletes(FILE_A_DELETES).addDeletes(FILE_A2_DELETES).commit();
        TableScan tableScan = table.newScan();
        try (CloseableIterable fileScanTasks = ((TableScan)tableScan.filter((Expression)Expressions.equal((String)"data", (Object)"6"))).planFiles();){
            fileScanTasks.forEach(task -> {});
        }
        ScanReport scanReport = this.reporter.lastReport();
        Assertions.assertThat((Object)scanReport).isNotNull();
        ScanMetricsResult result = scanReport.scanMetrics();
        Assertions.assertThat((long)result.indexedDeleteFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)result.equalityDeleteFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)result.positionalDeleteFiles().value()).isEqualTo(1L);
    }

    static class TestMetricsReporter
    implements MetricsReporter {
        private final List<MetricsReport> reports = Lists.newArrayList();
        private final LoggingMetricsReporter delegate = LoggingMetricsReporter.instance();

        TestMetricsReporter() {
        }

        public void report(MetricsReport report) {
            this.reports.add(report);
            this.delegate.report(report);
        }

        public ScanReport lastReport() {
            if (this.reports.isEmpty()) {
                return null;
            }
            return (ScanReport)this.reports.get(this.reports.size() - 1);
        }

        public CommitReport lastCommitReport() {
            if (this.reports.isEmpty()) {
                return null;
            }
            return (CommitReport)this.reports.get(this.reports.size() - 1);
        }
    }
}

