/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Tables;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestScanDataFileColumns {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final Configuration CONF = new Configuration();
    private static final Tables TABLES = new HadoopTables(CONF);
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    private String tableLocation = null;
    private Table table = null;

    @Before
    public void createTables() throws IOException {
        File location = this.temp.newFolder("shared");
        Assert.assertTrue((boolean)location.delete());
        this.tableLocation = location.toString();
        this.table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)FileFormat.PARQUET.name()), this.tableLocation);
        this.table.newAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("file1.parquet").withFileSizeInBytes(100L).withMetrics(new Metrics(Long.valueOf(3L), (Map)ImmutableMap.of((Object)1, (Object)50L), (Map)ImmutableMap.of((Object)1, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestScanDataFileColumns.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestScanDataFileColumns.longToBuffer(2L)))).build()).appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("file2.parquet").withFileSizeInBytes(100L).withMetrics(new Metrics(Long.valueOf(3L), (Map)ImmutableMap.of((Object)1, (Object)60L), (Map)ImmutableMap.of((Object)1, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestScanDataFileColumns.longToBuffer(10L)), (Map)ImmutableMap.of((Object)1, (Object)TestScanDataFileColumns.longToBuffer(12L)))).build()).appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("file3.parquet").withFileSizeInBytes(100L).withMetrics(new Metrics(Long.valueOf(3L), (Map)ImmutableMap.of((Object)1, (Object)70L), (Map)ImmutableMap.of((Object)1, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestScanDataFileColumns.longToBuffer(20L)), (Map)ImmutableMap.of((Object)1, (Object)TestScanDataFileColumns.longToBuffer(22L)))).build()).commit();
    }

    @Test
    public void testColumnStatsIgnored() {
        for (FileScanTask fileTask : this.table.newScan().planFiles()) {
            Assert.assertNull((Object)((DataFile)fileTask.file()).valueCounts());
            Assert.assertNull((Object)((DataFile)fileTask.file()).nullValueCounts());
            Assert.assertNull((Object)((DataFile)fileTask.file()).lowerBounds());
            Assert.assertNull((Object)((DataFile)fileTask.file()).upperBounds());
        }
    }

    @Test
    public void testColumnStatsLoading() {
        for (FileScanTask fileTask : ((TableScan)this.table.newScan().includeColumnStats()).planFiles()) {
            Assert.assertNotNull((Object)((DataFile)fileTask.file()).valueCounts());
            Assert.assertNotNull((Object)((DataFile)fileTask.file()).nullValueCounts());
            Assert.assertNotNull((Object)((DataFile)fileTask.file()).lowerBounds());
            Assert.assertNotNull((Object)((DataFile)fileTask.file()).upperBounds());
            Assert.assertNotNull((Object)((DataFile)fileTask.file()).columnSizes());
        }
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }
}

