/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.V2TableTestBase;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRowDelta
extends V2TableTestBase {
    private final String branch;

    @Parameterized.Parameters(name="branch = {0}")
    public static Object[] parameters() {
        return new Object[][]{{"main"}, {"testBranch"}};
    }

    public TestRowDelta(String branch) {
        this.branch = branch;
    }

    @Test
    public void testAddDeleteFile() {
        RowDelta rowDelta = this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES);
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch);
        Snapshot snap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 1", (long)1L, (long)snap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 1", (long)1L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Delta commit should use operation 'overwrite'", (Object)"overwrite", (Object)snap.operation());
        Assert.assertEquals((String)"Should produce 1 data manifest", (long)1L, (long)snap.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(snap.snapshotId()), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)snap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)snap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L, 1L), TestRowDelta.fileSeqs(1L, 1L), TestRowDelta.ids(snap.snapshotId(), snap.snapshotId()), TestRowDelta.files(FILE_A_DELETES, FILE_B_DELETES), TestRowDelta.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testValidateDataFilesExistDefaults() {
        AppendFiles rowDelta1 = this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B);
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta1, this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        OverwriteFiles rowDelta2 = this.table.newOverwrite().deleteFile(FILE_A).addFile(FILE_A2);
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta2, this.branch);
        DeleteFiles rowDelta3 = this.table.newDelete().deleteFile(FILE_B);
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta3, this.branch);
        long deleteSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should fail to add FILE_A_DELETES because FILE_A is missing", ValidationException.class, (String)"Cannot commit, missing data files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(validateFromSnapshotId).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_A.path())), this.branch));
        Assert.assertEquals((String)"Table state should not be modified by failed RowDelta operation", (long)deleteSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
        Assert.assertEquals((String)"Table should not have any delete manifests", (long)0L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_B_DELETES).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_B.path())).validateFromSnapshot(validateFromSnapshotId), this.branch);
        Assert.assertEquals((String)"Table should have one new delete manifest", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
        ManifestFile deletes = (ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).get(0);
        this.validateDeleteManifest(deletes, TestRowDelta.dataSeqs(4L), TestRowDelta.fileSeqs(4L), TestRowDelta.ids(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()), TestRowDelta.files(FILE_B_DELETES), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testValidateDataFilesExistOverwrite() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_A).addFile(FILE_A2), this.branch);
        long deleteSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should fail to add FILE_A_DELETES because FILE_A is missing", ValidationException.class, (String)"Cannot commit, missing data files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(validateFromSnapshotId).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_A.path())), this.branch));
        Assert.assertEquals((String)"Table state should not be modified by failed RowDelta operation", (long)deleteSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
        Assert.assertEquals((String)"Table should not have any delete manifests", (long)0L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
    }

    @Test
    public void testValidateDataFilesExistReplacePartitions() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_A2), this.branch);
        long deleteSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should fail to add FILE_A_DELETES because FILE_A is missing", ValidationException.class, (String)"Cannot commit, missing data files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(validateFromSnapshotId).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_A.path())), this.branch));
        Assert.assertEquals((String)"Table state should not be modified by failed RowDelta operation", (long)deleteSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
        Assert.assertEquals((String)"Table should not have any delete manifests", (long)0L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
    }

    @Test
    public void testValidateDataFilesExistFromSnapshot() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        long appendSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_A2), this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        long replaceSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(validateFromSnapshotId).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_A.path())), this.branch);
        Snapshot snap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 2", (long)3L, (long)snap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 3", (long)3L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should have 2 data manifests", (long)2L, (long)snap.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(2L), TestRowDelta.fileSeqs(2L), TestRowDelta.ids(replaceSnapshotId), TestRowDelta.files(FILE_A2), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(1), TestRowDelta.dataSeqs(1L, 1L), TestRowDelta.fileSeqs(1L, 1L), TestRowDelta.ids(replaceSnapshotId, appendSnapshotId), TestRowDelta.files(FILE_A, FILE_B), TestRowDelta.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)snap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)snap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(3L), TestRowDelta.fileSeqs(3L), TestRowDelta.ids(snap.snapshotId()), TestRowDelta.files(FILE_A_DELETES), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testValidateDataFilesExistRewrite() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRewrite().rewriteFiles((Set)Sets.newHashSet((Object[])new DataFile[]{FILE_A}), (Set)Sets.newHashSet((Object[])new DataFile[]{FILE_A2})), this.branch);
        long deleteSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should fail to add FILE_A_DELETES because FILE_A is missing", ValidationException.class, (String)"Cannot commit, missing data files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(validateFromSnapshotId).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_A.path())), this.branch));
        Assert.assertEquals((String)"Table state should not be modified by failed RowDelta operation", (long)deleteSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
        Assert.assertEquals((String)"Table should not have any delete manifests", (long)0L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
    }

    @Test
    public void testValidateDataFilesExistValidateDeletes() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_A), this.branch);
        long deleteSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should fail to add FILE_A_DELETES because FILE_A is missing", ValidationException.class, (String)"Cannot commit, missing data files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateDeletedFiles().validateFromSnapshot(validateFromSnapshotId).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_A.path())), this.branch));
        Assert.assertEquals((String)"Table state should not be modified by failed RowDelta operation", (long)deleteSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
        Assert.assertEquals((String)"Table should not have any delete manifests", (long)0L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
    }

    @Test
    public void testValidateNoConflicts() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A2), this.branch);
        long appendSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should fail to add FILE_A_DELETES because FILE_A2 was added", ValidationException.class, (String)"Found conflicting files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(validateFromSnapshotId).conflictDetectionFilter((Expression)Expressions.equal((String)"data", (Object)"u")).validateNoConflictingDataFiles(), this.branch));
        Assert.assertEquals((String)"Table state should not be modified by failed RowDelta operation", (long)appendSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
        Assert.assertEquals((String)"Table should not have any delete manifests", (long)0L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
    }

    @Test
    public void testValidateNoConflictsFromSnapshot() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        long appendSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A2), this.branch);
        long validateFromSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateDeletedFiles().validateFromSnapshot(validateFromSnapshotId).validateDataFilesExist((Iterable)ImmutableList.of((Object)FILE_A.path())).conflictDetectionFilter((Expression)Expressions.equal((String)"data", (Object)"u")).validateNoConflictingDataFiles(), this.branch);
        Snapshot snap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 2", (long)3L, (long)snap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 3", (long)3L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should have 2 data manifests", (long)2L, (long)snap.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(2L), TestRowDelta.fileSeqs(2L), TestRowDelta.ids(validateFromSnapshotId), TestRowDelta.files(FILE_A2), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(1), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(appendSnapshotId), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)snap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)snap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(3L), TestRowDelta.fileSeqs(3L), TestRowDelta.ids(snap.snapshotId()), TestRowDelta.files(FILE_A_DELETES), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testOverwriteWithDeleteFile() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES), this.branch);
        long deltaSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Commit should produce sequence number 1", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 1", (long)1L, (long)this.table.ops().current().lastSequenceNumber());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newOverwrite().overwriteByRowFilter((Expression)Expressions.equal((UnboundTerm)Expressions.bucket((String)"data", (int)16), (Object)0)), this.branch);
        Snapshot snap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 2", (long)2L, (long)snap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 2", (long)2L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should produce 1 data manifest", (long)1L, (long)snap.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(snap.snapshotId()), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.DELETED));
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)snap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)snap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L, 1L), TestRowDelta.fileSeqs(1L, 1L), TestRowDelta.ids(snap.snapshotId(), deltaSnapshotId), TestRowDelta.files(FILE_A_DELETES, FILE_B_DELETES), TestRowDelta.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testReplacePartitionsWithDeleteFile() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES), this.branch);
        long deltaSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Commit should produce sequence number 1", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 1", (long)1L, (long)this.table.ops().current().lastSequenceNumber());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_A2), this.branch);
        Snapshot snap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 2", (long)2L, (long)snap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 2", (long)2L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should produce 2 data manifests", (long)2L, (long)snap.dataManifests(this.table.io()).size());
        int deleteManifestPos = ((ManifestFile)snap.dataManifests(this.table.io()).get(0)).deletedFilesCount() > 0 ? 0 : 1;
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(deleteManifestPos), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(snap.snapshotId()), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.DELETED));
        int appendManifestPos = deleteManifestPos == 0 ? 1 : 0;
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(appendManifestPos), TestRowDelta.dataSeqs(2L), TestRowDelta.fileSeqs(2L), TestRowDelta.ids(snap.snapshotId()), TestRowDelta.files(FILE_A2), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)snap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)snap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L, 1L), TestRowDelta.fileSeqs(1L, 1L), TestRowDelta.ids(snap.snapshotId(), deltaSnapshotId), TestRowDelta.files(FILE_A_DELETES, FILE_B_DELETES), TestRowDelta.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testDeleteByExpressionWithDeleteFile() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES), this.branch);
        long deltaSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Commit should produce sequence number 1", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 1", (long)1L, (long)this.table.ops().current().lastSequenceNumber());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()), this.branch);
        Snapshot snap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 2", (long)2L, (long)snap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 2", (long)2L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should produce 1 data manifest", (long)1L, (long)snap.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(snap.snapshotId()), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.DELETED));
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)snap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)snap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L, 1L), TestRowDelta.fileSeqs(1L, 1L), TestRowDelta.ids(snap.snapshotId(), snap.snapshotId()), TestRowDelta.files(FILE_A_DELETES, FILE_B_DELETES), TestRowDelta.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.DELETED));
    }

    @Test
    public void testDeleteDataFileWithDeleteFile() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_DELETES), this.branch);
        long deltaSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Commit should produce sequence number 1", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 1", (long)1L, (long)this.table.ops().current().lastSequenceNumber());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_A), this.branch);
        Snapshot deleteSnap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 2", (long)2L, (long)deleteSnap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 2", (long)2L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should produce 1 data manifest", (long)1L, (long)deleteSnap.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)deleteSnap.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(deleteSnap.snapshotId()), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.DELETED));
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)deleteSnap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)deleteSnap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(deltaSnapshotId), TestRowDelta.files(FILE_A_DELETES), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile((CharSequence)"no-such-file"), this.branch);
        Snapshot nextSnap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Append should produce sequence number 3", (long)3L, (long)nextSnap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 3", (long)3L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should have 0 data manifests", (long)0L, (long)nextSnap.dataManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)nextSnap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)nextSnap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(nextSnap.snapshotId()), TestRowDelta.files(FILE_A_DELETES), TestRowDelta.statuses(ManifestEntry.Status.DELETED));
    }

    @Test
    public void testFastAppendDoesNotRemoveStaleDeleteFiles() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_DELETES), this.branch);
        long deltaSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Commit should produce sequence number 1", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 1", (long)1L, (long)this.table.ops().current().lastSequenceNumber());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_A), this.branch);
        Snapshot deleteSnap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 2", (long)2L, (long)deleteSnap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 2", (long)2L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should produce 1 data manifest", (long)1L, (long)deleteSnap.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)deleteSnap.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(deleteSnap.snapshotId()), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.DELETED));
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)deleteSnap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)deleteSnap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(deltaSnapshotId), TestRowDelta.files(FILE_A_DELETES), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_B), this.branch);
        Snapshot nextSnap = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Append should produce sequence number 3", (long)3L, (long)nextSnap.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 3", (long)3L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should have 2 data manifests", (long)2L, (long)nextSnap.dataManifests(this.table.io()).size());
        int deleteManifestPos = ((ManifestFile)nextSnap.dataManifests(this.table.io()).get(0)).deletedFilesCount() > 0 ? 0 : 1;
        this.validateManifest((ManifestFile)nextSnap.dataManifests(this.table.io()).get(deleteManifestPos), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(deleteSnap.snapshotId()), TestRowDelta.files(FILE_A), TestRowDelta.statuses(ManifestEntry.Status.DELETED));
        int appendManifestPos = deleteManifestPos == 0 ? 1 : 0;
        this.validateManifest((ManifestFile)nextSnap.dataManifests(this.table.io()).get(appendManifestPos), TestRowDelta.dataSeqs(3L), TestRowDelta.fileSeqs(3L), TestRowDelta.ids(nextSnap.snapshotId()), TestRowDelta.files(FILE_B), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Should produce 1 delete manifest", (long)1L, (long)nextSnap.deleteManifests(this.table.io()).size());
        this.validateDeleteManifest((ManifestFile)nextSnap.deleteManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(1L), TestRowDelta.fileSeqs(1L), TestRowDelta.ids(deltaSnapshotId), TestRowDelta.files(FILE_A_DELETES), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testValidateDataFilesExistWithConflictDetectionFilter() {
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        DataFile dataFile1 = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("data=a").withRecordCount(1L).build();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile1), this.branch);
        DataFile dataFile2 = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("data=b").withRecordCount(1L).build();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        DeleteFile deleteFile = FileMetadata.deleteFileBuilder((PartitionSpec)this.table.spec()).ofPositionDeletes().withPath("/path/to/data-a-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data=a").withRecordCount(1L).build();
        UnboundPredicate conflictDetectionFilter = Expressions.equal((String)"data", (Object)"a");
        RowDelta rowDelta = this.table.newRowDelta().addDeletes(deleteFile).validateDataFilesExist((Iterable)ImmutableList.of((Object)dataFile1.path())).validateDeletedFiles().validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter((Expression)conflictDetectionFilter).validateNoConflictingDataFiles();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(dataFile2), this.branch);
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch);
        Assert.assertEquals((String)"Table should have one new delete manifest", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).size());
        ManifestFile deletes = (ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).deleteManifests(this.table.io()).get(0);
        this.validateDeleteManifest(deletes, TestRowDelta.dataSeqs(4L), TestRowDelta.fileSeqs(4L), TestRowDelta.ids(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()), TestRowDelta.files(deleteFile), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testValidateDataFilesDoNotExistWithConflictDetectionFilter() {
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        DataFile dataFile1 = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("data=a").withRecordCount(1L).build();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile1), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        DeleteFile deleteFile = FileMetadata.deleteFileBuilder((PartitionSpec)this.table.spec()).ofPositionDeletes().withPath("/path/to/data-a-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data=a").withRecordCount(1L).build();
        UnboundPredicate conflictDetectionFilter = Expressions.equal((String)"data", (Object)"a");
        RowDelta rowDelta = this.table.newRowDelta().addDeletes(deleteFile).validateDataFilesExist((Iterable)ImmutableList.of((Object)dataFile1.path())).validateDeletedFiles().validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter((Expression)conflictDetectionFilter).validateNoConflictingDataFiles();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(dataFile1), this.branch);
        AssertHelpers.assertThrows((String)"Should fail to add deletes because data file is missing", ValidationException.class, (String)"Cannot commit, missing data files", () -> this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch));
    }

    @Test
    public void testAddDeleteFilesMultipleSpecs() {
        this.table.updateProperties().set("write.summary.partition-limit", "10").commit();
        DataFile firstSnapshotDataFile = this.newDataFile("data_bucket=0");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(firstSnapshotDataFile), this.branch);
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        Assert.assertTrue((String)"Spec must be unpartitioned", (boolean)this.table.spec().isUnpartitioned());
        DataFile secondSnapshotDataFile = this.newDataFile("");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(secondSnapshotDataFile), this.branch);
        this.table.updateSpec().addField("data").commit();
        DataFile thirdSnapshotDataFile = this.newDataFile("data=abc");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(thirdSnapshotDataFile), this.branch);
        Assert.assertEquals((String)"Should have 3 specs", (long)3L, (long)this.table.specs().size());
        DataFile dataFile = this.newDataFile("data=xyz");
        DeleteFile firstDeleteFile = this.newDeleteFile(firstSnapshotDataFile.specId(), "data_bucket=0");
        DeleteFile secondDeleteFile = this.newDeleteFile(secondSnapshotDataFile.specId(), "");
        DeleteFile thirdDeleteFile = this.newDeleteFile(thirdSnapshotDataFile.specId(), "data=abc");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(dataFile).addDeletes(firstDeleteFile).addDeletes(secondDeleteFile).addDeletes(thirdDeleteFile), this.branch);
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Commit should produce sequence number 4", (long)4L, (long)snapshot.sequenceNumber());
        Assert.assertEquals((String)"Last sequence number should be 4", (long)4L, (long)this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Delta commit should be 'overwrite'", (Object)"overwrite", (Object)snapshot.operation());
        Map summary = snapshot.summary();
        Assert.assertEquals((String)"Should change 4 partitions", (Object)"4", summary.get("changed-partition-count"));
        Assert.assertEquals((String)"Should add 1 data file", (Object)"1", summary.get("added-data-files"));
        Assert.assertEquals((String)"Should have 4 data files", (Object)"4", summary.get("total-data-files"));
        Assert.assertEquals((String)"Should add 3 delete files", (Object)"3", summary.get("added-delete-files"));
        Assert.assertEquals((String)"Should have 3 delete files", (Object)"3", summary.get("total-delete-files"));
        Assert.assertEquals((String)"Should add 3 position deletes", (Object)"3", summary.get("added-position-deletes"));
        Assert.assertEquals((String)"Should have 3 position deletes", (Object)"3", summary.get("total-position-deletes"));
        Assert.assertTrue((String)"Partition metrics must be correct", (boolean)((String)summary.get("partitions.data_bucket=0")).contains("added-delete-files=1"));
        Assert.assertTrue((String)"Partition metrics must be correct", (boolean)((String)summary.get("partitions.data=abc")).contains("added-delete-files=1"));
        Assert.assertTrue((String)"Partition metrics must be correct", (boolean)((String)summary.get("partitions.data=xyz")).contains("added-data-files=1"));
        Assert.assertEquals((String)"Should have 4 data manifest", (long)4L, (long)snapshot.dataManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snapshot.dataManifests(this.table.io()).get(0), TestRowDelta.dataSeqs(4L), TestRowDelta.fileSeqs(4L), TestRowDelta.ids(snapshot.snapshotId()), TestRowDelta.files(dataFile), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Should produce 3 delete manifest", (long)3L, (long)snapshot.deleteManifests(this.table.io()).size());
        ManifestFile firstDeleteManifest = (ManifestFile)snapshot.deleteManifests(this.table.io()).get(2);
        Assert.assertEquals((String)"Spec must match", (long)firstSnapshotDataFile.specId(), (long)firstDeleteManifest.partitionSpecId());
        this.validateDeleteManifest(firstDeleteManifest, TestRowDelta.dataSeqs(4L), TestRowDelta.fileSeqs(4L), TestRowDelta.ids(snapshot.snapshotId()), TestRowDelta.files(firstDeleteFile), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        ManifestFile secondDeleteManifest = (ManifestFile)snapshot.deleteManifests(this.table.io()).get(1);
        Assert.assertEquals((String)"Spec must match", (long)secondSnapshotDataFile.specId(), (long)secondDeleteManifest.partitionSpecId());
        this.validateDeleteManifest(secondDeleteManifest, TestRowDelta.dataSeqs(4L), TestRowDelta.fileSeqs(4L), TestRowDelta.ids(snapshot.snapshotId()), TestRowDelta.files(secondDeleteFile), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
        ManifestFile thirdDeleteManifest = (ManifestFile)snapshot.deleteManifests(this.table.io()).get(0);
        Assert.assertEquals((String)"Spec must match", (long)thirdSnapshotDataFile.specId(), (long)thirdDeleteManifest.partitionSpecId());
        this.validateDeleteManifest(thirdDeleteManifest, TestRowDelta.dataSeqs(4L), TestRowDelta.fileSeqs(4L), TestRowDelta.ids(snapshot.snapshotId()), TestRowDelta.files(thirdDeleteFile), TestRowDelta.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testManifestMergingMultipleSpecs() {
        this.table.updateProperties().set("commit.manifest-merge.enabled", "true").set("commit.manifest.min-count-to-merge", "2").commit();
        DataFile firstSnapshotDataFile = this.newDataFile("data_bucket=0");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(firstSnapshotDataFile), this.branch);
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        Assert.assertTrue((String)"Spec must be unpartitioned", (boolean)this.table.spec().isUnpartitioned());
        DataFile secondSnapshotDataFile = this.newDataFile("");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(secondSnapshotDataFile), this.branch);
        DeleteFile firstDeleteFile = this.newDeleteFile(firstSnapshotDataFile.specId(), "data_bucket=0");
        DeleteFile secondDeleteFile = this.newDeleteFile(secondSnapshotDataFile.specId(), "");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(firstDeleteFile).addDeletes(secondDeleteFile), this.branch);
        Snapshot thirdSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Should have 2 data manifest", (long)2L, (long)thirdSnapshot.dataManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should have 2 delete manifest", (long)2L, (long)thirdSnapshot.deleteManifests(this.table.io()).size());
        DeleteFile thirdDeleteFile = this.newDeleteFile(firstSnapshotDataFile.specId(), "data_bucket=0");
        DeleteFile fourthDeleteFile = this.newDeleteFile(secondSnapshotDataFile.specId(), "");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(thirdDeleteFile).addDeletes(fourthDeleteFile), this.branch);
        Snapshot fourthSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Assert.assertEquals((String)"Should have 2 data manifest", (long)2L, (long)fourthSnapshot.dataManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should have 2 delete manifest", (long)2L, (long)fourthSnapshot.deleteManifests(this.table.io()).size());
        ManifestFile firstDeleteManifest = (ManifestFile)fourthSnapshot.deleteManifests(this.table.io()).get(1);
        Assert.assertEquals((String)"Spec must match", (long)firstSnapshotDataFile.specId(), (long)firstDeleteManifest.partitionSpecId());
        this.validateDeleteManifest(firstDeleteManifest, TestRowDelta.dataSeqs(4L, 3L), TestRowDelta.fileSeqs(4L, 3L), TestRowDelta.ids(fourthSnapshot.snapshotId(), thirdSnapshot.snapshotId()), TestRowDelta.files(thirdDeleteFile, firstDeleteFile), TestRowDelta.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING));
        ManifestFile secondDeleteManifest = (ManifestFile)fourthSnapshot.deleteManifests(this.table.io()).get(0);
        Assert.assertEquals((String)"Spec must match", (long)secondSnapshotDataFile.specId(), (long)secondDeleteManifest.partitionSpecId());
        this.validateDeleteManifest(secondDeleteManifest, TestRowDelta.dataSeqs(4L, 3L), TestRowDelta.fileSeqs(4L, 3L), TestRowDelta.ids(fourthSnapshot.snapshotId(), thirdSnapshot.snapshotId()), TestRowDelta.files(fourthDeleteFile, secondDeleteFile), TestRowDelta.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testAbortMultipleSpecs() {
        DataFile firstSnapshotDataFile = this.newDataFile("data_bucket=0");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(firstSnapshotDataFile), this.branch);
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        Assert.assertTrue((String)"Spec must be unpartitioned", (boolean)this.table.spec().isUnpartitioned());
        DataFile secondSnapshotDataFile = this.newDataFile("");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(secondSnapshotDataFile), this.branch);
        DeleteFile firstDeleteFile = this.newDeleteFile(firstSnapshotDataFile.specId(), "data_bucket=0");
        DeleteFile secondDeleteFile = this.newDeleteFile(secondSnapshotDataFile.specId(), "");
        HashSet deletedFiles = Sets.newHashSet();
        RowDelta rowDelta = ((RowDelta)((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addDeletes(firstDeleteFile).addDeletes(secondDeleteFile).deleteWith(deletedFiles::add)).validateDeletedFiles().validateDataFilesExist((Iterable)ImmutableList.of((Object)firstSnapshotDataFile.path()));
        rowDelta.apply();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(firstSnapshotDataFile), this.branch);
        AssertHelpers.assertThrows((String)"Should fail to commit row delta", ValidationException.class, (String)"Cannot commit, missing data files", () -> this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch));
        Assert.assertEquals((String)"Should delete 3 files", (long)3L, (long)deletedFiles.size());
    }

    @Test
    public void testConcurrentConflictingRowDelta() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        True conflictDetectionFilter = Expressions.alwaysTrue();
        RowDelta rowDelta = ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addRows(FILE_B).addDeletes(FILE_A_DELETES).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter((Expression)conflictDetectionFilter).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles();
        ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addDeletes(FILE_A_DELETES).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter((Expression)conflictDetectionFilter).validateNoConflictingDataFiles().commit();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Found new conflicting delete files", () -> this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch));
    }

    @Test
    public void testConcurrentConflictingRowDeltaWithoutAppendValidation() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        True conflictDetectionFilter = Expressions.alwaysTrue();
        RowDelta rowDelta = this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter((Expression)conflictDetectionFilter).validateNoConflictingDeleteFiles();
        ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addDeletes(FILE_A_DELETES).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter((Expression)conflictDetectionFilter).validateNoConflictingDataFiles().commit();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Found new conflicting delete files", () -> this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch));
    }

    @Test
    public void testConcurrentNonConflictingRowDelta() {
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        DataFile dataFile1 = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("data=a").withRecordCount(1L).build();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile1), this.branch);
        DataFile dataFile2 = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("data=b").withRecordCount(1L).build();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        UnboundPredicate conflictDetectionFilter = Expressions.equal((String)"data", (Object)"a");
        DeleteFile deleteFile1 = FileMetadata.deleteFileBuilder((PartitionSpec)this.table.spec()).ofPositionDeletes().withPath("/path/to/data-a-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data=a").withRecordCount(1L).build();
        RowDelta rowDelta = ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addDeletes(deleteFile1).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter((Expression)conflictDetectionFilter).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles();
        DeleteFile deleteFile2 = FileMetadata.deleteFileBuilder((PartitionSpec)this.table.spec()).ofPositionDeletes().withPath("/path/to/data-b-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data=b").withRecordCount(1L).build();
        ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addDeletes(deleteFile2).validateFromSnapshot(baseSnapshot.snapshotId()).commit();
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch);
        this.validateBranchDeleteFiles((Table)this.table, this.branch, deleteFile1, deleteFile2);
    }

    @Test
    public void testConcurrentNonConflictingRowDeltaAndRewriteFilesWithSequenceNumber() {
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        DataFile dataFile1 = this.newDataFile("data=a");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile1), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        DeleteFile deleteFile1 = this.newEqualityDeleteFile(this.table.spec().specId(), "data=a", ((Types.NestedField)this.table.schema().asStruct().fields().get(0)).fieldId());
        RowDelta rowDelta = ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addDeletes(deleteFile1).validateFromSnapshot(baseSnapshot.snapshotId()).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles();
        DataFile dataFile2 = this.newDataFile("data=a");
        RewriteFiles rewriteFiles = this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)dataFile1), (Set)ImmutableSet.of((Object)dataFile2), baseSnapshot.sequenceNumber()).validateFromSnapshot(baseSnapshot.snapshotId());
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch);
        this.commit((Table)this.table, (SnapshotUpdate)rewriteFiles, this.branch);
        this.validateBranchDeleteFiles((Table)this.table, this.branch, deleteFile1);
        this.validateBranchFiles((Table)this.table, this.branch, dataFile2);
    }

    @Test
    public void testRowDeltaAndRewriteFilesMergeManifestsWithSequenceNumber() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        DataFile dataFile1 = this.newDataFile("data=a");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile1), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        DeleteFile deleteFile1 = this.newEqualityDeleteFile(this.table.spec().specId(), "data=a", ((Types.NestedField)this.table.schema().asStruct().fields().get(0)).fieldId());
        RowDelta rowDelta = this.table.newRowDelta().addDeletes(deleteFile1).validateFromSnapshot(baseSnapshot.snapshotId()).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles();
        DataFile dataFile2 = this.newDataFile("data=a");
        RewriteFiles rewriteFiles = this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)dataFile1), (Set)ImmutableSet.of((Object)dataFile2), baseSnapshot.sequenceNumber()).validateFromSnapshot(baseSnapshot.snapshotId());
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch);
        this.commit((Table)this.table, (SnapshotUpdate)rewriteFiles, this.branch);
        this.table.refresh();
        List dataManifests = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).dataManifests(this.table.io());
        Assert.assertEquals((String)"should have 1 data manifest", (long)1L, (long)dataManifests.size());
        ManifestFile mergedDataManifest = (ManifestFile)dataManifests.get(0);
        Assert.assertEquals((String)"Manifest seq number must match", (long)3L, (long)mergedDataManifest.sequenceNumber());
        long currentSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.validateManifest(mergedDataManifest, TestRowDelta.dataSeqs(1L, 1L), TestRowDelta.fileSeqs(3L, 1L), TestRowDelta.ids(currentSnapshotId, currentSnapshotId), TestRowDelta.files(dataFile2, dataFile1), TestRowDelta.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.DELETED));
    }

    @Test
    public void testConcurrentConflictingRowDeltaAndRewriteFilesWithSequenceNumber() {
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        DataFile dataFile1 = this.newDataFile("data=a");
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(dataFile1), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        DeleteFile deleteFile1 = this.newDeleteFile(this.table.spec().specId(), "data=a");
        RowDelta rowDelta = this.table.newRowDelta().addDeletes(deleteFile1).validateFromSnapshot(baseSnapshot.snapshotId()).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles();
        DataFile dataFile2 = this.newDataFile("data=a");
        RewriteFiles rewriteFiles = this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)dataFile1), (Set)ImmutableSet.of((Object)dataFile2), baseSnapshot.sequenceNumber()).validateFromSnapshot(baseSnapshot.snapshotId());
        this.commit((Table)this.table, (SnapshotUpdate)rowDelta, this.branch);
        AssertHelpers.assertThrows((String)"Should not allow any new position delete associated with the data file", ValidationException.class, (String)"Cannot commit, found new position delete for replaced data file", () -> this.commit((Table)this.table, (SnapshotUpdate)rewriteFiles, this.branch));
    }

    @Test
    public void testRowDeltaCaseSensitivity() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_A2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES), this.branch);
        UnboundPredicate conflictDetectionFilter = Expressions.equal((UnboundTerm)Expressions.bucket((String)"dAtA", (int)16), (Object)0);
        AssertHelpers.assertThrows((String)"Should use case sensitive binding by default", ValidationException.class, (String)"Cannot find field 'dAtA'", () -> this.lambda$testRowDeltaCaseSensitivity$11(firstSnapshot, (Expression)conflictDetectionFilter));
        AssertHelpers.assertThrows((String)"Should fail with case sensitive binding", ValidationException.class, (String)"Cannot find field 'dAtA'", () -> this.lambda$testRowDeltaCaseSensitivity$12(firstSnapshot, (Expression)conflictDetectionFilter));
        AssertHelpers.assertThrows((String)"Should reject case sensitive binding", ValidationException.class, (String)"Found new conflicting delete files", () -> this.lambda$testRowDeltaCaseSensitivity$13(firstSnapshot, (Expression)conflictDetectionFilter));
    }

    private /* synthetic */ void lambda$testRowDeltaCaseSensitivity$13(Snapshot firstSnapshot, Expression conflictDetectionFilter) {
        ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).caseSensitive(false).addRows(FILE_B).addDeletes(FILE_A2_DELETES).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(conflictDetectionFilter).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles().commit();
    }

    private /* synthetic */ void lambda$testRowDeltaCaseSensitivity$12(Snapshot firstSnapshot, Expression conflictDetectionFilter) {
        ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).caseSensitive(true).addRows(FILE_B).addDeletes(FILE_A2_DELETES).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(conflictDetectionFilter).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles().commit();
    }

    private /* synthetic */ void lambda$testRowDeltaCaseSensitivity$11(Snapshot firstSnapshot, Expression conflictDetectionFilter) {
        ((RowDelta)this.table.newRowDelta().toBranch(this.branch)).addRows(FILE_B).addDeletes(FILE_A2_DELETES).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(conflictDetectionFilter).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles().commit();
    }
}

