/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseRewriteManifests;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestRewriteManifests
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestRewriteManifests(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testRewriteManifestsAppendedDirectly() throws IOException {
        TestTables.TestTable table = this.load();
        table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, FILE_A));
        table.newFastAppend().appendManifest(newManifest).commit();
        long appendId = table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
        table.rewriteManifests().clusterBy(file -> "").commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)1L, (long)manifests.size());
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(appendId), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testRewriteManifestsWithScanExecutor() throws IOException {
        TestTables.TestTable table = this.load();
        table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, FILE_A));
        table.newFastAppend().appendManifest(newManifest).commit();
        Assert.assertEquals((long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
        AtomicInteger scanThreadsIndex = new AtomicInteger(0);
        ((RewriteManifests)table.rewriteManifests().clusterBy(file -> "").scanManifestsWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("scan-" + scanThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }))).commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)1L, (long)manifests.size());
        Assert.assertTrue((String)"Thread should be created in provided pool", (scanThreadsIndex.get() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRewriteManifestsGeneratedAndAppendedDirectly() throws IOException {
        List<Long> ids;
        List<DataFile> files;
        TestTables.TestTable table = this.load();
        table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, FILE_A));
        table.newFastAppend().appendManifest(newManifest).commit();
        long manifestAppendId = table.currentSnapshot().snapshotId();
        table.newFastAppend().appendFile(FILE_B).commit();
        long fileAppendId = table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)2L, (long)table.currentSnapshot().allManifests(table.io()).size());
        table.rewriteManifests().clusterBy(file -> "").commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((String)"Manifests must be merged into 1", (long)1L, (long)manifests.size());
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)((ManifestFile)manifests.get(0)), (FileIO)table.io());){
            if (((DataFile)reader.iterator().next()).path().equals(FILE_A.path())) {
                files = Arrays.asList(FILE_A, FILE_B);
                ids = Arrays.asList(manifestAppendId, fileAppendId);
            } else {
                files = Arrays.asList(FILE_B, FILE_A);
                ids = Arrays.asList(fileAppendId, manifestAppendId);
            }
        }
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), ids.iterator(), files.iterator(), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testReplaceManifestsSeparate() {
        TestTables.TestTable table = this.load();
        table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        long appendId = table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
        table.rewriteManifests().clusterBy(file -> file.path()).commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)2L, (long)manifests.size());
        manifests.sort(Comparator.comparing(ManifestFile::path));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(appendId), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(appendId), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testReplaceManifestsConsolidate() throws IOException {
        List<Long> ids;
        List<DataFile> files;
        TestTables.TestTable table = this.load();
        table.newFastAppend().appendFile(FILE_A).commit();
        long appendIdA = table.currentSnapshot().snapshotId();
        table.newFastAppend().appendFile(FILE_B).commit();
        long appendIdB = table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)2L, (long)table.currentSnapshot().allManifests(table.io()).size());
        table.rewriteManifests().clusterBy(file -> "file").commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)1L, (long)manifests.size());
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)((ManifestFile)manifests.get(0)), (FileIO)table.io());){
            if (((DataFile)reader.iterator().next()).path().equals(FILE_A.path())) {
                files = Arrays.asList(FILE_A, FILE_B);
                ids = Arrays.asList(appendIdA, appendIdB);
            } else {
                files = Arrays.asList(FILE_B, FILE_A);
                ids = Arrays.asList(appendIdB, appendIdA);
            }
        }
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), ids.iterator(), files.iterator(), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testReplaceManifestsWithFilter() throws IOException {
        List<Long> ids;
        List<DataFile> files;
        TestTables.TestTable table = this.load();
        table.newFastAppend().appendFile(FILE_A).commit();
        long appendIdA = table.currentSnapshot().snapshotId();
        table.newFastAppend().appendFile(FILE_B).commit();
        long appendIdB = table.currentSnapshot().snapshotId();
        table.newFastAppend().appendFile(FILE_C).commit();
        long appendIdC = table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)3L, (long)table.currentSnapshot().allManifests(table.io()).size());
        table.rewriteManifests().clusterBy(file -> "file").rewriteIf(arg_0 -> TestRewriteManifests.lambda$testReplaceManifestsWithFilter$7((Table)table, arg_0)).commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)2L, (long)manifests.size());
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)((ManifestFile)manifests.get(0)), (FileIO)table.io());){
            if (((DataFile)reader.iterator().next()).path().equals(FILE_B.path())) {
                files = Arrays.asList(FILE_B, FILE_C);
                ids = Arrays.asList(appendIdB, appendIdC);
            } else {
                files = Arrays.asList(FILE_C, FILE_B);
                ids = Arrays.asList(appendIdC, appendIdB);
            }
        }
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), ids.iterator(), files.iterator(), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(appendIdA), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testReplaceManifestsMaxSize() {
        TestTables.TestTable table = this.load();
        table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        long appendId = table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
        BaseRewriteManifests rewriteManifests = (BaseRewriteManifests)Mockito.spy((Object)((BaseRewriteManifests)table.rewriteManifests()));
        Mockito.when((Object)rewriteManifests.getManifestTargetSizeBytes()).thenReturn((Object)1L);
        rewriteManifests.clusterBy(file -> "file").commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)2L, (long)manifests.size());
        manifests.sort(Comparator.comparing(ManifestFile::path));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(appendId), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(appendId), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testConcurrentRewriteManifest() throws IOException {
        List<Long> ids;
        List<DataFile> files;
        TestTables.TestTable table = this.load();
        table.newFastAppend().appendFile(FILE_A).commit();
        long appendIdA = table.currentSnapshot().snapshotId();
        table.newFastAppend().appendFile(FILE_B).commit();
        long appendIdB = table.currentSnapshot().snapshotId();
        RewriteManifests rewrite = table.rewriteManifests();
        rewrite.clusterBy(file -> "file").apply();
        table.rewriteManifests().clusterBy(file -> "file").rewriteIf(arg_0 -> TestRewriteManifests.lambda$testConcurrentRewriteManifest$11((Table)table, arg_0)).commit();
        Assert.assertEquals((long)2L, (long)table.currentSnapshot().allManifests(table.io()).size());
        rewrite.commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)1L, (long)manifests.size());
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)((ManifestFile)manifests.get(0)), (FileIO)table.io());){
            if (((DataFile)reader.iterator().next()).path().equals(FILE_A.path())) {
                files = Arrays.asList(FILE_A, FILE_B);
                ids = Arrays.asList(appendIdA, appendIdB);
            } else {
                files = Arrays.asList(FILE_B, FILE_A);
                ids = Arrays.asList(appendIdB, appendIdA);
            }
        }
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), ids.iterator(), files.iterator(), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testAppendDuringRewriteManifest() {
        TestTables.TestTable table = this.load();
        table.newFastAppend().appendFile(FILE_A).commit();
        long appendIdA = table.currentSnapshot().snapshotId();
        RewriteManifests rewrite = table.rewriteManifests();
        rewrite.clusterBy(file -> "file").apply();
        table.newFastAppend().appendFile(FILE_B).commit();
        long appendIdB = table.currentSnapshot().snapshotId();
        Assert.assertEquals((long)2L, (long)table.currentSnapshot().allManifests(table.io()).size());
        rewrite.commit();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)2L, (long)manifests.size());
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(appendIdA), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(appendIdB), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testRewriteManifestDuringAppend() {
        TestTables.TestTable table = this.load();
        table.newFastAppend().appendFile(FILE_A).commit();
        long appendIdA = table.currentSnapshot().snapshotId();
        AppendFiles append = table.newFastAppend();
        append.appendFile(FILE_B).apply();
        table.rewriteManifests().clusterBy(file -> "file").commit();
        Assert.assertEquals((long)1L, (long)table.currentSnapshot().allManifests(table.io()).size());
        append.commit();
        long appendIdB = table.currentSnapshot().snapshotId();
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertEquals((long)2L, (long)manifests.size());
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(appendIdB), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.ADDED));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(appendIdA), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testBasicManifestReplacement() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        this.table.newFastAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        ManifestFile firstNewManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A));
        ManifestFile secondNewManifest = this.writeManifest("manifest-file-2.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_B));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.deleteManifest(firstSnapshotManifest);
        rewriteManifests.addManifest(firstNewManifest);
        rewriteManifests.addManifest(secondNewManifest);
        rewriteManifests.commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((long)3L, (long)manifests.size());
        this.validateSummary(snapshot, 1, 1, 2, 0);
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(2), TestRewriteManifests.ids(secondSnapshot.snapshotId(), secondSnapshot.snapshotId()), TestRewriteManifests.files(FILE_C, FILE_D), TestRewriteManifests.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testBasicManifestReplacementWithSnapshotIdInheritance() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        this.table.newFastAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        ManifestFile firstNewManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A));
        ManifestFile secondNewManifest = this.writeManifest("manifest-file-2.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_B));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.deleteManifest(firstSnapshotManifest);
        rewriteManifests.addManifest(firstNewManifest);
        rewriteManifests.addManifest(secondNewManifest);
        rewriteManifests.commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((long)3L, (long)manifests.size());
        this.validateSummary(snapshot, 1, 1, 2, 0);
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(2), TestRewriteManifests.ids(secondSnapshot.snapshotId(), secondSnapshot.snapshotId()), TestRewriteManifests.files(FILE_C, FILE_D), TestRewriteManifests.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
    }

    @Test
    public void testWithMultiplePartitionSpec() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)base.currentSnapshot().allManifests(this.table.io()).get(0);
        int initialPartitionSpecId = initialManifest.partitionSpecId();
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)base.schema()).bucket("data", 16).bucket("id", 4).build();
        this.table.ops().commit(base, base.updatePartitionSpec(newSpec));
        DataFile newFileY = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-y.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2/id_bucket=3").withRecordCount(1L).build();
        this.table.newAppend().appendFile(newFileY).commit();
        DataFile newFileZ = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-z.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2/id_bucket=4").withRecordCount(1L).build();
        this.table.newAppend().appendFile(newFileZ).commit();
        Assert.assertEquals((String)"Should use 3 manifest files", (long)3L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.clusterBy(dataFile -> "file").commit();
        List manifestFiles = this.table.currentSnapshot().allManifests(this.table.io());
        Assert.assertEquals((String)"Rewrite manifest should produce 2 manifest files", (long)2L, (long)manifestFiles.size());
        Assert.assertEquals((String)"2 manifest files should have different partitionSpecId", (Object)true, (Object)(((ManifestFile)manifestFiles.get(0)).partitionSpecId() != ((ManifestFile)manifestFiles.get(1)).partitionSpecId() ? 1 : 0));
        this.matchNumberOfManifestFileWithSpecId(manifestFiles, initialPartitionSpecId, 1);
        this.matchNumberOfManifestFileWithSpecId(manifestFiles, this.table.ops().current().spec().specId(), 1);
        Assert.assertEquals((String)"first manifest file should have 2 data files", (Object)2, (Object)((ManifestFile)manifestFiles.get(0)).existingFilesCount());
        Assert.assertEquals((String)"second manifest file should have 2 data files", (Object)2, (Object)((ManifestFile)manifestFiles.get(1)).existingFilesCount());
    }

    @Test
    public void testManifestSizeWithMultiplePartitionSpec() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)base.currentSnapshot().allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)base.currentSnapshot().allManifests(this.table.io()).get(0);
        int initialPartitionSpecId = initialManifest.partitionSpecId();
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)base.schema()).bucket("data", 16).bucket("id", 4).build();
        this.table.ops().commit(base, base.updatePartitionSpec(newSpec));
        DataFile newFileY = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-y.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2/id_bucket=3").withRecordCount(1L).build();
        this.table.newAppend().appendFile(newFileY).commit();
        DataFile newFileZ = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-z.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2/id_bucket=4").withRecordCount(1L).build();
        this.table.newAppend().appendFile(newFileZ).commit();
        Assert.assertEquals((String)"Rewrite manifests should produce 3 manifest files", (long)3L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        BaseRewriteManifests rewriteManifests = (BaseRewriteManifests)Mockito.spy((Object)((BaseRewriteManifests)this.table.rewriteManifests()));
        Mockito.when((Object)rewriteManifests.getManifestTargetSizeBytes()).thenReturn((Object)1L);
        rewriteManifests.clusterBy(dataFile -> "file").commit();
        List manifestFiles = this.table.currentSnapshot().allManifests(this.table.io());
        Assert.assertEquals((String)"Should use 4 manifest files", (long)4L, (long)manifestFiles.size());
        this.matchNumberOfManifestFileWithSpecId(manifestFiles, initialPartitionSpecId, 2);
        this.matchNumberOfManifestFileWithSpecId(manifestFiles, this.table.ops().current().spec().specId(), 2);
        Assert.assertEquals((String)"first manifest file should have 1 data files", (Object)1, (Object)((ManifestFile)manifestFiles.get(0)).existingFilesCount());
        Assert.assertEquals((String)"second manifest file should have 1 data files", (Object)1, (Object)((ManifestFile)manifestFiles.get(1)).existingFilesCount());
        Assert.assertEquals((String)"third manifest file should have 1 data files", (Object)1, (Object)((ManifestFile)manifestFiles.get(2)).existingFilesCount());
        Assert.assertEquals((String)"fourth manifest file should have 1 data files", (Object)1, (Object)((ManifestFile)manifestFiles.get(3)).existingFilesCount());
    }

    @Test
    public void testManifestReplacementConcurrentAppend() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        ManifestFile firstNewManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A));
        ManifestFile secondNewManifest = this.writeManifest("manifest-file-2.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_B));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.deleteManifest(firstSnapshotManifest);
        rewriteManifests.addManifest(firstNewManifest);
        rewriteManifests.addManifest(secondNewManifest);
        this.table.newFastAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((long)2L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        rewriteManifests.commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((long)3L, (long)manifests.size());
        this.validateSummary(snapshot, 1, 1, 2, 0);
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(2), TestRewriteManifests.ids(secondSnapshot.snapshotId(), secondSnapshot.snapshotId()), TestRewriteManifests.files(FILE_C, FILE_D), TestRewriteManifests.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testManifestReplacementConcurrentDelete() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.updateProperties().set("commit.manifest-merge.enabled", "false").commit();
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        this.table.newFastAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        long secondSnapshotId = this.table.currentSnapshot().snapshotId();
        ManifestFile firstNewManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A));
        ManifestFile secondNewManifest = this.writeManifest("manifest-file-2.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_B));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.deleteManifest(firstSnapshotManifest);
        rewriteManifests.addManifest(firstNewManifest);
        rewriteManifests.addManifest(secondNewManifest);
        this.table.newDelete().deleteFile(FILE_C).commit();
        long thirdSnapshotId = this.table.currentSnapshot().snapshotId();
        rewriteManifests.commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((long)3L, (long)manifests.size());
        this.validateSummary(snapshot, 1, 1, 2, 0);
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(2), TestRewriteManifests.ids(thirdSnapshotId, secondSnapshotId), TestRewriteManifests.files(FILE_C, FILE_D), TestRewriteManifests.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testManifestReplacementConcurrentConflictingDelete() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        ManifestFile firstNewManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A));
        ManifestFile secondNewManifest = this.writeManifest("manifest-file-2.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_B));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.deleteManifest(firstSnapshotManifest);
        rewriteManifests.addManifest(firstNewManifest);
        rewriteManifests.addManifest(secondNewManifest);
        this.table.newDelete().deleteFile(FILE_A).commit();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Manifest is missing", () -> ((RewriteManifests)rewriteManifests).commit());
    }

    @Test
    public void testManifestReplacementCombinedWithRewrite() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        this.table.newFastAppend().appendFile(FILE_D).commit();
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.table.snapshots()));
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A));
        this.table.rewriteManifests().deleteManifest(firstSnapshotManifest).addManifest(newManifest).clusterBy(dataFile -> "const-value").rewriteIf(manifest -> {
            try {
                ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)this.table.io());
                Throwable throwable = null;
                try {
                    boolean bl = !((DataFile)reader.iterator().next()).path().equals(FILE_B.path());
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        TestRewriteManifests.$closeResource(throwable, (AutoCloseable)reader);
                    }
                }
            }
            catch (IOException x) {
                throw new RuntimeIOException(x);
            }
        }).commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((long)3L, (long)manifests.size());
        this.validateSummary(snapshot, 3, 1, 2, 2);
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(2), TestRewriteManifests.ids(secondSnapshot.snapshotId()), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testManifestReplacementCombinedWithRewriteConcurrentDelete() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.updateProperties().set("commit.manifest-merge.enabled", "false").commit();
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        ManifestEntry<DataFile> entry = this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A);
        entry.setDataSequenceNumber(firstSnapshot.sequenceNumber());
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", entry);
        RewriteManifests rewriteManifests = this.table.rewriteManifests().deleteManifest(firstSnapshotManifest).addManifest(newManifest).clusterBy(dataFile -> "const-value");
        rewriteManifests.apply();
        this.table.newDelete().deleteFile(FILE_C).commit();
        rewriteManifests.commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((long)2L, (long)manifests.size());
        this.validateSummary(snapshot, 3, 0, 2, 1);
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(0), TestRewriteManifests.ids(secondSnapshot.snapshotId()), TestRewriteManifests.files(FILE_B), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
        TestRewriteManifests.validateManifestEntries((ManifestFile)manifests.get(1), TestRewriteManifests.ids(firstSnapshot.snapshotId()), TestRewriteManifests.files(FILE_A), TestRewriteManifests.statuses(ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testInvalidUsage() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)manifests.size());
        ManifestFile manifest = (ManifestFile)manifests.get(0);
        ManifestEntry<DataFile> appendEntry = this.manifestEntry(ManifestEntry.Status.ADDED, snapshot.snapshotId(), FILE_A);
        appendEntry.setDataSequenceNumber(snapshot.sequenceNumber());
        ManifestFile invalidAddedFileManifest = this.writeManifest("manifest-file-2.avro", appendEntry);
        AssertHelpers.assertThrows((String)"Should reject commit", IllegalArgumentException.class, (String)"Cannot add manifest with added files", () -> this.table.rewriteManifests().deleteManifest(manifest).addManifest(invalidAddedFileManifest).commit());
        ManifestEntry<DataFile> deleteEntry = this.manifestEntry(ManifestEntry.Status.DELETED, snapshot.snapshotId(), FILE_A);
        deleteEntry.setDataSequenceNumber(snapshot.sequenceNumber());
        ManifestFile invalidDeletedFileManifest = this.writeManifest("manifest-file-3.avro", deleteEntry);
        AssertHelpers.assertThrows((String)"Should reject commit", IllegalArgumentException.class, (String)"Cannot add manifest with deleted files", () -> this.table.rewriteManifests().deleteManifest(manifest).addManifest(invalidDeletedFileManifest).commit());
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"must have the same number of active files", () -> this.table.rewriteManifests().deleteManifest(manifest).commit());
    }

    @Test
    public void testManifestReplacementFailure() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        List secondSnapshotManifests = secondSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)2L, (long)secondSnapshotManifests.size());
        ManifestFile secondSnapshotManifest = (ManifestFile)secondSnapshotManifests.get(0);
        ManifestFile newManifest = this.writeManifest("manifest-file.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A), this.manifestEntry(ManifestEntry.Status.EXISTING, secondSnapshot.snapshotId(), FILE_B));
        this.table.updateProperties().set("commit.retry.num-retries", "1").commit();
        this.table.ops().failCommits(5);
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.deleteManifest(firstSnapshotManifest);
        rewriteManifests.deleteManifest(secondSnapshotManifest);
        rewriteManifests.addManifest(newManifest);
        AssertHelpers.assertThrows((String)"Should reject commit", CommitFailedException.class, (String)"Injected failure", () -> ((RewriteManifests)rewriteManifests).commit());
        Assert.assertTrue((String)"New manifest should not be deleted", (boolean)new File(newManifest.path()).exists());
    }

    @Test
    public void testManifestReplacementFailureWithSnapshotIdInheritance() throws IOException {
        Assert.assertNull((String)"Table should be empty", (Object)this.table.currentSnapshot());
        this.table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        List firstSnapshotManifests = firstSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)1L, (long)firstSnapshotManifests.size());
        ManifestFile firstSnapshotManifest = (ManifestFile)firstSnapshotManifests.get(0);
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        List secondSnapshotManifests = secondSnapshot.allManifests(this.table.io());
        Assert.assertEquals((long)2L, (long)secondSnapshotManifests.size());
        ManifestFile secondSnapshotManifest = (ManifestFile)secondSnapshotManifests.get(0);
        ManifestFile newManifest = this.writeManifest("manifest-file.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, firstSnapshot.snapshotId(), FILE_A), this.manifestEntry(ManifestEntry.Status.EXISTING, secondSnapshot.snapshotId(), FILE_B));
        this.table.updateProperties().set("commit.retry.num-retries", "1").commit();
        this.table.ops().failCommits(5);
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        rewriteManifests.deleteManifest(firstSnapshotManifest);
        rewriteManifests.deleteManifest(secondSnapshotManifest);
        rewriteManifests.addManifest(newManifest);
        AssertHelpers.assertThrows((String)"Should reject commit", CommitFailedException.class, (String)"Injected failure", () -> ((RewriteManifests)rewriteManifests).commit());
        Assert.assertTrue((String)"New manifest should not be deleted", (boolean)new File(newManifest.path()).exists());
    }

    @Test
    public void testRewriteManifestsOnBranchUnsupported() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertEquals((long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        AssertHelpers.assertThrows((String)"Should reject committing rewrite manifests to branch", UnsupportedOperationException.class, (String)"Cannot commit to branch someBranch: org.apache.iceberg.BaseRewriteManifests does not support branch commits", () -> ((RewriteManifests)this.table.rewriteManifests().toBranch("someBranch")).commit());
    }

    private void validateSummary(Snapshot snapshot, int replaced, int kept, int created, int entryCount) {
        Map summary = snapshot.summary();
        Assert.assertEquals((String)"Replaced manifest count should match", (long)replaced, (long)Integer.parseInt((String)summary.get("manifests-replaced")));
        Assert.assertEquals((String)"Kept manifest count should match", (long)kept, (long)Integer.parseInt((String)summary.get("manifests-kept")));
        Assert.assertEquals((String)"Created manifest count should match", (long)created, (long)Integer.parseInt((String)summary.get("manifests-created")));
        Assert.assertEquals((String)"Entry count should match", (long)entryCount, (long)Integer.parseInt((String)summary.get("entries-processed")));
    }

    private void matchNumberOfManifestFileWithSpecId(List<ManifestFile> manifestFiles, int toBeMatchedPartitionSpecId, int numberOfManifestWithPartitionSpecID) {
        long matchedManifestsCounter = manifestFiles.stream().filter(m -> m.partitionSpecId() == toBeMatchedPartitionSpecId).count();
        Assert.assertEquals((String)("manifest list should have " + numberOfManifestWithPartitionSpecID + " manifests matching this partitionSpecId " + toBeMatchedPartitionSpecId), (long)numberOfManifestWithPartitionSpecID, (long)matchedManifestsCounter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ boolean lambda$testConcurrentRewriteManifest$11(Table table, ManifestFile manifest) {
        try {
            ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)table.io());
            Throwable throwable = null;
            try {
                boolean bl = !((DataFile)reader.iterator().next()).path().equals(FILE_A.path());
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    TestRewriteManifests.$closeResource(throwable, (AutoCloseable)reader);
                }
            }
        }
        catch (IOException x) {
            throw new RuntimeIOException(x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ boolean lambda$testReplaceManifestsWithFilter$7(Table table, ManifestFile manifest) {
        try {
            ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)table.io());
            Throwable throwable = null;
            try {
                boolean bl = !((DataFile)reader.iterator().next()).path().equals(FILE_A.path());
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    TestRewriteManifests.$closeResource(throwable, (AutoCloseable)reader);
                }
            }
        }
        catch (IOException x) {
            throw new RuntimeIOException(x);
        }
    }
}

