/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.internal.util.collections.Sets;

@RunWith(value=Parameterized.class)
public class TestRewriteFiles
extends TableTestBase {
    private final String branch;

    @Parameterized.Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[] parameters() {
        return new Object[][]{{1, "main"}, {1, "testBranch"}, {2, "main"}, {2, "testBranch"}};
    }

    public TestRewriteFiles(int formatVersion, String branch) {
        super(formatVersion);
        this.branch = branch;
    }

    @Test
    public void testEmptyTable() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.ref(this.branch));
        AssertHelpers.assertThrows((String)"Expected an exception", ValidationException.class, (String)"Missing required files to delete: /path/to/data-a.parquet", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_B})), this.branch));
        AssertHelpers.assertThrows((String)"Expected an exception", ValidationException.class, (String)"Missing required files to delete: /path/to/data-a-deletes.parquet", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_A_DELETES), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_B_DELETES)), this.branch));
    }

    @Test
    public void testAddOnly() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        AssertHelpers.assertThrows((String)"Expected an exception", ValidationException.class, (String)"Missing required files to delete: /path/to/data-a.parquet", () -> this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Collections.emptySet()), this.branch));
        AssertHelpers.assertThrows((String)"Expected an exception", IllegalArgumentException.class, (String)"Delete files to add must be empty because there's no delete file to be rewritten", () -> this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_A_DELETES)), this.branch));
        AssertHelpers.assertThrows((String)"Expected an exception", IllegalArgumentException.class, (String)"Delete files to add must be empty because there's no delete file to be rewritten", () -> this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_B), (Set)ImmutableSet.of((Object)FILE_B_DELETES)), this.branch));
    }

    @Test
    public void testDeleteOnly() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        AssertHelpers.assertThrows((String)"Expected an exception", IllegalArgumentException.class, (String)"Files to delete cannot be empty", () -> this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles(Collections.emptySet(), Sets.newSet((Object[])new DataFile[]{FILE_A})), this.branch));
        AssertHelpers.assertThrows((String)"Expected an exception", IllegalArgumentException.class, (String)"Files to delete cannot be empty", () -> this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_A_DELETES)), this.branch));
        AssertHelpers.assertThrows((String)"Expected an exception", IllegalArgumentException.class, (String)"Files to delete cannot be empty", () -> this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_A_DELETES)), this.branch));
    }

    @Test
    public void testDeleteWithDuplicateEntriesInManifest() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseSnapshotId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).allManifests(this.table.io()).get(0);
        Snapshot pending = this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_C})), this.branch);
        Assert.assertEquals((String)"Should contain 2 manifest", (long)2L, (long)pending.allManifests(this.table.io()).size());
        Assert.assertFalse((String)"Should not contain manifest from initial write", (boolean)pending.allManifests(this.table.io()).contains(initialManifest));
        long pendingId = pending.snapshotId();
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(0), TestRewriteFiles.ids(pendingId), TestRewriteFiles.files(FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(1), TestRewriteFiles.ids(pendingId, pendingId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_A, FILE_B), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Assert.assertEquals((String)"Only 3 manifests should exist", (long)3L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testAddAndDelete() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseSnapshotId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0);
        Snapshot pending = this.apply((SnapshotUpdate)this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_C})), this.branch);
        Assert.assertEquals((String)"Should contain 2 manifest", (long)2L, (long)pending.allManifests(this.table.io()).size());
        Assert.assertFalse((String)"Should not contain manifest from initial write", (boolean)pending.allManifests(this.table.io()).contains(initialManifest));
        long pendingId = pending.snapshotId();
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(0), TestRewriteFiles.ids(pendingId), TestRewriteFiles.files(FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(1), TestRewriteFiles.ids(pendingId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_B), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Assert.assertEquals((String)"Only 3 manifests should exist", (long)3L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testRewriteDataAndDeleteFiles() {
        Assume.assumeTrue((String)"Rewriting delete files is only supported in iceberg format v2. ", (this.formatVersion > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addRows(FILE_B).addRows(FILE_C).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES), this.branch);
        TableMetadata base = this.readMetadata();
        Snapshot baseSnap = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch);
        long baseSnapshotId = baseSnap.snapshotId();
        Assert.assertEquals((String)"Should create 2 manifests for initial write", (long)2L, (long)baseSnap.allManifests(this.table.io()).size());
        List initialManifests = baseSnap.allManifests(this.table.io());
        TestRewriteFiles.validateManifestEntries((ManifestFile)initialManifests.get(0), TestRewriteFiles.ids(baseSnapshotId, baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_B, FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.validateDeleteManifest((ManifestFile)initialManifests.get(1), TestRewriteFiles.dataSeqs(1L, 1L), TestRewriteFiles.fileSeqs(1L, 1L), TestRewriteFiles.ids(baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A_DELETES, FILE_B_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Snapshot pending = this.apply((SnapshotUpdate)this.table.newRewrite().validateFromSnapshot(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()).rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_A_DELETES), (Set)ImmutableSet.of((Object)FILE_D), (Set)ImmutableSet.of()), this.branch);
        Assert.assertEquals((String)"Should contain 3 manifest", (long)3L, (long)pending.allManifests(this.table.io()).size());
        Assert.assertFalse((String)"Should not contain manifest from initial write", (boolean)pending.allManifests(this.table.io()).stream().anyMatch(initialManifests::contains));
        long pendingId = pending.snapshotId();
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(0), TestRewriteFiles.ids(pendingId), TestRewriteFiles.files(FILE_D), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(1), TestRewriteFiles.ids(pendingId, baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_B, FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        this.validateDeleteManifest((ManifestFile)pending.allManifests(this.table.io()).get(2), TestRewriteFiles.dataSeqs(1L, 1L), TestRewriteFiles.fileSeqs(1L, 1L), TestRewriteFiles.ids(pendingId, baseSnapshotId), TestRewriteFiles.files(FILE_A_DELETES, FILE_B_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Assert.assertEquals((String)"Only 5 manifests should exist", (long)5L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testRewriteDataAndAssignOldSequenceNumber() {
        Assume.assumeTrue((String)"Sequence number is only supported in iceberg format v2. ", (this.formatVersion > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addRows(FILE_B).addRows(FILE_C).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES), this.branch);
        TableMetadata base = this.readMetadata();
        Snapshot baseSnap = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch);
        long baseSnapshotId = baseSnap.snapshotId();
        Assert.assertEquals((String)"Should create 2 manifests for initial write", (long)2L, (long)baseSnap.allManifests(this.table.io()).size());
        List initialManifests = baseSnap.allManifests(this.table.io());
        TestRewriteFiles.validateManifestEntries((ManifestFile)initialManifests.get(0), TestRewriteFiles.ids(baseSnapshotId, baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_B, FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.validateDeleteManifest((ManifestFile)initialManifests.get(1), TestRewriteFiles.dataSeqs(1L, 1L), TestRewriteFiles.fileSeqs(1L, 1L), TestRewriteFiles.ids(baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A_DELETES, FILE_B_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        long oldSequenceNumber = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).sequenceNumber();
        Snapshot pending = this.apply((SnapshotUpdate)this.table.newRewrite().validateFromSnapshot(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()).rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_D), oldSequenceNumber), this.branch);
        Assert.assertEquals((String)"Should contain 3 manifest", (long)3L, (long)pending.allManifests(this.table.io()).size());
        Assert.assertFalse((String)"Should not contain data manifest from initial write", (boolean)pending.dataManifests(this.table.io()).stream().anyMatch(initialManifests::contains));
        long pendingId = pending.snapshotId();
        ManifestFile newManifest = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        TestRewriteFiles.validateManifestEntries(newManifest, TestRewriteFiles.ids(pendingId), TestRewriteFiles.files(FILE_D), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        for (ManifestEntry entry : ManifestFiles.read((ManifestFile)newManifest, (FileIO)FILE_IO).entries()) {
            Assert.assertEquals((String)"Should have old sequence number for manifest entries", (long)oldSequenceNumber, (long)entry.dataSequenceNumber());
        }
        Assert.assertEquals((String)"Should use new sequence number for the manifest file", (long)(oldSequenceNumber + 1L), (long)newManifest.sequenceNumber());
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(1), TestRewriteFiles.ids(pendingId, baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_B, FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        this.validateDeleteManifest((ManifestFile)pending.allManifests(this.table.io()).get(2), TestRewriteFiles.dataSeqs(1L, 1L), TestRewriteFiles.fileSeqs(1L, 1L), TestRewriteFiles.ids(baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A_DELETES, FILE_B_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Only 4 manifests should exist", (long)4L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testFailure() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        this.table.ops().failCommits(5);
        RewriteFiles rewrite = this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_B}));
        Snapshot pending = this.apply((SnapshotUpdate)rewrite, this.branch);
        Assert.assertEquals((String)"Should produce 2 manifests", (long)2L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile manifest1 = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        ManifestFile manifest2 = (ManifestFile)pending.allManifests(this.table.io()).get(1);
        TestRewriteFiles.validateManifestEntries(manifest1, TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_B), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries(manifest2, TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_A), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED));
        AssertHelpers.assertThrows((String)"Should retry 4 times and throw last failure", CommitFailedException.class, (String)"Injected failure", () -> this.commit((Table)this.table, (SnapshotUpdate)rewrite, this.branch));
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(manifest1.path()).exists());
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(manifest2.path()).exists());
        Assert.assertEquals((String)"Only 1 manifest should exist", (long)1L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testFailureWhenRewriteBothDataAndDeleteFiles() {
        Assume.assumeTrue((String)"Rewriting delete files is only supported in iceberg format v2. ", (this.formatVersion > 1 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addRows(FILE_B).addRows(FILE_C).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES), this.branch);
        long baseSnapshotId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        this.table.ops().failCommits(5);
        RewriteFiles rewrite = this.table.newRewrite().validateFromSnapshot(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()).rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_A_DELETES, (Object)FILE_B_DELETES), (Set)ImmutableSet.of((Object)FILE_D), (Set)ImmutableSet.of());
        Snapshot pending = this.apply((SnapshotUpdate)rewrite, this.branch);
        Assert.assertEquals((String)"Should produce 3 manifests", (long)3L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile manifest1 = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        ManifestFile manifest2 = (ManifestFile)pending.allManifests(this.table.io()).get(1);
        ManifestFile manifest3 = (ManifestFile)pending.allManifests(this.table.io()).get(2);
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(0), TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_D), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(1), TestRewriteFiles.ids(pending.snapshotId(), baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_B, FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        this.validateDeleteManifest((ManifestFile)pending.allManifests(this.table.io()).get(2), TestRewriteFiles.dataSeqs(1L, 1L), TestRewriteFiles.fileSeqs(1L, 1L), TestRewriteFiles.ids(pending.snapshotId(), pending.snapshotId()), TestRewriteFiles.files(FILE_A_DELETES, FILE_B_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.DELETED));
        AssertHelpers.assertThrows((String)"Should retry 4 times and throw last failure", CommitFailedException.class, (String)"Injected failure", () -> ((RewriteFiles)rewrite).commit());
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(manifest1.path()).exists());
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(manifest2.path()).exists());
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(manifest3.path()).exists());
        Assert.assertEquals((String)"Only 2 manifest should exist", (long)2L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testRecovery() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        this.table.ops().failCommits(3);
        RewriteFiles rewrite = this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_B}));
        Snapshot pending = this.apply((SnapshotUpdate)rewrite, this.branch);
        Assert.assertEquals((String)"Should produce 2 manifests", (long)2L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile manifest1 = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        ManifestFile manifest2 = (ManifestFile)pending.allManifests(this.table.io()).get(1);
        TestRewriteFiles.validateManifestEntries(manifest1, TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_B), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries(manifest2, TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_A), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED));
        this.commit((Table)this.table, (SnapshotUpdate)rewrite, this.branch);
        Assert.assertTrue((String)"Should reuse the manifest for appends", (boolean)new File(manifest1.path()).exists());
        Assert.assertTrue((String)"Should reuse the manifest with deletes", (boolean)new File(manifest2.path()).exists());
        TableMetadata metadata = this.readMetadata();
        Assert.assertTrue((String)"Should commit the manifest for append", (boolean)SnapshotUtil.latestSnapshot((TableMetadata)metadata, (String)this.branch).allManifests(this.table.io()).contains(manifest2));
        Assert.assertEquals((String)"Only 3 manifests should exist", (long)3L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testRecoverWhenRewriteBothDataAndDeleteFiles() {
        Assume.assumeTrue((String)"Rewriting delete files is only supported in iceberg format v2. ", (this.formatVersion > 1 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addRows(FILE_B).addRows(FILE_C).addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES), this.branch);
        long baseSnapshotId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        this.table.ops().failCommits(3);
        RewriteFiles rewrite = this.table.newRewrite().validateFromSnapshot(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()).rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_A_DELETES, (Object)FILE_B_DELETES), (Set)ImmutableSet.of((Object)FILE_D), (Set)ImmutableSet.of());
        Snapshot pending = this.apply((SnapshotUpdate)rewrite, this.branch);
        Assert.assertEquals((String)"Should produce 3 manifests", (long)3L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile manifest1 = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        ManifestFile manifest2 = (ManifestFile)pending.allManifests(this.table.io()).get(1);
        ManifestFile manifest3 = (ManifestFile)pending.allManifests(this.table.io()).get(2);
        TestRewriteFiles.validateManifestEntries(manifest1, TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_D), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries(manifest2, TestRewriteFiles.ids(pending.snapshotId(), baseSnapshotId, baseSnapshotId), TestRewriteFiles.files(FILE_A, FILE_B, FILE_C), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        this.validateDeleteManifest(manifest3, TestRewriteFiles.dataSeqs(1L, 1L), TestRewriteFiles.fileSeqs(1L, 1L), TestRewriteFiles.ids(pending.snapshotId(), pending.snapshotId()), TestRewriteFiles.files(FILE_A_DELETES, FILE_B_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.DELETED));
        this.commit((Table)this.table, (SnapshotUpdate)rewrite, this.branch);
        Assert.assertTrue((String)"Should reuse new manifest", (boolean)new File(manifest1.path()).exists());
        Assert.assertTrue((String)"Should reuse new manifest", (boolean)new File(manifest2.path()).exists());
        Assert.assertTrue((String)"Should reuse new manifest", (boolean)new File(manifest3.path()).exists());
        TableMetadata metadata = this.readMetadata();
        ArrayList committedManifests = Lists.newArrayList((Object[])new ManifestFile[]{manifest1, manifest2, manifest3});
        Assert.assertEquals((String)"Should committed the manifests", (Object)SnapshotUtil.latestSnapshot((TableMetadata)metadata, (String)this.branch).allManifests(this.table.io()), (Object)committedManifests);
        Assert.assertEquals((String)"Only 5 manifest should exist", (long)5L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testReplaceEqualityDeletesWithPositionDeletes() {
        Assume.assumeTrue((String)"Rewriting delete files is only supported in iceberg format v2. ", (this.formatVersion > 1 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A2).addDeletes(FILE_A2_DELETES), this.branch);
        TableMetadata metadata = this.readMetadata();
        long baseSnapshotId = SnapshotUtil.latestSnapshot((TableMetadata)metadata, (String)this.branch).snapshotId();
        RewriteFiles rewrite = this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_A2_DELETES), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_B_DELETES));
        Snapshot pending = this.apply((SnapshotUpdate)rewrite, this.branch);
        Assert.assertEquals((String)"Should produce 3 manifests", (long)3L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile manifest1 = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        ManifestFile manifest2 = (ManifestFile)pending.allManifests(this.table.io()).get(1);
        ManifestFile manifest3 = (ManifestFile)pending.allManifests(this.table.io()).get(2);
        TestRewriteFiles.validateManifestEntries(manifest1, TestRewriteFiles.ids(baseSnapshotId), TestRewriteFiles.files(FILE_A2), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        this.validateDeleteManifest(manifest2, TestRewriteFiles.dataSeqs(2L), TestRewriteFiles.fileSeqs(2L), TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_B_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        this.validateDeleteManifest(manifest3, TestRewriteFiles.dataSeqs(1L), TestRewriteFiles.fileSeqs(1L), TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_A2_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED));
        this.commit((Table)this.table, (SnapshotUpdate)rewrite, this.branch);
        Assert.assertTrue((String)"Should reuse new manifest", (boolean)new File(manifest1.path()).exists());
        Assert.assertTrue((String)"Should reuse new manifest", (boolean)new File(manifest2.path()).exists());
        Assert.assertTrue((String)"Should reuse new manifest", (boolean)new File(manifest3.path()).exists());
        metadata = this.readMetadata();
        ArrayList committedManifests = Lists.newArrayList((Object[])new ManifestFile[]{manifest1, manifest2, manifest3});
        Assert.assertEquals((String)"Should committed the manifests", (Object)SnapshotUtil.latestSnapshot((TableMetadata)metadata, (String)this.branch).allManifests(this.table.io()), (Object)committedManifests);
        Assert.assertEquals((String)"4 manifests should exist", (long)4L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testRemoveAllDeletes() {
        Assume.assumeTrue((String)"Rewriting delete files is only supported in iceberg format v2. ", (this.formatVersion > 1 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_DELETES), this.branch);
        RewriteFiles rewrite = this.table.newRewrite().validateFromSnapshot(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()).rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_A_DELETES), (Set)ImmutableSet.of(), (Set)ImmutableSet.of());
        Snapshot pending = this.apply((SnapshotUpdate)rewrite, this.branch);
        Assert.assertEquals((String)"Should produce 2 manifests", (long)2L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile manifest1 = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        ManifestFile manifest2 = (ManifestFile)pending.allManifests(this.table.io()).get(1);
        TestRewriteFiles.validateManifestEntries(manifest1, TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_A), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED));
        this.validateDeleteManifest(manifest2, TestRewriteFiles.dataSeqs(1L), TestRewriteFiles.fileSeqs(1L), TestRewriteFiles.ids(pending.snapshotId()), TestRewriteFiles.files(FILE_A_DELETES), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED));
        this.commit((Table)this.table, (SnapshotUpdate)rewrite, this.branch);
        Assert.assertTrue((String)"Should reuse the new manifest", (boolean)new File(manifest1.path()).exists());
        Assert.assertTrue((String)"Should reuse the new manifest", (boolean)new File(manifest2.path()).exists());
        TableMetadata metadata = this.readMetadata();
        ArrayList committedManifests = Lists.newArrayList((Object[])new ManifestFile[]{manifest1, manifest2});
        Assert.assertTrue((String)"Should committed the manifests", (boolean)SnapshotUtil.latestSnapshot((TableMetadata)metadata, (String)this.branch).allManifests(this.table.io()).containsAll(committedManifests));
        Assert.assertEquals((String)"4 manifests should exist", (long)4L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testDeleteNonExistentFile() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).allManifests(this.table.io()).size());
        AssertHelpers.assertThrows((String)"Expected an exception", ValidationException.class, (String)"Missing required files to delete: /path/to/data-c.parquet", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_C}), Sets.newSet((Object[])new DataFile[]{FILE_D})), this.branch));
        Assert.assertEquals((String)"Only 1 manifests should exist", (long)1L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testAlreadyDeletedFile() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).allManifests(this.table.io()).size());
        RewriteFiles rewrite = this.table.newRewrite();
        Snapshot pending = this.apply((SnapshotUpdate)rewrite.rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_B})), this.branch);
        Assert.assertEquals((String)"Should contain 2 manifest", (long)2L, (long)pending.allManifests(this.table.io()).size());
        long pendingId = pending.snapshotId();
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(0), TestRewriteFiles.ids(pendingId), TestRewriteFiles.files(FILE_B), TestRewriteFiles.statuses(ManifestEntry.Status.ADDED));
        TestRewriteFiles.validateManifestEntries((ManifestFile)pending.allManifests(this.table.io()).get(1), TestRewriteFiles.ids(pendingId, SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId()), TestRewriteFiles.files(FILE_A), TestRewriteFiles.statuses(ManifestEntry.Status.DELETED));
        this.commit((Table)this.table, (SnapshotUpdate)rewrite, this.branch);
        AssertHelpers.assertThrows((String)"Expected an exception", ValidationException.class, (String)"Missing required files to delete: /path/to/data-a.parquet", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newRewrite().rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_D})), this.branch));
        Assert.assertEquals((String)"Only 3 manifests should exist", (long)3L, (long)this.listManifestFiles().size());
    }

    @Test
    public void testNewDeleteFile() {
        Assume.assumeTrue((String)"Delete files are only supported in v2", (this.formatVersion > 1 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        long snapshotBeforeDeletes = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES), this.branch);
        long snapshotAfterDeletes = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should fail because deletes were added after the starting snapshot", ValidationException.class, (String)"Cannot commit, found new delete for replaced data file", () -> this.apply((SnapshotUpdate)this.table.newRewrite().validateFromSnapshot(snapshotBeforeDeletes).rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_A2})), this.branch));
        this.apply((SnapshotUpdate)this.table.newRewrite().validateFromSnapshot(snapshotAfterDeletes).rewriteFiles(Sets.newSet((Object[])new DataFile[]{FILE_A}), Sets.newSet((Object[])new DataFile[]{FILE_A2})), this.branch);
    }
}

