/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestReplaceTransaction
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestReplaceTransaction(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testReplaceTransactionWithCustomSortOrder() {
        Snapshot start = this.table.currentSnapshot();
        Schema schema = this.table.schema();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        SortOrder newSortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("id", NullOrder.NULLS_FIRST)).build();
        HashMap props = Maps.newHashMap();
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", schema, PartitionSpec.unpartitioned(), newSortOrder, props);
        replace.commitTransaction();
        this.table.refresh();
        Assert.assertEquals((String)"Version should be 2", (long)2L, (long)this.version().intValue());
        Assert.assertNull((String)"Table should not have a current snapshot", (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Schema should match previous schema", (Object)schema.asStruct(), (Object)this.table.schema().asStruct());
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).build();
        this.V2Assert.assertEquals("Table should have an unpartitioned spec", v2Expected, this.table.spec());
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)this.table.schema()).alwaysNull("data", "data_bucket").withSpecId(1).build();
        this.V1Assert.assertEquals("Table should have a spec with one void field", v1Expected, this.table.spec());
        Assert.assertEquals((String)"Table should have 2 orders", (long)2L, (long)this.table.sortOrders().size());
        SortOrder sortOrder = this.table.sortOrder();
        Assert.assertEquals((String)"Order ID must match", (long)1L, (long)sortOrder.orderId());
        Assert.assertEquals((String)"Order must have 1 field", (long)1L, (long)sortOrder.fields().size());
        Assert.assertEquals((String)"Direction must match ", (Object)SortDirection.ASC, (Object)((SortField)sortOrder.fields().get(0)).direction());
        Assert.assertEquals((String)"Null order must match ", (Object)NullOrder.NULLS_FIRST, (Object)((SortField)sortOrder.fields().get(0)).nullOrder());
        Transform transform = Transforms.identity();
        Assert.assertEquals((String)"Transform must match", (Object)transform, (Object)((SortField)sortOrder.fields().get(0)).transform());
    }

    @Test
    public void testReplaceTransaction() {
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)4, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)5, (String)"data", (Type)Types.StringType.get())});
        Snapshot start = this.table.currentSnapshot();
        Schema schema = this.table.schema();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", newSchema, PartitionSpec.unpartitioned());
        replace.commitTransaction();
        this.table.refresh();
        Assert.assertEquals((String)"Version should be 2", (long)2L, (long)this.version().intValue());
        Assert.assertNull((String)"Table should not have a current snapshot", (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Schema should match previous schema", (Object)schema.asStruct(), (Object)this.table.schema().asStruct());
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).build();
        this.V2Assert.assertEquals("Table should have an unpartitioned spec", v2Expected, this.table.spec());
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)this.table.schema()).alwaysNull("data", "data_bucket").withSpecId(1).build();
        this.V1Assert.assertEquals("Table should have a spec with one void field", v1Expected, this.table.spec());
        Assert.assertEquals((String)"Table should have 1 order", (long)1L, (long)this.table.sortOrders().size());
        Assert.assertEquals((String)"Table order ID should match", (long)0L, (long)this.table.sortOrder().orderId());
        Assert.assertTrue((String)"Table should be unsorted", (boolean)this.table.sortOrder().isUnsorted());
    }

    @Test
    public void testReplaceWithIncompatibleSchemaUpdate() {
        Assume.assumeTrue((String)"Fails early for v1 tables because partition spec cannot drop a field", (this.formatVersion == 2 ? 1 : 0) != 0);
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)4, (String)"obj_id", (Type)Types.IntegerType.get())});
        Snapshot start = this.table.currentSnapshot();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", newSchema, PartitionSpec.unpartitioned());
        replace.commitTransaction();
        this.table.refresh();
        Assert.assertEquals((String)"Version should be 2", (long)2L, (long)this.version().intValue());
        Assert.assertNull((String)"Table should not have a current snapshot", (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Schema should use new schema, not compatible with previous", (Object)new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"obj_id", (Type)Types.IntegerType.get())}).asStruct(), (Object)this.table.schema().asStruct());
    }

    @Test
    public void testReplaceWithNewPartitionSpec() {
        PartitionSpec newSpec = PartitionSpec.unpartitioned();
        Snapshot start = this.table.currentSnapshot();
        Schema schema = this.table.schema();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", this.table.schema(), newSpec);
        replace.commitTransaction();
        this.table.refresh();
        Assert.assertEquals((String)"Version should be 2", (long)2L, (long)this.version().intValue());
        Assert.assertNull((String)"Table should not have a current snapshot", (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Schema should use new schema, not compatible with previous", (Object)schema.asStruct(), (Object)this.table.schema().asStruct());
        PartitionSpec v2Expected = PartitionSpec.builderFor((Schema)this.table.schema()).withSpecId(1).build();
        this.V2Assert.assertEquals("Table should have an unpartitioned spec", v2Expected, this.table.spec());
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)this.table.schema()).alwaysNull("data", "data_bucket").withSpecId(1).build();
        this.V1Assert.assertEquals("Table should have a spec with one void field", v1Expected, this.table.spec());
    }

    @Test
    public void testReplaceWithNewData() {
        Snapshot start = this.table.currentSnapshot();
        Schema schema = this.table.schema();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", this.table.schema(), this.table.spec());
        replace.newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        replace.commitTransaction();
        this.table.refresh();
        Assert.assertEquals((String)"Version should be 2", (long)2L, (long)this.version().intValue());
        Assert.assertNotNull((String)"Table should have a current snapshot", (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Schema should use new schema, not compatible with previous", (Object)schema.asStruct(), (Object)this.table.schema().asStruct());
        this.validateSnapshot(null, this.table.currentSnapshot(), FILE_B, FILE_C, FILE_D);
    }

    @Test
    public void testReplaceDetectsUncommittedChangeOnCommit() {
        Assert.assertEquals((String)"Version should be 0", (long)0L, (long)this.version().intValue());
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", this.table.schema(), this.table.spec());
        replace.newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D);
        AssertHelpers.assertThrows((String)"Should reject commit when last operation has not committed", IllegalStateException.class, (String)"Cannot commit transaction: last operation has not committed", () -> ((Transaction)replace).commitTransaction());
        Assert.assertEquals((String)"Version should be 0", (long)0L, (long)this.version().intValue());
    }

    @Test
    public void testReplaceDetectsUncommittedChangeOnTableCommit() {
        Assert.assertEquals((String)"Version should be 0", (long)0L, (long)this.version().intValue());
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", this.table.schema(), this.table.spec());
        replace.table().newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D);
        AssertHelpers.assertThrows((String)"Should reject commit when last operation has not committed", IllegalStateException.class, (String)"Cannot commit transaction: last operation has not committed", () -> ((Transaction)replace).commitTransaction());
        Assert.assertEquals((String)"Version should be 0", (long)0L, (long)this.version().intValue());
    }

    @Test
    public void testReplaceTransactionRetry() {
        Snapshot start = this.table.currentSnapshot();
        Schema schema = this.table.schema();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", this.table.schema(), this.table.spec());
        replace.newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        ((TestTables.TestTableOperations)((BaseTransaction)replace).ops()).failCommits(1);
        replace.commitTransaction();
        this.table.refresh();
        Assert.assertEquals((String)"Version should be 2", (long)2L, (long)this.version().intValue());
        Assert.assertNotNull((String)"Table should have a current snapshot", (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Schema should use new schema, not compatible with previous", (Object)schema.asStruct(), (Object)this.table.schema().asStruct());
        this.validateSnapshot(null, this.table.currentSnapshot(), FILE_B, FILE_C, FILE_D);
    }

    @Test
    public void testReplaceTransactionConflict() {
        Snapshot start = this.table.currentSnapshot();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        HashSet manifests = Sets.newHashSet(this.listManifestFiles());
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", this.table.schema(), this.table.spec());
        replace.newAppend().appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        ((TestTables.TestTableOperations)((BaseTransaction)replace).ops()).failCommits(100);
        AssertHelpers.assertThrows((String)"Should reject commit when retries are exhausted", CommitFailedException.class, (String)"Injected failure", () -> ((Transaction)replace).commitTransaction());
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.table.refresh();
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        Assert.assertEquals((String)"Should clean up replace manifests", (Object)manifests, (Object)Sets.newHashSet(this.listManifestFiles()));
    }

    @Test
    public void testReplaceToCreateAndAppend() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction replace = TestTables.beginReplace(tableDir, "test_append", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        Assert.assertTrue((String)"Should return a transaction table", (boolean)(replace.table() instanceof BaseTransaction.TransactionTable));
        replace.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertNull((String)"Appending in a transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        replace.commitTransaction();
        TableMetadata meta = TestTables.readMetadata("test_append");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_append").intValue());
        Assert.assertEquals((String)"Should have 1 manifest file", (long)1L, (long)this.listManifestFiles(tableDir).size());
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TestReplaceTransaction.assignFreshIds(SCHEMA).asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should have one snapshot", (long)1L, (long)meta.snapshots().size());
        this.validateSnapshot(null, meta.currentSnapshot(), FILE_A, FILE_B);
    }

    @Test
    public void testReplaceTransactionWithUnknownState() {
        Schema newSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)4, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)5, (String)"data", (Type)Types.StringType.get())});
        Snapshot start = this.table.currentSnapshot();
        Schema schema = this.table.schema();
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertEquals((String)"Version should be 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(start, this.table.currentSnapshot(), FILE_A);
        TestTables.TestTableOperations ops = TestTables.opsWithCommitSucceedButStateUnknown(this.tableDir, "test");
        Transaction replace = TestTables.beginReplace(this.tableDir, "test", newSchema, PartitionSpec.unpartitioned(), SortOrder.unsorted(), (Map<String, String>)ImmutableMap.of(), ops);
        replace.newAppend().appendFile(FILE_B).commit();
        AssertHelpers.assertThrows((String)"Transaction commit should fail with CommitStateUnknownException", CommitStateUnknownException.class, (String)"datacenter on fire", () -> replace.commitTransaction());
        this.table.refresh();
        Assert.assertEquals((String)"Version should be 2", (long)2L, (long)this.version().intValue());
        Assert.assertNotNull((String)"Table should have a current snapshot", (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Schema should use new schema, not compatible with previous", (Object)schema.asStruct(), (Object)this.table.schema().asStruct());
        Assert.assertEquals((String)"Should have 4 files in metadata", (long)4L, (long)TestReplaceTransaction.countAllMetadataFiles(this.tableDir));
        this.validateSnapshot(null, this.table.currentSnapshot(), FILE_B);
    }

    @Test
    public void testCreateTransactionWithUnknownState() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        TestTables.TestTableOperations ops = TestTables.opsWithCommitSucceedButStateUnknown(tableDir, "test_append");
        Transaction replace = TestTables.beginReplace(tableDir, "test_append", SCHEMA, PartitionSpec.unpartitioned(), SortOrder.unsorted(), (Map<String, String>)ImmutableMap.of(), ops);
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        Assert.assertTrue((String)"Should return a transaction table", (boolean)(replace.table() instanceof BaseTransaction.TransactionTable));
        replace.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertNull((String)"Appending in a transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        AssertHelpers.assertThrows((String)"Transaction commit should fail with CommitStateUnknownException", CommitStateUnknownException.class, (String)"datacenter on fire", () -> replace.commitTransaction());
        TableMetadata meta = TestTables.readMetadata("test_append");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_append").intValue());
        Assert.assertEquals((String)"Should have 1 manifest file", (long)1L, (long)this.listManifestFiles(tableDir).size());
        Assert.assertEquals((String)"Should have 2 files in metadata", (long)2L, (long)TestReplaceTransaction.countAllMetadataFiles(tableDir));
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TestReplaceTransaction.assignFreshIds(SCHEMA).asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should have one snapshot", (long)1L, (long)meta.snapshots().size());
        this.validateSnapshot(null, meta.currentSnapshot(), FILE_A, FILE_B);
    }

    private static Schema assignFreshIds(Schema schema) {
        AtomicInteger lastColumnId = new AtomicInteger(0);
        return TypeUtil.assignFreshIds((Schema)schema, lastColumnId::incrementAndGet);
    }
}

