/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestReplacePartitions
extends TableTestBase {
    static final DataFile FILE_E = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-e.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=0").withRecordCount(0L).build();
    static final DataFile FILE_F = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-f.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=1").withRecordCount(0L).build();
    static final DataFile FILE_G = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-g.parquet").withFileSizeInBytes(0L).withPartitionPath("data_bucket=10").withRecordCount(0L).build();
    static final DataFile FILE_UNPARTITIONED_A = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-unpartitioned-a.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    static final DeleteFile FILE_UNPARTITIONED_A_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)PartitionSpec.unpartitioned()).ofPositionDeletes().withPath("/path/to/data-unpartitioned-a-deletes.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    private final String branch;

    @Parameterized.Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[] parameters() {
        return new Object[][]{{1, "main"}, {1, "testBranch"}, {2, "main"}, {2, "testBranch"}};
    }

    public TestReplacePartitions(int formatVersion, String branch) {
        super(formatVersion);
        this.branch = branch;
    }

    @Test
    public void testReplaceOnePartition() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_E), this.branch);
        long replaceId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertNotEquals((String)"Should create a new snapshot", (long)baseId, (long)replaceId);
        Assert.assertEquals((String)"Table should have 2 manifests", (long)2L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(replaceId), TestReplacePartitions.files(FILE_E), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(replaceId, baseId), TestReplacePartitions.files(FILE_A, FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testReplaceAndMergeOnePartition() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_E), this.branch);
        long replaceId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertNotEquals((String)"Should create a new snapshot", (long)baseId, (long)replaceId);
        Assert.assertEquals((String)"Table should have 1 manifest", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(replaceId, replaceId, baseId), TestReplacePartitions.files(FILE_E, FILE_A, FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testReplaceWithUnpartitionedTable() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        TestTables.TestTable unpartitioned = TestTables.create(tableDir, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), this.formatVersion);
        Assert.assertEquals((String)"Table version should be 0", (long)0L, (long)TestTables.metadataVersion("unpartitioned").intValue());
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newAppend().appendFile(FILE_A), this.branch);
        Assert.assertEquals((String)"Table version should be 1", (long)1L, (long)TestTables.metadataVersion("unpartitioned").intValue());
        this.validateSnapshot(null, SnapshotUtil.latestSnapshot((TableMetadata)TestTables.readMetadata("unpartitioned"), (String)this.branch), FILE_A);
        ReplacePartitions replacePartitions = unpartitioned.newReplacePartitions().addFile(FILE_B);
        this.commit((Table)this.table, (SnapshotUpdate)replacePartitions, this.branch);
        Assert.assertEquals((String)"Table version should be 2", (long)2L, (long)TestTables.metadataVersion("unpartitioned").intValue());
        TableMetadata replaceMetadata = TestTables.readMetadata("unpartitioned");
        long replaceId = SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 2 manifests", (long)2L, (long)SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).allManifests(unpartitioned.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).allManifests(unpartitioned.io()).get(0), TestReplacePartitions.ids(replaceId), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).allManifests(unpartitioned.io()).get(1), TestReplacePartitions.ids(replaceId), TestReplacePartitions.files(FILE_A), TestReplacePartitions.statuses(ManifestEntry.Status.DELETED));
    }

    @Test
    public void testReplaceAndMergeWithUnpartitionedTable() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        TestTables.TestTable unpartitioned = TestTables.create(tableDir, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), this.formatVersion);
        unpartitioned.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        Assert.assertEquals((String)"Table version should be 1", (long)1L, (long)TestTables.metadataVersion("unpartitioned").intValue());
        AppendFiles appendFiles = unpartitioned.newAppend().appendFile(FILE_A);
        this.commit((Table)this.table, (SnapshotUpdate)appendFiles, this.branch);
        Assert.assertEquals((String)"Table version should be 2", (long)2L, (long)TestTables.metadataVersion("unpartitioned").intValue());
        this.validateSnapshot(null, SnapshotUtil.latestSnapshot((TableMetadata)TestTables.readMetadata("unpartitioned"), (String)this.branch), FILE_A);
        ReplacePartitions replacePartitions = unpartitioned.newReplacePartitions().addFile(FILE_B);
        this.commit((Table)this.table, (SnapshotUpdate)replacePartitions, this.branch);
        Assert.assertEquals((String)"Table version should be 3", (long)3L, (long)TestTables.metadataVersion("unpartitioned").intValue());
        TableMetadata replaceMetadata = TestTables.readMetadata("unpartitioned");
        long replaceId = SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 1 manifest", (long)1L, (long)SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).allManifests(unpartitioned.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).allManifests(unpartitioned.io()).get(0), TestReplacePartitions.ids(replaceId, replaceId), TestReplacePartitions.files(FILE_B, FILE_A), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.DELETED));
    }

    @Test
    public void testValidationFailure() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        ReplacePartitions replace = this.table.newReplacePartitions().addFile(FILE_F).addFile(FILE_G).validateAppendOnly();
        AssertHelpers.assertThrows((String)"Should reject commit with file not matching delete expression", ValidationException.class, (String)"Cannot commit file that conflicts with existing partition", () -> this.commit((Table)this.table, (SnapshotUpdate)replace, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)baseId, (long)SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId());
    }

    @Test
    public void testValidationSuccess() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_G).validateAppendOnly(), this.branch);
        long replaceId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertNotEquals((String)"Should create a new snapshot", (long)baseId, (long)replaceId);
        Assert.assertEquals((String)"Table should have 2 manifests", (long)2L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(replaceId), TestReplacePartitions.files(FILE_G), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(baseId, baseId), TestReplacePartitions.files(FILE_A, FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testValidationNotInvoked() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_E).validateFromSnapshot(SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId()), this.branch);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_A).addFile(FILE_B).validateFromSnapshot(SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId()), this.branch);
        long replaceId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 2 manifest", (long)2L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(replaceId, replaceId), TestReplacePartitions.files(FILE_A, FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(replaceId), TestReplacePartitions.files(FILE_E), TestReplacePartitions.statuses(ManifestEntry.Status.DELETED));
    }

    @Test
    public void testValidateWithDefaultSnapshotId() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_A), this.branch);
        ReplacePartitions replace = this.table.newReplacePartitions();
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found conflicting files that can contain records matching partitions [data_bucket=0, data_bucket=1]: [/path/to/data-a.parquet]", () -> this.commit((Table)this.table, (SnapshotUpdate)replace.addFile(FILE_A).addFile(FILE_B).validateNoConflictingData().validateNoConflictingDeletes(), this.branch));
    }

    @Test
    public void testConcurrentReplaceConflict() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_A), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found conflicting files that can contain records matching partitions [data_bucket=0, data_bucket=1]: [/path/to/data-a.parquet]", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateFromSnapshot(baseId).addFile(FILE_A).addFile(FILE_B).validateNoConflictingData().validateNoConflictingDeletes(), this.branch));
    }

    @Test
    public void testConcurrentReplaceNoConflict() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        long id1 = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().addFile(FILE_A), this.branch);
        long id2 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateFromSnapshot(id1).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_B), this.branch);
        long id3 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 2 manifests", (long)2L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(id3), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(id2), TestReplacePartitions.files(FILE_A), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testConcurrentReplaceConflictNonPartitioned() {
        TestTables.TestTable unpartitioned = TestTables.create(this.tableDir, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), this.formatVersion);
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newAppend().appendFile(FILE_UNPARTITIONED_A), this.branch);
        TableMetadata replaceMetadata = TestTables.readMetadata("unpartitioned");
        long replaceBaseId = SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newReplacePartitions().addFile(FILE_UNPARTITIONED_A), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found conflicting files that can contain records matching true: [/path/to/data-unpartitioned-a.parquet]", () -> this.lambda$testConcurrentReplaceConflictNonPartitioned$3((Table)unpartitioned, replaceBaseId));
    }

    @Test
    public void testAppendReplaceConflict() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_B), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found conflicting files that can contain records matching partitions [data_bucket=0, data_bucket=1]: [/path/to/data-b.parquet]", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateFromSnapshot(baseId).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_A).addFile(FILE_B), this.branch));
    }

    @Test
    public void testAppendReplaceNoConflict() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        long id1 = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_B), this.branch);
        long id2 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateFromSnapshot(id1).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_A), this.branch);
        long id3 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 3 manifests", (long)3L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(id3), TestReplacePartitions.files(FILE_A), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(id2), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(2), TestReplacePartitions.ids(id3), TestReplacePartitions.files(FILE_A), TestReplacePartitions.statuses(ManifestEntry.Status.DELETED));
    }

    @Test
    public void testAppendReplaceConflictNonPartitioned() {
        TestTables.TestTable unpartitioned = TestTables.create(this.tableDir, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), this.formatVersion);
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newAppend().appendFile(FILE_UNPARTITIONED_A), this.branch);
        TableMetadata replaceMetadata = TestTables.readMetadata("unpartitioned");
        long replaceBaseId = SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newAppend().appendFile(FILE_UNPARTITIONED_A), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found conflicting files that can contain records matching true: [/path/to/data-unpartitioned-a.parquet]", () -> this.lambda$testAppendReplaceConflictNonPartitioned$5((Table)unpartitioned, replaceBaseId));
    }

    @Test
    public void testDeleteReplaceConflict() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(baseId), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found new conflicting delete files that can apply to records matching [data_bucket=0]: [/path/to/data-a-deletes.parquet]", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateFromSnapshot(baseId).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_A), this.branch));
    }

    @Test
    public void testDeleteReplaceConflictNonPartitioned() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        TestTables.TestTable unpartitioned = TestTables.create(this.tableDir, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), this.formatVersion);
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newAppend().appendFile(FILE_A), this.branch);
        TableMetadata replaceMetadata = TestTables.readMetadata("unpartitioned");
        long replaceBaseId = SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newRowDelta().addDeletes(FILE_UNPARTITIONED_A_DELETES), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found new conflicting delete files that can apply to records matching true: [/path/to/data-unpartitioned-a-deletes.parquet]", () -> this.lambda$testDeleteReplaceConflictNonPartitioned$7((Table)unpartitioned, replaceBaseId));
    }

    @Test
    public void testDeleteReplaceNoConflict() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        long id1 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_A_DELETES).validateFromSnapshot(id1).validateNoConflictingDataFiles().validateNoConflictingDeleteFiles().validateFromSnapshot(id1), this.branch);
        long id2 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateNoConflictingData().validateNoConflictingDeletes().validateFromSnapshot(id1).addFile(FILE_B), this.branch);
        long id3 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 3 manifest", (long)3L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(id3), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(id1), TestReplacePartitions.files(FILE_A), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        this.validateDeleteManifest((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(2), TestReplacePartitions.dataSeqs(2L), TestReplacePartitions.fileSeqs(2L), TestReplacePartitions.ids(id2), TestReplacePartitions.files(FILE_A_DELETES), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testOverwriteReplaceConflict() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_A), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found conflicting deleted files that can apply to records matching [data_bucket=0]: [/path/to/data-a.parquet]", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateFromSnapshot(baseId).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_A), this.branch));
    }

    @Test
    public void testOverwriteReplaceNoConflict() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_A), this.branch);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateNoConflictingData().validateNoConflictingDeletes().validateFromSnapshot(baseId).addFile(FILE_B), this.branch);
        long finalId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 2 manifest", (long)2L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(finalId), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(finalId), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.DELETED));
    }

    @Test
    public void testOverwriteReplaceConflictNonPartitioned() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        TestTables.TestTable unpartitioned = TestTables.create(this.tableDir, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), this.formatVersion);
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newAppend().appendFile(FILE_UNPARTITIONED_A), this.branch);
        TableMetadata replaceMetadata = TestTables.readMetadata("unpartitioned");
        long replaceBaseId = SnapshotUtil.latestSnapshot((TableMetadata)replaceMetadata, (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newOverwrite().deleteFile(FILE_UNPARTITIONED_A), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit with file matching partitions replaced", ValidationException.class, (String)"Found conflicting deleted files that can contain records matching true: [/path/to/data-unpartitioned-a.parquet]", () -> this.lambda$testOverwriteReplaceConflictNonPartitioned$9((Table)unpartitioned, replaceBaseId));
    }

    @Test
    public void testValidateOnlyDeletes() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_B), this.branch);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newReplacePartitions().validateFromSnapshot(baseId).validateNoConflictingDeletes().addFile(FILE_B), this.branch);
        long finalId = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Table should have 3 manifest", (long)3L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestReplacePartitions.ids(finalId), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestReplacePartitions.ids(finalId), TestReplacePartitions.files(FILE_B), TestReplacePartitions.statuses(ManifestEntry.Status.DELETED));
        TestReplacePartitions.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(2), TestReplacePartitions.ids(baseId), TestReplacePartitions.files(FILE_A), TestReplacePartitions.statuses(ManifestEntry.Status.ADDED));
    }

    @Test
    public void testEmptyPartitionPathWithUnpartitionedTable() {
        DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPartitionPath("");
    }

    private /* synthetic */ Object lambda$testOverwriteReplaceConflictNonPartitioned$9(Table unpartitioned, long replaceBaseId) throws Exception {
        return this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newReplacePartitions().validateFromSnapshot(replaceBaseId).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_UNPARTITIONED_A), this.branch);
    }

    private /* synthetic */ Object lambda$testDeleteReplaceConflictNonPartitioned$7(Table unpartitioned, long replaceBaseId) throws Exception {
        return this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newReplacePartitions().validateFromSnapshot(replaceBaseId).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_UNPARTITIONED_A), this.branch);
    }

    private /* synthetic */ Object lambda$testAppendReplaceConflictNonPartitioned$5(Table unpartitioned, long replaceBaseId) throws Exception {
        return this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newReplacePartitions().validateFromSnapshot(replaceBaseId).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_UNPARTITIONED_A), this.branch);
    }

    private /* synthetic */ Object lambda$testConcurrentReplaceConflictNonPartitioned$3(Table unpartitioned, long replaceBaseId) throws Exception {
        return this.commit((Table)this.table, (SnapshotUpdate)unpartitioned.newReplacePartitions().validateFromSnapshot(replaceBaseId).validateNoConflictingData().validateNoConflictingDeletes().addFile(FILE_UNPARTITIONED_A), this.branch);
    }
}

