/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.RemoveSnapshots;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRemoveSnapshots
extends TableTestBase {
    private final boolean incrementalCleanup;

    @Parameterized.Parameters(name="formatVersion = {0}, incrementalCleanup = {1}")
    public static Object[] parameters() {
        return new Object[][]{{1, true}, {2, true}, {1, false}, {2, false}};
    }

    public TestRemoveSnapshots(int formatVersion, boolean incrementalCleanup) {
        super(formatVersion);
        this.incrementalCleanup = incrementalCleanup;
    }

    private long waitUntilAfter(long timestampMillis) {
        long current = System.currentTimeMillis();
        while (current <= timestampMillis) {
            current = System.currentTimeMillis();
        }
        return current;
    }

    @Test
    public void testExpireOlderThan() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.table.newAppend().appendFile(FILE_B).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        long tAfterCommits = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(tAfterCommits).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Expire should not change current snapshot", (long)snapshotId, (long)this.table.currentSnapshot().snapshotId());
        Assert.assertNull((String)"Expire should remove the oldest snapshot", (Object)this.table.snapshot(firstSnapshot.snapshotId()));
        Assert.assertEquals((String)"Should remove only the expired manifest list location", (Object)Sets.newHashSet((Object[])new String[]{firstSnapshot.manifestListLocation()}), (Object)deletedFiles);
    }

    @Test
    public void testExpireOlderThanWithDelete() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Should create one manifest", (long)1L, (long)firstSnapshot.allManifests(this.table.io()).size());
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.table.newDelete().deleteFile(FILE_A).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Should create replace manifest with a rewritten manifest", (long)1L, (long)secondSnapshot.allManifests(this.table.io()).size());
        this.table.newAppend().appendFile(FILE_B).commit();
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        long snapshotId = this.table.currentSnapshot().snapshotId();
        long tAfterCommits = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(tAfterCommits).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Expire should not change current snapshot", (long)snapshotId, (long)this.table.currentSnapshot().snapshotId());
        Assert.assertNull((String)"Expire should remove the oldest snapshot", (Object)this.table.snapshot(firstSnapshot.snapshotId()));
        Assert.assertNull((String)"Expire should remove the second oldest snapshot", (Object)this.table.snapshot(secondSnapshot.snapshotId()));
        Assert.assertEquals((String)"Should remove expired manifest lists and deleted data file", (Object)Sets.newHashSet((Object[])new CharSequence[]{firstSnapshot.manifestListLocation(), ((ManifestFile)firstSnapshot.allManifests(this.table.io()).get(0)).path(), secondSnapshot.manifestListLocation(), ((ManifestFile)secondSnapshot.allManifests(this.table.io()).get(0)).path(), FILE_A.path()}), (Object)deletedFiles);
    }

    @Test
    public void testExpireOlderThanWithDeleteInMergedManifests() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "0").commit();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Should create one manifest", (long)1L, (long)firstSnapshot.allManifests(this.table.io()).size());
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.table.newDelete().deleteFile(FILE_A).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Should replace manifest with a rewritten manifest", (long)1L, (long)secondSnapshot.allManifests(this.table.io()).size());
        this.table.newFastAppend().appendFile(FILE_C).commit();
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        long snapshotId = this.table.currentSnapshot().snapshotId();
        long tAfterCommits = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(tAfterCommits).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Expire should not change current snapshot", (long)snapshotId, (long)this.table.currentSnapshot().snapshotId());
        Assert.assertNull((String)"Expire should remove the oldest snapshot", (Object)this.table.snapshot(firstSnapshot.snapshotId()));
        Assert.assertNull((String)"Expire should remove the second oldest snapshot", (Object)this.table.snapshot(secondSnapshot.snapshotId()));
        Assert.assertEquals((String)"Should remove expired manifest lists and deleted data file", (Object)Sets.newHashSet((Object[])new CharSequence[]{firstSnapshot.manifestListLocation(), ((ManifestFile)firstSnapshot.allManifests(this.table.io()).get(0)).path(), secondSnapshot.manifestListLocation(), FILE_A.path()}), (Object)deletedFiles);
    }

    @Test
    public void testExpireOlderThanWithRollback() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "0").commit();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Should create one manifest", (long)1L, (long)firstSnapshot.allManifests(this.table.io()).size());
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.table.newDelete().deleteFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        HashSet secondSnapshotManifests = Sets.newHashSet((Iterable)secondSnapshot.allManifests(this.table.io()));
        secondSnapshotManifests.removeAll(firstSnapshot.allManifests(this.table.io()));
        Assert.assertEquals((String)"Should add one new manifest for append", (long)1L, (long)secondSnapshotManifests.size());
        this.table.manageSnapshots().rollbackTo(firstSnapshot.snapshotId()).commit();
        long tAfterCommits = this.waitUntilAfter(secondSnapshot.timestampMillis());
        long snapshotId = this.table.currentSnapshot().snapshotId();
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(tAfterCommits).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Expire should not change current snapshot", (long)snapshotId, (long)this.table.currentSnapshot().snapshotId());
        Assert.assertNotNull((String)"Expire should keep the oldest snapshot, current", (Object)this.table.snapshot(firstSnapshot.snapshotId()));
        Assert.assertNull((String)"Expire should remove the orphaned snapshot", (Object)this.table.snapshot(secondSnapshot.snapshotId()));
        Assert.assertEquals((String)"Should remove expired manifest lists and reverted appended data file", (Object)Sets.newHashSet((Object[])new String[]{secondSnapshot.manifestListLocation(), ((ManifestFile)Iterables.getOnlyElement((Iterable)secondSnapshotManifests)).path()}), (Object)deletedFiles);
    }

    @Test
    public void testExpireOlderThanWithRollbackAndMergedManifests() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Should create one manifest", (long)1L, (long)firstSnapshot.allManifests(this.table.io()).size());
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        HashSet secondSnapshotManifests = Sets.newHashSet((Iterable)secondSnapshot.allManifests(this.table.io()));
        secondSnapshotManifests.removeAll(firstSnapshot.allManifests(this.table.io()));
        Assert.assertEquals((String)"Should add one new manifest for append", (long)1L, (long)secondSnapshotManifests.size());
        this.table.manageSnapshots().rollbackTo(firstSnapshot.snapshotId()).commit();
        long tAfterCommits = this.waitUntilAfter(secondSnapshot.timestampMillis());
        long snapshotId = this.table.currentSnapshot().snapshotId();
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(tAfterCommits).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Expire should not change current snapshot", (long)snapshotId, (long)this.table.currentSnapshot().snapshotId());
        Assert.assertNotNull((String)"Expire should keep the oldest snapshot, current", (Object)this.table.snapshot(firstSnapshot.snapshotId()));
        Assert.assertNull((String)"Expire should remove the orphaned snapshot", (Object)this.table.snapshot(secondSnapshot.snapshotId()));
        Assert.assertEquals((String)"Should remove expired manifest lists and reverted appended data file", (Object)Sets.newHashSet((Object[])new CharSequence[]{secondSnapshot.manifestListLocation(), ((ManifestFile)Iterables.getOnlyElement((Iterable)secondSnapshotManifests)).path(), FILE_B.path()}), (Object)deletedFiles);
    }

    @Test
    public void testRetainLastWithExpireOlderThan() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).commit();
        long firstSnapshotId = this.table.currentSnapshot().snapshotId();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        this.removeSnapshots((Table)this.table).expireOlderThan(t3).retainLast(2).commit();
        Assert.assertEquals((String)"Should have two snapshots.", (long)2L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertEquals((String)"First snapshot should not present.", null, (Object)this.table.snapshot(firstSnapshotId));
    }

    @Test
    public void testRetainLastWithExpireById() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).commit();
        long firstSnapshotId = this.table.currentSnapshot().snapshotId();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        this.removeSnapshots((Table)this.table).expireSnapshotId(firstSnapshotId).retainLast(3).commit();
        Assert.assertEquals((String)"Should have two snapshots.", (long)2L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertEquals((String)"First snapshot should not present.", null, (Object)this.table.snapshot(firstSnapshotId));
    }

    @Test
    public void testRetainNAvailableSnapshotsWithTransaction() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).commit();
        long firstSnapshotId = this.table.currentSnapshot().snapshotId();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        Assert.assertEquals((String)"Should be 3 manifest lists", (long)3L, (long)this.listManifestLists(this.table.location()).size());
        Transaction tx = this.table.newTransaction();
        this.removeSnapshots(tx.table()).expireOlderThan(t3).retainLast(2).commit();
        tx.commitTransaction();
        Assert.assertEquals((String)"Should have two snapshots.", (long)2L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertEquals((String)"First snapshot should not present.", null, (Object)this.table.snapshot(firstSnapshotId));
        Assert.assertEquals((String)"Should be 2 manifest lists", (long)2L, (long)this.listManifestLists(this.table.location()).size());
    }

    @Test
    public void testRetainLastWithTooFewSnapshots() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        long firstSnapshotId = this.table.currentSnapshot().snapshotId();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.removeSnapshots((Table)this.table).expireOlderThan(t2).retainLast(3).commit();
        Assert.assertEquals((String)"Should have two snapshots", (long)2L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertEquals((String)"First snapshot should still present", (long)firstSnapshotId, (long)this.table.snapshot(firstSnapshotId).snapshotId());
    }

    @Test
    public void testRetainNLargerThanCurrentSnapshots() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long firstSnapshotId = this.table.currentSnapshot().snapshotId();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        Transaction tx = this.table.newTransaction();
        this.removeSnapshots(tx.table()).expireOlderThan(t3).retainLast(4).commit();
        tx.commitTransaction();
        Assert.assertEquals((String)"Should have three snapshots.", (long)3L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
    }

    @Test
    public void testRetainLastKeepsExpiringSnapshot() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).commit();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_D).commit();
        long t4 = System.currentTimeMillis();
        while (t4 <= this.table.currentSnapshot().timestampMillis()) {
            t4 = System.currentTimeMillis();
        }
        this.removeSnapshots((Table)this.table).expireOlderThan(secondSnapshot.timestampMillis()).retainLast(2).commit();
        Assert.assertEquals((String)"Should have three snapshots.", (long)3L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertNotNull((String)"Second snapshot should present.", (Object)this.table.snapshot(secondSnapshot.snapshotId()));
    }

    @Test
    public void testExpireOlderThanMultipleCalls() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).commit();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        Snapshot thirdSnapshot = this.table.currentSnapshot();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        this.removeSnapshots((Table)this.table).expireOlderThan(secondSnapshot.timestampMillis()).expireOlderThan(thirdSnapshot.timestampMillis()).commit();
        Assert.assertEquals((String)"Should have one snapshots.", (long)1L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertNull((String)"Second snapshot should not present.", (Object)this.table.snapshot(secondSnapshot.snapshotId()));
    }

    @Test
    public void testRetainLastMultipleCalls() {
        long t0 = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_A).commit();
        long t1 = System.currentTimeMillis();
        while (t1 <= this.table.currentSnapshot().timestampMillis()) {
            t1 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        long t2 = System.currentTimeMillis();
        while (t2 <= this.table.currentSnapshot().timestampMillis()) {
            t2 = System.currentTimeMillis();
        }
        this.table.newAppend().appendFile(FILE_C).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        this.removeSnapshots((Table)this.table).expireOlderThan(t3).retainLast(2).retainLast(1).commit();
        Assert.assertEquals((String)"Should have one snapshots.", (long)1L, (long)Lists.newArrayList((Iterable)this.table.snapshots()).size());
        Assert.assertNull((String)"Second snapshot should not present.", (Object)this.table.snapshot(secondSnapshot.snapshotId()));
    }

    @Test
    public void testRetainZeroSnapshots() {
        AssertHelpers.assertThrows((String)"Should fail retain 0 snapshots because number of snapshots to retain cannot be zero", IllegalArgumentException.class, (String)"Number of snapshots to retain must be at least 1, cannot be: 0", () -> this.removeSnapshots((Table)this.table).retainLast(0).commit());
    }

    @Test
    public void testScanExpiredManifestInValidSnapshotAppend() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.newOverwrite().addFile(FILE_C).deleteFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_D).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(t3).deleteWith(deletedFiles::add).commit();
        Assert.assertTrue((String)"FILE_A should be deleted", (boolean)deletedFiles.contains(FILE_A.path().toString()));
    }

    @Test
    public void testScanExpiredManifestInValidSnapshotFastAppend() {
        this.table.updateProperties().set("commit.manifest-merge.enabled", "true").set("commit.manifest.min-count-to-merge", "1").commit();
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.newOverwrite().addFile(FILE_C).deleteFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_D).commit();
        long t3 = System.currentTimeMillis();
        while (t3 <= this.table.currentSnapshot().timestampMillis()) {
            t3 = System.currentTimeMillis();
        }
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(t3).deleteWith(deletedFiles::add).commit();
        Assert.assertTrue((String)"FILE_A should be deleted", (boolean)deletedFiles.contains(FILE_A.path().toString()));
    }

    @Test
    public void dataFilesCleanup() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_B), (Set)ImmutableSet.of((Object)FILE_D)).commit();
        long thirdSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_C)).commit();
        long fourthSnapshotId = this.table.currentSnapshot().snapshotId();
        long t4 = System.currentTimeMillis();
        while (t4 <= this.table.currentSnapshot().timestampMillis()) {
            t4 = System.currentTimeMillis();
        }
        List manifests = this.table.currentSnapshot().dataManifests(this.table.io());
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, thirdSnapshotId, FILE_C), this.manifestEntry(ManifestEntry.Status.EXISTING, fourthSnapshotId, FILE_D));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        manifests.forEach(arg_0 -> ((RewriteManifests)rewriteManifests).deleteManifest(arg_0));
        rewriteManifests.addManifest(newManifest);
        rewriteManifests.commit();
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(t4).deleteWith(deletedFiles::add).commit();
        Assert.assertTrue((String)"FILE_A should be deleted", (boolean)deletedFiles.contains(FILE_A.path().toString()));
        Assert.assertTrue((String)"FILE_B should be deleted", (boolean)deletedFiles.contains(FILE_B.path().toString()));
    }

    @Test
    public void dataFilesCleanupWithParallelTasks() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_B), (Set)ImmutableSet.of((Object)FILE_D)).commit();
        long thirdSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_C)).commit();
        long fourthSnapshotId = this.table.currentSnapshot().snapshotId();
        long t4 = System.currentTimeMillis();
        while (t4 <= this.table.currentSnapshot().timestampMillis()) {
            t4 = System.currentTimeMillis();
        }
        List manifests = this.table.currentSnapshot().dataManifests(this.table.io());
        ManifestFile newManifest = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, thirdSnapshotId, FILE_C), this.manifestEntry(ManifestEntry.Status.EXISTING, fourthSnapshotId, FILE_D));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        manifests.forEach(arg_0 -> ((RewriteManifests)rewriteManifests).deleteManifest(arg_0));
        rewriteManifests.addManifest(newManifest);
        rewriteManifests.commit();
        HashSet deletedFiles = Sets.newHashSet();
        ConcurrentHashMap.KeySetView deleteThreads = ConcurrentHashMap.newKeySet();
        AtomicInteger deleteThreadsIndex = new AtomicInteger(0);
        AtomicInteger planThreadsIndex = new AtomicInteger(0);
        this.removeSnapshots((Table)this.table).executeDeleteWith(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("remove-snapshot-" + deleteThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })).planWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("plan-" + planThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })).expireOlderThan(t4).deleteWith(s -> {
            deleteThreads.add(Thread.currentThread().getName());
            deletedFiles.add(s);
        }).commit();
        Assert.assertEquals(deleteThreads, (Object)Sets.newHashSet((Object[])new String[]{"remove-snapshot-0", "remove-snapshot-1", "remove-snapshot-2", "remove-snapshot-3"}));
        Assert.assertTrue((String)"FILE_A should be deleted", (boolean)deletedFiles.contains(FILE_A.path().toString()));
        Assert.assertTrue((String)"FILE_B should be deleted", (boolean)deletedFiles.contains(FILE_B.path().toString()));
        Assert.assertTrue((String)"Thread should be created in provided pool", (planThreadsIndex.get() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void noDataFileCleanup() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_B), (Set)ImmutableSet.of((Object)FILE_D)).commit();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_C)).commit();
        long t4 = System.currentTimeMillis();
        while (t4 <= this.table.currentSnapshot().timestampMillis()) {
            t4 = System.currentTimeMillis();
        }
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).cleanExpiredFiles(false).expireOlderThan(t4).deleteWith(deletedFiles::add).commit();
        Assert.assertTrue((String)"No files should have been deleted", (boolean)deletedFiles.isEmpty());
    }

    @Test
    public void testWithExpiringDanglingStageCommit() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((AppendFiles)this.table.newAppend().appendFile(FILE_B).stageOnly()).commit();
        TableMetadata base = this.readMetadata();
        Snapshot snapshotA = (Snapshot)base.snapshots().get(0);
        Snapshot snapshotB = (Snapshot)base.snapshots().get(1);
        this.table.newAppend().appendFile(FILE_C).commit();
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).deleteWith(deletedFiles::add).expireOlderThan(snapshotB.timestampMillis() + 1L).commit();
        HashSet expectedDeletes = Sets.newHashSet();
        expectedDeletes.add(snapshotA.manifestListLocation());
        snapshotB.addedDataFiles(this.table.io()).forEach(i -> expectedDeletes.add(i.path().toString()));
        expectedDeletes.add(snapshotB.manifestListLocation());
        snapshotB.dataManifests(this.table.io()).forEach(file -> {
            if (file.snapshotId().longValue() == snapshotB.snapshotId()) {
                expectedDeletes.add(file.path());
            }
        });
        Assert.assertSame((String)"Files deleted count should be expected", (Object)expectedDeletes.size(), (Object)deletedFiles.size());
        expectedDeletes.removeAll(deletedFiles);
        Assert.assertTrue((String)"Exactly same files should be deleted", (boolean)expectedDeletes.isEmpty());
    }

    @Test
    public void testWithCherryPickTableSnapshot() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot snapshotA = this.table.currentSnapshot();
        HashSet deletedAFiles = Sets.newHashSet();
        ((OverwriteFiles)this.table.newOverwrite().addFile(FILE_B).deleteFile(FILE_A).deleteWith(deletedAFiles::add)).commit();
        Assert.assertTrue((String)"No files should be physically deleted", (boolean)deletedAFiles.isEmpty());
        Snapshot snapshotB = this.readMetadata().currentSnapshot();
        this.table.newAppend().appendFile(FILE_C).commit();
        Snapshot snapshotC = this.readMetadata().currentSnapshot();
        this.table.manageSnapshots().setCurrentSnapshot(snapshotA.snapshotId()).commit();
        this.table.manageSnapshots().cherrypick(snapshotB.snapshotId()).commit();
        Snapshot snapshotD = this.readMetadata().currentSnapshot();
        this.table.manageSnapshots().setCurrentSnapshot(snapshotC.snapshotId()).commit();
        ArrayList deletedFiles = Lists.newArrayList();
        this.removeSnapshots((Table)this.table).deleteWith(deletedFiles::add).expireOlderThan(snapshotC.timestampMillis() + 1L).commit();
        Lists.newArrayList((Object[])new Snapshot[]{snapshotB, snapshotC, snapshotD}).forEach(i -> i.addedDataFiles(this.table.io()).forEach(item -> Assert.assertFalse((boolean)deletedFiles.contains(item.path().toString()))));
    }

    @Test
    public void testWithExpiringStagedThenCherrypick() {
        this.table.newAppend().appendFile(FILE_A).commit();
        ((AppendFiles)this.table.newAppend().appendFile(FILE_B).stageOnly()).commit();
        TableMetadata base = this.readMetadata();
        Snapshot snapshotB = (Snapshot)base.snapshots().get(1);
        this.table.newAppend().appendFile(FILE_C).commit();
        this.table.manageSnapshots().cherrypick(snapshotB.snapshotId()).commit();
        base = this.readMetadata();
        Snapshot snapshotD = (Snapshot)base.snapshots().get(3);
        ArrayList deletedFiles = Lists.newArrayList();
        this.removeSnapshots((Table)this.table).deleteWith(deletedFiles::add).expireSnapshotId(snapshotB.snapshotId()).commit();
        Lists.newArrayList((Object[])new Snapshot[]{snapshotB}).forEach(i -> i.addedDataFiles(this.table.io()).forEach(item -> Assert.assertFalse((boolean)deletedFiles.contains(item.path().toString()))));
        this.removeSnapshots((Table)this.table).deleteWith(deletedFiles::add).expireOlderThan(this.table.currentSnapshot().timestampMillis() + 1L).commit();
        Lists.newArrayList((Object[])new Snapshot[]{snapshotB, snapshotD}).forEach(i -> i.addedDataFiles(this.table.io()).forEach(item -> Assert.assertFalse((boolean)deletedFiles.contains(item.path().toString()))));
    }

    @Test
    public void testExpireSnapshotsWhenGarbageCollectionDisabled() {
        this.table.updateProperties().set("gc.enabled", "false").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        AssertHelpers.assertThrows((String)"Should complain about expiring snapshots", ValidationException.class, (String)"Cannot expire snapshots: GC is disabled", () -> this.table.expireSnapshots());
    }

    @Test
    public void testExpireWithDefaultRetainLast() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        Assert.assertEquals((String)"Expected 3 snapshots", (long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        this.table.updateProperties().set("history.expire.min-snapshots-to-keep", "3").commit();
        HashSet deletedFiles = Sets.newHashSet();
        Snapshot snapshotBeforeExpiration = this.table.currentSnapshot();
        this.removeSnapshots((Table)this.table).expireOlderThan(System.currentTimeMillis()).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Should not change current snapshot", (Object)snapshotBeforeExpiration, (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Should keep 3 snapshots", (long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        Assert.assertTrue((String)"Should not delete data", (boolean)deletedFiles.isEmpty());
    }

    @Test
    public void testExpireWithDefaultSnapshotAge() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        this.waitUntilAfter(firstSnapshot.timestampMillis());
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        this.waitUntilAfter(secondSnapshot.timestampMillis());
        this.table.newAppend().appendFile(FILE_C).commit();
        Snapshot thirdSnapshot = this.table.currentSnapshot();
        this.waitUntilAfter(thirdSnapshot.timestampMillis());
        Assert.assertEquals((String)"Expected 3 snapshots", (long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        this.table.updateProperties().set("history.expire.max-snapshot-age-ms", "1").commit();
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Should not change current snapshot", (Object)thirdSnapshot, (Object)this.table.currentSnapshot());
        Assert.assertEquals((String)"Should keep 1 snapshot", (long)1L, (long)Iterables.size((Iterable)this.table.snapshots()));
        Assert.assertEquals((String)"Should remove expired manifest lists", (Object)Sets.newHashSet((Object[])new String[]{firstSnapshot.manifestListLocation(), secondSnapshot.manifestListLocation()}), (Object)deletedFiles);
    }

    @Test
    public void testExpireWithDeleteFiles() {
        Assume.assumeTrue((String)"Delete files only supported in V2 spec", (this.formatVersion == 2 ? 1 : 0) != 0);
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot firstSnapshot = this.table.currentSnapshot();
        this.table.newRowDelta().addDeletes(FILE_A_DELETES).commit();
        Snapshot secondSnapshot = this.table.currentSnapshot();
        Assert.assertEquals((String)"Should have 1 data manifest", (long)1L, (long)secondSnapshot.dataManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)secondSnapshot.deleteManifests(this.table.io()).size());
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_A_DELETES), (Set)ImmutableSet.of((Object)FILE_B), (Set)ImmutableSet.of((Object)FILE_B_DELETES)).validateFromSnapshot(secondSnapshot.snapshotId()).commit();
        Snapshot thirdSnapshot = this.table.currentSnapshot();
        Set manifestOfDeletedFiles = thirdSnapshot.allManifests(this.table.io()).stream().filter(ManifestFile::hasDeletedFiles).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should have two manifests of deleted files", (long)2L, (long)manifestOfDeletedFiles.size());
        this.table.newAppend().appendFile(FILE_C).commit();
        Snapshot fourthSnapshot = this.table.currentSnapshot();
        long fourthSnapshotTs = this.waitUntilAfter(fourthSnapshot.timestampMillis());
        HashSet deletedFiles = Sets.newHashSet();
        this.removeSnapshots((Table)this.table).expireOlderThan(fourthSnapshotTs).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((String)"Should remove old delete files and delete file manifests", (Object)ImmutableSet.builder().add((Object)FILE_A.path()).add((Object)FILE_A_DELETES.path()).add((Object)firstSnapshot.manifestListLocation()).add((Object)secondSnapshot.manifestListLocation()).add((Object)thirdSnapshot.manifestListLocation()).addAll(this.manifestPaths(secondSnapshot, this.table.io())).addAll((Iterable)manifestOfDeletedFiles.stream().map(ManifestFile::path).collect(Collectors.toList())).build(), (Object)deletedFiles);
    }

    @Test
    public void testTagExpiration() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long now = System.currentTimeMillis();
        long maxAgeMs = 100L;
        long expirationTime = now + maxAgeMs;
        this.table.manageSnapshots().createTag("tag", this.table.currentSnapshot().snapshotId()).setMaxRefAgeMs("tag", maxAgeMs).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().createBranch("branch", this.table.currentSnapshot().snapshotId()).commit();
        this.waitUntilAfter(expirationTime);
        this.removeSnapshots((Table)this.table).cleanExpiredFiles(false).commit();
        Assert.assertNull((Object)this.table.ops().current().ref("tag"));
        Assert.assertNotNull((Object)this.table.ops().current().ref("branch"));
        Assert.assertNotNull((Object)this.table.ops().current().ref("main"));
    }

    @Test
    public void testBranchExpiration() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long now = System.currentTimeMillis();
        long maxAgeMs = 100L;
        long expirationTime = now + maxAgeMs;
        this.table.manageSnapshots().createBranch("branch", this.table.currentSnapshot().snapshotId()).setMaxRefAgeMs("branch", maxAgeMs).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().createTag("tag", this.table.currentSnapshot().snapshotId()).commit();
        this.waitUntilAfter(expirationTime);
        this.removeSnapshots((Table)this.table).cleanExpiredFiles(false).commit();
        Assert.assertNull((Object)this.table.ops().current().ref("branch"));
        Assert.assertNotNull((Object)this.table.ops().current().ref("tag"));
        Assert.assertNotNull((Object)this.table.ops().current().ref("main"));
    }

    @Test
    public void testMultipleRefsAndCleanExpiredFilesFailsForIncrementalCleanup() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newDelete().deleteFile(FILE_A).commit();
        this.table.manageSnapshots().createTag("TagA", this.table.currentSnapshot().snapshotId()).commit();
        this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        RemoveSnapshots removeSnapshots = (RemoveSnapshots)this.table.expireSnapshots();
        AssertHelpers.assertThrows((String)"Should fail removing snapshots and files when there is more than 1 ref", UnsupportedOperationException.class, (String)"Cannot incrementally clean files for tables with more than 1 ref", () -> removeSnapshots.withIncrementalCleanup(true).expireOlderThan(this.table.currentSnapshot().timestampMillis()).cleanExpiredFiles(true).commit());
    }

    @Test
    public void testExpireWithStatisticsFiles() throws IOException {
        this.table.newAppend().appendFile(FILE_A).commit();
        String statsFileLocation1 = this.statsFileLocation(this.table.location());
        StatisticsFile statisticsFile1 = this.writeStatsFile(this.table.currentSnapshot().snapshotId(), this.table.currentSnapshot().sequenceNumber(), statsFileLocation1, this.table.io());
        this.commitStats((Table)this.table, statisticsFile1);
        this.table.newAppend().appendFile(FILE_B).commit();
        String statsFileLocation2 = this.statsFileLocation(this.table.location());
        StatisticsFile statisticsFile2 = this.writeStatsFile(this.table.currentSnapshot().snapshotId(), this.table.currentSnapshot().sequenceNumber(), statsFileLocation2, this.table.io());
        this.commitStats((Table)this.table, statisticsFile2);
        Assert.assertEquals((String)"Should have 2 statistics file", (long)2L, (long)this.table.statisticsFiles().size());
        long tAfterCommits = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.removeSnapshots((Table)this.table).expireOlderThan(tAfterCommits).commit();
        Assert.assertEquals((String)"Should keep 1 snapshot", (long)1L, (long)Iterables.size((Iterable)this.table.snapshots()));
        ((ListAssert)Assertions.assertThat((List)this.table.statisticsFiles()).hasSize(1)).extracting(StatisticsFile::snapshotId).as("Should contain only the statistics file of snapshot2", new Object[0]).isEqualTo((Object)Lists.newArrayList((Object[])new Long[]{statisticsFile2.snapshotId()}));
        Assertions.assertThat((boolean)new File(statsFileLocation1).exists()).isFalse();
        Assertions.assertThat((boolean)new File(statsFileLocation2).exists()).isTrue();
    }

    @Test
    public void testExpireWithStatisticsFilesWithReuse() throws IOException {
        this.table.newAppend().appendFile(FILE_A).commit();
        String statsFileLocation1 = this.statsFileLocation(this.table.location());
        StatisticsFile statisticsFile1 = this.writeStatsFile(this.table.currentSnapshot().snapshotId(), this.table.currentSnapshot().sequenceNumber(), statsFileLocation1, this.table.io());
        this.commitStats((Table)this.table, statisticsFile1);
        this.table.newAppend().appendFile(FILE_B).commit();
        StatisticsFile statisticsFile2 = this.reuseStatsFile(this.table.currentSnapshot().snapshotId(), statisticsFile1);
        this.commitStats((Table)this.table, statisticsFile2);
        Assert.assertEquals((String)"Should have 2 statistics file", (long)2L, (long)this.table.statisticsFiles().size());
        long tAfterCommits = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.removeSnapshots((Table)this.table).expireOlderThan(tAfterCommits).commit();
        Assert.assertEquals((String)"Should keep 1 snapshot", (long)1L, (long)Iterables.size((Iterable)this.table.snapshots()));
        ((ListAssert)Assertions.assertThat((List)this.table.statisticsFiles()).hasSize(1)).extracting(StatisticsFile::snapshotId).as("Should contain only the statistics file of snapshot2", new Object[0]).isEqualTo((Object)Lists.newArrayList((Object[])new Long[]{statisticsFile2.snapshotId()}));
        Assertions.assertThat((boolean)new File(statsFileLocation1).exists()).isTrue();
    }

    @Test
    public void testFailRemovingSnapshotWhenStillReferencedByBranch() {
        this.table.newAppend().appendFile(FILE_A).commit();
        AppendFiles append = (AppendFiles)this.table.newAppend().appendFile(FILE_B).stageOnly();
        long snapshotId = ((Snapshot)append.apply()).snapshotId();
        append.commit();
        this.table.manageSnapshots().createBranch("branch", snapshotId).commit();
        AssertHelpers.assertThrows((String)"Should fail removing snapshot when it is still referenced", IllegalArgumentException.class, (String)"Cannot expire 2. Still referenced by refs: [branch]", () -> this.removeSnapshots((Table)this.table).expireSnapshotId(snapshotId).commit());
    }

    @Test
    public void testFailRemovingSnapshotWhenStillReferencedByTag() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.manageSnapshots().createTag("tag", snapshotId).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        AssertHelpers.assertThrows((String)"Should fail removing snapshot when it is still referenced", IllegalArgumentException.class, (String)"Cannot expire 1. Still referenced by refs: [tag]", () -> this.removeSnapshots((Table)this.table).expireSnapshotId(snapshotId).commit());
    }

    @Test
    public void testRetainUnreferencedSnapshotsWithinExpirationAge() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long expireTimestampSnapshotA = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.waitUntilAfter(expireTimestampSnapshotA);
        ((AppendFiles)this.table.newAppend().appendFile(FILE_B).stageOnly()).commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        this.removeSnapshots((Table)this.table).expireOlderThan(expireTimestampSnapshotA).commit();
        Assert.assertEquals((long)2L, (long)this.table.ops().current().snapshots().size());
    }

    @Test
    public void testUnreferencedSnapshotParentOfTag() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long initialSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        long expiredSnapshotId = this.table.currentSnapshot().snapshotId();
        long expireTimestampSnapshotB = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.waitUntilAfter(expireTimestampSnapshotB);
        this.table.newAppend().appendFile(FILE_C).commit();
        this.table.manageSnapshots().createTag("tag", this.table.currentSnapshot().snapshotId()).replaceBranch("main", initialSnapshotId).commit();
        this.removeSnapshots((Table)this.table).expireOlderThan(expireTimestampSnapshotB).cleanExpiredFiles(false).commit();
        Assert.assertNull((String)"Should remove unreferenced snapshot beneath a tag", (Object)this.table.snapshot(expiredSnapshotId));
        Assert.assertEquals((long)2L, (long)this.table.ops().current().snapshots().size());
    }

    @Test
    public void testSnapshotParentOfBranchNotUnreferenced() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long initialSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        long expireTimestampSnapshotB = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        this.waitUntilAfter(expireTimestampSnapshotB);
        this.table.newAppend().appendFile(FILE_C).commit();
        this.table.manageSnapshots().createBranch("branch", this.table.currentSnapshot().snapshotId()).setMaxSnapshotAgeMs("branch", Long.MAX_VALUE).replaceBranch("main", initialSnapshotId).commit();
        this.removeSnapshots((Table)this.table).expireOlderThan(expireTimestampSnapshotB).cleanExpiredFiles(false).commit();
        Assert.assertNotNull((String)"Should not remove snapshot beneath a branch", (Object)this.table.snapshot(snapshotId));
        Assert.assertEquals((long)3L, (long)this.table.ops().current().snapshots().size());
    }

    @Test
    public void testMinSnapshotsToKeepMultipleBranches() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long initialSnapshotId = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_B).commit();
        AppendFiles append = (AppendFiles)this.table.newAppend().appendFile(FILE_C).stageOnly();
        long branchSnapshotId = ((Snapshot)append.apply()).snapshotId();
        append.commit();
        Assert.assertEquals((String)"Should have 3 snapshots", (long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        long maxSnapshotAgeMs = 1L;
        long expirationTime = System.currentTimeMillis() + maxSnapshotAgeMs;
        this.table.manageSnapshots().setMinSnapshotsToKeep("main", 1).setMaxSnapshotAgeMs("main", 1L).commit();
        this.table.manageSnapshots().createBranch("branch", branchSnapshotId).setMinSnapshotsToKeep("branch", 3).setMaxSnapshotAgeMs("branch", maxSnapshotAgeMs).commit();
        this.waitUntilAfter(expirationTime);
        this.table.expireSnapshots().cleanExpiredFiles(false).commit();
        Assert.assertEquals((String)"Should have 3 snapshots (none removed)", (long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        this.table.manageSnapshots().setMinSnapshotsToKeep("branch", 1).commit();
        this.removeSnapshots((Table)this.table).cleanExpiredFiles(false).commit();
        Assert.assertEquals((String)"Should have 2 snapshots (initial removed)", (long)2L, (long)Iterables.size((Iterable)this.table.snapshots()));
        Assert.assertNull((Object)this.table.ops().current().snapshot(initialSnapshotId));
    }

    @Test
    public void testMaxSnapshotAgeMultipleBranches() {
        this.table.newAppend().appendFile(FILE_A).commit();
        long initialSnapshotId = this.table.currentSnapshot().snapshotId();
        long ageMs = 10L;
        long expirationTime = System.currentTimeMillis() + ageMs;
        this.waitUntilAfter(expirationTime);
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().setMaxSnapshotAgeMs("main", ageMs).setMinSnapshotsToKeep("main", 1).commit();
        AppendFiles append = (AppendFiles)this.table.newAppend().appendFile(FILE_C).stageOnly();
        long branchSnapshotId = ((Snapshot)append.apply()).snapshotId();
        append.commit();
        Assert.assertEquals((String)"Should have 3 snapshots", (long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        this.table.manageSnapshots().createBranch("branch", branchSnapshotId).setMinSnapshotsToKeep("branch", 1).setMaxSnapshotAgeMs("branch", Long.MAX_VALUE).commit();
        this.removeSnapshots((Table)this.table).cleanExpiredFiles(false).commit();
        Assert.assertEquals((String)"Should have 3 snapshots (none removed)", (long)3L, (long)Iterables.size((Iterable)this.table.snapshots()));
        this.table.manageSnapshots().setMaxSnapshotAgeMs("branch", ageMs).commit();
        this.table.expireSnapshots().cleanExpiredFiles(false).commit();
        Assert.assertEquals((String)"Should have 2 snapshots (initial removed)", (long)2L, (long)Iterables.size((Iterable)this.table.snapshots()));
        Assert.assertNull((Object)this.table.ops().current().snapshot(initialSnapshotId));
    }

    @Test
    public void testRetainFilesOnRetainedBranches() {
        String testBranch = "test-branch";
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot appendA = this.table.currentSnapshot();
        this.table.manageSnapshots().createBranch(testBranch, appendA.snapshotId()).commit();
        this.table.newDelete().deleteFile(FILE_A).commit();
        Snapshot deletionA = this.table.currentSnapshot();
        this.table.newAppend().appendFile(FILE_B).commit();
        long tAfterCommits = this.waitUntilAfter(this.table.currentSnapshot().timestampMillis());
        HashSet deletedFiles = Sets.newHashSet();
        HashSet expectedDeletes = Sets.newHashSet();
        expectedDeletes.add(deletionA.manifestListLocation());
        expectedDeletes.addAll(this.manifestPaths(deletionA, this.table.io()));
        this.table.expireSnapshots().expireOlderThan(tAfterCommits).deleteWith(deletedFiles::add).commit();
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.table.snapshots()));
        Assert.assertEquals((Object)expectedDeletes, (Object)deletedFiles);
        ((DeleteFiles)this.table.newDelete().deleteFile(FILE_A).toBranch(testBranch)).commit();
        Snapshot branchDelete = this.table.snapshot(testBranch);
        ((AppendFiles)this.table.newAppend().appendFile(FILE_C).toBranch(testBranch)).commit();
        Snapshot testBranchHead = this.table.snapshot(testBranch);
        deletedFiles = Sets.newHashSet();
        expectedDeletes = Sets.newHashSet();
        this.waitUntilAfter(testBranchHead.timestampMillis());
        this.table.expireSnapshots().expireOlderThan(testBranchHead.timestampMillis()).deleteWith(deletedFiles::add).commit();
        expectedDeletes.add(appendA.manifestListLocation());
        expectedDeletes.addAll(this.manifestPaths(appendA, this.table.io()));
        expectedDeletes.add(branchDelete.manifestListLocation());
        expectedDeletes.addAll(this.manifestPaths(branchDelete, this.table.io()));
        expectedDeletes.add(FILE_A.path().toString());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.table.snapshots()));
        Assert.assertEquals((Object)expectedDeletes, (Object)deletedFiles);
    }

    private Set<String> manifestPaths(Snapshot snapshot, FileIO io) {
        return snapshot.allManifests(io).stream().map(ManifestFile::path).collect(Collectors.toSet());
    }

    private RemoveSnapshots removeSnapshots(Table table) {
        RemoveSnapshots removeSnapshots = (RemoveSnapshots)table.expireSnapshots();
        return (RemoveSnapshots)removeSnapshots.withIncrementalCleanup(this.incrementalCleanup);
    }

    private StatisticsFile writeStatsFile(long snapshotId, long snapshotSequenceNumber, String statsLocation, FileIO fileIO) throws IOException {
        try (PuffinWriter puffinWriter = Puffin.write((OutputFile)fileIO.newOutputFile(statsLocation)).build();){
            puffinWriter.add(new Blob("some-blob-type", (List)ImmutableList.of((Object)1), snapshotId, snapshotSequenceNumber, ByteBuffer.wrap("blob content".getBytes(StandardCharsets.UTF_8))));
            puffinWriter.finish();
            GenericStatisticsFile genericStatisticsFile = new GenericStatisticsFile(snapshotId, statsLocation, puffinWriter.fileSize(), puffinWriter.footerSize(), (List)puffinWriter.writtenBlobsMetadata().stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList()));
            return genericStatisticsFile;
        }
    }

    private StatisticsFile reuseStatsFile(long snapshotId, StatisticsFile statisticsFile) {
        return new GenericStatisticsFile(snapshotId, statisticsFile.path(), statisticsFile.fileSizeInBytes(), statisticsFile.fileFooterSizeInBytes(), statisticsFile.blobMetadata());
    }

    private void commitStats(Table table, StatisticsFile statisticsFile) {
        table.updateStatistics().setStatistics(statisticsFile.snapshotId(), statisticsFile).commit();
    }

    private String statsFileLocation(String tableLocation) {
        String statsFileName = "stats-file-" + UUID.randomUUID();
        return tableLocation + "/metadata/" + statsFileName;
    }
}

