/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestPartitioning {
    private static final int V1_FORMAT_VERSION = 1;
    private static final int V2_FORMAT_VERSION = 2;
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"category", (Type)Types.StringType.get())});
    private static final PartitionSpec BY_DATA_SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("data").build();
    private static final PartitionSpec BY_CATEGORY_DATA_SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").identity("data").build();
    private static final PartitionSpec BY_DATA_CATEGORY_BUCKET_SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("data").bucket("category", 8).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private File tableDir = null;

    @Before
    public void setupTableDir() throws IOException {
        this.tableDir = this.temp.newFolder();
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    @Test
    public void testPartitionTypeWithSpecEvolutionInV1Tables() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 1);
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)1001, (String)"category_bucket_8", (Type)Types.IntegerType.get())});
        Types.StructType actualType = Partitioning.partitionType((Table)table);
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
        table.updateSpec().removeField("data").removeField("category_bucket_8").commit();
        Assert.assertEquals((String)"Should have 3 specs", (long)3L, (long)table.specs().size());
        Assert.assertTrue((String)"PartitionSpec should be unpartitioned", (boolean)table.spec().isUnpartitioned());
    }

    @Test
    public void testPartitionTypeWithSpecEvolutionInV2Tables() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 2);
        table.updateSpec().removeField("data").addField("category").commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)1001, (String)"category", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.partitionType((Table)table);
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testPartitionTypeWithRenamesInV1Table() {
        PartitionSpec initialSpec = PartitionSpec.builderFor((Schema)SCHEMA).identity("data", "p1").build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, initialSpec, 1);
        table.updateSpec().addField("category").commit();
        table.updateSpec().renameField("p1", "p2").commit();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"p2", (Type)Types.StringType.get()), Types.NestedField.optional((int)1001, (String)"category", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.partitionType((Table)table);
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testPartitionTypeWithAddingBackSamePartitionFieldInV1Table() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 1);
        table.updateSpec().removeField("data").commit();
        table.updateSpec().addField("data").commit();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data_1000", (Type)Types.StringType.get()), Types.NestedField.optional((int)1001, (String)"data", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.partitionType((Table)table);
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testPartitionTypeWithAddingBackSamePartitionFieldInV2Table() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 2);
        table.updateSpec().removeField("data").commit();
        table.updateSpec().addField("data").commit();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.partitionType((Table)table);
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testPartitionTypeWithIncompatibleSpecEvolution() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 1);
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)table.schema()).identity("category").build();
        TableOperations ops = table.operations();
        TableMetadata current = ops.current();
        ops.commit(current, current.updatePartitionSpec(newSpec));
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        AssertHelpers.assertThrows((String)"Should complain about incompatible specs", ValidationException.class, (String)"Conflicting partition fields", () -> Partitioning.partitionType((Table)table));
    }

    @Test
    public void testGroupingKeyTypeWithSpecEvolutionInV1Tables() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 1);
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithSpecEvolutionInV2Tables() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 2);
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithDroppedPartitionFieldInV1Tables() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_CATEGORY_BUCKET_SPEC, 1);
        table.updateSpec().removeField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithDroppedPartitionFieldInV2Tables() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_CATEGORY_BUCKET_SPEC, 2);
        table.updateSpec().removeField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithRenamesInV1Table() {
        PartitionSpec initialSpec = PartitionSpec.builderFor((Schema)SCHEMA).identity("data", "p1").build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, initialSpec, 1);
        table.updateSpec().addField("category").commit();
        table.updateSpec().renameField("p1", "p2").commit();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"p2", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithRenamesInV2Table() {
        PartitionSpec initialSpec = PartitionSpec.builderFor((Schema)SCHEMA).identity("data", "p1").build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, initialSpec, 2);
        table.updateSpec().addField("category").commit();
        table.updateSpec().renameField("p1", "p2").commit();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"p2", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithEvolvedIntoUnpartitionedSpecV1Table() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 1);
        table.updateSpec().removeField("data").commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithEvolvedIntoUnpartitionedSpecV2Table() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 2);
        table.updateSpec().removeField("data").commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithAddingBackSamePartitionFieldInV1Table() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_CATEGORY_DATA_SPEC, 1);
        table.updateSpec().removeField("data").commit();
        table.updateSpec().addField("data").commit();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"category", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithAddingBackSamePartitionFieldInV2Table() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_CATEGORY_DATA_SPEC, 2);
        table.updateSpec().removeField("data").commit();
        table.updateSpec().addField("data").commit();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"category", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithOnlyUnpartitionedSpec() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, PartitionSpec.unpartitioned(), 1);
        Assert.assertEquals((String)"Should have 1 spec", (long)1L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithEvolvedUnpartitionedSpec() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, PartitionSpec.unpartitioned(), 1);
        table.updateSpec().addField((Term)Expressions.bucket((String)"category", (int)8)).commit();
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithProjectedSchema() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_CATEGORY_DATA_SPEC, 1);
        Schema projectedSchema = table.schema().select(new String[]{"id", "data"});
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1001, (String)"data", (Type)Types.StringType.get())});
        Types.StructType actualType = Partitioning.groupingKeyType((Schema)projectedSchema, table.specs().values());
        Assert.assertEquals((String)"Types must match", (Object)expectedType, (Object)actualType);
    }

    @Test
    public void testGroupingKeyTypeWithIncompatibleSpecEvolution() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 1);
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)table.schema()).identity("category").build();
        TableOperations ops = table.operations();
        TableMetadata current = ops.current();
        ops.commit(current, current.updatePartitionSpec(newSpec));
        Assert.assertEquals((String)"Should have 2 specs", (long)2L, (long)table.specs().size());
        AssertHelpers.assertThrows((String)"Should complain about incompatible specs", ValidationException.class, (String)"Conflicting partition fields", () -> Partitioning.groupingKeyType((Schema)table.schema(), table.specs().values()));
    }

    @Test
    public void testDeletingPartitionField() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", SCHEMA, BY_DATA_SPEC, 1);
        table.updateSpec().removeField("data").commit();
        table.updateSchema().deleteColumn("data").commit();
        table.updateSpec().addField("id").commit();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).withSpecId(2).alwaysNull("data", "data").identity("id").build();
        Assert.assertEquals((String)"The spec should be there", (Object)spec, (Object)table.spec());
    }
}

