/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PartitionSpecTestBase;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableTestBase;
import org.junit.Assert;
import org.junit.Test;

public class TestPartitionSpecParser
extends TableTestBase {
    public TestPartitionSpecParser() {
        super(1);
    }

    @Test
    public void testToJsonForV1Table() {
        String expected = "{\n  \"spec-id\" : 0,\n  \"fields\" : [ {\n    \"name\" : \"data_bucket\",\n    \"transform\" : \"bucket[16]\",\n    \"source-id\" : 2,\n    \"field-id\" : 1000\n  } ]\n}";
        Assert.assertEquals((Object)expected, (Object)PartitionSpecParser.toJson((PartitionSpec)this.table.spec(), (boolean)true));
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.table.schema()).bucket("id", 8).bucket("data", 16).build();
        this.table.ops().commit(this.table.ops().current(), this.table.ops().current().updatePartitionSpec(spec));
        expected = "{\n  \"spec-id\" : 1,\n  \"fields\" : [ {\n    \"name\" : \"id_bucket\",\n    \"transform\" : \"bucket[8]\",\n    \"source-id\" : 1,\n    \"field-id\" : 1000\n  }, {\n    \"name\" : \"data_bucket\",\n    \"transform\" : \"bucket[16]\",\n    \"source-id\" : 2,\n    \"field-id\" : 1001\n  } ]\n}";
        Assert.assertEquals((Object)expected, (Object)PartitionSpecParser.toJson((PartitionSpec)this.table.spec(), (boolean)true));
    }

    @Test
    public void testFromJsonWithFieldId() {
        String specString = "{\n  \"spec-id\" : 1,\n  \"fields\" : [ {\n    \"name\" : \"id_bucket\",\n    \"transform\" : \"bucket[8]\",\n    \"source-id\" : 1,\n    \"field-id\" : 1001\n  }, {\n    \"name\" : \"data_bucket\",\n    \"transform\" : \"bucket[16]\",\n    \"source-id\" : 2,\n    \"field-id\" : 1000\n  } ]\n}";
        PartitionSpec spec = PartitionSpecParser.fromJson((Schema)this.table.schema(), (String)specString);
        Assert.assertEquals((long)2L, (long)spec.fields().size());
        Assert.assertEquals((long)1001L, (long)((PartitionField)spec.fields().get(0)).fieldId());
        Assert.assertEquals((long)1000L, (long)((PartitionField)spec.fields().get(1)).fieldId());
    }

    @Test
    public void testFromJsonWithoutFieldId() {
        String specString = "{\n  \"spec-id\" : 1,\n  \"fields\" : [ {\n    \"name\" : \"id_bucket\",\n    \"transform\" : \"bucket[8]\",\n    \"source-id\" : 1\n  }, {\n    \"name\" : \"data_bucket\",\n    \"transform\" : \"bucket[16]\",\n    \"source-id\" : 2\n  } ]\n}";
        PartitionSpec spec = PartitionSpecParser.fromJson((Schema)this.table.schema(), (String)specString);
        Assert.assertEquals((long)2L, (long)spec.fields().size());
        Assert.assertEquals((long)1000L, (long)((PartitionField)spec.fields().get(0)).fieldId());
        Assert.assertEquals((long)1001L, (long)((PartitionField)spec.fields().get(1)).fieldId());
    }

    @Test
    public void testTransforms() {
        for (PartitionSpec spec : PartitionSpecTestBase.SPECS) {
            Assert.assertEquals((String)"To/from JSON should produce equal partition spec", (Object)spec, (Object)TestPartitionSpecParser.roundTripJSON(spec));
        }
    }

    private static PartitionSpec roundTripJSON(PartitionSpec spec) {
        return PartitionSpecParser.fromJson((Schema)PartitionSpecTestBase.SCHEMA, (String)PartitionSpecParser.toJson((PartitionSpec)spec));
    }
}

