/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestPartitionSpecInfo {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    private File tableDir = null;
    private final int formatVersion;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestPartitionSpecInfo(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    @Before
    public void setupTableDir() throws IOException {
        this.tableDir = this.temp.newFolder();
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    @Test
    public void testSpecIsUnpartitionedForVoidTranforms() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.schema).alwaysNull("id").alwaysNull("data").build();
        Assert.assertTrue((boolean)spec.isUnpartitioned());
    }

    @Test
    public void testSpecInfoUnpartitionedTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        Assert.assertTrue((boolean)spec.isUnpartitioned());
        Assert.assertEquals((Object)spec, (Object)table.spec());
        Assert.assertEquals((long)spec.lastAssignedFieldId(), (long)table.spec().lastAssignedFieldId());
        Assert.assertEquals((Object)ImmutableMap.of((Object)spec.specId(), (Object)spec), (Object)table.specs());
        Assert.assertNull(table.specs().get(Integer.MAX_VALUE));
    }

    @Test
    public void testSpecInfoPartitionedTable() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.schema).identity("data").build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        Assert.assertEquals((Object)spec, (Object)table.spec());
        Assert.assertEquals((long)spec.lastAssignedFieldId(), (long)table.spec().lastAssignedFieldId());
        Assert.assertEquals((Object)ImmutableMap.of((Object)spec.specId(), (Object)spec), (Object)table.specs());
        Assert.assertNull(table.specs().get(Integer.MAX_VALUE));
    }

    @Test
    public void testColumnDropWithPartitionSpecEvolution() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.schema).identity("id").build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        Assert.assertEquals((Object)spec, (Object)table.spec());
        TableMetadata base = TestTables.readMetadata("test");
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)table.schema()).identity("data").withSpecId(1).build();
        table.ops().commit(base, base.updatePartitionSpec(newSpec));
        int initialColSize = table.schema().columns().size();
        table.updateSchema().deleteColumn("id").commit();
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        Assert.assertEquals((Object)newSpec, (Object)table.spec());
        Assert.assertEquals((Object)newSpec, table.specs().get(newSpec.specId()));
        Assert.assertEquals((Object)spec, table.specs().get(spec.specId()));
        Assert.assertEquals((Object)ImmutableMap.of((Object)spec.specId(), (Object)spec, (Object)newSpec.specId(), (Object)newSpec), (Object)table.specs());
        Assert.assertNull(table.specs().get(Integer.MAX_VALUE));
        Assert.assertTrue((String)"Schema must have only \"data\" column", (boolean)table.schema().sameSchema(expectedSchema));
    }

    @Test
    public void testSpecInfoPartitionSpecEvolutionForV1Table() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.schema).bucket("data", 4).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        Assert.assertEquals((Object)spec, (Object)table.spec());
        TableMetadata base = TestTables.readMetadata("test");
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)table.schema()).bucket("data", 10).withSpecId(1).build();
        table.ops().commit(base, base.updatePartitionSpec(newSpec));
        Assert.assertEquals((Object)newSpec, (Object)table.spec());
        Assert.assertEquals((Object)newSpec, table.specs().get(newSpec.specId()));
        Assert.assertEquals((Object)spec, table.specs().get(spec.specId()));
        Assert.assertEquals((Object)ImmutableMap.of((Object)spec.specId(), (Object)spec, (Object)newSpec.specId(), (Object)newSpec), (Object)table.specs());
        Assert.assertNull(table.specs().get(Integer.MAX_VALUE));
    }
}

