/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestOverwriteWithValidation
extends TableTestBase {
    private static final String TABLE_NAME = "overwrite_table";
    private static final Schema DATE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get())});
    private static final PartitionSpec PARTITION_SPEC = PartitionSpec.builderFor((Schema)DATE_SCHEMA).identity("date").build();
    private static final DataFile FILE_DAY_1 = DataFiles.builder((PartitionSpec)PARTITION_SPEC).withPath("/path/to/data-1.parquet").withFileSizeInBytes(0L).withPartitionPath("date=2018-06-08").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(4L)))).build();
    private static final DeleteFile FILE_DAY_1_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)PARTITION_SPEC).ofPositionDeletes().withPath("/path/to/data-1-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("date=2018-06-08").withRecordCount(1L).build();
    private static final DataFile FILE_DAY_2 = DataFiles.builder((PartitionSpec)PARTITION_SPEC).withPath("/path/to/data-2.parquet").withFileSizeInBytes(0L).withPartitionPath("date=2018-06-09").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(5L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(9L)))).build();
    private static final DeleteFile FILE_DAY_2_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)PARTITION_SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-2-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("date=2018-06-09").withRecordCount(1L).build();
    private static final DeleteFile FILE_DAY_2_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)PARTITION_SPEC).ofPositionDeletes().withPath("/path/to/data-2-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("date=2018-06-09").withRecordCount(1L).build();
    private static final DataFile FILE_DAY_2_MODIFIED = DataFiles.builder((PartitionSpec)PARTITION_SPEC).withPath("/path/to/data-3.parquet").withFileSizeInBytes(0L).withPartitionPath("date=2018-06-09").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(5L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(9L)))).build();
    private static final DataFile FILE_DAY_2_ANOTHER_RANGE = DataFiles.builder((PartitionSpec)PARTITION_SPEC).withPath("/path/to/data-3.parquet").withFileSizeInBytes(0L).withPartitionPath("date=2018-06-09").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(10L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(14L)))).build();
    private static final DeleteFile FILE_DAY_2_ANOTHER_RANGE_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)PARTITION_SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-3-eq-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("date=2018-06-09").withRecordCount(1L).withMetrics(new Metrics(Long.valueOf(1L), null, (Map)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(10L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwriteWithValidation.longToBuffer(10L)))).build();
    private static final Expression EXPRESSION_DAY_2 = Expressions.equal((String)"date", (Object)"2018-06-09");
    private static final Expression EXPRESSION_DAY_2_ID_RANGE = Expressions.and((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)5L), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)9L));
    private static final Expression EXPRESSION_DAY_2_ANOTHER_ID_RANGE = Expressions.greaterThanOrEqual((String)"id", (Object)10L);
    private final String branch;
    private Table table = null;

    @Parameterized.Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[] parameters() {
        return new Object[][]{{1, "main"}, {1, "testBranch"}, {2, "main"}, {2, "testBranch"}};
    }

    public TestOverwriteWithValidation(int formatVersion, String branch) {
        super(formatVersion);
        this.branch = branch;
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }

    @Before
    public void before() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        this.table = TestTables.create(tableDir, TABLE_NAME, DATE_SCHEMA, PARTITION_SPEC, this.formatVersion);
    }

    @Test
    public void testOverwriteEmptyTableNotValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED), this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteEmptyTableStrictValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter((Expression)Expressions.alwaysTrue()).validateNoConflictingData(), this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteEmptyTableValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData(), this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteTableNotValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1, FILE_DAY_2);
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED), this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteTableStrictValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1, FILE_DAY_2);
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter((Expression)Expressions.alwaysTrue()).validateNoConflictingData(), this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteTableValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1, FILE_DAY_2);
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData(), this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteCompatibleAdditionNotValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        this.validateSnapshot(null, SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch), FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED);
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteCompatibleAdditionStrictValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter((Expression)Expressions.alwaysTrue()).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        long committedSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Found conflicting files", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)committedSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testOverwriteCompatibleAdditionValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteCompatibleDeletionValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1, FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_DAY_1), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteIncompatibleAdditionValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1);
        OverwriteFiles overwrite = this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        long committedSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Found conflicting files", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)committedSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testOverwriteIncompatibleDeletionValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1, FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_DAY_2), this.branch);
        long committedSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Missing required files to delete:", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)committedSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testOverwriteCompatibleRewriteAllowed() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1, FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_DAY_2), (Set)ImmutableSet.of((Object)FILE_DAY_2)), this.branch);
        long committedSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        Assert.assertNotEquals((String)"Should successfully commit", (long)committedSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testOverwriteCompatibleExpirationAdditionValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        this.table.expireSnapshots().expireSnapshotId(1L).commit();
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteCompatibleExpirationDeletionValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.validateSnapshot(null, baseSnapshot, FILE_DAY_1, FILE_DAY_2);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_DAY_1), this.branch);
        this.table.expireSnapshots().expireSnapshotId(1L).commit();
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteIncompatibleExpirationValidated() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        this.commit(this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_DAY_1), this.branch);
        this.table.expireSnapshots().expireSnapshotId(2L).commit();
        long committedSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Cannot determine history", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)committedSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testOverwriteIncompatibleBaseExpirationEmptyTableValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        OverwriteFiles overwrite = this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        this.commit(this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_DAY_1), this.branch);
        this.table.expireSnapshots().expireSnapshotId(1L).commit();
        long committedSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Cannot determine history", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)committedSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testOverwriteAnotherRangeValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        OverwriteFiles overwrite = this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(EXPRESSION_DAY_2_ID_RANGE).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testOverwriteAnotherRangeWithinPartitionValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        Expression conflictDetectionFilter = Expressions.and((Expression)EXPRESSION_DAY_2, (Expression)EXPRESSION_DAY_2_ID_RANGE);
        OverwriteFiles overwrite = this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(conflictDetectionFilter).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2_ANOTHER_RANGE), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_ANOTHER_RANGE, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testTransactionCompatibleAdditionValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        Snapshot baseSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        Transaction txn = this.table.newTransaction();
        OverwriteFiles overwrite = txn.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(baseSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        txn.commitTransaction();
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testTransactionIncompatibleAdditionValidated() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        Transaction txn = this.table.newTransaction();
        this.commit(this.table, (SnapshotUpdate)txn.newAppend().appendFile(FILE_DAY_1), this.branch);
        OverwriteFiles overwrite = txn.newOverwrite().addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData();
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2), this.branch);
        long committedSnapshotId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Found conflicting files", () -> ((Transaction)txn).commitTransaction());
        Assert.assertEquals((String)"Should not create a new snapshot", (long)committedSnapshotId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testConcurrentConflictingPositionDeletes() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_2_POS_DELETES), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"found new delete", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
    }

    @Test
    public void testConcurrentConflictingPositionDeletesOverwriteByFilter() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(EXPRESSION_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_2_POS_DELETES), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Found new conflicting delete", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
    }

    @Test
    public void testConcurrentConflictingDataFileDeleteOverwriteByFilter() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(EXPRESSION_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_DAY_2), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"Found conflicting deleted files", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
    }

    @Test
    public void testConcurrentNonConflictingDataFileDeleteOverwriteByFilter() {
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(EXPRESSION_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().deleteFile(FILE_DAY_1), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_MODIFIED);
    }

    @Test
    public void testConcurrentNonConflictingPositionDeletes() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_1_POS_DELETES), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
        this.validateBranchDeleteFiles(this.table, this.branch, FILE_DAY_1_POS_DELETES);
    }

    @Test
    public void testConcurrentNonConflictingPositionDeletesOverwriteByFilter() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(EXPRESSION_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_1_POS_DELETES), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
        this.validateBranchDeleteFiles(this.table, this.branch, FILE_DAY_1_POS_DELETES);
    }

    @Test
    public void testConcurrentConflictingEqualityDeletes() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_2_EQ_DELETES), this.branch);
        AssertHelpers.assertThrows((String)"Should reject commit", ValidationException.class, (String)"found new delete", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
    }

    @Test
    public void testConcurrentNonConflictingEqualityDeletes() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2).appendFile(FILE_DAY_2_ANOTHER_RANGE), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().deleteFile(FILE_DAY_2).addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).conflictDetectionFilter(EXPRESSION_DAY_2_ID_RANGE).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_2_ANOTHER_RANGE_EQ_DELETES), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2_ANOTHER_RANGE, FILE_DAY_2_MODIFIED);
        this.validateBranchDeleteFiles(this.table, this.branch, FILE_DAY_2_ANOTHER_RANGE_EQ_DELETES);
    }

    @Test
    public void testOverwriteByFilterInheritsConflictDetectionFilter() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        Snapshot firstSnapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(EXPRESSION_DAY_2).validateAddedFilesMatchOverwriteFilter().addFile(FILE_DAY_2_MODIFIED).validateFromSnapshot(firstSnapshot.snapshotId()).validateNoConflictingData().validateNoConflictingDeletes();
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_1_POS_DELETES), this.branch);
        this.commit(this.table, (SnapshotUpdate)overwrite, this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_1, FILE_DAY_2_MODIFIED);
        this.validateBranchDeleteFiles(this.table, this.branch, FILE_DAY_1_POS_DELETES);
    }

    @Test
    public void testOverwriteCaseSensitivity() {
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1).appendFile(FILE_DAY_2), this.branch);
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_1), this.branch);
        UnboundPredicate rowFilter = Expressions.equal((String)"dAtE", (Object)"2018-06-09");
        AssertHelpers.assertThrows((String)"Should use case sensitive binding by default", ValidationException.class, (String)"Cannot find field 'dAtE'", () -> this.lambda$testOverwriteCaseSensitivity$9((Expression)rowFilter));
        AssertHelpers.assertThrows((String)"Should fail with case sensitive binding", ValidationException.class, (String)"Cannot find field 'dAtE'", () -> this.lambda$testOverwriteCaseSensitivity$10((Expression)rowFilter));
        AssertHelpers.assertThrows((String)"Should trigger the validation", ValidationException.class, (String)"Found conflicting files", () -> this.lambda$testOverwriteCaseSensitivity$11((Expression)rowFilter));
    }

    @Test
    public void testMetadataOnlyDeleteWithPositionDeletes() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Assert.assertNull((String)"Should be empty table", (Object)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_DAY_2).appendFile(FILE_DAY_2_ANOTHER_RANGE), this.branch);
        this.commit(this.table, (SnapshotUpdate)this.table.newRowDelta().addDeletes(FILE_DAY_2_POS_DELETES).addDeletes(FILE_DAY_2_ANOTHER_RANGE_EQ_DELETES), this.branch);
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().overwriteByRowFilter(EXPRESSION_DAY_2_ANOTHER_ID_RANGE).addFile(FILE_DAY_2_MODIFIED), this.branch);
        this.validateBranchFiles(this.table, this.branch, FILE_DAY_2, FILE_DAY_2_MODIFIED);
        this.validateBranchDeleteFiles(this.table, this.branch, FILE_DAY_2_POS_DELETES);
    }

    private /* synthetic */ Object lambda$testOverwriteCaseSensitivity$11(Expression rowFilter) throws Exception {
        return this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().caseSensitive(false).addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(rowFilter).validateNoConflictingData(), this.branch);
    }

    private /* synthetic */ Object lambda$testOverwriteCaseSensitivity$10(Expression rowFilter) throws Exception {
        return this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().caseSensitive(true).addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(rowFilter).validateNoConflictingData(), this.branch);
    }

    private /* synthetic */ Object lambda$testOverwriteCaseSensitivity$9(Expression rowFilter) throws Exception {
        return this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().addFile(FILE_DAY_2_MODIFIED).conflictDetectionFilter(rowFilter).validateNoConflictingData(), this.branch);
    }
}

