/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestOverwrite
extends TableTestBase {
    private static final Schema DATE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get())});
    private static final PartitionSpec PARTITION_BY_DATE = PartitionSpec.builderFor((Schema)DATE_SCHEMA).identity("date").build();
    private static final String TABLE_NAME = "overwrite_table";
    private static final DataFile FILE_0_TO_4 = DataFiles.builder((PartitionSpec)PARTITION_BY_DATE).withPath("/path/to/data-1.parquet").withFileSizeInBytes(0L).withPartitionPath("date=2018-06-08").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwrite.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwrite.longToBuffer(4L)))).build();
    private static final DataFile FILE_5_TO_9 = DataFiles.builder((PartitionSpec)PARTITION_BY_DATE).withPath("/path/to/data-2.parquet").withFileSizeInBytes(0L).withPartitionPath("date=2018-06-09").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwrite.longToBuffer(5L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwrite.longToBuffer(9L)))).build();
    private static final DataFile FILE_10_TO_14 = DataFiles.builder((PartitionSpec)PARTITION_BY_DATE).withPath("/path/to/data-2.parquet").withFileSizeInBytes(0L).withPartitionPath("date=2018-06-09").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), null, (Map)ImmutableMap.of((Object)1, (Object)TestOverwrite.longToBuffer(5L)), (Map)ImmutableMap.of((Object)1, (Object)TestOverwrite.longToBuffer(9L)))).build();
    private final String branch;
    private Table table = null;

    @Parameterized.Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[] parameters() {
        return new Object[][]{{1, "main"}, {1, "testBranch"}, {2, "main"}, {2, "testBranch"}};
    }

    public TestOverwrite(int formatVersion, String branch) {
        super(formatVersion);
        this.branch = branch;
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }

    @Before
    public void createTestTable() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        this.table = TestTables.create(tableDir, TABLE_NAME, DATE_SCHEMA, PARTITION_BY_DATE, this.formatVersion);
        this.commit(this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_0_TO_4).appendFile(FILE_5_TO_9), this.branch);
    }

    @Test
    public void testOverwriteWithoutAppend() {
        TableMetadata base = TestTables.readMetadata(TABLE_NAME);
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().overwriteByRowFilter((Expression)Expressions.equal((String)"date", (Object)"2018-06-08")), this.branch);
        long overwriteId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertNotEquals((String)"Should create a new snapshot", (long)baseId, (long)overwriteId);
        Assert.assertEquals((String)"Table should have one manifest", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestOverwrite.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestOverwrite.ids(overwriteId, baseId), TestOverwrite.files(FILE_0_TO_4, FILE_5_TO_9), TestOverwrite.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testOverwriteFailsDelete() {
        TableMetadata base = TestTables.readMetadata(TABLE_NAME);
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch) == null ? -1L : SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(Expressions.and((Expression)Expressions.equal((String)"date", (Object)"2018-06-09"), (Expression)Expressions.lessThan((String)"id", (Object)9)));
        AssertHelpers.assertThrows((String)"Should reject commit with file not matching delete expression", ValidationException.class, (String)"Cannot delete file where some, but not all, rows match filter", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)baseId, (long)SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId());
    }

    @Test
    public void testOverwriteWithAppendOutsideOfDelete() {
        TableMetadata base = TestTables.readMetadata(TABLE_NAME);
        Snapshot latestSnapshot = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch);
        long baseId = latestSnapshot == null ? -1L : latestSnapshot.snapshotId();
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().overwriteByRowFilter((Expression)Expressions.equal((String)"date", (Object)"2018-06-08")).addFile(FILE_10_TO_14), this.branch);
        long overwriteId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertNotEquals((String)"Should create a new snapshot", (long)baseId, (long)overwriteId);
        Assert.assertEquals((String)"Table should have 2 manifests", (long)2L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestOverwrite.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestOverwrite.ids(overwriteId), TestOverwrite.files(FILE_10_TO_14), TestOverwrite.statuses(ManifestEntry.Status.ADDED));
        TestOverwrite.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(1), TestOverwrite.ids(overwriteId, baseId), TestOverwrite.files(FILE_0_TO_4, FILE_5_TO_9), TestOverwrite.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testOverwriteWithMergedAppendOutsideOfDelete() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        TableMetadata base = TestTables.readMetadata(TABLE_NAME);
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch) == null ? -1L : SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        this.commit(this.table, (SnapshotUpdate)this.table.newOverwrite().overwriteByRowFilter((Expression)Expressions.equal((String)"date", (Object)"2018-06-08")).addFile(FILE_10_TO_14), this.branch);
        long overwriteId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertNotEquals((String)"Should create a new snapshot", (long)baseId, (long)overwriteId);
        Assert.assertEquals((String)"Table should have one merged manifest", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        TestOverwrite.validateManifestEntries((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestOverwrite.ids(overwriteId, overwriteId, baseId), TestOverwrite.files(FILE_10_TO_14, FILE_0_TO_4, FILE_5_TO_9), TestOverwrite.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testValidatedOverwriteWithAppendOutsideOfDelete() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        TableMetadata base = TestTables.readMetadata(TABLE_NAME);
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch) == null ? -1L : SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter((Expression)Expressions.equal((String)"date", (Object)"2018-06-08")).addFile(FILE_10_TO_14).validateAddedFilesMatchOverwriteFilter();
        AssertHelpers.assertThrows((String)"Should reject commit with file not matching delete expression", ValidationException.class, (String)"Cannot append file with rows that do not match filter", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)baseId, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId());
    }

    @Test
    public void testValidatedOverwriteWithAppendOutsideOfDeleteMetrics() {
        TableMetadata base = TestTables.readMetadata(TABLE_NAME);
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch) == null ? -1L : SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(Expressions.and((Expression)Expressions.equal((String)"date", (Object)"2018-06-09"), (Expression)Expressions.lessThan((String)"id", (Object)10))).addFile(FILE_10_TO_14).validateAddedFilesMatchOverwriteFilter();
        AssertHelpers.assertThrows((String)"Should reject commit with file not matching delete expression", ValidationException.class, (String)"Cannot append file with rows that do not match filter", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)baseId, (long)SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId());
    }

    @Test
    public void testValidatedOverwriteWithAppendSuccess() {
        TableMetadata base = TestTables.readMetadata(TABLE_NAME);
        long baseId = SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch) == null ? -1L : SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId();
        OverwriteFiles overwrite = this.table.newOverwrite().overwriteByRowFilter(Expressions.and((Expression)Expressions.equal((String)"date", (Object)"2018-06-09"), (Expression)Expressions.lessThan((String)"id", (Object)20))).addFile(FILE_10_TO_14).validateAddedFilesMatchOverwriteFilter();
        AssertHelpers.assertThrows((String)"Should reject commit with file not matching delete expression", ValidationException.class, (String)"Cannot append file with rows that do not match filter", () -> this.commit(this.table, (SnapshotUpdate)overwrite, this.branch));
        Assert.assertEquals((String)"Should not create a new snapshot", (long)baseId, (long)SnapshotUtil.latestSnapshot((TableMetadata)base, (String)this.branch).snapshotId());
    }
}

