/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MockFileScanTask;
import org.apache.iceberg.OffsetsAwareSplitScanTaskIterator;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class TestOffsetsBasedSplitScanTaskIterator {
    @Test
    public void testSplits() {
        TestOffsetsBasedSplitScanTaskIterator.verify(TestOffsetsBasedSplitScanTaskIterator.asList(4L, 10L, 15L, 18L, 30L, 45L), 48L, TestOffsetsBasedSplitScanTaskIterator.asList(TestOffsetsBasedSplitScanTaskIterator.asList(4L, 6L), TestOffsetsBasedSplitScanTaskIterator.asList(10L, 5L), TestOffsetsBasedSplitScanTaskIterator.asList(15L, 3L), TestOffsetsBasedSplitScanTaskIterator.asList(18L, 12L), TestOffsetsBasedSplitScanTaskIterator.asList(30L, 15L), TestOffsetsBasedSplitScanTaskIterator.asList(45L, 3L)));
        TestOffsetsBasedSplitScanTaskIterator.verify(TestOffsetsBasedSplitScanTaskIterator.asList(4L, 10L, 15L, 18L, 30L, 47L), 48L, TestOffsetsBasedSplitScanTaskIterator.asList(TestOffsetsBasedSplitScanTaskIterator.asList(4L, 6L), TestOffsetsBasedSplitScanTaskIterator.asList(10L, 5L), TestOffsetsBasedSplitScanTaskIterator.asList(15L, 3L), TestOffsetsBasedSplitScanTaskIterator.asList(18L, 12L), TestOffsetsBasedSplitScanTaskIterator.asList(30L, 17L), TestOffsetsBasedSplitScanTaskIterator.asList(47L, 1L)));
    }

    private static void verify(List<Long> offsetRanges, long fileLen, List<List<Long>> offsetLenPairs) {
        MockFileScanTask mockFileScanTask = new MockFileScanTask(fileLen);
        OffsetsAwareSplitScanTaskIterator splitTaskIterator = new OffsetsAwareSplitScanTaskIterator((ScanTask)mockFileScanTask, mockFileScanTask.length(), offsetRanges, TestOffsetsBasedSplitScanTaskIterator::createSplitTask);
        ArrayList tasks = Lists.newArrayList((Iterator)splitTaskIterator);
        Assert.assertEquals((String)"Number of tasks don't match", (long)offsetLenPairs.size(), (long)tasks.size());
        for (int i = 0; i < tasks.size(); ++i) {
            FileScanTask task = (FileScanTask)tasks.get(i);
            List<Long> split = offsetLenPairs.get(i);
            long offset = split.get(0);
            long length = split.get(1);
            Assert.assertEquals((long)offset, (long)task.start());
            Assert.assertEquals((long)length, (long)task.length());
        }
    }

    private static <T> List<T> asList(T ... items) {
        return Lists.newArrayList((Object[])items);
    }

    private static FileScanTask createSplitTask(FileScanTask parentTask, long offset, long length) {
        return new BaseFileScanTask.SplitScanTask(offset, length, parentTask);
    }
}

