/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collections;
import java.util.List;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MicroBatches;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMicroBatchBuilder
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestMicroBatchBuilder(int formatVersion) {
        super(formatVersion);
    }

    @Before
    public void setupTableProperties() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "3").commit();
    }

    @Test
    public void testGenerateMicroBatch() {
        TestMicroBatchBuilder.add(this.table.newAppend(), TestMicroBatchBuilder.files("A", "B", "C", "D", "E"));
        MicroBatches.MicroBatch batch = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(0L, 6L, Long.MAX_VALUE, true);
        Assert.assertEquals((long)batch.snapshotId(), (long)1L);
        Assert.assertEquals((long)batch.startFileIndex(), (long)0L);
        Assert.assertEquals((long)batch.endFileIndex(), (long)5L);
        Assert.assertEquals((long)batch.sizeInBytes(), (long)50L);
        Assert.assertTrue((boolean)batch.lastIndexOfSnapshot());
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E"}), TestMicroBatchBuilder.filesToScan(batch.tasks()));
        MicroBatches.MicroBatch batch1 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(0L, 1L, 15L, true);
        Assert.assertEquals((long)batch1.endFileIndex(), (long)1L);
        Assert.assertEquals((long)batch1.sizeInBytes(), (long)10L);
        Assert.assertFalse((boolean)batch1.lastIndexOfSnapshot());
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"A"}), TestMicroBatchBuilder.filesToScan(batch1.tasks()));
        MicroBatches.MicroBatch batch2 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(batch1.endFileIndex(), 4L, 30L, true);
        Assert.assertEquals((long)batch2.endFileIndex(), (long)4L);
        Assert.assertEquals((long)batch2.sizeInBytes(), (long)30L);
        Assert.assertFalse((boolean)batch2.lastIndexOfSnapshot());
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D"}), TestMicroBatchBuilder.filesToScan(batch2.tasks()));
        MicroBatches.MicroBatch batch3 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(batch2.endFileIndex(), 5L, 50L, true);
        Assert.assertEquals((long)batch3.endFileIndex(), (long)5L);
        Assert.assertEquals((long)batch3.sizeInBytes(), (long)10L);
        Assert.assertTrue((boolean)batch3.lastIndexOfSnapshot());
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"E"}), TestMicroBatchBuilder.filesToScan(batch3.tasks()));
    }

    @Test
    public void testGenerateMicroBatchWithSmallTargetSize() {
        TestMicroBatchBuilder.add(this.table.newAppend(), TestMicroBatchBuilder.files("A", "B", "C", "D", "E"));
        MicroBatches.MicroBatch batch = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(0L, 1L, 10L, true);
        Assert.assertEquals((long)batch.snapshotId(), (long)1L);
        Assert.assertEquals((long)batch.startFileIndex(), (long)0L);
        Assert.assertEquals((long)batch.endFileIndex(), (long)1L);
        Assert.assertEquals((long)batch.sizeInBytes(), (long)10L);
        Assert.assertFalse((boolean)batch.lastIndexOfSnapshot());
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"A"}), TestMicroBatchBuilder.filesToScan(batch.tasks()));
        MicroBatches.MicroBatch batch1 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(batch.endFileIndex(), 2L, 5L, true);
        Assert.assertEquals((long)batch1.endFileIndex(), (long)2L);
        Assert.assertEquals((long)batch1.sizeInBytes(), (long)10L);
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"B"}), TestMicroBatchBuilder.filesToScan(batch1.tasks()));
        Assert.assertFalse((boolean)batch1.lastIndexOfSnapshot());
        MicroBatches.MicroBatch batch2 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(batch1.endFileIndex(), 3L, 10L, true);
        Assert.assertEquals((long)batch2.endFileIndex(), (long)3L);
        Assert.assertEquals((long)batch2.sizeInBytes(), (long)10L);
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"C"}), TestMicroBatchBuilder.filesToScan(batch2.tasks()));
        Assert.assertFalse((boolean)batch2.lastIndexOfSnapshot());
        MicroBatches.MicroBatch batch3 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(batch2.endFileIndex(), 4L, 10L, true);
        Assert.assertEquals((long)batch3.endFileIndex(), (long)4L);
        Assert.assertEquals((long)batch3.sizeInBytes(), (long)10L);
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"D"}), TestMicroBatchBuilder.filesToScan(batch3.tasks()));
        Assert.assertFalse((boolean)batch3.lastIndexOfSnapshot());
        MicroBatches.MicroBatch batch4 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(batch3.endFileIndex(), 5L, 5L, true);
        Assert.assertEquals((long)batch4.endFileIndex(), (long)5L);
        Assert.assertEquals((long)batch4.sizeInBytes(), (long)10L);
        TestMicroBatchBuilder.filesMatch(Lists.newArrayList((Object[])new String[]{"E"}), TestMicroBatchBuilder.filesToScan(batch4.tasks()));
        Assert.assertTrue((boolean)batch4.lastIndexOfSnapshot());
        MicroBatches.MicroBatch batch5 = MicroBatches.from((Snapshot)this.table.snapshot(1L), (FileIO)this.table.io()).specsById(this.table.specs()).generate(batch4.endFileIndex(), 5L, 5L, true);
        Assert.assertEquals((long)batch5.endFileIndex(), (long)5L);
        Assert.assertEquals((long)batch5.sizeInBytes(), (long)0L);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)batch5.tasks()));
        Assert.assertTrue((boolean)batch5.lastIndexOfSnapshot());
    }

    private static DataFile file(String name) {
        return DataFiles.builder((PartitionSpec)SPEC).withPath(name + ".parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();
    }

    private static void add(AppendFiles appendFiles, List<DataFile> adds) {
        for (DataFile f : adds) {
            appendFiles.appendFile(f);
        }
        appendFiles.commit();
    }

    private static void delete(DeleteFiles deleteFiles, List<DataFile> deletes) {
        for (DataFile f : deletes) {
            deleteFiles.deleteFile(f);
        }
        deleteFiles.commit();
    }

    private static List<DataFile> files(String ... names) {
        return Lists.transform((List)Lists.newArrayList((Object[])names), TestMicroBatchBuilder::file);
    }

    private static List<String> filesToScan(Iterable<FileScanTask> tasks) {
        Iterable filesToRead = Iterables.transform(tasks, t -> {
            String path = ((DataFile)t.file()).path().toString();
            return path.split("\\.")[0];
        });
        return Lists.newArrayList((Iterable)filesToRead);
    }

    private static void filesMatch(List<String> expected, List<String> actual) {
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
    }
}

