/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.UnicodeUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestMetricsTruncation {
    @Test
    public void testTruncateBinary() {
        ByteBuffer original = ByteBuffer.wrap(new byte[]{1, 1, -1, 2});
        ByteBuffer emptyByteBuffer = ByteBuffer.allocate(0);
        Comparator cmp = Literal.of((ByteBuffer)original).comparator();
        Assert.assertEquals((String)"Truncating to a length of zero should return an empty ByteBuffer", (long)0L, (long)cmp.compare(BinaryUtil.truncateBinary((ByteBuffer)original, (int)0), emptyByteBuffer));
        Assert.assertEquals((String)"Truncating to the original buffer's remaining size should return the original buffer", (Object)original, (Object)BinaryUtil.truncateBinary((ByteBuffer)original, (int)original.remaining()));
        Assert.assertEquals((String)"Truncating with a length greater than the input's remaining size should return the input", (Object)original, (Object)BinaryUtil.truncateBinary((ByteBuffer)original, (int)16));
        ByteBuffer truncated = BinaryUtil.truncateBinary((ByteBuffer)original, (int)2);
        Assert.assertTrue((String)"Truncating with a length less than the input's remaining size should truncate properly", (truncated.remaining() == 2 && truncated.position() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncating should not modify the input buffer", (original.remaining() == 4 && original.position() == 0 ? 1 : 0) != 0);
        AssertHelpers.assertThrows((String)"Should not allow a negative truncation length", IllegalArgumentException.class, (String)"length should be non-negative", () -> BinaryUtil.truncateBinary((ByteBuffer)original, (int)-1));
    }

    @Test
    public void testTruncateBinaryMin() {
        ByteBuffer test1 = ByteBuffer.wrap(new byte[]{1, 1, -1, 2});
        ByteBuffer test1_2_expected = ByteBuffer.wrap(new byte[]{1, 1});
        ByteBuffer test2 = ByteBuffer.wrap(new byte[]{-1, -1, -1, 2});
        ByteBuffer test2_2 = ByteBuffer.wrap(new byte[]{-1, -1});
        Comparator cmp = Literal.of((ByteBuffer)test1).comparator();
        Assert.assertTrue((String)"Truncated lower bound should be lower than or equal to the actual lower bound", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMin((Literal)Literal.of((ByteBuffer)test1), (int)2).value(), test1) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have the first two bytes of the input", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMin((Literal)Literal.of((ByteBuffer)test1), (int)2).value(), test1_2_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No truncation required as truncate length is greater than the input size", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMin((Literal)Literal.of((ByteBuffer)test1), (int)5).value(), test1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated lower bound should be lower than or equal to the actual lower bound", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMin((Literal)Literal.of((ByteBuffer)test2), (int)2).value(), test2) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have the first two bytes of the input. A lower bound exists even though the first two bytes are the max value", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMin((Literal)Literal.of((ByteBuffer)test2), (int)2).value(), test2_2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTruncateBinaryMax() {
        ByteBuffer test1 = ByteBuffer.wrap(new byte[]{1, 1, 2});
        ByteBuffer test2 = ByteBuffer.wrap(new byte[]{1, 1, -1, 2});
        ByteBuffer test3 = ByteBuffer.wrap(new byte[]{-1, -1, -1, 2});
        ByteBuffer test4 = ByteBuffer.wrap(new byte[]{1, 1, 0});
        ByteBuffer expectedOutput = ByteBuffer.wrap(new byte[]{1, 2});
        Comparator cmp = Literal.of((ByteBuffer)test1).comparator();
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test1), (int)2).value(), test1) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have two bytes and the second byte of the input must be incremented", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test1), (int)2).value(), expectedOutput) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test2), (int)2).value(), test2) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Since the third byte is already the max value, output must have two bytes with the second byte incremented ", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test2), (int)3).value(), expectedOutput) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No truncation required as truncate length is greater than the input size", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test3), (int)5).value(), test3) == 0 ? 1 : 0) != 0);
        Assert.assertNull((String)"An upper bound doesn't exist since the first two bytes are the max value", (Object)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test3), (int)2));
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test4), (int)2).value(), test4) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Since a shorter sequence is considered smaller, output must have two bytes and the second byte of the input must be incremented", (cmp.compare((ByteBuffer)BinaryUtil.truncateBinaryMax((Literal)Literal.of((ByteBuffer)test4), (int)2).value(), expectedOutput) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTruncateStringMin() {
        String test1 = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8";
        String test1_2_expected = "\u30a4\u30ed";
        String test1_3_expected = "\u30a4\u30ed\u30cf";
        String test2 = "\u0449\u0449\u0430\u03b5\u306f\u0447\u03c9\u3044\u306b\u03c0\u03ac\u307b\u0445\u03b5\u308d\u3078\u03c3\u03ba\u03b6";
        String test2_7_expected = "\u0449\u0449\u0430\u03b5\u306f\u0447\u03c9";
        String test3 = "\uffff\uffff";
        String test4 = "\ud800\udc00\ud800\udc00";
        String test4_1_expected = "\ud800\udc00";
        Comparator cmp = Literal.of((CharSequence)test1).comparator();
        Assert.assertTrue((String)"Truncated lower bound should be lower than or equal to the actual lower bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test1), (int)3).value(), test1) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No truncation required as truncate length is greater than the input size", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test1), (int)8).value(), test1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have the first two characters of the input", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test1), (int)2).value(), test1_2_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have the first three characters of the input", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test1), (int)3).value(), test1_3_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated lower bound should be lower than or equal to the actual lower bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test2), (int)16).value(), test2) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have the first seven characters of the input", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test2), (int)7).value(), test2_7_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated lower bound should be lower than or equal to the actual lower bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test3), (int)2).value(), test3) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No truncation required as truncate length is equal to the input size", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test3), (int)2).value(), test3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated lower bound should be lower than or equal to the actual lower bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test4), (int)1).value(), test4) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have the first 4 byte UTF-8 character of the input", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMin((Literal)Literal.of((CharSequence)test4), (int)1).value(), test4_1_expected) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTruncateStringMax() {
        String test1 = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8";
        String test1_2_expected = "\u30a4\u30ee";
        String test1_3_expected = "\u30a4\u30ed\u30d0";
        String test2 = "\u0449\u0449\u0430\u03b5\u306f\u0447\u03c9\u3044\u306b\u03c0\u03ac\u307b\u0445\u03b5\u308d\u3078\u03c3\u03ba\u03b6";
        String test2_7_expected = "\u0449\u0449\u0430\u03b5\u306f\u0447\u03ca";
        String test3 = "a\u0928\u093f\uffff\uffff";
        String test3_3_expected = "a\u0928\u0940";
        String test4 = "\uffff\uffff";
        String test4_1_expected = "\ud800\udc00";
        String test5 = "\udbff\udfff\udbff\udfff";
        String test6 = "\ud800\udfff\ud800\udfff";
        String test6_2_expected = "\ud801\udc00";
        String test7 = "\ud83d\ude02\ud83d\ude02\ud83d\ude02";
        String test7_2_expected = "\ud83d\ude02\ud83d\ude03";
        String test7_1_expected = "\ud83d\ude03";
        Comparator cmp = Literal.of((CharSequence)test1).comparator();
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test1), (int)4).value(), test1) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No truncation required as truncate length is equal to the input size", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test1), (int)7).value(), test1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have two characters and the second character of the input must be incremented", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test1), (int)2).value(), test1_2_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have three characters and the third character of the input must be incremented", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test1), (int)3).value(), test1_3_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"No truncation required as truncate length is greater than the input size", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test1), (int)8).value(), test1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test2), (int)8).value(), test2) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have seven characters and the seventh character of the input must be incremented", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test2), (int)7).value(), test2_7_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test3), (int)3).value(), test3) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have three characters and the third character of the input must be incremented. The second perceivable character in this string is actually a glyph. It consists of two unicode characters", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test3), (int)3).value(), test3_3_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test4), (int)1).value(), test4) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output must have one character. Since the first character is the max 3 byte UTF-8 character, it should be incremented to the lowest 4 byte UTF-8 character", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test4), (int)1).value(), test4_1_expected) == 0 ? 1 : 0) != 0);
        Assert.assertNull((String)"An upper bound doesn't exist since the first two characters are max UTF-8 characters", (Object)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test5), (int)1));
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test6), (int)2).value(), test6) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Test 4 byte UTF-8 character increment. Output must have one character with the first character incremented", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test6), (int)1).value(), test6_2_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Truncated upper bound should be greater than or equal to the actual upper bound", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test7), (int)2).value(), test7) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Test input with multiple 4 byte UTF-8 character where the second unicode character should be incremented", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test7), (int)2).value(), test7_2_expected) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Test input with multiple 4 byte UTF-8 character where the first unicode character should be incremented", (cmp.compare((CharSequence)UnicodeUtil.truncateStringMax((Literal)Literal.of((CharSequence)test7), (int)1).value(), test7_1_expected) == 0 ? 1 : 0) != 0);
    }
}

