/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMetricsModes {
    private final int formatVersion;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestMetricsModes(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    @After
    public void after() {
        TestTables.clearTables();
    }

    @Test
    public void testMetricsModeParsing() {
        Assert.assertEquals((Object)MetricsModes.None.get(), (Object)MetricsModes.fromString((String)"none"));
        Assert.assertEquals((Object)MetricsModes.None.get(), (Object)MetricsModes.fromString((String)"nOnE"));
        Assert.assertEquals((Object)MetricsModes.Counts.get(), (Object)MetricsModes.fromString((String)"counts"));
        Assert.assertEquals((Object)MetricsModes.Counts.get(), (Object)MetricsModes.fromString((String)"coUntS"));
        Assert.assertEquals((Object)MetricsModes.Truncate.withLength((int)1), (Object)MetricsModes.fromString((String)"truncate(1)"));
        Assert.assertEquals((Object)MetricsModes.Truncate.withLength((int)10), (Object)MetricsModes.fromString((String)"truNcAte(10)"));
        Assert.assertEquals((Object)MetricsModes.Full.get(), (Object)MetricsModes.fromString((String)"full"));
        Assert.assertEquals((Object)MetricsModes.Full.get(), (Object)MetricsModes.fromString((String)"FULL"));
    }

    @Test
    public void testInvalidTruncationLength() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetricsModes.fromString((String)"truncate(0)")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Truncate length should be positive");
    }

    @Test
    public void testInvalidColumnModeValue() {
        ImmutableMap properties = ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"full", (Object)"write.metadata.metrics.column.col", (Object)"troncate(5)");
        MetricsConfig config = MetricsConfig.fromProperties((Map)properties);
        Assert.assertEquals((String)"Invalid mode should be defaulted to table default (full)", (Object)MetricsModes.Full.get(), (Object)config.columnMode("col"));
    }

    @Test
    public void testInvalidDefaultColumnModeValue() {
        ImmutableMap properties = ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"fuull", (Object)"write.metadata.metrics.column.col", (Object)"troncate(5)");
        MetricsConfig config = MetricsConfig.fromProperties((Map)properties);
        Assert.assertEquals((String)"Invalid mode should be defaulted to library default (truncate(16))", (Object)MetricsModes.Truncate.withLength((int)16), (Object)config.columnMode("col"));
    }

    @Test
    public void testMetricsConfigSortedColsDefault() throws Exception {
        File tableDir = this.temp.newFolder();
        tableDir.delete();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"col1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"col2", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"col3", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"col4", (Type)Types.IntegerType.get())});
        SortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("col2")).asc("col3")).build();
        TestTables.TestTable testTable = TestTables.create(tableDir, "test", schema, PartitionSpec.unpartitioned(), sortOrder, this.formatVersion);
        testTable.updateProperties().set("write.metadata.metrics.default", "counts").set("write.metadata.metrics.column.col1", "counts").set("write.metadata.metrics.column.col2", "none").commit();
        MetricsConfig config = MetricsConfig.forTable((Table)testTable);
        Assert.assertEquals((String)"Non-sorted existing column should not be overridden", (Object)MetricsModes.Counts.get(), (Object)config.columnMode("col1"));
        Assert.assertEquals((String)"Sorted column defaults should not override user specified config", (Object)MetricsModes.None.get(), (Object)config.columnMode("col2"));
        Assert.assertEquals((String)"Unspecified sorted column should use default", (Object)MetricsModes.Truncate.withLength((int)16), (Object)config.columnMode("col3"));
        Assert.assertEquals((String)"Unspecified normal column should use default", (Object)MetricsModes.Counts.get(), (Object)config.columnMode("col4"));
    }

    @Test
    public void testMetricsConfigSortedColsDefaultByInvalid() throws Exception {
        File tableDir = this.temp.newFolder();
        tableDir.delete();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"col1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"col2", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"col3", (Type)Types.IntegerType.get())});
        SortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("col2")).asc("col3")).build();
        TestTables.TestTable testTable = TestTables.create(tableDir, "test", schema, PartitionSpec.unpartitioned(), sortOrder, this.formatVersion);
        testTable.updateProperties().set("write.metadata.metrics.default", "counts").set("write.metadata.metrics.column.col1", "full").set("write.metadata.metrics.column.col2", "invalid").commit();
        MetricsConfig config = MetricsConfig.forTable((Table)testTable);
        Assert.assertEquals((String)"Non-sorted existing column should not be overridden by sorted column", (Object)MetricsModes.Full.get(), (Object)config.columnMode("col1"));
        Assert.assertEquals((String)"Original default applies as user entered invalid mode for sorted column", (Object)MetricsModes.Counts.get(), (Object)config.columnMode("col2"));
    }

    @Test
    public void testMetricsConfigInferredDefaultModeLimit() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"col1", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"col2", (Type)Types.IntegerType.get()), Types.NestedField.required((int)3, (String)"col3", (Type)Types.IntegerType.get())});
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        TestTables.TestTable table = TestTables.create(tableDir, "test", schema, PartitionSpec.unpartitioned(), SortOrder.unsorted(), this.formatVersion);
        table.updateProperties().set("write.metadata.metrics.max-inferred-column-defaults", "2").commit();
        MetricsConfig config = MetricsConfig.forTable((Table)table);
        Assert.assertEquals((String)"Should use default mode for col1", (Object)MetricsModes.Truncate.withLength((int)16), (Object)config.columnMode("col1"));
        Assert.assertEquals((String)"Should use default mode for col2", (Object)MetricsModes.Truncate.withLength((int)16), (Object)config.columnMode("col2"));
        Assert.assertEquals((String)"Should use None for col3", (Object)MetricsModes.None.get(), (Object)config.columnMode("col3"));
    }
}

