/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class TestMetrics {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final Types.StructType LEAF_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"leafLongCol", (Type)Types.LongType.get()), Types.NestedField.optional((int)6, (String)"leafBinaryCol", (Type)Types.BinaryType.get())});
    private static final Types.StructType NESTED_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"longCol", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"leafStructCol", (Type)LEAF_STRUCT_TYPE), Types.NestedField.required((int)7, (String)"doubleCol", (Type)Types.DoubleType.get())});
    private static final Schema NESTED_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"intCol", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"nestedStructCol", (Type)NESTED_STRUCT_TYPE)});
    private static final Schema SIMPLE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"booleanCol", (Type)Types.BooleanType.get()), Types.NestedField.required((int)2, (String)"intCol", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"longCol", (Type)Types.LongType.get()), Types.NestedField.required((int)4, (String)"floatCol", (Type)Types.FloatType.get()), Types.NestedField.optional((int)5, (String)"doubleCol", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)6, (String)"decimalCol", (Type)Types.DecimalType.of((int)10, (int)2)), Types.NestedField.required((int)7, (String)"stringCol", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"dateCol", (Type)Types.DateType.get()), Types.NestedField.required((int)9, (String)"timeCol", (Type)Types.TimeType.get()), Types.NestedField.required((int)10, (String)"timestampColAboveEpoch", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)11, (String)"fixedCol", (Type)Types.FixedType.ofLength((int)4)), Types.NestedField.required((int)12, (String)"binaryCol", (Type)Types.BinaryType.get()), Types.NestedField.required((int)13, (String)"timestampColBelowEpoch", (Type)Types.TimestampType.withoutZone())});
    private static final Schema FLOAT_DOUBLE_ONLY_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"floatCol", (Type)Types.FloatType.get()), Types.NestedField.optional((int)2, (String)"doubleCol", (Type)Types.DoubleType.get())});
    private static final Record FLOAT_DOUBLE_RECORD_1 = TestMetrics.createRecordWithFloatAndDouble(1.2f, 3.4);
    private static final Record FLOAT_DOUBLE_RECORD_2 = TestMetrics.createRecordWithFloatAndDouble(5.6f, 7.8);
    private static final Record NAN_ONLY_RECORD = TestMetrics.createRecordWithFloatAndDouble(Float.NaN, Double.NaN);
    private final int formatVersion;
    private final byte[] fixed = "abcd".getBytes(StandardCharsets.UTF_8);

    protected TestMetrics(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    @After
    public void after() {
        TestTables.clearTables();
    }

    private static Record createRecordWithFloatAndDouble(float floatValue, double doubleValue) {
        GenericRecord record = GenericRecord.create((Schema)FLOAT_DOUBLE_ONLY_SCHEMA);
        record.setField("floatCol", (Object)Float.valueOf(floatValue));
        record.setField("doubleCol", (Object)doubleValue);
        return record;
    }

    public abstract FileFormat fileFormat();

    public abstract Metrics getMetrics(Schema var1, MetricsConfig var2, Record ... var3) throws IOException;

    public abstract Metrics getMetrics(Schema var1, Record ... var2) throws IOException;

    protected abstract Metrics getMetricsForRecordsWithSmallRowGroups(Schema var1, OutputFile var2, Record ... var3) throws IOException;

    public abstract int splitCount(InputFile var1) throws IOException;

    public boolean supportsSmallRowGroups() {
        return false;
    }

    protected abstract OutputFile createOutputFile() throws IOException;

    @Test
    public void testMetricsForRepeatedValues() throws IOException {
        GenericRecord record = GenericRecord.create((Schema)SIMPLE_SCHEMA);
        record.setField("booleanCol", (Object)true);
        record.setField("intCol", (Object)3);
        record.setField("longCol", null);
        record.setField("floatCol", (Object)Float.valueOf(Float.NaN));
        record.setField("doubleCol", (Object)2.0);
        record.setField("decimalCol", (Object)new BigDecimal("3.50"));
        record.setField("stringCol", (Object)"AAA");
        record.setField("dateCol", (Object)DateTimeUtil.dateFromDays((int)1500));
        record.setField("timeCol", (Object)DateTimeUtil.timeFromMicros((long)2000L));
        record.setField("timestampColAboveEpoch", (Object)DateTimeUtil.timestampFromMicros((long)0L));
        record.setField("fixedCol", (Object)this.fixed);
        record.setField("binaryCol", (Object)ByteBuffer.wrap("S".getBytes()));
        record.setField("timestampColBelowEpoch", (Object)DateTimeUtil.timestampFromMicros((long)0L));
        Metrics metrics = this.getMetrics(SIMPLE_SCHEMA, new Record[]{record, record});
        Assert.assertEquals((long)2L, (long)metrics.recordCount());
        this.assertCounts(1, 2L, 0L, metrics);
        this.assertCounts(2, 2L, 0L, metrics);
        this.assertCounts(3, 2L, 2L, metrics);
        this.assertCounts(4, 2L, 0L, 2L, metrics);
        this.assertCounts(5, 2L, 0L, 0L, metrics);
        this.assertCounts(6, 2L, 0L, metrics);
        this.assertCounts(7, 2L, 0L, metrics);
        this.assertCounts(8, 2L, 0L, metrics);
        this.assertCounts(9, 2L, 0L, metrics);
        this.assertCounts(10, 2L, 0L, metrics);
        this.assertCounts(11, 2L, 0L, metrics);
        this.assertCounts(12, 2L, 0L, metrics);
        this.assertCounts(13, 2L, 0L, metrics);
    }

    @Test
    public void testMetricsForTopLevelFields() throws IOException {
        GenericRecord firstRecord = GenericRecord.create((Schema)SIMPLE_SCHEMA);
        firstRecord.setField("booleanCol", (Object)true);
        firstRecord.setField("intCol", (Object)3);
        firstRecord.setField("longCol", (Object)5L);
        firstRecord.setField("floatCol", (Object)Float.valueOf(2.0f));
        firstRecord.setField("doubleCol", (Object)2.0);
        firstRecord.setField("decimalCol", (Object)new BigDecimal("3.50"));
        firstRecord.setField("stringCol", (Object)"AAA");
        firstRecord.setField("dateCol", (Object)DateTimeUtil.dateFromDays((int)1500));
        firstRecord.setField("timeCol", (Object)DateTimeUtil.timeFromMicros((long)2000L));
        firstRecord.setField("timestampColAboveEpoch", (Object)DateTimeUtil.timestampFromMicros((long)0L));
        firstRecord.setField("fixedCol", (Object)this.fixed);
        firstRecord.setField("binaryCol", (Object)ByteBuffer.wrap("S".getBytes()));
        firstRecord.setField("timestampColBelowEpoch", (Object)DateTimeUtil.timestampFromMicros((long)-1900300L));
        GenericRecord secondRecord = GenericRecord.create((Schema)SIMPLE_SCHEMA);
        secondRecord.setField("booleanCol", (Object)false);
        secondRecord.setField("intCol", (Object)Integer.MIN_VALUE);
        secondRecord.setField("longCol", null);
        secondRecord.setField("floatCol", (Object)Float.valueOf(1.0f));
        secondRecord.setField("doubleCol", null);
        secondRecord.setField("decimalCol", null);
        secondRecord.setField("stringCol", (Object)"ZZZ");
        secondRecord.setField("dateCol", null);
        secondRecord.setField("timeCol", (Object)DateTimeUtil.timeFromMicros((long)3000L));
        secondRecord.setField("timestampColAboveEpoch", (Object)DateTimeUtil.timestampFromMicros((long)900L));
        secondRecord.setField("fixedCol", (Object)this.fixed);
        secondRecord.setField("binaryCol", (Object)ByteBuffer.wrap("W".getBytes()));
        secondRecord.setField("timestampColBelowEpoch", (Object)DateTimeUtil.timestampFromMicros((long)-7000L));
        Metrics metrics = this.getMetrics(SIMPLE_SCHEMA, new Record[]{firstRecord, secondRecord});
        Assert.assertEquals((long)2L, (long)metrics.recordCount());
        this.assertCounts(1, 2L, 0L, metrics);
        this.assertBounds(1, (Type)Types.BooleanType.get(), false, true, metrics);
        this.assertCounts(2, 2L, 0L, metrics);
        this.assertBounds(2, (Type)Types.IntegerType.get(), Integer.MIN_VALUE, 3, metrics);
        this.assertCounts(3, 2L, 1L, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), 5L, 5L, metrics);
        this.assertCounts(4, 2L, 0L, 0L, metrics);
        this.assertBounds(4, (Type)Types.FloatType.get(), Float.valueOf(1.0f), Float.valueOf(2.0f), metrics);
        this.assertCounts(5, 2L, 1L, 0L, metrics);
        this.assertBounds(5, (Type)Types.DoubleType.get(), 2.0, 2.0, metrics);
        this.assertCounts(6, 2L, 1L, metrics);
        this.assertBounds(6, (Type)Types.DecimalType.of((int)10, (int)2), new BigDecimal("3.50"), new BigDecimal("3.50"), metrics);
        this.assertCounts(7, 2L, 0L, metrics);
        this.assertBounds(7, (Type)Types.StringType.get(), CharBuffer.wrap("AAA"), CharBuffer.wrap("ZZZ"), metrics);
        this.assertCounts(8, 2L, 1L, metrics);
        this.assertBounds(8, (Type)Types.DateType.get(), 1500, 1500, metrics);
        this.assertCounts(9, 2L, 0L, metrics);
        this.assertBounds(9, (Type)Types.TimeType.get(), 2000L, 3000L, metrics);
        this.assertCounts(10, 2L, 0L, metrics);
        this.assertBounds(10, (Type)Types.TimestampType.withoutZone(), 0L, 900L, metrics);
        this.assertCounts(11, 2L, 0L, metrics);
        this.assertBounds(11, (Type)Types.FixedType.ofLength((int)4), ByteBuffer.wrap(this.fixed), ByteBuffer.wrap(this.fixed), metrics);
        this.assertCounts(12, 2L, 0L, metrics);
        this.assertBounds(12, (Type)Types.BinaryType.get(), ByteBuffer.wrap("S".getBytes()), ByteBuffer.wrap("W".getBytes()), metrics);
        if (this.fileFormat() == FileFormat.ORC) {
            this.assertBounds(13, (Type)Types.TimestampType.withoutZone(), -1900300L, 993000L, metrics);
        } else {
            this.assertBounds(13, (Type)Types.TimestampType.withoutZone(), -1900300L, -7000L, metrics);
        }
    }

    @Test
    public void testMetricsForDecimals() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"decimalAsInt32", (Type)Types.DecimalType.of((int)4, (int)2)), Types.NestedField.required((int)2, (String)"decimalAsInt64", (Type)Types.DecimalType.of((int)14, (int)2)), Types.NestedField.required((int)3, (String)"decimalAsFixed", (Type)Types.DecimalType.of((int)22, (int)2))});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.setField("decimalAsInt32", (Object)new BigDecimal("2.55"));
        record.setField("decimalAsInt64", (Object)new BigDecimal("4.75"));
        record.setField("decimalAsFixed", (Object)new BigDecimal("5.80"));
        Metrics metrics = this.getMetrics(schema, new Record[]{record});
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        this.assertCounts(1, 1L, 0L, metrics);
        this.assertBounds(1, (Type)Types.DecimalType.of((int)4, (int)2), new BigDecimal("2.55"), new BigDecimal("2.55"), metrics);
        this.assertCounts(2, 1L, 0L, metrics);
        this.assertBounds(2, (Type)Types.DecimalType.of((int)14, (int)2), new BigDecimal("4.75"), new BigDecimal("4.75"), metrics);
        this.assertCounts(3, 1L, 0L, metrics);
        this.assertBounds(3, (Type)Types.DecimalType.of((int)22, (int)2), new BigDecimal("5.80"), new BigDecimal("5.80"), metrics);
    }

    @Test
    public void testMetricsForNestedStructFields() throws IOException {
        Metrics metrics = this.getMetrics(NESTED_SCHEMA, this.buildNestedTestRecord());
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        this.assertCounts(1, 1L, 0L, metrics);
        this.assertBounds(1, (Type)Types.IntegerType.get(), Integer.MAX_VALUE, Integer.MAX_VALUE, metrics);
        this.assertCounts(3, 1L, 0L, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), 100L, 100L, metrics);
        this.assertCounts(5, 1L, 0L, metrics);
        this.assertBounds(5, (Type)Types.LongType.get(), 20L, 20L, metrics);
        this.assertCounts(6, 1L, 0L, metrics);
        this.assertBounds(6, (Type)Types.BinaryType.get(), ByteBuffer.wrap("A".getBytes()), ByteBuffer.wrap("A".getBytes()), metrics);
        this.assertCounts(7, 1L, 0L, 1L, metrics);
        this.assertBounds(7, (Type)Types.DoubleType.get(), null, null, metrics);
    }

    @Test
    public void testMetricsModeForNestedStructFields() throws IOException {
        ImmutableMap properties = ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)MetricsModes.None.get().toString(), (Object)"write.metadata.metrics.column.nestedStructCol.longCol", (Object)MetricsModes.Full.get().toString());
        MetricsConfig config = MetricsConfig.fromProperties((Map)properties);
        Metrics metrics = this.getMetrics(NESTED_SCHEMA, config, this.buildNestedTestRecord());
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        Assert.assertEquals((long)1L, (long)metrics.lowerBounds().size());
        Assert.assertEquals((long)1L, (long)metrics.upperBounds().size());
        this.assertBounds(3, (Type)Types.LongType.get(), 100L, 100L, metrics);
    }

    private Record buildNestedTestRecord() {
        GenericRecord leafStruct = GenericRecord.create((Types.StructType)LEAF_STRUCT_TYPE);
        leafStruct.setField("leafLongCol", (Object)20L);
        leafStruct.setField("leafBinaryCol", (Object)ByteBuffer.wrap("A".getBytes()));
        GenericRecord nestedStruct = GenericRecord.create((Types.StructType)NESTED_STRUCT_TYPE);
        nestedStruct.setField("longCol", (Object)100L);
        nestedStruct.setField("leafStructCol", (Object)leafStruct);
        nestedStruct.setField("doubleCol", (Object)Double.NaN);
        GenericRecord record = GenericRecord.create((Schema)NESTED_SCHEMA);
        record.setField("intCol", (Object)Integer.MAX_VALUE);
        record.setField("nestedStructCol", (Object)nestedStruct);
        return record;
    }

    @Test
    public void testMetricsForListAndMapElements() throws IOException {
        Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"leafIntCol", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"leafStringCol", (Type)Types.StringType.get())});
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"intListCol", (Type)Types.ListType.ofRequired((int)4, (Type)Types.IntegerType.get())), Types.NestedField.optional((int)5, (String)"mapCol", (Type)Types.MapType.ofRequired((int)6, (int)7, (Type)Types.StringType.get(), (Type)structType))});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.setField("intListCol", (Object)Lists.newArrayList((Object[])new Integer[]{10, 11, 12}));
        GenericRecord struct = GenericRecord.create((Types.StructType)structType);
        struct.setField("leafIntCol", (Object)1);
        struct.setField("leafStringCol", (Object)"BBB");
        HashMap map = Maps.newHashMap();
        map.put("4", struct);
        record.set(1, (Object)map);
        Metrics metrics = this.getMetrics(schema, new Record[]{record});
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        if (this.fileFormat() != FileFormat.ORC) {
            this.assertCounts(1, 1L, 0L, metrics);
            this.assertCounts(2, 1L, 0L, metrics);
            this.assertCounts(4, 3L, 0L, metrics);
            this.assertCounts(6, 1L, 0L, metrics);
        } else {
            this.assertCounts(1, null, null, metrics);
            this.assertCounts(2, null, null, metrics);
            this.assertCounts(4, null, null, metrics);
            this.assertCounts(6, null, null, metrics);
        }
        this.assertBounds(1, (Type)Types.IntegerType.get(), null, null, metrics);
        this.assertBounds(2, (Type)Types.StringType.get(), null, null, metrics);
        this.assertBounds(4, (Type)Types.IntegerType.get(), null, null, metrics);
        this.assertBounds(6, (Type)Types.StringType.get(), null, null, metrics);
        this.assertBounds(7, (Type)structType, null, null, metrics);
    }

    @Test
    public void testMetricsForNullColumns() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"intCol", (Type)Types.IntegerType.get())});
        GenericRecord firstRecord = GenericRecord.create((Schema)schema);
        firstRecord.setField("intCol", null);
        GenericRecord secondRecord = GenericRecord.create((Schema)schema);
        secondRecord.setField("intCol", null);
        Metrics metrics = this.getMetrics(schema, new Record[]{firstRecord, secondRecord});
        Assert.assertEquals((long)2L, (long)metrics.recordCount());
        this.assertCounts(1, 2L, 2L, metrics);
        this.assertBounds(1, (Type)Types.IntegerType.get(), null, null, metrics);
    }

    @Test
    public void testMetricsForNaNColumns() throws IOException {
        Metrics metrics = this.getMetrics(FLOAT_DOUBLE_ONLY_SCHEMA, NAN_ONLY_RECORD, NAN_ONLY_RECORD);
        Assert.assertEquals((long)2L, (long)metrics.recordCount());
        this.assertCounts(1, 2L, 0L, 2L, metrics);
        this.assertCounts(2, 2L, 0L, 2L, metrics);
        this.assertBounds(1, (Type)Types.FloatType.get(), null, null, metrics);
        this.assertBounds(2, (Type)Types.DoubleType.get(), null, null, metrics);
    }

    @Test
    public void testColumnBoundsWithNaNValueAtFront() throws IOException {
        Metrics metrics = this.getMetrics(FLOAT_DOUBLE_ONLY_SCHEMA, NAN_ONLY_RECORD, FLOAT_DOUBLE_RECORD_1, FLOAT_DOUBLE_RECORD_2);
        Assert.assertEquals((long)3L, (long)metrics.recordCount());
        this.assertCounts(1, 3L, 0L, 1L, metrics);
        this.assertCounts(2, 3L, 0L, 1L, metrics);
        this.assertBounds(1, (Type)Types.FloatType.get(), Float.valueOf(1.2f), Float.valueOf(5.6f), metrics);
        this.assertBounds(2, (Type)Types.DoubleType.get(), 3.4, 7.8, metrics);
    }

    @Test
    public void testColumnBoundsWithNaNValueInMiddle() throws IOException {
        Metrics metrics = this.getMetrics(FLOAT_DOUBLE_ONLY_SCHEMA, FLOAT_DOUBLE_RECORD_1, NAN_ONLY_RECORD, FLOAT_DOUBLE_RECORD_2);
        Assert.assertEquals((long)3L, (long)metrics.recordCount());
        this.assertCounts(1, 3L, 0L, 1L, metrics);
        this.assertCounts(2, 3L, 0L, 1L, metrics);
        this.assertBounds(1, (Type)Types.FloatType.get(), Float.valueOf(1.2f), Float.valueOf(5.6f), metrics);
        this.assertBounds(2, (Type)Types.DoubleType.get(), 3.4, 7.8, metrics);
    }

    @Test
    public void testColumnBoundsWithNaNValueAtEnd() throws IOException {
        Metrics metrics = this.getMetrics(FLOAT_DOUBLE_ONLY_SCHEMA, FLOAT_DOUBLE_RECORD_1, FLOAT_DOUBLE_RECORD_2, NAN_ONLY_RECORD);
        Assert.assertEquals((long)3L, (long)metrics.recordCount());
        this.assertCounts(1, 3L, 0L, 1L, metrics);
        this.assertCounts(2, 3L, 0L, 1L, metrics);
        this.assertBounds(1, (Type)Types.FloatType.get(), Float.valueOf(1.2f), Float.valueOf(5.6f), metrics);
        this.assertBounds(2, (Type)Types.DoubleType.get(), 3.4, 7.8, metrics);
    }

    @Test
    public void testMetricsForTopLevelWithMultipleRowGroup() throws Exception {
        Assume.assumeTrue((String)"Skip test for formats that do not support small row groups", (boolean)this.supportsSmallRowGroups());
        int recordCount = 201;
        ArrayList records = Lists.newArrayListWithExpectedSize((int)recordCount);
        for (int i = 0; i < recordCount; ++i) {
            GenericRecord newRecord = GenericRecord.create((Schema)SIMPLE_SCHEMA);
            newRecord.setField("booleanCol", (Object)(i != 0 ? 1 : 0));
            newRecord.setField("intCol", (Object)(i + 1));
            newRecord.setField("longCol", i == 0 ? null : Long.valueOf((long)i + 1L));
            newRecord.setField("floatCol", (Object)Float.valueOf((float)i + 1.0f));
            newRecord.setField("doubleCol", i == 0 ? null : Double.valueOf((double)i + 1.0));
            newRecord.setField("decimalCol", i == 0 ? null : new BigDecimal(i + "").add(new BigDecimal("1.00")));
            newRecord.setField("stringCol", (Object)"AAA");
            newRecord.setField("dateCol", (Object)DateTimeUtil.dateFromDays((int)(i + 1)));
            newRecord.setField("timeCol", (Object)DateTimeUtil.timeFromMicros((long)((long)i + 1L)));
            newRecord.setField("timestampColAboveEpoch", (Object)DateTimeUtil.timestampFromMicros((long)((long)i + 1L)));
            newRecord.setField("fixedCol", (Object)this.fixed);
            newRecord.setField("binaryCol", (Object)ByteBuffer.wrap("S".getBytes()));
            newRecord.setField("timestampColBelowEpoch", (Object)DateTimeUtil.timestampFromMicros((long)(((long)i + 1L) * -1L)));
            records.add(newRecord);
        }
        OutputFile outputFile = this.createOutputFile();
        Metrics metrics = this.getMetricsForRecordsWithSmallRowGroups(SIMPLE_SCHEMA, outputFile, records.toArray(new Record[0]));
        InputFile recordsFile = outputFile.toInputFile();
        Assert.assertNotNull((Object)recordsFile);
        Assert.assertEquals((long)3L, (long)this.splitCount(recordsFile));
        Assert.assertEquals((long)201L, (long)metrics.recordCount());
        this.assertCounts(1, 201L, 0L, metrics);
        this.assertBounds(1, (Type)Types.BooleanType.get(), false, true, metrics);
        this.assertBounds(2, (Type)Types.IntegerType.get(), 1, 201, metrics);
        this.assertCounts(3, 201L, 1L, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), 2L, 201L, metrics);
        this.assertCounts(4, 201L, 0L, 0L, metrics);
        this.assertBounds(4, (Type)Types.FloatType.get(), Float.valueOf(1.0f), Float.valueOf(201.0f), metrics);
        this.assertCounts(5, 201L, 1L, 0L, metrics);
        this.assertBounds(5, (Type)Types.DoubleType.get(), 2.0, 201.0, metrics);
        this.assertCounts(6, 201L, 1L, metrics);
        this.assertBounds(6, (Type)Types.DecimalType.of((int)10, (int)2), new BigDecimal("2.00"), new BigDecimal("201.00"), metrics);
    }

    @Test
    public void testMetricsForNestedStructFieldsWithMultipleRowGroup() throws IOException {
        Assume.assumeTrue((String)"Skip test for formats that do not support small row groups", (boolean)this.supportsSmallRowGroups());
        int recordCount = 201;
        ArrayList records = Lists.newArrayListWithExpectedSize((int)recordCount);
        for (int i = 0; i < recordCount; ++i) {
            GenericRecord newLeafStruct = GenericRecord.create((Types.StructType)LEAF_STRUCT_TYPE);
            newLeafStruct.setField("leafLongCol", (Object)((long)i + 1L));
            newLeafStruct.setField("leafBinaryCol", (Object)ByteBuffer.wrap("A".getBytes()));
            GenericRecord newNestedStruct = GenericRecord.create((Types.StructType)NESTED_STRUCT_TYPE);
            newNestedStruct.setField("longCol", (Object)((long)i + 1L));
            newNestedStruct.setField("leafStructCol", (Object)newLeafStruct);
            newNestedStruct.setField("doubleCol", (Object)Double.NaN);
            GenericRecord newRecord = GenericRecord.create((Schema)NESTED_SCHEMA);
            newRecord.setField("intCol", (Object)(i + 1));
            newRecord.setField("nestedStructCol", (Object)newNestedStruct);
            records.add(newRecord);
        }
        OutputFile outputFile = this.createOutputFile();
        Metrics metrics = this.getMetricsForRecordsWithSmallRowGroups(NESTED_SCHEMA, outputFile, records.toArray(new Record[0]));
        InputFile recordsFile = outputFile.toInputFile();
        Assert.assertNotNull((Object)recordsFile);
        Assert.assertEquals((long)3L, (long)this.splitCount(recordsFile));
        Assert.assertEquals((long)201L, (long)metrics.recordCount());
        this.assertCounts(1, 201L, 0L, metrics);
        this.assertBounds(1, (Type)Types.IntegerType.get(), 1, 201, metrics);
        this.assertCounts(3, 201L, 0L, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), 1L, 201L, metrics);
        this.assertCounts(5, 201L, 0L, metrics);
        this.assertBounds(5, (Type)Types.LongType.get(), 1L, 201L, metrics);
        this.assertCounts(6, 201L, 0L, metrics);
        this.assertBounds(6, (Type)Types.BinaryType.get(), ByteBuffer.wrap("A".getBytes()), ByteBuffer.wrap("A".getBytes()), metrics);
        this.assertCounts(7, 201L, 0L, 201L, metrics);
        this.assertBounds(7, (Type)Types.DoubleType.get(), null, null, metrics);
    }

    @Test
    public void testNoneMetricsMode() throws IOException {
        Metrics metrics = this.getMetrics(NESTED_SCHEMA, MetricsConfig.fromProperties((Map)ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"none")), this.buildNestedTestRecord());
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        Assert.assertTrue((boolean)metrics.columnSizes().values().stream().allMatch(Objects::nonNull));
        this.assertCounts(1, null, null, metrics);
        this.assertBounds(1, (Type)Types.IntegerType.get(), null, null, metrics);
        this.assertCounts(3, null, null, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), null, null, metrics);
        this.assertCounts(5, null, null, metrics);
        this.assertBounds(5, (Type)Types.LongType.get(), null, null, metrics);
        this.assertCounts(6, null, null, metrics);
        this.assertBounds(6, (Type)Types.BinaryType.get(), null, null, metrics);
        this.assertCounts(7, null, null, metrics);
        this.assertBounds(7, (Type)Types.DoubleType.get(), null, null, metrics);
    }

    @Test
    public void testCountsMetricsMode() throws IOException {
        Metrics metrics = this.getMetrics(NESTED_SCHEMA, MetricsConfig.fromProperties((Map)ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"counts")), this.buildNestedTestRecord());
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        Assert.assertTrue((boolean)metrics.columnSizes().values().stream().allMatch(Objects::nonNull));
        this.assertCounts(1, 1L, 0L, metrics);
        this.assertBounds(1, (Type)Types.IntegerType.get(), null, null, metrics);
        this.assertCounts(3, 1L, 0L, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), null, null, metrics);
        this.assertCounts(5, 1L, 0L, metrics);
        this.assertBounds(5, (Type)Types.LongType.get(), null, null, metrics);
        this.assertCounts(6, 1L, 0L, metrics);
        this.assertBounds(6, (Type)Types.BinaryType.get(), null, null, metrics);
        this.assertCounts(7, 1L, 0L, 1L, metrics);
        this.assertBounds(7, (Type)Types.DoubleType.get(), null, null, metrics);
    }

    @Test
    public void testFullMetricsMode() throws IOException {
        Metrics metrics = this.getMetrics(NESTED_SCHEMA, MetricsConfig.fromProperties((Map)ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"full")), this.buildNestedTestRecord());
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        Assert.assertTrue((boolean)metrics.columnSizes().values().stream().allMatch(Objects::nonNull));
        this.assertCounts(1, 1L, 0L, metrics);
        this.assertBounds(1, (Type)Types.IntegerType.get(), Integer.MAX_VALUE, Integer.MAX_VALUE, metrics);
        this.assertCounts(3, 1L, 0L, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), 100L, 100L, metrics);
        this.assertCounts(5, 1L, 0L, metrics);
        this.assertBounds(5, (Type)Types.LongType.get(), 20L, 20L, metrics);
        this.assertCounts(6, 1L, 0L, metrics);
        this.assertBounds(6, (Type)Types.BinaryType.get(), ByteBuffer.wrap("A".getBytes()), ByteBuffer.wrap("A".getBytes()), metrics);
        this.assertCounts(7, 1L, 0L, 1L, metrics);
        this.assertBounds(7, (Type)Types.DoubleType.get(), null, null, metrics);
    }

    @Test
    public void testTruncateStringMetricsMode() throws IOException {
        String colName = "str_to_truncate";
        Schema singleStringColSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)colName, (Type)Types.StringType.get())});
        String value = "Lorem ipsum dolor sit amet";
        GenericRecord record = GenericRecord.create((Schema)singleStringColSchema);
        record.setField(colName, (Object)value);
        Metrics metrics = this.getMetrics(singleStringColSchema, MetricsConfig.fromProperties((Map)ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"truncate(10)")), new Record[]{record});
        CharBuffer expectedMinBound = CharBuffer.wrap("Lorem ipsu");
        CharBuffer expectedMaxBound = CharBuffer.wrap("Lorem ipsv");
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        Assert.assertTrue((boolean)metrics.columnSizes().values().stream().allMatch(Objects::nonNull));
        this.assertCounts(1, 1L, 0L, metrics);
        this.assertBounds(1, (Type)Types.StringType.get(), expectedMinBound, expectedMaxBound, metrics);
    }

    @Test
    public void testTruncateBinaryMetricsMode() throws IOException {
        String colName = "bin_to_truncate";
        Schema singleBinaryColSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)colName, (Type)Types.BinaryType.get())});
        byte[] value = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 10, 11};
        GenericRecord record = GenericRecord.create((Schema)singleBinaryColSchema);
        record.setField(colName, (Object)ByteBuffer.wrap(value));
        Metrics metrics = this.getMetrics(singleBinaryColSchema, MetricsConfig.fromProperties((Map)ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"truncate(5)")), new Record[]{record});
        ByteBuffer expectedMinBounds = ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5});
        ByteBuffer expectedMaxBounds = ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 6});
        Assert.assertEquals((long)1L, (long)metrics.recordCount());
        Assert.assertTrue((boolean)metrics.columnSizes().values().stream().allMatch(Objects::nonNull));
        this.assertCounts(1, 1L, 0L, metrics);
        this.assertBounds(1, (Type)Types.BinaryType.get(), expectedMinBounds, expectedMaxBounds, metrics);
    }

    @Test
    public void testSortedColumnMetrics() throws IOException {
        File tableDir = this.temp.newFolder();
        tableDir.delete();
        SortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SIMPLE_SCHEMA).asc("booleanCol")).asc("intCol")).asc("longCol")).asc("decimalCol")).asc("stringCol")).asc("dateCol")).build();
        PartitionSpec spec = PartitionSpec.unpartitioned();
        TestTables.TestTable table = TestTables.create(tableDir, "test", SIMPLE_SCHEMA, spec, sortOrder, this.formatVersion);
        table.updateProperties().set("write.metadata.metrics.default", "none").commit();
        GenericRecord firstRecord = GenericRecord.create((Schema)SIMPLE_SCHEMA);
        firstRecord.setField("booleanCol", (Object)true);
        firstRecord.setField("intCol", (Object)Integer.MIN_VALUE);
        firstRecord.setField("longCol", (Object)Long.MIN_VALUE);
        firstRecord.setField("floatCol", (Object)Float.valueOf(Float.NaN));
        firstRecord.setField("doubleCol", (Object)2.0);
        firstRecord.setField("decimalCol", (Object)new BigDecimal("0.00"));
        firstRecord.setField("stringCol", (Object)"AAA");
        firstRecord.setField("dateCol", (Object)DateTimeUtil.dateFromDays((int)1500));
        firstRecord.setField("timeCol", (Object)DateTimeUtil.timeFromMicros((long)2000L));
        firstRecord.setField("timestampColAboveEpoch", (Object)DateTimeUtil.timestampFromMicros((long)0L));
        firstRecord.setField("fixedCol", (Object)this.fixed);
        firstRecord.setField("binaryCol", (Object)ByteBuffer.wrap("S".getBytes()));
        firstRecord.setField("timestampColBelowEpoch", (Object)DateTimeUtil.timestampFromMicros((long)0L));
        GenericRecord secondRecord = GenericRecord.create((Schema)SIMPLE_SCHEMA);
        secondRecord.setField("booleanCol", (Object)false);
        secondRecord.setField("intCol", (Object)Integer.MAX_VALUE);
        secondRecord.setField("longCol", (Object)Long.MAX_VALUE);
        secondRecord.setField("floatCol", (Object)Float.valueOf(Float.NaN));
        secondRecord.setField("doubleCol", (Object)2.0);
        secondRecord.setField("decimalCol", (Object)new BigDecimal("10.00"));
        secondRecord.setField("stringCol", (Object)"ZZZ");
        secondRecord.setField("dateCol", (Object)DateTimeUtil.dateFromDays((int)3000));
        secondRecord.setField("timeCol", (Object)DateTimeUtil.timeFromMicros((long)2000L));
        secondRecord.setField("timestampColAboveEpoch", (Object)DateTimeUtil.timestampFromMicros((long)0L));
        secondRecord.setField("fixedCol", (Object)this.fixed);
        secondRecord.setField("binaryCol", (Object)ByteBuffer.wrap("S".getBytes()));
        secondRecord.setField("timestampColBelowEpoch", (Object)DateTimeUtil.timestampFromMicros((long)0L));
        Metrics metrics = this.getMetrics(SIMPLE_SCHEMA, MetricsConfig.forTable((Table)table), new Record[]{firstRecord, secondRecord});
        Assert.assertEquals((long)2L, (long)metrics.recordCount());
        this.assertBounds(1, (Type)Types.BooleanType.get(), false, true, metrics);
        this.assertBounds(2, (Type)Types.IntegerType.get(), Integer.MIN_VALUE, Integer.MAX_VALUE, metrics);
        this.assertBounds(3, (Type)Types.LongType.get(), Long.MIN_VALUE, Long.MAX_VALUE, metrics);
        this.assertBounds(6, (Type)Types.DecimalType.of((int)10, (int)2), new BigDecimal("0.00"), new BigDecimal("10.00"), metrics);
        this.assertBounds(7, (Type)Types.StringType.get(), CharBuffer.wrap("AAA"), CharBuffer.wrap("ZZZ"), metrics);
        this.assertBounds(8, (Type)Types.DateType.get(), 1500, 3000, metrics);
    }

    @Test
    public void testMetricsForSortedNestedStructFields() throws IOException {
        File tableDir = this.temp.newFolder();
        tableDir.delete();
        SortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)NESTED_SCHEMA).asc("nestedStructCol.longCol")).asc("nestedStructCol.leafStructCol.leafLongCol")).build();
        PartitionSpec spec = PartitionSpec.unpartitioned();
        TestTables.TestTable table = TestTables.create(tableDir, "nested", NESTED_SCHEMA, spec, sortOrder, this.formatVersion);
        GenericRecord leafStruct = GenericRecord.create((Types.StructType)LEAF_STRUCT_TYPE);
        leafStruct.setField("leafLongCol", (Object)Long.MAX_VALUE);
        leafStruct.setField("leafBinaryCol", (Object)ByteBuffer.wrap("A".getBytes()));
        GenericRecord nestedStruct = GenericRecord.create((Types.StructType)NESTED_STRUCT_TYPE);
        nestedStruct.setField("longCol", (Object)Long.MAX_VALUE);
        nestedStruct.setField("leafStructCol", (Object)leafStruct);
        nestedStruct.setField("doubleCol", (Object)Double.NaN);
        GenericRecord record = GenericRecord.create((Schema)NESTED_SCHEMA);
        record.setField("intCol", (Object)Integer.MAX_VALUE);
        record.setField("nestedStructCol", (Object)nestedStruct);
        Metrics metrics = this.getMetrics(NESTED_SCHEMA, MetricsConfig.forTable((Table)table), new Record[]{record});
        this.assertBounds(3, (Type)Types.LongType.get(), Long.MAX_VALUE, Long.MAX_VALUE, metrics);
        this.assertBounds(5, (Type)Types.LongType.get(), Long.MAX_VALUE, Long.MAX_VALUE, metrics);
    }

    protected void assertCounts(int fieldId, Long valueCount, Long nullValueCount, Metrics metrics) {
        this.assertCounts(fieldId, valueCount, nullValueCount, null, metrics);
    }

    protected void assertCounts(int fieldId, Long valueCount, Long nullValueCount, Long nanValueCount, Metrics metrics) {
        Map valueCounts = metrics.valueCounts();
        Map nullValueCounts = metrics.nullValueCounts();
        Map nanValueCounts = metrics.nanValueCounts();
        Assert.assertEquals((Object)valueCount, valueCounts.get(fieldId));
        Assert.assertEquals((Object)nullValueCount, nullValueCounts.get(fieldId));
        Assert.assertEquals((Object)nanValueCount, nanValueCounts.get(fieldId));
    }

    protected <T> void assertBounds(int fieldId, Type type, T lowerBound, T upperBound, Metrics metrics) {
        Map lowerBounds = metrics.lowerBounds();
        Map upperBounds = metrics.upperBounds();
        Assert.assertEquals(lowerBound, lowerBounds.containsKey(fieldId) ? Conversions.fromByteBuffer((Type)type, (ByteBuffer)((ByteBuffer)lowerBounds.get(fieldId))) : null);
        Assert.assertEquals(upperBound, upperBounds.containsKey(fieldId) ? Conversions.fromByteBuffer((Type)type, (ByteBuffer)((ByteBuffer)upperBounds.get(fieldId))) : null);
    }
}

