/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.BlobMetadata;
import org.apache.iceberg.Files;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.MetadataUpdateParser;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotParser;
import org.apache.iceberg.SnapshotRefType;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestMetadataUpdateParser {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final Schema ID_DATA_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});

    @Test
    public void testMetadataUpdateWithoutActionCannotDeserialize() {
        ImmutableList invalidJson = ImmutableList.of((Object)"{\"action\":null,\"format-version\":2}", (Object)"{\"format-version\":2}");
        for (String json : invalidJson) {
            AssertHelpers.assertThrows((String)"MetadataUpdate without a recognized action should fail to deserialize", IllegalArgumentException.class, (String)"Cannot parse metadata update. Missing field: action", () -> MetadataUpdateParser.fromJson((String)json));
        }
    }

    @Test
    public void testAssignUUIDToJson() {
        String action = "assign-uuid";
        String uuid = "9510c070-5e6d-4b40-bf40-a8915bb76e5d";
        String json = "{\"action\":\"assign-uuid\",\"uuid\":\"9510c070-5e6d-4b40-bf40-a8915bb76e5d\"}";
        MetadataUpdate.AssignUUID expected = new MetadataUpdate.AssignUUID(uuid);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testAssignUUIDFromJson() {
        String uuid = "9510c070-5e6d-4b40-bf40-a8915bb76e5d";
        String expected = "{\"action\":\"assign-uuid\",\"uuid\":\"9510c070-5e6d-4b40-bf40-a8915bb76e5d\"}";
        MetadataUpdate.AssignUUID actual = new MetadataUpdate.AssignUUID(uuid);
        Assert.assertEquals((String)"Assign UUID should convert to the correct JSON value", (Object)expected, (Object)MetadataUpdateParser.toJson((MetadataUpdate)actual));
    }

    @Test
    public void testUpgradeFormatVersionToJson() {
        int formatVersion = 2;
        String action = "upgrade-format-version";
        String json = "{\"action\":\"upgrade-format-version\",\"format-version\":2}";
        MetadataUpdate.UpgradeFormatVersion expected = new MetadataUpdate.UpgradeFormatVersion(formatVersion);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testUpgradeFormatVersionFromJson() {
        int formatVersion = 2;
        String expected = "{\"action\":\"upgrade-format-version\",\"format-version\":2}";
        MetadataUpdate.UpgradeFormatVersion actual = new MetadataUpdate.UpgradeFormatVersion(formatVersion);
        Assert.assertEquals((String)"Upgrade format version should convert to the correct JSON value", (Object)expected, (Object)MetadataUpdateParser.toJson((MetadataUpdate)actual));
    }

    @Test
    public void testAddSchemaFromJson() {
        String action = "add-schema";
        Schema schema = ID_DATA_SCHEMA;
        int lastColumnId = schema.highestFieldId();
        String json = String.format("{\"action\":\"add-schema\",\"schema\":%s,\"last-column-id\":%d}", SchemaParser.toJson((Schema)schema), lastColumnId);
        MetadataUpdate.AddSchema actualUpdate = new MetadataUpdate.AddSchema(schema, lastColumnId);
        this.assertEquals(action, (MetadataUpdate)actualUpdate, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testAddSchemaToJson() {
        Schema schema = ID_DATA_SCHEMA;
        int lastColumnId = schema.highestFieldId();
        String expected = String.format("{\"action\":\"add-schema\",\"schema\":%s,\"last-column-id\":%d}", SchemaParser.toJson((Schema)schema), lastColumnId);
        MetadataUpdate.AddSchema update = new MetadataUpdate.AddSchema(schema, lastColumnId);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Add schema should convert to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetCurrentSchemaFromJson() {
        String action = "set-current-schema";
        int schemaId = 6;
        String json = String.format("{\"action\":\"%s\",\"schema-id\":%d}", action, schemaId);
        MetadataUpdate.SetCurrentSchema expected = new MetadataUpdate.SetCurrentSchema(schemaId);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetCurrentSchemaToJson() {
        String action = "set-current-schema";
        int schemaId = 6;
        String expected = String.format("{\"action\":\"%s\",\"schema-id\":%d}", action, schemaId);
        MetadataUpdate.SetCurrentSchema update = new MetadataUpdate.SetCurrentSchema(schemaId);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set current schema should convert to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testAddPartitionSpecFromJsonWithFieldId() {
        String action = "add-spec";
        String specString = "{\"spec-id\":1,\"fields\":[{\"name\":\"id_bucket\",\"transform\":\"bucket[8]\",\"source-id\":1,\"field-id\":1000},{\"name\":\"data_bucket\",\"transform\":\"bucket[16]\",\"source-id\":2,\"field-id\":1001}]}";
        UnboundPartitionSpec actualSpec = PartitionSpecParser.fromJson((Schema)ID_DATA_SCHEMA, (String)specString).toUnbound();
        String json = String.format("{\"action\":\"%s\",\"spec\":%s}", action, PartitionSpecParser.toJson((UnboundPartitionSpec)actualSpec));
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)ID_DATA_SCHEMA).bucket("id", 8).bucket("data", 16).withSpecId(1).build();
        MetadataUpdate.AddPartitionSpec expected = new MetadataUpdate.AddPartitionSpec(expectedSpec);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testAddPartitionSpecFromJsonWithoutFieldId() {
        String action = "add-spec";
        String specString = "{\"spec-id\":1,\"fields\":[{\"name\":\"id_bucket\",\"transform\":\"bucket[8]\",\"source-id\":1},{\"name\": \"data_bucket\",\"transform\":\"bucket[16]\",\"source-id\":2}]}";
        UnboundPartitionSpec actualSpec = PartitionSpecParser.fromJson((Schema)ID_DATA_SCHEMA, (String)specString).toUnbound();
        String json = String.format("{\"action\":\"%s\",\"spec\":%s}", action, PartitionSpecParser.toJson((UnboundPartitionSpec)actualSpec));
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)ID_DATA_SCHEMA).bucket("id", 8).bucket("data", 16).withSpecId(1).build();
        MetadataUpdate.AddPartitionSpec expected = new MetadataUpdate.AddPartitionSpec(expectedSpec.toUnbound());
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testAddPartitionSpecToJson() {
        String action = "add-spec";
        String specString = "{\"spec-id\":1,\"fields\":[{\"name\":\"id_bucket\",\"transform\":\"bucket[8]\",\"source-id\":1,\"field-id\":1000},{\"name\":\"data_bucket\",\"transform\":\"bucket[16]\",\"source-id\":2,\"field-id\":1001}]}";
        UnboundPartitionSpec actualSpec = PartitionSpecParser.fromJson((Schema)ID_DATA_SCHEMA, (String)specString).toUnbound();
        String expected = String.format("{\"action\":\"%s\",\"spec\":%s}", action, PartitionSpecParser.toJson((UnboundPartitionSpec)actualSpec));
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)ID_DATA_SCHEMA).bucket("id", 8).bucket("data", 16).withSpecId(1).build();
        MetadataUpdate.AddPartitionSpec update = new MetadataUpdate.AddPartitionSpec(expectedSpec);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Add partition spec should convert to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetDefaultPartitionSpecToJson() {
        String action = "set-default-spec";
        int specId = 4;
        String expected = String.format("{\"action\":\"%s\",\"spec-id\":%d}", action, specId);
        MetadataUpdate.SetDefaultPartitionSpec update = new MetadataUpdate.SetDefaultPartitionSpec(specId);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set default partition spec should serialize to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetDefaultPartitionSpecFromJson() {
        String action = "set-default-spec";
        int specId = 4;
        String json = String.format("{\"action\":\"%s\",\"spec-id\":%d}", action, specId);
        MetadataUpdate.SetDefaultPartitionSpec expected = new MetadataUpdate.SetDefaultPartitionSpec(specId);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testAddSortOrderToJson() {
        String action = "add-sort-order";
        UnboundSortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)ID_DATA_SCHEMA).withOrderId(3).asc("id", NullOrder.NULLS_FIRST)).desc("data")).build().toUnbound();
        String expected = String.format("{\"action\":\"%s\",\"sort-order\":%s}", action, SortOrderParser.toJson((UnboundSortOrder)sortOrder));
        MetadataUpdate.AddSortOrder update = new MetadataUpdate.AddSortOrder(sortOrder);
        Assert.assertEquals((String)"Add sort order should serialize to the correct JSON value", (Object)expected, (Object)MetadataUpdateParser.toJson((MetadataUpdate)update));
    }

    @Test
    public void testAddSortOrderFromJson() {
        String action = "add-sort-order";
        UnboundSortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)ID_DATA_SCHEMA).withOrderId(3).asc("id", NullOrder.NULLS_FIRST)).desc("data")).build().toUnbound();
        String json = String.format("{\"action\":\"%s\",\"sort-order\":%s}", action, SortOrderParser.toJson((UnboundSortOrder)sortOrder));
        MetadataUpdate.AddSortOrder expected = new MetadataUpdate.AddSortOrder(sortOrder);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetDefaultSortOrderToJson() {
        String action = "set-default-sort-order";
        int sortOrderId = 2;
        String expected = String.format("{\"action\":\"%s\",\"sort-order-id\":%d}", action, sortOrderId);
        MetadataUpdate.SetDefaultSortOrder update = new MetadataUpdate.SetDefaultSortOrder(sortOrderId);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set default sort order should serialize to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetDefaultSortOrderFromJson() {
        String action = "set-default-sort-order";
        int sortOrderId = 2;
        String json = String.format("{\"action\":\"%s\",\"sort-order-id\":%d}", action, sortOrderId);
        MetadataUpdate.SetDefaultSortOrder expected = new MetadataUpdate.SetDefaultSortOrder(sortOrderId);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testAddSnapshotToJson() throws IOException {
        String action = "add-snapshot";
        long parentId = 1L;
        long snapshotId = 2L;
        int schemaId = 3;
        String manifestList = this.createManifestListWithManifestFiles(snapshotId, parentId);
        BaseSnapshot snapshot = new BaseSnapshot(0L, snapshotId, Long.valueOf(parentId), System.currentTimeMillis(), "replace", (Map)ImmutableMap.of((Object)"files-added", (Object)"4", (Object)"files-deleted", (Object)"100"), Integer.valueOf(schemaId), manifestList);
        String snapshotJson = SnapshotParser.toJson((Snapshot)snapshot, (boolean)false);
        String expected = String.format("{\"action\":\"%s\",\"snapshot\":%s}", action, snapshotJson);
        MetadataUpdate.AddSnapshot update = new MetadataUpdate.AddSnapshot((Snapshot)snapshot);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Add snapshot should serialize to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testAddSnapshotFromJson() throws IOException {
        String action = "add-snapshot";
        long parentId = 1L;
        long snapshotId = 2L;
        int schemaId = 3;
        ImmutableMap summary = ImmutableMap.of((Object)"files-added", (Object)"4", (Object)"files-deleted", (Object)"100");
        String manifestList = this.createManifestListWithManifestFiles(snapshotId, parentId);
        BaseSnapshot snapshot = new BaseSnapshot(0L, snapshotId, Long.valueOf(parentId), System.currentTimeMillis(), "replace", (Map)summary, Integer.valueOf(schemaId), manifestList);
        String snapshotJson = SnapshotParser.toJson((Snapshot)snapshot, (boolean)false);
        String json = String.format("{\"action\":\"%s\",\"snapshot\":%s}", action, snapshotJson);
        MetadataUpdate.AddSnapshot expected = new MetadataUpdate.AddSnapshot((Snapshot)snapshot);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testRemoveSnapshotsFromJson() {
        String action = "remove-snapshots";
        long snapshotId = 2L;
        String json = String.format("{\"action\":\"%s\",\"snapshot-ids\":[2]}", action);
        MetadataUpdate.RemoveSnapshot expected = new MetadataUpdate.RemoveSnapshot(snapshotId);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testRemoveSnapshotsToJson() {
        String action = "remove-snapshots";
        long snapshotId = 2L;
        String expected = String.format("{\"action\":\"%s\",\"snapshot-ids\":[2]}", action);
        MetadataUpdate.RemoveSnapshot update = new MetadataUpdate.RemoveSnapshot(snapshotId);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Remove snapshots should serialize to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testRemoveSnapshotRefFromJson() {
        String action = "remove-snapshot-ref";
        String snapshotRef = "snapshot-ref";
        String json = "{\"action\":\"remove-snapshot-ref\",\"ref-name\":\"snapshot-ref\"}";
        MetadataUpdate.RemoveSnapshotRef expected = new MetadataUpdate.RemoveSnapshotRef(snapshotRef);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testRemoveSnapshotRefToJson() {
        String snapshotRef = "snapshot-ref";
        String expected = "{\"action\":\"remove-snapshot-ref\",\"ref-name\":\"snapshot-ref\"}";
        MetadataUpdate.RemoveSnapshotRef actual = new MetadataUpdate.RemoveSnapshotRef(snapshotRef);
        Assert.assertEquals((String)"RemoveSnapshotRef should convert to the correct JSON value", (Object)expected, (Object)MetadataUpdateParser.toJson((MetadataUpdate)actual));
    }

    @Test
    public void testSetSnapshotRefTagFromJsonDefault_NullValuesMissing() {
        String action = "set-snapshot-ref";
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.TAG;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = null;
        String json = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"tag\"}";
        MetadataUpdate.SetSnapshotRef expected = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetSnapshotRefTagFromJsonDefault_ExplicitNullValues() {
        String action = "set-snapshot-ref";
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.TAG;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = null;
        String json = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"tag\",\"min-snapshots-to-keep\":null,\"max-snapshot-age-ms\":null,\"max-ref-age-ms\":null}";
        MetadataUpdate.SetSnapshotRef expected = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetSnapshotRefTagFromJsonAllFields_NullValuesMissing() {
        String action = "set-snapshot-ref";
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.TAG;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = 1L;
        String json = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"tag\",\"max-ref-age-ms\":1}";
        MetadataUpdate.SetSnapshotRef expected = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetSnapshotRefTagFromJsonAllFields_ExplicitNullValues() {
        String action = "set-snapshot-ref";
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.TAG;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = 1L;
        String json = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"tag\",\"max-ref-age-ms\":1,\"min-snapshots-to-keep\":null,\"max-snapshot-age-ms\":null}";
        MetadataUpdate.SetSnapshotRef expected = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetSnapshotRefBranchFromJsonDefault_NullValuesMissing() {
        String action = "set-snapshot-ref";
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.BRANCH;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = null;
        String json = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"bRaNch\"}";
        MetadataUpdate.SetSnapshotRef expected = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetSnapshotRefBranchFromJsonDefault_ExplicitNullValues() {
        String action = "set-snapshot-ref";
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.BRANCH;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = null;
        String json = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"bRaNch\",\"max-ref-age-ms\":null,\"min-snapshots-to-keep\":null,\"max-snapshot-age-ms\":null}";
        MetadataUpdate.SetSnapshotRef expected = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testBranchFromJsonAllFields() {
        String action = "set-snapshot-ref";
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.BRANCH;
        String refName = "hank";
        Integer minSnapshotsToKeep = 2;
        Long maxSnapshotAgeMs = 3L;
        Long maxRefAgeMs = 4L;
        String json = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"branch\",\"min-snapshots-to-keep\":2,\"max-snapshot-age-ms\":3,\"max-ref-age-ms\":4}";
        MetadataUpdate.SetSnapshotRef expected = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetSnapshotRefTagToJsonDefault() {
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.TAG;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = null;
        String expected = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"tag\"}";
        MetadataUpdate.SetSnapshotRef update = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set snapshot ref should serialize to the correct JSON value for tag with default fields", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetSnapshotRefTagToJsonAllFields() {
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.TAG;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = 1L;
        String expected = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"tag\",\"max-ref-age-ms\":1}";
        MetadataUpdate.SetSnapshotRef update = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set snapshot ref should serialize to the correct JSON value for tag with all fields", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetSnapshotRefBranchToJsonDefault() {
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.BRANCH;
        String refName = "hank";
        Integer minSnapshotsToKeep = null;
        Long maxSnapshotAgeMs = null;
        Long maxRefAgeMs = null;
        String expected = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"branch\"}";
        MetadataUpdate.SetSnapshotRef update = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set snapshot ref should serialize to the correct JSON value for branch with default fields", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetSnapshotRefBranchToJsonAllFields() {
        long snapshotId = 1L;
        SnapshotRefType type = SnapshotRefType.BRANCH;
        String refName = "hank";
        Integer minSnapshotsToKeep = 2;
        Long maxSnapshotAgeMs = 3L;
        Long maxRefAgeMs = 4L;
        String expected = "{\"action\":\"set-snapshot-ref\",\"ref-name\":\"hank\",\"snapshot-id\":1,\"type\":\"branch\",\"min-snapshots-to-keep\":2,\"max-snapshot-age-ms\":3,\"max-ref-age-ms\":4}";
        MetadataUpdate.SetSnapshotRef update = new MetadataUpdate.SetSnapshotRef(refName, Long.valueOf(snapshotId), type, minSnapshotsToKeep, maxSnapshotAgeMs, maxRefAgeMs);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set snapshot ref should serialize to the correct JSON value for branch with all fields", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetPropertiesFromJson() {
        String action = "set-properties";
        ImmutableMap props = ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2");
        String propsMap = "{\"prop1\":\"val1\",\"prop2\":\"val2\"}";
        String json = String.format("{\"action\":\"%s\",\"updated\":%s}", action, propsMap);
        MetadataUpdate.SetProperties expected = new MetadataUpdate.SetProperties((Map)props);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
        json = String.format("{\"action\":\"%s\",\"updates\":%s}", action, propsMap);
        expected = new MetadataUpdate.SetProperties((Map)props);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
        json = String.format("{\"action\":\"%s\",\"updates\":%s,\"updated\":{\"propX\":\"valX\"}}", action, propsMap);
        expected = new MetadataUpdate.SetProperties((Map)props);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetPropertiesFromJsonFailsWhenDeserializingNullValues() {
        String action = "set-properties";
        HashMap props = Maps.newHashMap();
        props.put("prop1", "val1");
        props.put("prop2", null);
        String propsMap = "{\"prop1\":\"val1\",\"prop2\":null}";
        String json = String.format("{\"action\":\"%s\",\"updated\":%s}", action, propsMap);
        AssertHelpers.assertThrows((String)"Parsing updates from SetProperties with a property set to null should throw", IllegalArgumentException.class, (String)"Cannot parse to a string value: prop2: null", () -> MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetPropertiesToJson() {
        String action = "set-properties";
        ImmutableMap props = ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2");
        String propsMap = "{\"prop1\":\"val1\",\"prop2\":\"val2\"}";
        String expected = String.format("{\"action\":\"%s\",\"updates\":%s}", action, propsMap);
        MetadataUpdate.SetProperties update = new MetadataUpdate.SetProperties((Map)props);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Set properties should serialize to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testRemovePropertiesFromJson() {
        String action = "remove-properties";
        ImmutableSet toRemove = ImmutableSet.of((Object)"prop1", (Object)"prop2");
        String toRemoveAsJSON = "[\"prop1\",\"prop2\"]";
        String json = String.format("{\"action\":\"%s\",\"removed\":%s}", action, toRemoveAsJSON);
        MetadataUpdate.RemoveProperties expected = new MetadataUpdate.RemoveProperties((Set)toRemove);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
        json = String.format("{\"action\":\"%s\",\"removals\":%s}", action, toRemoveAsJSON);
        expected = new MetadataUpdate.RemoveProperties((Set)toRemove);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
        json = String.format("{\"action\":\"%s\",\"removals\":%s,\"removed\": [\"propX\"]}", action, toRemoveAsJSON);
        expected = new MetadataUpdate.RemoveProperties((Set)toRemove);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testRemovePropertiesToJson() {
        String action = "remove-properties";
        ImmutableSet toRemove = ImmutableSet.of((Object)"prop1", (Object)"prop2");
        String toRemoveAsJSON = "[\"prop1\",\"prop2\"]";
        String expected = String.format("{\"action\":\"%s\",\"removals\":%s}", action, toRemoveAsJSON);
        MetadataUpdate.RemoveProperties update = new MetadataUpdate.RemoveProperties((Set)toRemove);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Remove properties should serialize to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetLocationFromJson() {
        String action = "set-location";
        String location = "s3://bucket/warehouse/tbl_location";
        String json = String.format("{\"action\":\"%s\",\"location\":\"%s\"}", action, location);
        MetadataUpdate.SetLocation expected = new MetadataUpdate.SetLocation(location);
        this.assertEquals(action, (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
    }

    @Test
    public void testSetLocationToJson() {
        String action = "set-location";
        String location = "s3://bucket/warehouse/tbl_location";
        String expected = String.format("{\"action\":\"%s\",\"location\":\"%s\"}", action, location);
        MetadataUpdate.SetLocation update = new MetadataUpdate.SetLocation(location);
        String actual = MetadataUpdateParser.toJson((MetadataUpdate)update);
        Assert.assertEquals((String)"Remove properties should serialize to the correct JSON value", (Object)expected, (Object)actual);
    }

    @Test
    public void testSetStatistics() {
        String json = "{\"action\":\"set-statistics\",\"snapshot-id\":1940541653261589030,\"statistics\":{\"snapshot-id\":1940541653261589030,\"statistics-path\":\"s3://bucket/warehouse/stats.puffin\",\"file-size-in-bytes\":124,\"file-footer-size-in-bytes\":27,\"blob-metadata\":[{\"type\":\"boring-type\",\"snapshot-id\":1940541653261589030,\"sequence-number\":2,\"fields\":[1],\"properties\":{\"prop-key\":\"prop-value\"}}]}}";
        long snapshotId = 1940541653261589030L;
        MetadataUpdate.SetStatistics expected = new MetadataUpdate.SetStatistics(snapshotId, (StatisticsFile)new GenericStatisticsFile(snapshotId, "s3://bucket/warehouse/stats.puffin", 124L, 27L, (List)ImmutableList.of((Object)new GenericBlobMetadata("boring-type", snapshotId, 2L, (List)ImmutableList.of((Object)1), (Map)ImmutableMap.of((Object)"prop-key", (Object)"prop-value")))));
        this.assertEquals("set-statistics", (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
        Assert.assertEquals((String)"Set statistics should convert to the correct JSON value", (Object)json, (Object)MetadataUpdateParser.toJson((MetadataUpdate)expected));
    }

    @Test
    public void testRemoveStatistics() {
        String json = "{\"action\":\"remove-statistics\",\"snapshot-id\":1940541653261589030}";
        MetadataUpdate.RemoveStatistics expected = new MetadataUpdate.RemoveStatistics(1940541653261589030L);
        this.assertEquals("remove-statistics", (MetadataUpdate)expected, MetadataUpdateParser.fromJson((String)json));
        Assert.assertEquals((String)"Remove statistics should convert to the correct JSON value", (Object)json, (Object)MetadataUpdateParser.toJson((MetadataUpdate)expected));
    }

    public void assertEquals(String action, MetadataUpdate expectedUpdate, MetadataUpdate actualUpdate) {
        switch (action) {
            case "assign-uuid": {
                TestMetadataUpdateParser.assertEqualsAssignUUID((MetadataUpdate.AssignUUID)expectedUpdate, (MetadataUpdate.AssignUUID)actualUpdate);
                break;
            }
            case "upgrade-format-version": {
                TestMetadataUpdateParser.assertEqualsUpgradeFormatVersion((MetadataUpdate.UpgradeFormatVersion)expectedUpdate, (MetadataUpdate.UpgradeFormatVersion)actualUpdate);
                break;
            }
            case "add-schema": {
                TestMetadataUpdateParser.assertEqualsAddSchema((MetadataUpdate.AddSchema)expectedUpdate, (MetadataUpdate.AddSchema)actualUpdate);
                break;
            }
            case "set-current-schema": {
                TestMetadataUpdateParser.assertEqualsSetCurrentSchema((MetadataUpdate.SetCurrentSchema)expectedUpdate, (MetadataUpdate.SetCurrentSchema)actualUpdate);
                break;
            }
            case "add-spec": {
                TestMetadataUpdateParser.assertEqualsAddPartitionSpec((MetadataUpdate.AddPartitionSpec)expectedUpdate, (MetadataUpdate.AddPartitionSpec)actualUpdate);
                break;
            }
            case "set-default-spec": {
                TestMetadataUpdateParser.assertEqualsSetDefaultPartitionSpec((MetadataUpdate.SetDefaultPartitionSpec)expectedUpdate, (MetadataUpdate.SetDefaultPartitionSpec)actualUpdate);
                break;
            }
            case "add-sort-order": {
                TestMetadataUpdateParser.assertEqualsAddSortOrder((MetadataUpdate.AddSortOrder)expectedUpdate, (MetadataUpdate.AddSortOrder)actualUpdate);
                break;
            }
            case "set-default-sort-order": {
                TestMetadataUpdateParser.assertEqualsSetDefaultSortOrder((MetadataUpdate.SetDefaultSortOrder)expectedUpdate, (MetadataUpdate.SetDefaultSortOrder)actualUpdate);
                break;
            }
            case "set-statistics": {
                TestMetadataUpdateParser.assertEqualsSetStatistics((MetadataUpdate.SetStatistics)expectedUpdate, (MetadataUpdate.SetStatistics)actualUpdate);
                break;
            }
            case "remove-statistics": {
                TestMetadataUpdateParser.assertEqualsRemoveStatistics((MetadataUpdate.RemoveStatistics)expectedUpdate, (MetadataUpdate.RemoveStatistics)actualUpdate);
                break;
            }
            case "add-snapshot": {
                TestMetadataUpdateParser.assertEqualsAddSnapshot((MetadataUpdate.AddSnapshot)expectedUpdate, (MetadataUpdate.AddSnapshot)actualUpdate);
                break;
            }
            case "remove-snapshots": {
                TestMetadataUpdateParser.assertEqualsRemoveSnapshots((MetadataUpdate.RemoveSnapshot)expectedUpdate, (MetadataUpdate.RemoveSnapshot)actualUpdate);
                break;
            }
            case "remove-snapshot-ref": {
                TestMetadataUpdateParser.assertEqualsRemoveSnapshotRef((MetadataUpdate.RemoveSnapshotRef)expectedUpdate, (MetadataUpdate.RemoveSnapshotRef)actualUpdate);
                break;
            }
            case "set-snapshot-ref": {
                TestMetadataUpdateParser.assertEqualsSetSnapshotRef((MetadataUpdate.SetSnapshotRef)expectedUpdate, (MetadataUpdate.SetSnapshotRef)actualUpdate);
                break;
            }
            case "set-properties": {
                TestMetadataUpdateParser.assertEqualsSetProperties((MetadataUpdate.SetProperties)expectedUpdate, (MetadataUpdate.SetProperties)actualUpdate);
                break;
            }
            case "remove-properties": {
                TestMetadataUpdateParser.assertEqualsRemoveProperties((MetadataUpdate.RemoveProperties)expectedUpdate, (MetadataUpdate.RemoveProperties)actualUpdate);
                break;
            }
            case "set-location": {
                TestMetadataUpdateParser.assertEqualsSetLocation((MetadataUpdate.SetLocation)expectedUpdate, (MetadataUpdate.SetLocation)actualUpdate);
                break;
            }
            default: {
                Assert.fail((String)("Unrecognized metadata update action: " + action));
            }
        }
    }

    private static void assertEqualsAssignUUID(MetadataUpdate.AssignUUID expected, MetadataUpdate.AssignUUID actual) {
        Assert.assertEquals((String)"UUIDs should be equal", (Object)expected.uuid(), (Object)actual.uuid());
    }

    private static void assertEqualsUpgradeFormatVersion(MetadataUpdate.UpgradeFormatVersion expected, MetadataUpdate.UpgradeFormatVersion actual) {
        Assert.assertEquals((String)"Format version should be equal", (long)expected.formatVersion(), (long)actual.formatVersion());
    }

    private static void assertEqualsAddSchema(MetadataUpdate.AddSchema expected, MetadataUpdate.AddSchema actual) {
        Assert.assertTrue((String)"Schemas should be the same", (boolean)expected.schema().sameSchema(actual.schema()));
        Assert.assertEquals((String)"Last column id should be equal", (long)expected.lastColumnId(), (long)actual.lastColumnId());
    }

    private static void assertEqualsSetCurrentSchema(MetadataUpdate.SetCurrentSchema expected, MetadataUpdate.SetCurrentSchema actual) {
        Assert.assertEquals((String)"Schema id should be equal", (long)expected.schemaId(), (long)actual.schemaId());
    }

    private static void assertEqualsSetDefaultPartitionSpec(MetadataUpdate.SetDefaultPartitionSpec expected, MetadataUpdate.SetDefaultPartitionSpec actual) {
        Assertions.assertThat((int)actual.specId()).isEqualTo(expected.specId());
    }

    private static void assertEqualsAddPartitionSpec(MetadataUpdate.AddPartitionSpec expected, MetadataUpdate.AddPartitionSpec actual) {
        Assert.assertEquals((String)"Unbound partition specs should have the same spec id", (long)expected.spec().specId(), (long)actual.spec().specId());
        Assert.assertEquals((String)"Unbound partition specs should have the same number of fields", (long)expected.spec().fields().size(), (long)actual.spec().fields().size());
        IntStream.range(0, expected.spec().fields().size()).forEachOrdered(i -> {
            UnboundPartitionSpec.UnboundPartitionField expectedField = (UnboundPartitionSpec.UnboundPartitionField)expected.spec().fields().get(i);
            UnboundPartitionSpec.UnboundPartitionField actualField = (UnboundPartitionSpec.UnboundPartitionField)actual.spec().fields().get(i);
            Assert.assertTrue((String)"Fields of the unbound partition spec should be the same", (Objects.equals(expectedField.partitionId(), actualField.partitionId()) && expectedField.name().equals(actualField.name()) && Objects.equals(expectedField.transformAsString(), actualField.transformAsString()) && expectedField.sourceId() == actualField.sourceId() ? 1 : 0) != 0);
        });
    }

    private static void assertEqualsAddSortOrder(MetadataUpdate.AddSortOrder expected, MetadataUpdate.AddSortOrder actual) {
        Assert.assertEquals((String)"Order id of the sort order should be the same", (long)expected.sortOrder().orderId(), (long)actual.sortOrder().orderId());
        Assert.assertEquals((String)"Sort orders should have the same number of fields", (long)expected.sortOrder().fields().size(), (long)actual.sortOrder().fields().size());
        IntStream.range(0, expected.sortOrder().fields().size()).forEachOrdered(i -> {
            UnboundSortOrder.UnboundSortField expectedField = (UnboundSortOrder.UnboundSortField)expected.sortOrder().fields().get(i);
            UnboundSortOrder.UnboundSortField actualField = (UnboundSortOrder.UnboundSortField)actual.sortOrder().fields().get(i);
            Assert.assertTrue((String)"Fields of the sort order should be the same", (expectedField.sourceId() == actualField.sourceId() && expectedField.nullOrder().equals((Object)actualField.nullOrder()) && expectedField.direction().equals((Object)actualField.direction()) && Objects.equals(expectedField.transformAsString(), actualField.transformAsString()) ? 1 : 0) != 0);
        });
    }

    private static void assertEqualsSetDefaultSortOrder(MetadataUpdate.SetDefaultSortOrder expected, MetadataUpdate.SetDefaultSortOrder actual) {
        Assert.assertEquals((String)"Sort order id should be the same", (long)expected.sortOrderId(), (long)actual.sortOrderId());
    }

    private static void assertEqualsSetStatistics(MetadataUpdate.SetStatistics expected, MetadataUpdate.SetStatistics actual) {
        Assert.assertEquals((String)"Snapshot IDs should be equal", (long)expected.snapshotId(), (long)actual.snapshotId());
        Assert.assertEquals((String)"Statistics files snapshot IDs should be equal", (long)expected.statisticsFile().snapshotId(), (long)actual.statisticsFile().snapshotId());
        Assert.assertEquals((String)"Statistics files paths should be equal", (Object)expected.statisticsFile().path(), (Object)actual.statisticsFile().path());
        Assert.assertEquals((String)"Statistics files size should be equal", (long)expected.statisticsFile().fileSizeInBytes(), (long)actual.statisticsFile().fileSizeInBytes());
        Assert.assertEquals((String)"Statistics files footer size should be equal", (long)expected.statisticsFile().fileFooterSizeInBytes(), (long)actual.statisticsFile().fileFooterSizeInBytes());
        Assert.assertEquals((String)"Statistics blob list size should be equal", (long)expected.statisticsFile().blobMetadata().size(), (long)actual.statisticsFile().blobMetadata().size());
        Streams.zip(expected.statisticsFile().blobMetadata().stream(), actual.statisticsFile().blobMetadata().stream(), Pair::of).forEachOrdered(pair -> {
            BlobMetadata expectedBlob = (BlobMetadata)pair.first();
            BlobMetadata actualBlob = (BlobMetadata)pair.second();
            Assert.assertEquals((String)"Expected blob type should be equal", (Object)expectedBlob.type(), (Object)actualBlob.type());
            Assert.assertEquals((String)"Expected blob fields should be equal", (Object)expectedBlob.fields(), (Object)actualBlob.fields());
            Assert.assertEquals((String)"Expected blob source snapshot ID should be equal", (long)expectedBlob.sourceSnapshotId(), (long)actualBlob.sourceSnapshotId());
            Assert.assertEquals((String)"Expected blob source snapshot sequence number should be equal", (long)expectedBlob.sourceSnapshotSequenceNumber(), (long)actualBlob.sourceSnapshotSequenceNumber());
            Assert.assertEquals((String)"Expected blob properties should be equal", (Object)expectedBlob.properties(), (Object)actualBlob.properties());
        });
    }

    private static void assertEqualsRemoveStatistics(MetadataUpdate.RemoveStatistics expected, MetadataUpdate.RemoveStatistics actual) {
        Assert.assertEquals((String)"Snapshots to remove should be the same", (long)expected.snapshotId(), (long)actual.snapshotId());
    }

    private static void assertEqualsAddSnapshot(MetadataUpdate.AddSnapshot expected, MetadataUpdate.AddSnapshot actual) {
        Assert.assertEquals((String)"Snapshot ID should be equal", (long)expected.snapshot().snapshotId(), (long)actual.snapshot().snapshotId());
        Assert.assertEquals((String)"Manifest list location should be equal", (Object)expected.snapshot().manifestListLocation(), (Object)actual.snapshot().manifestListLocation());
        ((MapAssert)Assertions.assertThat((Map)actual.snapshot().summary()).as("Snapshot summary should be equivalent", new Object[0])).containsExactlyEntriesOf(expected.snapshot().summary());
        Assert.assertEquals((String)"Snapshot Parent ID should be equal", (Object)expected.snapshot().parentId(), (Object)actual.snapshot().parentId());
        Assert.assertEquals((String)"Snapshot timestamp should be equal", (long)expected.snapshot().timestampMillis(), (long)actual.snapshot().timestampMillis());
        Assert.assertEquals((String)"Snapshot schema id should be equal", (Object)expected.snapshot().schemaId(), (Object)actual.snapshot().schemaId());
    }

    private static void assertEqualsRemoveSnapshots(MetadataUpdate.RemoveSnapshot expected, MetadataUpdate.RemoveSnapshot actual) {
        Assert.assertEquals((String)"Snapshots to remove should be the same", (long)expected.snapshotId(), (long)actual.snapshotId());
    }

    private static void assertEqualsSetSnapshotRef(MetadataUpdate.SetSnapshotRef expected, MetadataUpdate.SetSnapshotRef actual) {
        Assert.assertNotNull((String)"Snapshot ref name should not be null", (Object)actual.name());
        Assert.assertEquals((String)"Snapshot ref name should be equal", (Object)expected.name(), (Object)actual.name());
        Assert.assertEquals((String)"Snapshot ID should be equal", (long)expected.snapshotId(), (long)actual.snapshotId());
        Assert.assertNotNull((String)"Snapshot reference type should not be null", (Object)actual.type());
        Assert.assertEquals((String)"Snapshot reference type should be equal", (Object)expected.type(), (Object)actual.type());
        Assert.assertEquals((String)"Min snapshots to keep should be equal when present and null when missing or explicitly null", (Object)expected.minSnapshotsToKeep(), (Object)actual.minSnapshotsToKeep());
        Assert.assertEquals((String)"Max snapshot age ms should be equal when present and null when missing or explicitly null", (Object)expected.maxSnapshotAgeMs(), (Object)actual.maxSnapshotAgeMs());
        Assert.assertEquals((String)"Max ref age ms should be equal when present and null when missing or explicitly null", (Object)expected.maxRefAgeMs(), (Object)actual.maxRefAgeMs());
    }

    private static void assertEqualsRemoveSnapshotRef(MetadataUpdate.RemoveSnapshotRef expected, MetadataUpdate.RemoveSnapshotRef actual) {
        Assertions.assertThat((String)actual.name()).isEqualTo(expected.name());
    }

    private static void assertEqualsSetProperties(MetadataUpdate.SetProperties expected, MetadataUpdate.SetProperties actual) {
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)actual.updated()).as("Properties to set / update should not be null", new Object[0])).isNotNull()).as("Properties to set / update should be the same", new Object[0])).containsExactlyInAnyOrderEntriesOf(expected.updated());
    }

    private static void assertEqualsRemoveProperties(MetadataUpdate.RemoveProperties expected, MetadataUpdate.RemoveProperties actual) {
        ((AbstractCollectionAssert)((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)actual.removed()).as("Properties to remove should not be null", new Object[0])).isNotNull()).as("Properties to remove should be equal", new Object[0])).containsExactlyInAnyOrderElementsOf((Iterable)expected.removed());
    }

    private static void assertEqualsSetLocation(MetadataUpdate.SetLocation expected, MetadataUpdate.SetLocation actual) {
        Assert.assertEquals((String)"Location should be the same", (Object)expected.location(), (Object)actual.location());
    }

    private String createManifestListWithManifestFiles(long snapshotId, Long parentSnapshotId) throws IOException {
        File manifestList = this.temp.newFile("manifests" + UUID.randomUUID());
        manifestList.deleteOnExit();
        ImmutableList manifests = ImmutableList.of((Object)new GenericManifestFile(Files.localInput((String)"file:/tmp/manifest1.avro"), 0), (Object)new GenericManifestFile(Files.localInput((String)"file:/tmp/manifest2.avro"), 0));
        try (ManifestListWriter writer = ManifestLists.write((int)1, (OutputFile)Files.localOutput((File)manifestList), (long)snapshotId, (Long)parentSnapshotId, (long)0L);){
            writer.addAll((Iterable)manifests);
        }
        return Files.localInput((File)manifestList).location();
    }
}

