/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.iceberg.AllDataFilesTable;
import org.apache.iceberg.AllEntriesTable;
import org.apache.iceberg.AllManifestsTable;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetadataTableScanTestBase;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestMetadataTableScansWithPartitionEvolution
extends MetadataTableScanTestBase {
    public TestMetadataTableScansWithPartitionEvolution(int formatVersion) {
        super(formatVersion);
    }

    @Before
    public void createTable() throws IOException {
        TestTables.clearTables();
        this.tableDir = this.temp.newFolder();
        this.tableDir.delete();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get())}))});
        this.metadataDir = new File(this.tableDir, "metadata");
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("id").build();
        this.table = this.create(schema, spec);
        this.table.newFastAppend().appendFile(this.newDataFile("id=0")).appendFile(this.newDataFile("id=1")).commit();
        this.table.updateSpec().addField("nested.id").commit();
        this.table.newFastAppend().appendFile(this.newDataFile("id=2/nested.id=2")).appendFile(this.newDataFile("id=3/nested.id=3")).commit();
    }

    @Test
    public void testManifestsTableWithAddPartitionOnNestedField() throws IOException {
        ManifestsTable manifestsTable = new ManifestsTable((Table)this.table);
        TableScan scan = manifestsTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assertions.assertThat((Iterable)tasks).hasSize(1);
            Assertions.assertThat(this.allRows((Iterable<FileScanTask>)tasks)).hasSize(2);
        }
    }

    @Test
    public void testDataFilesTableWithAddPartitionOnNestedField() throws IOException {
        DataFilesTable dataFilesTable = new DataFilesTable((Table)this.table);
        TableScan scan = dataFilesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assertions.assertThat((Iterable)tasks).hasSize(2);
            Assertions.assertThat(this.allRows((Iterable<FileScanTask>)tasks)).hasSize(4);
        }
    }

    @Test
    public void testManifestEntriesWithAddPartitionOnNestedField() throws IOException {
        ManifestEntriesTable manifestEntriesTable = new ManifestEntriesTable((Table)this.table);
        TableScan scan = manifestEntriesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assertions.assertThat((Iterable)tasks).hasSize(2);
            Assertions.assertThat(this.allRows((Iterable<FileScanTask>)tasks)).hasSize(4);
        }
    }

    @Test
    public void testAllDataFilesTableWithAddPartitionOnNestedField() throws IOException {
        AllDataFilesTable allDataFilesTable = new AllDataFilesTable((Table)this.table);
        TableScan scan = allDataFilesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assertions.assertThat((Iterable)tasks).hasSize(2);
            Assertions.assertThat(this.allRows((Iterable<FileScanTask>)tasks)).hasSize(4);
        }
    }

    @Test
    public void testAllEntriesTableWithAddPartitionOnNestedField() throws IOException {
        AllEntriesTable allEntriesTable = new AllEntriesTable((Table)this.table);
        TableScan scan = allEntriesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assertions.assertThat((Iterable)tasks).hasSize(2);
            Assertions.assertThat(this.allRows((Iterable<FileScanTask>)tasks)).hasSize(4);
        }
    }

    @Test
    public void testAllManifestsTableWithAddPartitionOnNestedField() throws IOException {
        AllManifestsTable allManifestsTable = new AllManifestsTable((Table)this.table);
        TableScan scan = allManifestsTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assertions.assertThat((Iterable)tasks).hasSize(2);
            Assertions.assertThat(this.allRows((Iterable<FileScanTask>)tasks)).hasSize(3);
        }
    }

    @Test
    public void testPartitionsTableScanWithAddPartitionOnNestedField() throws IOException {
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Types.StructType idPartition = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"partition", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1001, (String)"nested.id", (Type)Types.IntegerType.get())}))}).asStruct();
        TableScan scanNoFilter = (TableScan)partitionsTable.newScan().select(new String[]{"partition"});
        Assert.assertEquals((Object)idPartition, (Object)scanNoFilter.schema().asStruct());
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanNoFilter));
        Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        this.validatePartition(files, 0, 0);
        this.validatePartition(files, 0, 1);
        this.validatePartition(files, 0, 2);
        this.validatePartition(files, 0, 3);
        this.validatePartition(files, 1, 2);
        this.validatePartition(files, 1, 3);
    }

    @Test
    public void testPositionDeletesPartitionSpecRemoval() {
        Assume.assumeTrue((String)"Position deletes supported only for v2 tables", (this.formatVersion == 2 ? 1 : 0) != 0);
        this.table.updateSpec().removeField("id").commit();
        DeleteFile deleteFile = this.newDeleteFile(this.table.ops().current().spec().specId(), "nested.id=1");
        this.table.newRowDelta().addDeletes(deleteFile).commit();
        PositionDeletesTable positionDeletesTable = new PositionDeletesTable((Table)this.table);
        Expression expression = Expressions.and((Expression)Expressions.equal((String)"partition.nested.id", (Object)1), (Expression)Expressions.greaterThan((String)"pos", (Object)0));
        BatchScan scan = (BatchScan)positionDeletesTable.newBatchScan().filter(expression);
        Assertions.assertThat((Object)scan).isInstanceOf(PositionDeletesTable.PositionDeletesBatchScan.class);
        ArrayList tasks = Lists.newArrayList((Iterable)scan.planFiles());
        Assertions.assertThat((List)tasks).hasSize(1);
        ScanTask task = (ScanTask)tasks.get(0);
        Assertions.assertThat((Object)task).isInstanceOf(PositionDeletesScanTask.class);
        Types.StructType partitionType = Partitioning.partitionType((Table)this.table);
        PositionDeletesScanTask posDeleteTask = (PositionDeletesScanTask)task;
        int filePartition = (Integer)((DeleteFile)posDeleteTask.file()).partition().get(0, Integer.class);
        Assert.assertEquals((String)"Expected correct partition on task", (long)1L, (long)filePartition);
        int taskConstantPartition = (Integer)((StructLike)this.constantsMap(posDeleteTask, partitionType).get(0x7FFFFFFA)).get(1, Integer.class);
        Assert.assertEquals((String)"Expected correct partition on constant column", (long)1L, (long)taskConstantPartition);
        Assert.assertEquals((String)"Expected correct partition field id on task's spec", (long)((Types.NestedField)this.table.ops().current().spec().partitionType().fields().get(0)).fieldId(), (long)((PartitionField)posDeleteTask.spec().fields().get(0)).fieldId());
        Assert.assertEquals((String)"Expected correct partition spec id on task", (long)this.table.ops().current().spec().specId(), (long)((DeleteFile)posDeleteTask.file()).specId());
        Assert.assertEquals((String)"Expected correct partition spec id on constant column", (Object)this.table.ops().current().spec().specId(), this.constantsMap(posDeleteTask, partitionType).get(MetadataColumns.SPEC_ID.fieldId()));
        Assert.assertEquals((String)"Expected correct delete file on task", (Object)deleteFile.path(), (Object)((DeleteFile)posDeleteTask.file()).path());
        Assert.assertEquals((String)"Expected correct delete file on constant column", (Object)deleteFile.path(), this.constantsMap(posDeleteTask, partitionType).get(MetadataColumns.FILE_PATH.fieldId()));
    }

    @Test
    public void testPartitionSpecEvolutionToUnpartitioned() throws IOException {
        this.table.updateSpec().removeField("id").removeField("nested.id").commit();
        DataFile dataFile = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-10.parquet").withRecordCount(10L).withFileSizeInBytes(10L).build();
        this.table.newFastAppend().appendFile(dataFile).commit();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Assertions.assertThat((Object)partitionsTable.schema().findField("partition")).isNotNull();
        try (CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)partitionsTable.newScan()));){
            Assertions.assertThat((Iterable)files).hasSize(5);
            Assertions.assertThat(StreamSupport.stream(files.spliterator(), false)).anyMatch(file -> {
                StructLike partition = file.partition();
                return Objects.equals(null, partition.get(0, Object.class));
            });
        }
    }

    private Stream<StructLike> allRows(Iterable<FileScanTask> tasks) {
        return Streams.stream(tasks).flatMap(task -> Streams.stream((Iterable)task.asDataTask().rows()));
    }
}

