/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.AllDataFilesTable;
import org.apache.iceberg.AllEntriesTable;
import org.apache.iceberg.AllManifestsTable;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFilesTable;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.FilesTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetadataTableScanTestBase;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestMetadataTableScans
extends MetadataTableScanTestBase {
    public TestMetadataTableScans(int formatVersion) {
        super(formatVersion);
    }

    private void preparePartitionedTable() {
        this.preparePartitionedTableData();
        if (this.formatVersion == 2) {
            this.table.newRowDelta().addDeletes(FILE_A_DELETES).commit();
            this.table.newRowDelta().addDeletes(FILE_B_DELETES).commit();
            this.table.newRowDelta().addDeletes(FILE_C2_DELETES).commit();
            this.table.newRowDelta().addDeletes(FILE_D2_DELETES).commit();
        }
    }

    private void preparePartitionedTableData() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        this.table.newFastAppend().appendFile(FILE_D).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
    }

    @Test
    public void testManifestsTableWithDroppedPartition() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        ManifestsTable manifestsTable = new ManifestsTable((Table)this.table);
        TableScan scan = manifestsTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assert.assertEquals((String)"Should have one task", (long)1L, (long)Iterables.size((Iterable)tasks));
        }
    }

    @Test
    public void testManifestsTableAlwaysIgnoresResiduals() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        ManifestsTable manifestsTable = new ManifestsTable((Table)this.table);
        TableScan scan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.lessThan((String)"length", (Object)10000L));
        try (CloseableIterable tasks = scan.planFiles();){
            Assert.assertTrue((String)"Tasks should not be empty", (Iterables.size((Iterable)tasks) > 0 ? 1 : 0) != 0);
            for (FileScanTask task : tasks) {
                Assert.assertEquals((String)"Residuals must be ignored", (Object)Expressions.alwaysTrue(), (Object)task.residual());
            }
        }
    }

    @Test
    public void testDataFilesTableWithDroppedPartition() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        DataFilesTable dataFilesTable = new DataFilesTable((Table)this.table);
        TableScan scan = dataFilesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assert.assertEquals((String)"Should have one task", (long)1L, (long)Iterables.size((Iterable)tasks));
        }
    }

    @Test
    public void testDataFilesTableHonorsIgnoreResiduals() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        DataFilesTable dataFilesTable = new DataFilesTable((Table)this.table);
        TableScan scan1 = (TableScan)dataFilesTable.newScan().filter((Expression)Expressions.equal((String)"record_count", (Object)1));
        this.validateTaskScanResiduals(scan1, false);
        TableScan scan2 = (TableScan)((TableScan)dataFilesTable.newScan().filter((Expression)Expressions.equal((String)"record_count", (Object)1))).ignoreResiduals();
        this.validateTaskScanResiduals(scan2, true);
    }

    @Test
    public void testManifestEntriesTableHonorsIgnoreResiduals() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        ManifestEntriesTable manifestEntriesTable = new ManifestEntriesTable((Table)this.table);
        TableScan scan1 = (TableScan)manifestEntriesTable.newScan().filter((Expression)Expressions.equal((String)"snapshot_id", (Object)1L));
        this.validateTaskScanResiduals(scan1, false);
        TableScan scan2 = (TableScan)((TableScan)manifestEntriesTable.newScan().filter((Expression)Expressions.equal((String)"snapshot_id", (Object)1L))).ignoreResiduals();
        this.validateTaskScanResiduals(scan2, true);
    }

    @Test
    public void testManifestEntriesTableWithDroppedPartition() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        ManifestEntriesTable manifestEntriesTable = new ManifestEntriesTable((Table)this.table);
        TableScan scan = manifestEntriesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assert.assertEquals((String)"Should have one task", (long)1L, (long)Iterables.size((Iterable)tasks));
        }
    }

    @Test
    public void testAllDataFilesTableHonorsIgnoreResiduals() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        AllDataFilesTable allDataFilesTable = new AllDataFilesTable((Table)this.table);
        TableScan scan1 = (TableScan)allDataFilesTable.newScan().filter((Expression)Expressions.equal((String)"record_count", (Object)1));
        this.validateTaskScanResiduals(scan1, false);
        TableScan scan2 = (TableScan)((TableScan)allDataFilesTable.newScan().filter((Expression)Expressions.equal((String)"record_count", (Object)1))).ignoreResiduals();
        this.validateTaskScanResiduals(scan2, true);
    }

    @Test
    public void testAllDataFilesTableWithDroppedPartition() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        AllDataFilesTable allDataFilesTable = new AllDataFilesTable((Table)this.table);
        TableScan scan = allDataFilesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assert.assertEquals((String)"Should have one task", (long)1L, (long)Iterables.size((Iterable)tasks));
        }
    }

    @Test
    public void testAllEntriesTableHonorsIgnoreResiduals() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        AllEntriesTable allEntriesTable = new AllEntriesTable((Table)this.table);
        TableScan scan1 = (TableScan)allEntriesTable.newScan().filter((Expression)Expressions.equal((String)"snapshot_id", (Object)1L));
        this.validateTaskScanResiduals(scan1, false);
        TableScan scan2 = (TableScan)((TableScan)allEntriesTable.newScan().filter((Expression)Expressions.equal((String)"snapshot_id", (Object)1L))).ignoreResiduals();
        this.validateTaskScanResiduals(scan2, true);
    }

    @Test
    public void testAllEntriesTableWithDroppedPartition() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        AllEntriesTable allEntriesTable = new AllEntriesTable((Table)this.table);
        TableScan scan = allEntriesTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assert.assertEquals((String)"Should have one task", (long)1L, (long)Iterables.size((Iterable)tasks));
        }
    }

    @Test
    public void testAllManifestsTableWithDroppedPartition() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        AllManifestsTable allManifestsTable = new AllManifestsTable((Table)this.table);
        TableScan scan = allManifestsTable.newScan();
        try (CloseableIterable tasks = scan.planFiles();){
            Assert.assertEquals((String)"Should have one task", (long)1L, (long)Iterables.size((Iterable)tasks));
        }
    }

    @Test
    public void testAllManifestsTableHonorsIgnoreResiduals() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        AllManifestsTable allManifestsTable = new AllManifestsTable((Table)this.table);
        TableScan scan1 = (TableScan)allManifestsTable.newScan().filter((Expression)Expressions.lessThan((String)"length", (Object)10000L));
        this.validateTaskScanResiduals(scan1, false);
        TableScan scan2 = (TableScan)((TableScan)allManifestsTable.newScan().filter((Expression)Expressions.lessThan((String)"length", (Object)10000L))).ignoreResiduals();
        this.validateTaskScanResiduals(scan2, true);
    }

    @Test
    public void testPartitionsTableScanNoFilter() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Types.StructType expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"partition", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data_bucket", (Type)Types.IntegerType.get())}))}).asStruct();
        TableScan scanNoFilter = (TableScan)partitionsTable.newScan().select(new String[]{"partition.data_bucket"});
        Assert.assertEquals((Object)expected, (Object)scanNoFilter.schema().asStruct());
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanNoFilter));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)8L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 0);
        this.validateSingleFieldPartition(files, 1);
        this.validateSingleFieldPartition(files, 2);
        this.validateSingleFieldPartition(files, 3);
    }

    @Test
    public void testPartitionsTableScanWithProjection() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Types.StructType expected = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"file_count", (Type)Types.IntegerType.get(), (String)"Count of data files")}).asStruct();
        TableScan scanWithProjection = (TableScan)partitionsTable.newScan().select(new String[]{"file_count"});
        Assert.assertEquals((Object)expected, (Object)scanWithProjection.schema().asStruct());
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanWithProjection));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)8L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 0);
        this.validateSingleFieldPartition(files, 1);
        this.validateSingleFieldPartition(files, 2);
        this.validateSingleFieldPartition(files, 3);
    }

    @Test
    public void testPartitionsTableScanNoStats() {
        this.table.newFastAppend().appendFile(FILE_WITH_STATS).commit();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        CloseableIterable tasksAndEq = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)partitionsTable.newScan()));
        for (ContentFile file : tasksAndEq) {
            Assert.assertNull((Object)file.columnSizes());
            Assert.assertNull((Object)file.valueCounts());
            Assert.assertNull((Object)file.nullValueCounts());
            Assert.assertNull((Object)file.lowerBounds());
            Assert.assertNull((Object)file.upperBounds());
        }
    }

    @Test
    public void testPartitionsTableScanAndFilter() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Expression andEquals = Expressions.and((Expression)Expressions.equal((String)"partition.data_bucket", (Object)0), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        TableScan scanAndEq = (TableScan)partitionsTable.newScan().filter(andEquals);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanAndEq));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 0);
    }

    @Test
    public void testPartitionsTableScanLtFilter() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Expression ltAnd = Expressions.and((Expression)Expressions.lessThan((String)"partition.data_bucket", (Object)2), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        TableScan scanLtAnd = (TableScan)partitionsTable.newScan().filter(ltAnd);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanLtAnd));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 0);
        this.validateSingleFieldPartition(files, 1);
    }

    @Test
    public void testPartitionsTableScanOrFilter() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Expression or = Expressions.or((Expression)Expressions.equal((String)"partition.data_bucket", (Object)2), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        TableScan scanOr = (TableScan)partitionsTable.newScan().filter(or);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanOr));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)8L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 0);
        this.validateSingleFieldPartition(files, 1);
        this.validateSingleFieldPartition(files, 2);
        this.validateSingleFieldPartition(files, 3);
    }

    @Test
    public void testPartitionsScanNotFilter() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Expression not = Expressions.not((Expression)Expressions.lessThan((String)"partition.data_bucket", (Object)2));
        TableScan scanNot = (TableScan)partitionsTable.newScan().filter(not);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanNot));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 2);
        this.validateSingleFieldPartition(files, 3);
    }

    @Test
    public void testPartitionsTableScanInFilter() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        UnboundPredicate set = Expressions.in((String)"partition.data_bucket", (Object[])new Integer[]{2, 3});
        TableScan scanSet = (TableScan)partitionsTable.newScan().filter((Expression)set);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanSet));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 2);
        this.validateSingleFieldPartition(files, 3);
    }

    @Test
    public void testPartitionsTableScanNotNullFilter() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        UnboundPredicate unary = Expressions.notNull((String)"partition.data_bucket");
        TableScan scanUnary = (TableScan)partitionsTable.newScan().filter((Expression)unary);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanUnary));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)8L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        }
        this.validateSingleFieldPartition(files, 0);
        this.validateSingleFieldPartition(files, 1);
        this.validateSingleFieldPartition(files, 2);
        this.validateSingleFieldPartition(files, 3);
    }

    @Test
    public void testFilesTableScanWithDroppedPartition() throws IOException {
        this.preparePartitionedTable();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField("data_bucket_16", (Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.refresh();
        this.table.updateSpec().addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        DataFilesTable dataFilesTable = new DataFilesTable((Table)this.table);
        TableScan scan = dataFilesTable.newScan();
        Schema schema = dataFilesTable.schema();
        Types.StructType actualType = schema.findField(102).type().asStructType();
        Types.StructType expectedType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1000, (String)"data_bucket", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1001, (String)"data_bucket_16", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1002, (String)"data_trunc_2", (Type)Types.StringType.get())});
        Assert.assertEquals((String)"Partition type must match", (Object)expectedType, (Object)actualType);
        Accessor accessor = schema.accessorForField(1000);
        try (CloseableIterable tasks = scan.planFiles();){
            Set results = StreamSupport.stream(tasks.spliterator(), false).flatMap(fileScanTask -> Streams.stream((Iterable)fileScanTask.asDataTask().rows())).map(arg_0 -> ((Accessor)accessor).get(arg_0)).map(i -> (Integer)i).collect(Collectors.toSet());
            Assert.assertEquals((String)"Partition value must match", (Object)Sets.newHashSet((Object[])new Integer[]{0, 1, 2, 3}), results);
        }
    }

    @Test
    public void testDeleteFilesTableSelection() throws IOException {
        Assume.assumeTrue((String)"Only V2 Tables Support Deletes", (this.formatVersion >= 2 ? 1 : 0) != 0);
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newRowDelta().addDeletes(FILE_A_DELETES).addDeletes(FILE_A2_DELETES).commit();
        DeleteFilesTable deleteFilesTable = new DeleteFilesTable((Table)this.table);
        TableScan scan = (TableScan)((TableScan)deleteFilesTable.newScan().filter((Expression)Expressions.equal((String)"record_count", (Object)1))).select(new String[]{"content", "record_count"});
        this.validateTaskScanResiduals(scan, false);
        Types.StructType expected = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)134, (String)"content", (Type)Types.IntegerType.get(), (String)"Contents of the file: 0=data, 1=position deletes, 2=equality deletes"), Types.NestedField.required((int)103, (String)"record_count", (Type)Types.LongType.get(), (String)"Number of records in the file")}).asStruct();
        Assert.assertEquals((Object)expected, (Object)scan.schema().asStruct());
    }

    @Test
    public void testFilesTableReadableMetricsSchema() {
        FilesTable filesTable = new FilesTable((Table)this.table);
        Types.StructType actual = filesTable.newScan().schema().select(new String[]{"readable_metrics"}).asStruct();
        int highestId = filesTable.schema().highestFieldId();
        Types.StructType expected = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)highestId, (String)"readable_metrics", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)(highestId - 14), (String)"data", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)(highestId - 13), (String)"column_size", (Type)Types.LongType.get(), (String)"Total size on disk"), Types.NestedField.optional((int)(highestId - 12), (String)"value_count", (Type)Types.LongType.get(), (String)"Total count, including null and NaN"), Types.NestedField.optional((int)(highestId - 11), (String)"null_value_count", (Type)Types.LongType.get(), (String)"Null value count"), Types.NestedField.optional((int)(highestId - 10), (String)"nan_value_count", (Type)Types.LongType.get(), (String)"NaN value count"), Types.NestedField.optional((int)(highestId - 9), (String)"lower_bound", (Type)Types.StringType.get(), (String)"Lower bound"), Types.NestedField.optional((int)(highestId - 8), (String)"upper_bound", (Type)Types.StringType.get(), (String)"Upper bound")}), (String)"Metrics for column data"), Types.NestedField.optional((int)(highestId - 7), (String)"id", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)(highestId - 6), (String)"column_size", (Type)Types.LongType.get(), (String)"Total size on disk"), Types.NestedField.optional((int)(highestId - 5), (String)"value_count", (Type)Types.LongType.get(), (String)"Total count, including null and NaN"), Types.NestedField.optional((int)(highestId - 4), (String)"null_value_count", (Type)Types.LongType.get(), (String)"Null value count"), Types.NestedField.optional((int)(highestId - 3), (String)"nan_value_count", (Type)Types.LongType.get(), (String)"NaN value count"), Types.NestedField.optional((int)(highestId - 2), (String)"lower_bound", (Type)Types.IntegerType.get(), (String)"Lower bound"), Types.NestedField.optional((int)(highestId - 1), (String)"upper_bound", (Type)Types.IntegerType.get(), (String)"Upper bound")}), (String)"Metrics for column id")}), (String)"Column metrics in readable form")});
        Assert.assertEquals((String)"Dynamic schema for readable_metrics should match", (Object)actual, (Object)expected);
    }

    @Test
    public void testEntriesTableReadableMetricsSchema() {
        ManifestEntriesTable entriesTable = new ManifestEntriesTable((Table)this.table);
        Types.StructType actual = entriesTable.newScan().schema().select(new String[]{"readable_metrics"}).asStruct();
        int highestId = entriesTable.schema().highestFieldId();
        Types.StructType expected = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)highestId, (String)"readable_metrics", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)(highestId - 14), (String)"data", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)(highestId - 13), (String)"column_size", (Type)Types.LongType.get(), (String)"Total size on disk"), Types.NestedField.optional((int)(highestId - 12), (String)"value_count", (Type)Types.LongType.get(), (String)"Total count, including null and NaN"), Types.NestedField.optional((int)(highestId - 11), (String)"null_value_count", (Type)Types.LongType.get(), (String)"Null value count"), Types.NestedField.optional((int)(highestId - 10), (String)"nan_value_count", (Type)Types.LongType.get(), (String)"NaN value count"), Types.NestedField.optional((int)(highestId - 9), (String)"lower_bound", (Type)Types.StringType.get(), (String)"Lower bound"), Types.NestedField.optional((int)(highestId - 8), (String)"upper_bound", (Type)Types.StringType.get(), (String)"Upper bound")}), (String)"Metrics for column data"), Types.NestedField.optional((int)(highestId - 7), (String)"id", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)(highestId - 6), (String)"column_size", (Type)Types.LongType.get(), (String)"Total size on disk"), Types.NestedField.optional((int)(highestId - 5), (String)"value_count", (Type)Types.LongType.get(), (String)"Total count, including null and NaN"), Types.NestedField.optional((int)(highestId - 4), (String)"null_value_count", (Type)Types.LongType.get(), (String)"Null value count"), Types.NestedField.optional((int)(highestId - 3), (String)"nan_value_count", (Type)Types.LongType.get(), (String)"NaN value count"), Types.NestedField.optional((int)(highestId - 2), (String)"lower_bound", (Type)Types.IntegerType.get(), (String)"Lower bound"), Types.NestedField.optional((int)(highestId - 1), (String)"upper_bound", (Type)Types.IntegerType.get(), (String)"Upper bound")}), (String)"Metrics for column id")}), (String)"Column metrics in readable form")});
        Assert.assertEquals((String)"Dynamic schema for readable_metrics should match", (Object)actual, (Object)expected);
    }

    @Test
    public void testPartitionSpecEvolutionAdditive() {
        this.preparePartitionedTable();
        this.table.updateSpec().addField("id").commit();
        PartitionSpec newSpec = this.table.spec();
        PartitionKey data10Key = new PartitionKey(newSpec, this.table.schema());
        data10Key.set(0, (Object)0);
        data10Key.set(1, (Object)10);
        DataFile data10 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-10.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data10Key).build();
        PartitionKey data11Key = new PartitionKey(newSpec, this.table.schema());
        data11Key.set(0, (Object)1);
        data10Key.set(1, (Object)11);
        DataFile data11 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-11.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data11Key).build();
        this.table.newFastAppend().appendFile(data10).commit();
        this.table.newFastAppend().appendFile(data11).commit();
        PartitionsTable metadataTable = new PartitionsTable((Table)this.table);
        Expression filter = Expressions.and((Expression)Expressions.equal((String)"partition.id", (Object)10), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        TableScan scan = (TableScan)metadataTable.newScan().filter(filter);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scan));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)9L, (long)Iterables.size((Iterable)files));
        } else {
            Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)files));
        }
        filter = Expressions.and((Expression)Expressions.equal((String)"partition.data_bucket", (Object)0), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        scan = (TableScan)metadataTable.newScan().filter(filter);
        files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scan));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)files));
        } else {
            Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)files));
        }
    }

    @Test
    public void testPartitionSpecEvolutionRemoval() {
        this.preparePartitionedTable();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField("id").commit();
        PartitionSpec newSpec = this.table.spec();
        int partIndex = this.formatVersion == 1 ? 1 : 0;
        PartitionKey data10Key = new PartitionKey(newSpec, this.table.schema());
        data10Key.set(partIndex, (Object)10);
        DataFile data10 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-10.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data10Key).build();
        PartitionKey data11Key = new PartitionKey(newSpec, this.table.schema());
        data11Key.set(partIndex, (Object)11);
        DataFile data11 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-11.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data11Key).build();
        this.table.newFastAppend().appendFile(data10).commit();
        this.table.newFastAppend().appendFile(data11).commit();
        PartitionsTable metadataTable = new PartitionsTable((Table)this.table);
        Expression filter = Expressions.and((Expression)Expressions.equal((String)"partition.id", (Object)10), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        TableScan scan = (TableScan)metadataTable.newScan().filter(filter);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scan));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)9L, (long)Iterables.size((Iterable)files));
        } else {
            Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)files));
        }
        filter = Expressions.and((Expression)Expressions.equal((String)"partition.data_bucket", (Object)0), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        scan = (TableScan)metadataTable.newScan().filter(filter);
        files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scan));
        if (this.formatVersion == 1) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)files));
        } else {
            Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)files));
        }
    }

    @Test
    public void testPartitionColumnNamedPartition() throws Exception {
        TestTables.clearTables();
        this.tableDir = this.temp.newFolder();
        this.tableDir.delete();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"partition", (Type)Types.IntegerType.get())});
        this.metadataDir = new File(this.tableDir, "metadata");
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("partition").build();
        DataFile par0 = DataFiles.builder((PartitionSpec)spec).withPath("/path/to/data-0.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{0})).withRecordCount(1L).build();
        DataFile par1 = DataFiles.builder((PartitionSpec)spec).withPath("/path/to/data-0.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{1})).withRecordCount(1L).build();
        DataFile par2 = DataFiles.builder((PartitionSpec)spec).withPath("/path/to/data-0.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{2})).withRecordCount(1L).build();
        this.table = this.create(schema, spec);
        this.table.newFastAppend().appendFile(par0).commit();
        this.table.newFastAppend().appendFile(par1).commit();
        this.table.newFastAppend().appendFile(par2).commit();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        Expression andEquals = Expressions.and((Expression)Expressions.equal((String)"partition.partition", (Object)0), (Expression)Expressions.greaterThan((String)"record_count", (Object)0));
        TableScan scanAndEq = (TableScan)partitionsTable.newScan().filter(andEquals);
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scanAndEq));
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)files.iterator()));
        this.validateSingleFieldPartition(files, 0);
    }

    @Test
    public void testAllDataFilesTableScanWithPlanExecutor() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        AllDataFilesTable allDataFilesTable = new AllDataFilesTable((Table)this.table);
        AtomicInteger planThreadsIndex = new AtomicInteger(0);
        TableScan scan = (TableScan)allDataFilesTable.newScan().planWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("plan-" + planThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)scan.planFiles()));
        Assert.assertTrue((String)"Thread should be created in provided pool", (planThreadsIndex.get() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllEntriesTableScanWithPlanExecutor() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        AllEntriesTable allEntriesTable = new AllEntriesTable((Table)this.table);
        AtomicInteger planThreadsIndex = new AtomicInteger(0);
        TableScan scan = (TableScan)allEntriesTable.newScan().planWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("plan-" + planThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)scan.planFiles()));
        Assert.assertTrue((String)"Thread should be created in provided pool", (planThreadsIndex.get() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionsTableScanWithPlanExecutor() {
        this.preparePartitionedTable();
        PartitionsTable partitionsTable = new PartitionsTable((Table)this.table);
        AtomicInteger planThreadsIndex = new AtomicInteger(0);
        TableScan scan = (TableScan)partitionsTable.newScan().planWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("plan-" + planThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }));
        CloseableIterable files = PartitionsTable.planFiles((StaticTableScan)((StaticTableScan)scan));
        if (this.formatVersion == 2) {
            Assert.assertEquals((long)8L, (long)Iterators.size((Iterator)files.iterator()));
        } else {
            Assert.assertEquals((long)4L, (long)Iterators.size((Iterator)files.iterator()));
        }
        Assert.assertTrue((String)"Thread should be created in provided pool", (planThreadsIndex.get() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAllManifestsTableSnapshotGt() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.greaterThan((String)"reference_snapshot_id", (Object)2));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 3L, 4L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotGte() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.greaterThanOrEqual((String)"reference_snapshot_id", (Object)3));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 3L, 4L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotLt() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.lessThan((String)"reference_snapshot_id", (Object)3));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 1L, 2L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotLte() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.lessThanOrEqual((String)"reference_snapshot_id", (Object)2));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 1L, 2L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotEq() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.equal((String)"reference_snapshot_id", (Object)2));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 2L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotNotEq() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.notEqual((String)"reference_snapshot_id", (Object)2));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 1L, 3L, 4L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotIn() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.in((String)"reference_snapshot_id", (Object[])new Integer[]{1, 3}));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 1L, 3L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotNotIn() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter((Expression)Expressions.notIn((String)"reference_snapshot_id", (Object[])new Integer[]{1, 3}));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 2L, 4L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotAnd() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter(Expressions.and((Expression)Expressions.equal((String)"reference_snapshot_id", (Object)2), (Expression)Expressions.greaterThan((String)"length", (Object)0)));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 2L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotOr() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter(Expressions.or((Expression)Expressions.equal((String)"reference_snapshot_id", (Object)2), (Expression)Expressions.equal((String)"reference_snapshot_id", (Object)4)));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 2L, 4L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testAllManifestsTableSnapshotNot() {
        this.preparePartitionedTableData();
        AllManifestsTable manifestsTable = new AllManifestsTable((Table)this.table);
        TableScan manifestsTableScan = (TableScan)manifestsTable.newScan().filter(Expressions.not((Expression)Expressions.equal((String)"reference_snapshot_id", (Object)2)));
        Assert.assertEquals((String)"Expected snapshots do not match", this.expectedManifestListPaths(this.table.snapshots(), 1L, 3L, 4L), this.actualManifestListPaths(manifestsTableScan));
    }

    @Test
    public void testPositionDeletesWithFilter() {
        Assume.assumeTrue((String)"Position deletes supported only for v2 tables", (this.formatVersion == 2 ? 1 : 0) != 0);
        this.preparePartitionedTable();
        PositionDeletesTable positionDeletesTable = new PositionDeletesTable((Table)this.table);
        Expression expression = Expressions.and((Expression)Expressions.equal((String)"partition.data_bucket", (Object)1), (Expression)Expressions.greaterThan((String)"pos", (Object)0));
        BatchScan scan = (BatchScan)positionDeletesTable.newBatchScan().filter(expression);
        Assertions.assertThat((Object)scan).isExactlyInstanceOf(PositionDeletesTable.PositionDeletesBatchScan.class);
        PositionDeletesTable.PositionDeletesBatchScan deleteScan = (PositionDeletesTable.PositionDeletesBatchScan)scan;
        ArrayList tasks = Lists.newArrayList((Iterable)scan.planFiles());
        Assert.assertEquals((String)"Expected to scan one delete manifest", (long)1L, (long)deleteScan.scanMetrics().scannedDeleteManifests().value());
        Assert.assertEquals((String)"Expected to skip three delete manifests", (long)3L, (long)deleteScan.scanMetrics().skippedDeleteManifests().value());
        Assertions.assertThat((List)tasks).hasSize(1);
        ScanTask task = (ScanTask)tasks.get(0);
        Assertions.assertThat((Object)task).isInstanceOf(PositionDeletesScanTask.class);
        Types.StructType partitionType = Partitioning.partitionType((Table)this.table);
        PositionDeletesScanTask posDeleteTask = (PositionDeletesScanTask)task;
        int filePartition = (Integer)((DeleteFile)posDeleteTask.file()).partition().get(0, Integer.class);
        StructLike taskPartitionStruct = (StructLike)this.constantsMap(posDeleteTask, partitionType).get(0x7FFFFFFA);
        int taskPartition = (Integer)taskPartitionStruct.get(0, Integer.class);
        Assert.assertEquals((String)"Expected correct partition on task's file", (long)1L, (long)filePartition);
        Assert.assertEquals((String)"Expected correct partition on task's column", (long)1L, (long)taskPartition);
        Assert.assertEquals((String)"Expected correct partition spec id on task", (long)0L, (long)((DeleteFile)posDeleteTask.file()).specId());
        Assert.assertEquals((String)"Expected correct partition spec id on constant column", (Object)0, this.constantsMap(posDeleteTask, partitionType).get(MetadataColumns.SPEC_ID.fieldId()));
        Assert.assertEquals((String)"Expected correct delete file on task", (Object)FILE_B_DELETES.path(), (Object)((DeleteFile)posDeleteTask.file()).path());
        Assert.assertEquals((String)"Expected correct delete file on constant column", (Object)FILE_B_DELETES.path(), this.constantsMap(posDeleteTask, partitionType).get(MetadataColumns.FILE_PATH.fieldId()));
    }

    @Test
    public void testPositionDeletesResiduals() {
        Assume.assumeTrue((String)"Position deletes supported only for v2 tables", (this.formatVersion == 2 ? 1 : 0) != 0);
        this.preparePartitionedTable();
        PositionDeletesTable positionDeletesTable = new PositionDeletesTable((Table)this.table);
        Expression expression = Expressions.and((Expression)Expressions.equal((String)"partition.data_bucket", (Object)1), (Expression)Expressions.greaterThan((String)"pos", (Object)1));
        BatchScan scan = (BatchScan)positionDeletesTable.newBatchScan().filter(expression);
        Assertions.assertThat((Object)scan).isExactlyInstanceOf(PositionDeletesTable.PositionDeletesBatchScan.class);
        ArrayList tasks = Lists.newArrayList((Iterable)scan.planFiles());
        Assertions.assertThat((List)tasks).hasSize(1);
        ScanTask task = (ScanTask)tasks.get(0);
        Assertions.assertThat((Object)task).isInstanceOf(PositionDeletesScanTask.class);
        PositionDeletesScanTask posDeleteTask = (PositionDeletesScanTask)task;
        Expression residual = posDeleteTask.residual();
        UnboundPredicate residualPred = (UnboundPredicate)TestHelpers.assertAndUnwrap((Expression)residual, UnboundPredicate.class);
        Assert.assertEquals((String)"Expected partition residual to be evaluated", (Object)Expression.Operation.GT, (Object)residualPred.op());
        Assert.assertEquals((String)"Expected partition residual to be evaluated", (Object)Literal.of((int)1), (Object)residualPred.literal());
    }

    @Test
    public void testPositionDeletesUnpartitioned() {
        Assume.assumeTrue((String)"Position deletes supported only for v2 tables", (this.formatVersion == 2 ? 1 : 0) != 0);
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        Assert.assertEquals((String)"Table should now be unpartitioned", (long)0L, (long)this.table.spec().fields().size());
        DataFile dataFile1 = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data1.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
        DataFile dataFile2 = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data2.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
        this.table.newAppend().appendFile(dataFile1).appendFile(dataFile2).commit();
        DeleteFile delete1 = FileMetadata.deleteFileBuilder((PartitionSpec)this.table.spec()).ofPositionDeletes().withPath("/path/to/delete1.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
        DeleteFile delete2 = FileMetadata.deleteFileBuilder((PartitionSpec)this.table.spec()).ofPositionDeletes().withPath("/path/to/delete2.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
        this.table.newRowDelta().addDeletes(delete1).addDeletes(delete2).commit();
        PositionDeletesTable positionDeletesTable = new PositionDeletesTable((Table)this.table);
        BatchScan scan = positionDeletesTable.newBatchScan();
        Assertions.assertThat((Object)scan).isInstanceOf(PositionDeletesTable.PositionDeletesBatchScan.class);
        PositionDeletesTable.PositionDeletesBatchScan deleteScan = (PositionDeletesTable.PositionDeletesBatchScan)scan;
        ArrayList scanTasks = Lists.newArrayList((Iterator)Iterators.transform((Iterator)deleteScan.planFiles().iterator(), task -> {
            Assertions.assertThat((Object)task).isInstanceOf(PositionDeletesScanTask.class);
            return (PositionDeletesScanTask)task;
        }));
        Assert.assertEquals((String)"Expected to scan 1 manifest", (long)1L, (long)deleteScan.scanMetrics().scannedDeleteManifests().value());
        Assert.assertEquals((String)"Expected 2 tasks", (long)2L, (long)scanTasks.size());
        scanTasks.sort(Comparator.comparing(f -> ((DeleteFile)f.file()).path().toString()));
        Assert.assertEquals((Object)"/path/to/delete1.parquet", (Object)((DeleteFile)((PositionDeletesScanTask)scanTasks.get(0)).file()).path().toString());
        Assert.assertEquals((Object)"/path/to/delete2.parquet", (Object)((DeleteFile)((PositionDeletesScanTask)scanTasks.get(1)).file()).path().toString());
        Types.StructType partitionType = Partitioning.partitionType((Table)this.table);
        Assert.assertEquals((Object)"/path/to/delete1.parquet", this.constantsMap((PositionDeletesScanTask)scanTasks.get(0), partitionType).get(MetadataColumns.FILE_PATH.fieldId()));
        Assert.assertEquals((Object)"/path/to/delete2.parquet", this.constantsMap((PositionDeletesScanTask)scanTasks.get(1), partitionType).get(MetadataColumns.FILE_PATH.fieldId()));
        Assert.assertEquals((Object)1, this.constantsMap((PositionDeletesScanTask)scanTasks.get(0), partitionType).get(MetadataColumns.SPEC_ID.fieldId()));
        Assert.assertEquals((Object)1, this.constantsMap((PositionDeletesScanTask)scanTasks.get(1), partitionType).get(MetadataColumns.SPEC_ID.fieldId()));
        StructLikeWrapper wrapper = StructLikeWrapper.forType((Types.StructType)Partitioning.partitionType((Table)this.table));
        PartitionData partitionData = new PartitionData(Partitioning.partitionType((Table)this.table));
        StructLikeWrapper expected = wrapper.set((StructLike)partitionData);
        StructLike scanTask1PartitionStruct = (StructLike)this.constantsMap((PositionDeletesScanTask)scanTasks.get(0), partitionType).get(0x7FFFFFFA);
        StructLikeWrapper scanTask1Partition = wrapper.copyFor(scanTask1PartitionStruct);
        StructLike scanTask2PartitionStruct = (StructLike)this.constantsMap((PositionDeletesScanTask)scanTasks.get(1), partitionType).get(0x7FFFFFFA);
        StructLikeWrapper scanTask2Partition = wrapper.copyFor(scanTask2PartitionStruct);
        Assert.assertEquals((Object)expected, (Object)scanTask1Partition);
        Assert.assertEquals((Object)expected, (Object)scanTask2Partition);
    }
}

