/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.iceberg.AllDataFilesTable;
import org.apache.iceberg.AllDeleteFilesTable;
import org.apache.iceberg.AllEntriesTable;
import org.apache.iceberg.AllFilesTable;
import org.apache.iceberg.BaseEntriesTable;
import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFilesTable;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.FilesTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMetadataTableFilters
extends TableTestBase {
    private static final Set<MetadataTableType> aggFileTables = Sets.newHashSet((Object[])new MetadataTableType[]{MetadataTableType.ALL_DATA_FILES, MetadataTableType.ALL_DATA_FILES, MetadataTableType.ALL_FILES, MetadataTableType.ALL_ENTRIES});
    private final MetadataTableType type;

    @Parameterized.Parameters(name="table_type = {0}, format = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{MetadataTableType.DATA_FILES, 1}, {MetadataTableType.DATA_FILES, 2}, {MetadataTableType.DELETE_FILES, 2}, {MetadataTableType.FILES, 1}, {MetadataTableType.FILES, 2}, {MetadataTableType.ALL_DATA_FILES, 1}, {MetadataTableType.ALL_DATA_FILES, 2}, {MetadataTableType.ALL_DELETE_FILES, 2}, {MetadataTableType.ALL_FILES, 1}, {MetadataTableType.ALL_FILES, 2}, {MetadataTableType.ENTRIES, 1}, {MetadataTableType.ENTRIES, 2}, {MetadataTableType.ALL_ENTRIES, 1}, {MetadataTableType.ALL_ENTRIES, 2}};
    }

    public TestMetadataTableFilters(MetadataTableType type, int formatVersion) {
        super(formatVersion);
        this.type = type;
    }

    @Override
    @Before
    public void setupTable() throws Exception {
        super.setupTable();
        this.table.updateProperties().set("commit.manifest-merge.enabled", "false").commit();
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        this.table.newFastAppend().appendFile(FILE_D).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        if (this.formatVersion == 2) {
            this.table.newRowDelta().addDeletes(FILE_A_DELETES).commit();
            this.table.newRowDelta().addDeletes(FILE_B_DELETES).commit();
            this.table.newRowDelta().addDeletes(FILE_C2_DELETES).commit();
            this.table.newRowDelta().addDeletes(FILE_D2_DELETES).commit();
        }
        if (this.isAggFileTable(this.type)) {
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            Assert.assertEquals((String)"Current snapshot should be made empty", (long)0L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        }
    }

    private Table createMetadataTable() {
        switch (this.type) {
            case FILES: {
                return new FilesTable((Table)this.table);
            }
            case DATA_FILES: {
                return new DataFilesTable((Table)this.table);
            }
            case DELETE_FILES: {
                return new DeleteFilesTable((Table)this.table);
            }
            case ALL_DATA_FILES: {
                return new AllDataFilesTable((Table)this.table);
            }
            case ALL_DELETE_FILES: {
                return new AllDeleteFilesTable((Table)this.table);
            }
            case ALL_FILES: {
                return new AllFilesTable((Table)this.table);
            }
            case ENTRIES: {
                return new ManifestEntriesTable((Table)this.table);
            }
            case ALL_ENTRIES: {
                return new AllEntriesTable((Table)this.table);
            }
        }
        throw new IllegalArgumentException("Unsupported metadata table type:" + this.type);
    }

    private int expectedScanTaskCount(int partitions) {
        switch (this.type) {
            case FILES: 
            case ENTRIES: {
                if (this.formatVersion == 1) {
                    return partitions;
                }
                return partitions * 2;
            }
            case DATA_FILES: 
            case DELETE_FILES: 
            case ALL_DELETE_FILES: {
                return partitions;
            }
            case ALL_DATA_FILES: {
                return partitions * 2;
            }
            case ALL_FILES: 
            case ALL_ENTRIES: {
                if (this.formatVersion == 1) {
                    return partitions * 2;
                }
                return partitions * 4;
            }
        }
        throw new IllegalArgumentException("Unsupported metadata table type:" + this.type);
    }

    private boolean isAggFileTable(MetadataTableType tableType) {
        return aggFileTables.contains(tableType);
    }

    private String partitionColumn(String colName) {
        switch (this.type) {
            case FILES: 
            case DATA_FILES: 
            case DELETE_FILES: 
            case ALL_DATA_FILES: 
            case ALL_DELETE_FILES: 
            case ALL_FILES: {
                return String.format("partition.%s", colName);
            }
            case ENTRIES: 
            case ALL_ENTRIES: {
                return String.format("data_file.partition.%s", colName);
            }
        }
        throw new IllegalArgumentException("Unsupported metadata table type:" + this.type);
    }

    private Expression dummyExpression() {
        switch (this.type) {
            case FILES: 
            case DATA_FILES: 
            case DELETE_FILES: 
            case ALL_DATA_FILES: 
            case ALL_DELETE_FILES: 
            case ALL_FILES: {
                return Expressions.greaterThan((String)"record_count", (Object)0);
            }
            case ENTRIES: 
            case ALL_ENTRIES: {
                return Expressions.greaterThan((String)"data_file.record_count", (Object)0);
            }
        }
        throw new IllegalArgumentException("Unsupported metadata table type:" + this.type);
    }

    @Test
    public void testNoFilter() {
        Table metadataTable = this.createMetadataTable();
        TableScan scan = (TableScan)metadataTable.newScan().select(new String[]{this.partitionColumn("data_bucket")});
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(4), (long)Iterables.size((Iterable)tasks));
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 0);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 1);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 2);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 3);
    }

    @Test
    public void testAnd() {
        Table metadataTable = this.createMetadataTable();
        Expression and = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("data_bucket"), (Object)0), (Expression)this.dummyExpression());
        TableScan scan = (TableScan)metadataTable.newScan().filter(and);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(1), (long)Iterables.size((Iterable)tasks));
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 0);
    }

    @Test
    public void testLt() {
        Table metadataTable = this.createMetadataTable();
        UnboundPredicate lt = Expressions.lessThan((String)this.partitionColumn("data_bucket"), (Object)2);
        TableScan scan = (TableScan)metadataTable.newScan().filter((Expression)lt);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(2), (long)Iterables.size((Iterable)tasks));
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 0);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 1);
    }

    @Test
    public void testOr() {
        Table metadataTable = this.createMetadataTable();
        Expression or = Expressions.or((Expression)Expressions.equal((String)this.partitionColumn("data_bucket"), (Object)2), (Expression)this.dummyExpression());
        TableScan scan = (TableScan)metadataTable.newScan().filter(or);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(4), (long)Iterables.size((Iterable)tasks));
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 0);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 1);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 2);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 3);
    }

    @Test
    public void testNot() {
        Table metadataTable = this.createMetadataTable();
        Expression not = Expressions.not((Expression)Expressions.lessThan((String)this.partitionColumn("data_bucket"), (Object)2));
        TableScan scan = (TableScan)metadataTable.newScan().filter(not);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(2), (long)Iterables.size((Iterable)tasks));
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 2);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 3);
    }

    @Test
    public void testIn() {
        Table metadataTable = this.createMetadataTable();
        UnboundPredicate set = Expressions.in((String)this.partitionColumn("data_bucket"), (Object[])new Integer[]{2, 3});
        TableScan scan = (TableScan)metadataTable.newScan().filter((Expression)set);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(2), (long)Iterables.size((Iterable)tasks));
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 2);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 3);
    }

    @Test
    public void testNotNull() {
        Table metadataTable = this.createMetadataTable();
        UnboundPredicate unary = Expressions.notNull((String)this.partitionColumn("data_bucket"));
        TableScan scan = (TableScan)metadataTable.newScan().filter((Expression)unary);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(4), (long)Iterables.size((Iterable)tasks));
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 0);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 1);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 2);
        this.validateFileScanTasks((CloseableIterable<FileScanTask>)tasks, 3);
    }

    @Test
    public void testPlanTasks() {
        Table metadataTable = this.createMetadataTable();
        Expression and = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("data_bucket"), (Object)0), (Expression)this.dummyExpression());
        TableScan scan = (TableScan)metadataTable.newScan().filter(and);
        CloseableIterable tasks = scan.planTasks();
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)tasks));
        this.validateCombinedScanTasks((CloseableIterable<CombinedScanTask>)tasks, 0);
    }

    @Test
    public void testPartitionSpecEvolutionRemovalV1() {
        Assume.assumeTrue((this.formatVersion == 1 ? 1 : 0) != 0);
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField("id").commit();
        PartitionSpec newSpec = this.table.spec();
        PartitionKey data10Key = new PartitionKey(newSpec, this.table.schema());
        data10Key.set(1, (Object)10);
        DataFile data10 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-10.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data10Key).build();
        PartitionKey data11Key = new PartitionKey(newSpec, this.table.schema());
        data10Key.set(1, (Object)11);
        DataFile data11 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-11.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data11Key).build();
        this.table.newFastAppend().appendFile(data10).commit();
        this.table.newFastAppend().appendFile(data11).commit();
        if (this.isAggFileTable(this.type)) {
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            Assert.assertEquals((String)"Current snapshot should be made empty", (long)0L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        }
        Table metadataTable = this.createMetadataTable();
        Expression filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("id"), (Object)10), (Expression)this.dummyExpression());
        TableScan scan = (TableScan)metadataTable.newScan().filter(filter);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(5), (long)Iterables.size((Iterable)tasks));
        filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("data_bucket"), (Object)0), (Expression)this.dummyExpression());
        scan = (TableScan)metadataTable.newScan().filter(filter);
        tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(1), (long)Iterables.size((Iterable)tasks));
    }

    @Test
    public void testPartitionSpecEvolutionRemovalV2() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField("id").commit();
        PartitionSpec newSpec = this.table.spec();
        DataFile data10 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-10.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartitionPath("id=10").build();
        DataFile data11 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-11.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartitionPath("id=11").build();
        DeleteFile delete10 = FileMetadata.deleteFileBuilder((PartitionSpec)newSpec).ofPositionDeletes().withPath("/path/to/data-10-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("id=10").withRecordCount(1L).build();
        DeleteFile delete11 = FileMetadata.deleteFileBuilder((PartitionSpec)newSpec).ofPositionDeletes().withPath("/path/to/data-11-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("id=11").withRecordCount(1L).build();
        this.table.newFastAppend().appendFile(data10).commit();
        this.table.newFastAppend().appendFile(data11).commit();
        if (this.formatVersion == 2) {
            this.table.newRowDelta().addDeletes(delete10).commit();
            this.table.newRowDelta().addDeletes(delete11).commit();
        }
        if (this.isAggFileTable(this.type)) {
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            Assert.assertEquals((String)"Current snapshot should be made empty", (long)0L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        }
        Table metadataTable = this.createMetadataTable();
        Expression filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("id"), (Object)10), (Expression)this.dummyExpression());
        TableScan scan = (TableScan)metadataTable.newScan().filter(filter);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(5), (long)Iterables.size((Iterable)tasks));
        filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("data_bucket"), (Object)0), (Expression)this.dummyExpression());
        scan = (TableScan)metadataTable.newScan().filter(filter);
        tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(3), (long)Iterables.size((Iterable)tasks));
    }

    @Test
    public void testPartitionSpecEvolutionAdditiveV1() {
        Assume.assumeTrue((this.formatVersion == 1 ? 1 : 0) != 0);
        this.table.updateSpec().addField("id").commit();
        PartitionSpec newSpec = this.table.spec();
        PartitionKey data10Key = new PartitionKey(newSpec, this.table.schema());
        data10Key.set(0, (Object)0);
        data10Key.set(1, (Object)10);
        DataFile data10 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-10.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data10Key).build();
        PartitionKey data11Key = new PartitionKey(newSpec, this.table.schema());
        data11Key.set(0, (Object)1);
        data10Key.set(1, (Object)11);
        DataFile data11 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-11.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartition((StructLike)data11Key).build();
        this.table.newFastAppend().appendFile(data10).commit();
        this.table.newFastAppend().appendFile(data11).commit();
        if (this.isAggFileTable(this.type)) {
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            Assert.assertEquals((String)"Current snapshot should be made empty", (long)0L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        }
        Table metadataTable = this.createMetadataTable();
        Expression filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("id"), (Object)10), (Expression)this.dummyExpression());
        TableScan scan = (TableScan)metadataTable.newScan().filter(filter);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(5), (long)Iterables.size((Iterable)tasks));
        filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("data_bucket"), (Object)0), (Expression)this.dummyExpression());
        scan = (TableScan)metadataTable.newScan().filter(filter);
        tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(2), (long)Iterables.size((Iterable)tasks));
    }

    @Test
    public void testPartitionSpecEvolutionAdditiveV2() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.table.updateSpec().addField("id").commit();
        PartitionSpec newSpec = this.table.spec();
        DataFile data10 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-10.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartitionPath("data_bucket=0/id=10").build();
        DataFile data11 = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-11.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartitionPath("data_bucket=1/id=11").build();
        DeleteFile delete10 = FileMetadata.deleteFileBuilder((PartitionSpec)newSpec).ofPositionDeletes().withPath("/path/to/data-10-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0/id=10").withRecordCount(1L).build();
        DeleteFile delete11 = FileMetadata.deleteFileBuilder((PartitionSpec)newSpec).ofPositionDeletes().withPath("/path/to/data-11-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=1/id=11").withRecordCount(1L).build();
        this.table.newFastAppend().appendFile(data10).commit();
        this.table.newFastAppend().appendFile(data11).commit();
        if (this.formatVersion == 2) {
            this.table.newRowDelta().addDeletes(delete10).commit();
            this.table.newRowDelta().addDeletes(delete11).commit();
        }
        if (this.isAggFileTable(this.type)) {
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
            Assert.assertEquals((String)"Current snapshot should be made empty", (long)0L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        }
        Table metadataTable = this.createMetadataTable();
        Expression filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("id"), (Object)10), (Expression)this.dummyExpression());
        TableScan scan = (TableScan)metadataTable.newScan().filter(filter);
        CloseableIterable tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(5), (long)Iterables.size((Iterable)tasks));
        filter = Expressions.and((Expression)Expressions.equal((String)this.partitionColumn("data_bucket"), (Object)0), (Expression)this.dummyExpression());
        scan = (TableScan)metadataTable.newScan().filter(filter);
        tasks = scan.planFiles();
        Assert.assertEquals((long)this.expectedScanTaskCount(2), (long)Iterables.size((Iterable)tasks));
    }

    private void validateFileScanTasks(CloseableIterable<FileScanTask> fileScanTasks, int partValue) {
        Assert.assertTrue((String)"File scan tasks do not include correct file", (boolean)StreamSupport.stream(fileScanTasks.spliterator(), false).anyMatch(t -> this.manifestHasPartition(this.manifest((FileScanTask)t), partValue)));
    }

    private void validateCombinedScanTasks(CloseableIterable<CombinedScanTask> tasks, int partValue) {
        Assert.assertTrue((String)"File scan tasks do not include correct partition value", (boolean)StreamSupport.stream(tasks.spliterator(), false).flatMap(c -> c.files().stream().map(this::manifest)).anyMatch(m -> this.manifestHasPartition((ManifestFile)m, partValue)));
    }

    private boolean manifestHasPartition(ManifestFile mf, int partValue) {
        int lower = (Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ManifestFile.PartitionFieldSummary)mf.partitions().get(0)).lowerBound());
        int upper = (Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ManifestFile.PartitionFieldSummary)mf.partitions().get(0)).upperBound());
        return lower <= partValue && upper >= partValue;
    }

    private ManifestFile manifest(FileScanTask task) {
        if (task instanceof BaseFilesTable.ManifestReadTask) {
            return ((BaseFilesTable.ManifestReadTask)task).manifest();
        }
        if (task instanceof BaseEntriesTable.ManifestReadTask) {
            return ((BaseEntriesTable.ManifestReadTask)task).manifest();
        }
        throw new IllegalArgumentException("Unexpected task type: " + task.getClass().getCanonicalName());
    }
}

