/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMergeAppend
extends TableTestBase {
    private final String branch;

    @Parameterized.Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[] parameters() {
        return new Object[][]{{1, "main"}, {1, "testBranch"}, {2, "main"}, {2, "testBranch"}};
    }

    public TestMergeAppend(int formatVersion, String branch) {
        super(formatVersion);
        this.branch = branch;
    }

    @Test
    public void testEmptyTableAppend() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        Snapshot committedSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        Assert.assertNotNull((String)"Should create a snapshot", (Object)committedSnapshot);
        this.V1Assert.assertEquals("Last sequence number should be 0", 0L, this.table.ops().current().lastSequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)committedSnapshot.allManifests(this.table.io()).size());
        long snapshotId = committedSnapshot.snapshotId();
        this.validateManifest((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testEmptyTableAppendManifest() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        Snapshot committedSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifest), this.branch);
        Assert.assertNotNull((String)"Should create a snapshot", (Object)committedSnapshot);
        this.V1Assert.assertEquals("Last sequence number should be 0", 0L, this.table.ops().current().lastSequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)committedSnapshot.allManifests(this.table.io()).size());
        long snapshotId = committedSnapshot.snapshotId();
        this.validateManifest((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Summary metadata should include 2 added files", (Object)"2", committedSnapshot.summary().get("added-data-files"));
    }

    @Test
    public void testEmptyTableAppendFilesAndManifest() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        Snapshot committedSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D).appendManifest(manifest), this.branch);
        Assert.assertNotNull((String)"Should create a snapshot", (Object)committedSnapshot);
        this.V1Assert.assertEquals("Last sequence number should be 0", 0L, this.table.ops().current().lastSequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should create 2 manifests for initial write", (long)2L, (long)committedSnapshot.allManifests(this.table.io()).size());
        long snapshotId = committedSnapshot.snapshotId();
        this.validateManifest((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId), TestMergeAppend.files(FILE_C, FILE_D), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testAppendWithManifestScanExecutor() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        AtomicInteger scanThreadsIndex = new AtomicInteger(0);
        Snapshot snapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).scanManifestsWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("scan-" + scanThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })), this.branch);
        Assert.assertTrue((String)"Thread should be created in provided pool", (scanThreadsIndex.get() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Should create a snapshot", (Object)snapshot);
    }

    @Test
    public void testMergeWithAppendFilesAndManifest() throws IOException {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        Snapshot committedSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D).appendManifest(manifest), this.branch);
        Assert.assertNotNull((String)"Should create a snapshot", (Object)committedSnapshot);
        this.V1Assert.assertEquals("Last sequence number should be 0", 0L, this.table.ops().current().lastSequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.table.ops().current().lastSequenceNumber());
        long snapshotId = committedSnapshot.snapshotId();
        Assert.assertEquals((String)"Should create 1 merged manifest", (long)1L, (long)committedSnapshot.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L, 1L, 1L, 1L), TestMergeAppend.fileSeqs(1L, 1L, 1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId, snapshotId, snapshotId), TestMergeAppend.files(FILE_C, FILE_D, FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testMergeWithExistingManifest() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        Snapshot commitBefore = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        Assert.assertNotNull((String)"Should create a snapshot", (Object)commitBefore);
        this.V1Assert.assertEquals("Last sequence number should be 0", 0L, this.table.ops().current().lastSequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.table.ops().current().lastSequenceNumber());
        TableMetadata base = this.readMetadata();
        long baseId = commitBefore.snapshotId();
        this.validateSnapshot((Snapshot)null, commitBefore, 1L, new DataFile[]{FILE_A, FILE_B});
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)commitBefore.allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)commitBefore.allManifests(this.table.io()).get(0);
        this.validateManifest(initialManifest, TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(baseId, baseId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Snapshot committedAfter = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D), this.branch);
        this.V1Assert.assertEquals("Last sequence number should be 0", 0L, this.table.ops().current().lastSequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 1 merged manifest for second write", (long)1L, (long)committedAfter.allManifests(this.table.io()).size());
        ManifestFile newManifest = (ManifestFile)committedAfter.allManifests(this.table.io()).get(0);
        Assert.assertNotEquals((String)"Should not contain manifest from initial write", (Object)initialManifest, (Object)newManifest);
        long snapshotId = committedAfter.snapshotId();
        this.validateManifest(newManifest, TestMergeAppend.dataSeqs(2L, 2L, 1L, 1L), TestMergeAppend.fileSeqs(2L, 2L, 1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId, baseId, baseId), Iterators.concat(TestMergeAppend.files(FILE_C, FILE_D), TestMergeAppend.files(initialManifest)), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testManifestMergeMinCount() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "2").set("commit.manifest.target-size-bytes", "15000").commit();
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        ManifestFile manifest = this.writeManifest(FILE_A);
        ManifestFile manifest2 = this.writeManifestWithName("FILE_C", FILE_C);
        ManifestFile manifest3 = this.writeManifestWithName("FILE_D", FILE_D);
        Snapshot snap1 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifest).appendManifest(manifest2).appendManifest(manifest3), this.branch);
        long commitId1 = snap1.snapshotId();
        base = this.readMetadata();
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, base.lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 2 merged manifest for first write", (long)2L, (long)snap1.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap1.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(commitId1), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap1.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(commitId1, commitId1), TestMergeAppend.files(FILE_C, FILE_D), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Snapshot snap2 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifest).appendManifest(manifest2).appendManifest(manifest3), this.branch);
        long commitId2 = snap2.snapshotId();
        base = this.readMetadata();
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, base.lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 3 merged manifest for second write", (long)3L, (long)snap2.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap2.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(2L), TestMergeAppend.fileSeqs(2L), TestMergeAppend.ids(commitId2), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap2.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(2L, 2L), TestMergeAppend.fileSeqs(2L, 2L), TestMergeAppend.ids(commitId2, commitId2), TestMergeAppend.files(FILE_C, FILE_D), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap2.allManifests(this.table.io()).get(2), TestMergeAppend.dataSeqs(1L, 1L, 1L), TestMergeAppend.fileSeqs(1L, 1L, 1L), TestMergeAppend.ids(commitId1, commitId1, commitId1), TestMergeAppend.files(FILE_A, FILE_C, FILE_D), TestMergeAppend.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        Assert.assertEquals((String)"Summary metadata should include 3 added files", (Object)"3", snap2.summary().get("added-data-files"));
    }

    @Test
    public void testManifestsMergeIntoOne() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        Snapshot snap1 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap1.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, base.lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
        long commitId1 = snap1.snapshotId();
        Assert.assertEquals((String)"Should contain 1 manifest", (long)1L, (long)snap1.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap1.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(commitId1), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        Snapshot snap2 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_B), this.branch);
        long commitId2 = snap2.snapshotId();
        base = this.readMetadata();
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, base.lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 2 manifests", (long)2L, (long)snap2.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap2.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(2L), TestMergeAppend.fileSeqs(2L), TestMergeAppend.ids(commitId2), TestMergeAppend.files(FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap2.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(commitId1), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        Snapshot snap3 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(this.writeManifest("input-m0.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, FILE_C))), this.branch);
        base = this.readMetadata();
        this.V2Assert.assertEquals("Snapshot sequence number should be 3", 3L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, base.lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 3 manifests", (long)3L, (long)snap3.allManifests(this.table.io()).size());
        long commitId3 = snap3.snapshotId();
        this.validateManifest((ManifestFile)snap3.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(3L), TestMergeAppend.fileSeqs(3L), TestMergeAppend.ids(commitId3), TestMergeAppend.files(FILE_C), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap3.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(2L), TestMergeAppend.fileSeqs(2L), TestMergeAppend.ids(commitId2), TestMergeAppend.files(FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)snap3.allManifests(this.table.io()).get(2), TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(commitId1), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        Snapshot snap4 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(this.writeManifest("input-m1.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, FILE_D))), this.branch);
        base = this.readMetadata();
        this.V2Assert.assertEquals("Snapshot sequence number should be 4", 4L, snap4.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 4", 4L, base.lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
        long commitId4 = snap4.snapshotId();
        Assert.assertEquals((String)"Should only contains 1 merged manifest", (long)1L, (long)snap4.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap4.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(4L, 3L, 2L, 1L), TestMergeAppend.fileSeqs(4L, 3L, 2L, 1L), TestMergeAppend.ids(commitId4, commitId3, commitId2, commitId1), TestMergeAppend.files(FILE_D, FILE_C, FILE_B, FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testManifestDoNotMergeMinCount() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "4").commit();
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        ManifestFile manifest2 = this.writeManifestWithName("FILE_C", FILE_C);
        ManifestFile manifest3 = this.writeManifestWithName("FILE_D", FILE_D);
        Snapshot committed = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifest).appendManifest(manifest2).appendManifest(manifest3), this.branch);
        Assert.assertNotNull((String)"Should create a snapshot", (Object)committed);
        this.V1Assert.assertEquals("Last sequence number should be 0", 0L, this.table.ops().current().lastSequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.table.ops().current().lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 3 merged manifest after 1st write write", (long)3L, (long)committed.allManifests(this.table.io()).size());
        long snapshotId = committed.snapshotId();
        this.validateManifest((ManifestFile)committed.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)committed.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(snapshotId), TestMergeAppend.files(FILE_C), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)committed.allManifests(this.table.io()).get(2), TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(snapshotId), TestMergeAppend.files(FILE_D), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Summary metadata should include 4 added files", (Object)"4", committed.summary().get("added-data-files"));
    }

    @Test
    public void testMergeWithExistingManifestAfterDelete() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Snapshot snap = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        this.validateSnapshot((Snapshot)null, snap, 1L, new DataFile[]{FILE_A, FILE_B});
        TableMetadata base = this.readMetadata();
        long baseId = snap.snapshotId();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)snap.allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)snap.allManifests(this.table.io()).get(0);
        this.validateManifest(initialManifest, TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(baseId, baseId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Snapshot deleteSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_A), this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, deleteSnapshot.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        TableMetadata delete = this.readMetadata();
        long deleteId = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).snapshotId();
        Assert.assertEquals((String)"Should create 1 filtered manifest for delete", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        ManifestFile deleteManifest = (ManifestFile)deleteSnapshot.allManifests(this.table.io()).get(0);
        this.validateManifest(deleteManifest, TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(deleteId, baseId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Snapshot committedSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D), this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 3", 3L, committedSnapshot.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 1 merged manifest for second write", (long)1L, (long)committedSnapshot.allManifests(this.table.io()).size());
        ManifestFile newManifest = (ManifestFile)committedSnapshot.allManifests(this.table.io()).get(0);
        Assert.assertNotEquals((String)"Should not contain manifest from initial write", (Object)initialManifest, (Object)newManifest);
        long snapshotId = committedSnapshot.snapshotId();
        TestMergeAppend.validateManifestEntries(newManifest, TestMergeAppend.ids(snapshotId, snapshotId, baseId), TestMergeAppend.files(FILE_C, FILE_D, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testMinMergeCount() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "4").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        Snapshot snap1 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_A), this.branch);
        long idFileA = snap1.snapshotId();
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        Snapshot snap2 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_B), this.branch);
        long idFileB = snap2.snapshotId();
        this.validateSnapshot(snap1, snap2, 2L, new DataFile[]{FILE_B});
        Assert.assertEquals((String)"Should have 2 manifests from setup writes", (long)2L, (long)snap2.allManifests(this.table.io()).size());
        Snapshot snap3 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_C), this.branch);
        long idFileC = snap3.snapshotId();
        this.validateSnapshot(snap2, snap3, 3L, new DataFile[]{FILE_C});
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should have 3 unmerged manifests", (long)3L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        HashSet unmerged = Sets.newHashSet((Iterable)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()));
        Snapshot committed = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_D), this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 4", 4L, committed.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 4", 4L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 1 merged manifest after the 4th write", (long)1L, (long)committed.allManifests(this.table.io()).size());
        ManifestFile newManifest = (ManifestFile)committed.allManifests(this.table.io()).get(0);
        Assert.assertFalse((String)"Should not contain previous manifests", (boolean)unmerged.contains(newManifest));
        long lastSnapshotId = committed.snapshotId();
        this.validateManifest(newManifest, TestMergeAppend.dataSeqs(4L, 3L, 2L, 1L), TestMergeAppend.fileSeqs(4L, 3L, 2L, 1L), TestMergeAppend.ids(lastSnapshotId, idFileC, idFileB, idFileA), TestMergeAppend.files(FILE_D, FILE_C, FILE_B, FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testMergeSizeTargetWithExistingManifest() {
        this.table.updateProperties().set("commit.manifest.target-size-bytes", "10").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        Snapshot snap = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        this.validateSnapshot((Snapshot)null, snap, 1L, new DataFile[]{FILE_A, FILE_B});
        TableMetadata base = this.readMetadata();
        long baseId = snap.snapshotId();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)snap.allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)snap.allManifests(this.table.io()).get(0);
        this.validateManifest(initialManifest, TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(baseId, baseId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Snapshot committed = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D), this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, committed.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Should contain 2 unmerged manifests after second write", (long)2L, (long)committed.allManifests(this.table.io()).size());
        ManifestFile newManifest = (ManifestFile)committed.allManifests(this.table.io()).get(0);
        Assert.assertNotEquals((String)"Should not contain manifest from initial write", (Object)initialManifest, (Object)newManifest);
        long pendingId = committed.snapshotId();
        this.validateManifest(newManifest, TestMergeAppend.dataSeqs(2L, 2L), TestMergeAppend.fileSeqs(2L, 2L), TestMergeAppend.ids(pendingId, pendingId), TestMergeAppend.files(FILE_C, FILE_D), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)committed.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(baseId, baseId), TestMergeAppend.files(initialManifest), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testChangedPartitionSpec() {
        Snapshot snap = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B), this.branch);
        long commitId = snap.snapshotId();
        this.validateSnapshot((Snapshot)null, snap, 1L, new DataFile[]{FILE_A, FILE_B});
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)snap.allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)snap.allManifests(this.table.io()).get(0);
        this.validateManifest(initialManifest, TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(commitId, commitId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)base.schema()).bucket("data", 16).bucket("id", 4).build();
        this.table.ops().commit(base, base.updatePartitionSpec(newSpec));
        Snapshot snap2 = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        DataFile newFileY = DataFiles.builder((PartitionSpec)newSpec).withPath("/path/to/data-y.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2/id_bucket=3").withRecordCount(1L).build();
        Snapshot lastSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(newFileY), this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, lastSnapshot.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Should use 2 manifest files", (long)2L, (long)lastSnapshot.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)lastSnapshot.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(2L), TestMergeAppend.fileSeqs(2L), TestMergeAppend.ids(lastSnapshot.snapshotId()), TestMergeAppend.files(newFileY), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Second manifest should be the initial manifest with the old spec", (Object)initialManifest, lastSnapshot.allManifests(this.table.io()).get(1));
    }

    @Test
    public void testChangedPartitionSpecMergeExisting() {
        Snapshot snap1 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        long id1 = snap1.snapshotId();
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A});
        Snapshot snap2 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(FILE_B), this.branch);
        long id2 = snap2.snapshotId();
        this.validateSnapshot(snap1, snap2, 2L, new DataFile[]{FILE_B});
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should contain 2 manifests", (long)2L, (long)snap2.allManifests(this.table.io()).size());
        ManifestFile manifest = (ManifestFile)snap2.allManifests(this.table.io()).get(0);
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)base.schema()).bucket("data", 16).bucket("id", 4).build();
        this.table.ops().commit(base, base.updatePartitionSpec(newSpec));
        Snapshot snap3 = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap3.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        DataFile newFileY = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-y.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2/id_bucket=3").withRecordCount(1L).build();
        Snapshot lastSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(newFileY), this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 3", 3L, lastSnapshot.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 3", 3L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Should use 2 manifest files", (long)2L, (long)lastSnapshot.allManifests(this.table.io()).size());
        Assert.assertFalse((String)"First manifest should not be in the new snapshot", (boolean)lastSnapshot.allManifests(this.table.io()).contains(manifest));
        this.validateManifest((ManifestFile)lastSnapshot.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(3L), TestMergeAppend.fileSeqs(3L), TestMergeAppend.ids(lastSnapshot.snapshotId()), TestMergeAppend.files(newFileY), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.validateManifest((ManifestFile)lastSnapshot.allManifests(this.table.io()).get(1), TestMergeAppend.dataSeqs(2L, 1L), TestMergeAppend.fileSeqs(2L, 1L), TestMergeAppend.ids(id2, id1), TestMergeAppend.files(FILE_B, FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testFailure() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Snapshot snap = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = snap.snapshotId();
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, base.lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
        ManifestFile initialManifest = (ManifestFile)snap.allManifests(this.table.io()).get(0);
        this.validateManifest(initialManifest, TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(baseId), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.table.ops().failCommits(5);
        AppendFiles append = this.table.newAppend().appendFile(FILE_B);
        Snapshot pending = this.apply((SnapshotUpdate)append, this.branch);
        Assert.assertEquals((String)"Should merge to 1 manifest", (long)1L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile newManifest = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        Assert.assertTrue((String)"Should create new manifest", (boolean)new File(newManifest.path()).exists());
        this.validateManifest(newManifest, TestMergeAppend.ids(pending.snapshotId(), baseId), Iterators.concat(TestMergeAppend.files(FILE_B), TestMergeAppend.files(initialManifest)));
        AssertHelpers.assertThrows((String)"Should retry 4 times and throw last failure", CommitFailedException.class, (String)"Injected failure", () -> this.commit((Table)this.table, (SnapshotUpdate)append, this.branch));
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Should only contain 1 manifest file", (long)1L, (long)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(baseId), TestMergeAppend.files(initialManifest), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(newManifest.path()).exists());
    }

    @Test
    public void testAppendManifestCleanup() throws IOException {
        TestTables.TestTableOperations ops = this.table.ops();
        ops.failCommits(5);
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        AppendFiles append = this.table.newAppend().appendManifest(manifest);
        Snapshot pending = this.apply((SnapshotUpdate)append, this.branch);
        ManifestFile newManifest = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        Assert.assertTrue((String)"Should create new manifest", (boolean)new File(newManifest.path()).exists());
        AssertHelpers.assertThrows((String)"Should retry 4 times and throw last failure", CommitFailedException.class, (String)"Injected failure", () -> this.commit((Table)this.table, (SnapshotUpdate)append, this.branch));
        this.V2Assert.assertEquals("Last sequence number should be 0", 0L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(newManifest.path()).exists());
    }

    @Test
    public void testRecovery() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Snapshot current = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        TableMetadata base = this.readMetadata();
        long baseId = current.snapshotId();
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        ManifestFile initialManifest = (ManifestFile)current.allManifests(this.table.io()).get(0);
        this.validateManifest(initialManifest, TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(baseId), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        this.table.ops().failCommits(3);
        AppendFiles append = this.table.newAppend().appendFile(FILE_B);
        Snapshot pending = this.apply((SnapshotUpdate)append, this.branch);
        Assert.assertEquals((String)"Should merge to 1 manifest", (long)1L, (long)pending.allManifests(this.table.io()).size());
        ManifestFile newManifest = (ManifestFile)pending.allManifests(this.table.io()).get(0);
        Assert.assertTrue((String)"Should create new manifest", (boolean)new File(newManifest.path()).exists());
        this.validateManifest(newManifest, TestMergeAppend.ids(pending.snapshotId(), baseId), Iterators.concat(TestMergeAppend.files(FILE_B), TestMergeAppend.files(initialManifest)));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Snapshot snapshot = this.commit((Table)this.table, (SnapshotUpdate)append, this.branch);
        long snapshotId = snapshot.snapshotId();
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snapshot.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        TableMetadata metadata = this.readMetadata();
        Assert.assertTrue((String)"Should reuse the new manifest", (boolean)new File(newManifest.path()).exists());
        Assert.assertEquals((String)"Should commit the same new manifest during retry", (Object)Lists.newArrayList((Object[])new ManifestFile[]{newManifest}), (Object)snapshot.allManifests(this.table.io()));
        Assert.assertEquals((String)"Should only contain 1 merged manifest file", (long)1L, (long)snapshot.allManifests(this.table.io()).size());
        ManifestFile manifestFile = (ManifestFile)snapshot.allManifests(this.table.io()).get(0);
        this.validateManifest(manifestFile, TestMergeAppend.dataSeqs(2L, 1L), TestMergeAppend.fileSeqs(2L, 1L), TestMergeAppend.ids(snapshotId, baseId), TestMergeAppend.files(FILE_B, FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testAppendManifestWithSnapshotIdInheritance() throws IOException {
        this.table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        Snapshot snapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifest), this.branch);
        long snapshotId = snapshot.snapshotId();
        this.validateSnapshot((Snapshot)null, snapshot, 1L, new DataFile[]{FILE_A, FILE_B});
        List manifests = snapshot.allManifests(this.table.io());
        Assert.assertEquals((String)"Should have 1 committed manifest", (long)1L, (long)manifests.size());
        ManifestFile manifestFile = (ManifestFile)snapshot.allManifests(this.table.io()).get(0);
        this.validateManifest(manifestFile, TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(snapshotId, snapshotId), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Summary metadata should include 2 added files", (Object)"2", snapshot.summary().get("added-data-files"));
        Assert.assertEquals((String)"Summary metadata should include 2 added records", (Object)"2", snapshot.summary().get("added-records"));
        Assert.assertEquals((String)"Summary metadata should include 2 files in total", (Object)"2", snapshot.summary().get("total-data-files"));
        Assert.assertEquals((String)"Summary metadata should include 2 records in total", (Object)"2", snapshot.summary().get("total-records"));
    }

    @Test
    public void testMergedAppendManifestCleanupWithSnapshotIdInheritance() throws IOException {
        this.table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").commit();
        ManifestFile manifest1 = this.writeManifestWithName("manifest-file-1.avro", FILE_A, FILE_B);
        Snapshot snap1 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifest1), this.branch);
        long commitId1 = snap1.snapshotId();
        this.validateSnapshot((Snapshot)null, snap1, 1L, new DataFile[]{FILE_A, FILE_B});
        Assert.assertEquals((String)"Should have only 1 manifest", (long)1L, (long)snap1.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)snap1.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(1L, 1L), TestMergeAppend.fileSeqs(1L, 1L), TestMergeAppend.ids(commitId1, commitId1), TestMergeAppend.files(FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Assert.assertTrue((String)"Unmerged append manifest should not be deleted", (boolean)new File(manifest1.path()).exists());
        ManifestFile manifest2 = this.writeManifestWithName("manifest-file-2.avro", FILE_C, FILE_D);
        Snapshot snap2 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifest2), this.branch);
        long commitId2 = snap2.snapshotId();
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, snap2.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Manifests should be merged into 1", (long)1L, (long)snap2.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch).allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(2L, 2L, 1L, 1L), TestMergeAppend.fileSeqs(2L, 2L, 1L, 1L), TestMergeAppend.ids(commitId2, commitId2, commitId1, commitId1), TestMergeAppend.files(FILE_C, FILE_D, FILE_A, FILE_B), TestMergeAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        Assert.assertFalse((String)"Merged append manifest should be deleted", (boolean)new File(manifest2.path()).exists());
    }

    @Test
    public void testAppendManifestFailureWithSnapshotIdInheritance() throws IOException {
        this.table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        this.table.updateProperties().set("commit.retry.num-retries", "1").commit();
        this.table.ops().failCommits(5);
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        AppendFiles append = this.table.newAppend();
        append.appendManifest(manifest);
        AssertHelpers.assertThrows((String)"Should reject commit", CommitFailedException.class, (String)"Injected failure", () -> this.commit((Table)this.table, (SnapshotUpdate)append, this.branch));
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        Assert.assertTrue((String)"Append manifest should not be deleted", (boolean)new File(manifest.path()).exists());
    }

    @Test
    public void testInvalidAppendManifest() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        ManifestFile manifestWithExistingFiles = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, null, FILE_A));
        AssertHelpers.assertThrows((String)"Should reject commit", IllegalArgumentException.class, (String)"Cannot append manifest with existing files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifestWithExistingFiles), this.branch));
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
        ManifestFile manifestWithDeletedFiles = this.writeManifest("manifest-file-2.avro", this.manifestEntry(ManifestEntry.Status.DELETED, null, FILE_A));
        AssertHelpers.assertThrows((String)"Should reject commit", IllegalArgumentException.class, (String)"Cannot append manifest with deleted files", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendManifest(manifestWithDeletedFiles), this.branch));
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)this.readMetadata().lastSequenceNumber());
    }

    @Test
    public void testUpdatePartitionSpecFieldIdsForV1Table() {
        TableMetadata base = this.readMetadata();
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)base.schema()).bucket("id", 16).identity("data").bucket("data", 4).bucket("data", 16, "data_partition").build();
        this.table.ops().commit(base, base.updatePartitionSpec(newSpec));
        Assert.assertEquals((String)"Last sequence number should be 0", (long)0L, (long)base.lastSequenceNumber());
        List partitionSpecs = this.table.ops().current().specs();
        PartitionSpec partitionSpec = (PartitionSpec)partitionSpecs.get(0);
        Assert.assertEquals((long)1000L, (long)partitionSpec.lastAssignedFieldId());
        Types.StructType structType = partitionSpec.partitionType();
        List fields = structType.fields();
        Assert.assertEquals((long)1L, (long)fields.size());
        Assert.assertEquals((Object)"data_bucket", (Object)((Types.NestedField)fields.get(0)).name());
        Assert.assertEquals((long)1000L, (long)((Types.NestedField)fields.get(0)).fieldId());
        partitionSpec = (PartitionSpec)partitionSpecs.get(1);
        Assert.assertEquals((long)1003L, (long)partitionSpec.lastAssignedFieldId());
        structType = partitionSpec.partitionType();
        fields = structType.fields();
        Assert.assertEquals((long)4L, (long)fields.size());
        Assert.assertEquals((Object)"id_bucket", (Object)((Types.NestedField)fields.get(0)).name());
        Assert.assertEquals((long)1000L, (long)((Types.NestedField)fields.get(0)).fieldId());
        Assert.assertEquals((Object)"data", (Object)((Types.NestedField)fields.get(1)).name());
        Assert.assertEquals((long)1001L, (long)((Types.NestedField)fields.get(1)).fieldId());
        Assert.assertEquals((Object)"data_bucket", (Object)((Types.NestedField)fields.get(2)).name());
        Assert.assertEquals((long)1002L, (long)((Types.NestedField)fields.get(2)).fieldId());
        Assert.assertEquals((Object)"data_partition", (Object)((Types.NestedField)fields.get(3)).name());
        Assert.assertEquals((long)1003L, (long)((Types.NestedField)fields.get(3)).fieldId());
    }

    @Test
    public void testManifestEntryFieldIdsForChangedPartitionSpecForV1Table() {
        Snapshot snap = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A), this.branch);
        long commitId = snap.snapshotId();
        this.validateSnapshot((Snapshot)null, snap, 1L, new DataFile[]{FILE_A});
        TableMetadata base = this.readMetadata();
        Assert.assertEquals((String)"Should create 1 manifest for initial write", (long)1L, (long)snap.allManifests(this.table.io()).size());
        ManifestFile initialManifest = (ManifestFile)snap.allManifests(this.table.io()).get(0);
        this.validateManifest(initialManifest, TestMergeAppend.dataSeqs(1L), TestMergeAppend.fileSeqs(1L), TestMergeAppend.ids(commitId), TestMergeAppend.files(FILE_A), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        PartitionSpec newSpec = PartitionSpec.builderFor((Schema)base.schema()).bucket("id", 8).bucket("data", 8).build();
        this.table.ops().commit(base, base.updatePartitionSpec(newSpec));
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        DataFile newFile = DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-x.parquet").withFileSizeInBytes(10L).withPartitionPath("id_bucket=1/data_bucket=1").withRecordCount(1L).build();
        Snapshot committedSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(newFile), this.branch);
        this.V2Assert.assertEquals("Snapshot sequence number should be 2", 2L, committedSnapshot.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 2", 2L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, this.readMetadata().lastSequenceNumber());
        Assert.assertEquals((String)"Should use 2 manifest files", (long)2L, (long)committedSnapshot.allManifests(this.table.io()).size());
        this.validateManifest((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(0), TestMergeAppend.dataSeqs(2L), TestMergeAppend.fileSeqs(2L), TestMergeAppend.ids(committedSnapshot.snapshotId()), TestMergeAppend.files(newFile), TestMergeAppend.statuses(ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Second manifest should be the initial manifest with the old spec", (Object)initialManifest, committedSnapshot.allManifests(this.table.io()).get(1));
        ManifestEntry entry = (ManifestEntry)ManifestFiles.read((ManifestFile)((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(0)), (FileIO)FILE_IO).entries().iterator().next();
        Types.NestedField field = (Types.NestedField)((PartitionData)((DataFile)entry.file()).partition()).getPartitionType().fields().get(0);
        Assert.assertEquals((long)1000L, (long)field.fieldId());
        Assert.assertEquals((Object)"id_bucket", (Object)field.name());
        field = (Types.NestedField)((PartitionData)((DataFile)entry.file()).partition()).getPartitionType().fields().get(1);
        Assert.assertEquals((long)1001L, (long)field.fieldId());
        Assert.assertEquals((Object)"data_bucket", (Object)field.name());
        entry = (ManifestEntry)ManifestFiles.read((ManifestFile)((ManifestFile)committedSnapshot.allManifests(this.table.io()).get(1)), (FileIO)FILE_IO).entries().iterator().next();
        field = (Types.NestedField)((PartitionData)((DataFile)entry.file()).partition()).getPartitionType().fields().get(0);
        Assert.assertEquals((long)1000L, (long)field.fieldId());
        Assert.assertEquals((Object)"data_bucket", (Object)field.name());
    }

    @Test
    public void testDefaultPartitionSummaries() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Set partitionSummaryKeys = this.table.currentSnapshot().summary().keySet().stream().filter(key -> key.startsWith("partitions.")).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should include no partition summaries by default", (long)0L, (long)partitionSummaryKeys.size());
        String summariesIncluded = this.table.currentSnapshot().summary().getOrDefault("partition-summaries-included", "false");
        Assert.assertEquals((String)"Should not set partition-summaries-included to true", (Object)"false", (Object)summariesIncluded);
        String changedPartitions = (String)this.table.currentSnapshot().summary().get("changed-partition-count");
        Assert.assertEquals((String)"Should set changed partition count", (Object)"1", (Object)changedPartitions);
    }

    @Test
    public void testIncludedPartitionSummaries() {
        this.table.updateProperties().set("write.summary.partition-limit", "1").commit();
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Set partitionSummaryKeys = this.table.currentSnapshot().summary().keySet().stream().filter(key -> key.startsWith("partitions.")).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should include a partition summary", (long)1L, (long)partitionSummaryKeys.size());
        String summariesIncluded = this.table.currentSnapshot().summary().getOrDefault("partition-summaries-included", "false");
        Assert.assertEquals((String)"Should set partition-summaries-included to true", (Object)"true", (Object)summariesIncluded);
        String changedPartitions = (String)this.table.currentSnapshot().summary().get("changed-partition-count");
        Assert.assertEquals((String)"Should set changed partition count", (Object)"1", (Object)changedPartitions);
        String partitionSummary = (String)this.table.currentSnapshot().summary().get("partitions.data_bucket=0");
        Assert.assertEquals((String)"Summary should include 1 file with 1 record that is 10 bytes", (Object)"added-data-files=1,added-records=1,added-files-size=10", (Object)partitionSummary);
    }

    @Test
    public void testIncludedPartitionSummaryLimit() {
        this.table.updateProperties().set("write.summary.partition-limit", "1").commit();
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Set partitionSummaryKeys = this.table.currentSnapshot().summary().keySet().stream().filter(key -> key.startsWith("partitions.")).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should include no partition summaries, over limit", (long)0L, (long)partitionSummaryKeys.size());
        String summariesIncluded = this.table.currentSnapshot().summary().getOrDefault("partition-summaries-included", "false");
        Assert.assertEquals((String)"Should not set partition-summaries-included to true", (Object)"false", (Object)summariesIncluded);
        String changedPartitions = (String)this.table.currentSnapshot().summary().get("changed-partition-count");
        Assert.assertEquals((String)"Should set changed partition count", (Object)"2", (Object)changedPartitions);
    }
}

