/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.GenericDeleteFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestManifestWriterVersions {
    private static final FileIO FILE_IO = new TestTables.LocalFileIO();
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"timestamp", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)3, (String)"category", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)5, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("category").hour("timestamp").bucket("id", 16).build();
    private static final long SEQUENCE_NUMBER = 34L;
    private static final long SNAPSHOT_ID = 987134631982734L;
    private static final String PATH = "s3://bucket/table/category=cheesy/timestamp_hour=10/id_bucket=3/file.avro";
    private static final FileFormat FORMAT = FileFormat.AVRO;
    private static final PartitionData PARTITION = DataFiles.data((PartitionSpec)SPEC, (String)"category=cheesy/timestamp_hour=10/id_bucket=3");
    private static final Metrics METRICS = new Metrics(Long.valueOf(1587L), (Map)ImmutableMap.of((Object)1, (Object)15L, (Object)2, (Object)122L, (Object)3, (Object)4021L, (Object)4, (Object)9411L, (Object)5, (Object)15L), (Map)ImmutableMap.of((Object)1, (Object)100L, (Object)2, (Object)100L, (Object)3, (Object)100L, (Object)4, (Object)100L, (Object)5, (Object)100L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L, (Object)3, (Object)0L, (Object)4, (Object)0L, (Object)5, (Object)0L), (Map)ImmutableMap.of((Object)5, (Object)10L), (Map)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)1)), (Map)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)1)));
    private static final List<Long> OFFSETS = ImmutableList.of((Object)4L);
    private static final Integer SORT_ORDER_ID = 2;
    private static final DataFile DATA_FILE = new GenericDataFile(0, "s3://bucket/table/category=cheesy/timestamp_hour=10/id_bucket=3/file.avro", FORMAT, PARTITION, 150972L, METRICS, null, OFFSETS, SORT_ORDER_ID);
    private static final List<Integer> EQUALITY_IDS = ImmutableList.of((Object)1);
    private static final int[] EQUALITY_ID_ARR = new int[]{1};
    private static final DeleteFile DELETE_FILE = new GenericDeleteFile(0, FileContent.EQUALITY_DELETES, "s3://bucket/table/category=cheesy/timestamp_hour=10/id_bucket=3/file.avro", FORMAT, PARTITION, 22905L, METRICS, EQUALITY_ID_ARR, SORT_ORDER_ID, null, null);
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testV1Write() throws IOException {
        ManifestFile manifest = this.writeManifest(1);
        this.checkManifest(manifest, -1L);
        this.checkEntry(this.readManifest(manifest), -1L, -1L, FileContent.DATA);
    }

    @Test
    public void testV1WriteDelete() {
        AssertHelpers.assertThrows((String)"Should fail to write a delete manifest for v1", IllegalArgumentException.class, (String)"Cannot write delete files in a v1 table", () -> this.writeDeleteManifest(1));
    }

    @Test
    public void testV1WriteWithInheritance() throws IOException {
        ManifestFile manifest = this.writeAndReadManifestList(this.writeManifest(1), 1);
        this.checkManifest(manifest, 0L);
        this.checkEntry(this.readManifest(manifest), 0L, 0L, FileContent.DATA);
    }

    @Test
    public void testV2Write() throws IOException {
        ManifestFile manifest = this.writeManifest(2);
        this.checkManifest(manifest, -1L);
        Assert.assertEquals((String)"Content", (Object)ManifestContent.DATA, (Object)manifest.content());
        this.checkEntry(this.readManifest(manifest), -1L, -1L, FileContent.DATA);
    }

    @Test
    public void testV2WriteWithInheritance() throws IOException {
        ManifestFile manifest = this.writeAndReadManifestList(this.writeManifest(2), 2);
        this.checkManifest(manifest, 34L);
        Assert.assertEquals((String)"Content", (Object)ManifestContent.DATA, (Object)manifest.content());
        this.checkEntry(this.readManifest(manifest), 34L, 34L, FileContent.DATA);
    }

    @Test
    public void testV2WriteDelete() throws IOException {
        ManifestFile manifest = this.writeDeleteManifest(2);
        this.checkManifest(manifest, -1L);
        Assert.assertEquals((String)"Content", (Object)ManifestContent.DELETES, (Object)manifest.content());
        this.checkEntry(this.readDeleteManifest(manifest), -1L, -1L, FileContent.EQUALITY_DELETES);
    }

    @Test
    public void testV2WriteDeleteWithInheritance() throws IOException {
        ManifestFile manifest = this.writeAndReadManifestList(this.writeDeleteManifest(2), 2);
        this.checkManifest(manifest, 34L);
        Assert.assertEquals((String)"Content", (Object)ManifestContent.DELETES, (Object)manifest.content());
        this.checkEntry(this.readDeleteManifest(manifest), 34L, 34L, FileContent.EQUALITY_DELETES);
    }

    @Test
    public void testV2ManifestListRewriteWithInheritance() throws IOException {
        ManifestFile manifest = this.writeAndReadManifestList(this.writeManifest(1), 1);
        this.checkManifest(manifest, 0L);
        ManifestFile manifest2 = this.writeAndReadManifestList(manifest, 2);
        this.checkManifest(manifest2, 0L);
        this.checkEntry(this.readManifest(manifest2), 0L, 0L, FileContent.DATA);
    }

    @Test
    public void testV2ManifestRewriteWithInheritance() throws IOException {
        ManifestFile manifest = this.writeAndReadManifestList(this.writeManifest(1), 1);
        this.checkManifest(manifest, 0L);
        ManifestFile rewritten = this.rewriteManifest(manifest, 2);
        this.checkRewrittenManifest(rewritten, -1L, 0L);
        ManifestFile manifest2 = this.writeAndReadManifestList(rewritten, 2);
        this.checkRewrittenManifest(manifest2, 34L, 0L);
        this.checkRewrittenEntry(this.readManifest(manifest2), 0L, FileContent.DATA);
    }

    void checkEntry(ManifestEntry<?> entry, Long expectedDataSequenceNumber, Long expectedFileSequenceNumber, FileContent content) {
        Assert.assertEquals((String)"Status", (Object)ManifestEntry.Status.ADDED, (Object)entry.status());
        Assert.assertEquals((String)"Snapshot ID", (Object)987134631982734L, (Object)entry.snapshotId());
        Assert.assertEquals((String)"Data sequence number", (Object)expectedDataSequenceNumber, (Object)entry.dataSequenceNumber());
        Assert.assertEquals((String)"File sequence number", (Object)expectedFileSequenceNumber, (Object)entry.fileSequenceNumber());
        this.checkDataFile(entry.file(), content);
    }

    void checkRewrittenEntry(ManifestEntry<DataFile> entry, Long expectedSequenceNumber, FileContent content) {
        Assert.assertEquals((String)"Status", (Object)ManifestEntry.Status.EXISTING, (Object)entry.status());
        Assert.assertEquals((String)"Snapshot ID", (Object)987134631982734L, (Object)entry.snapshotId());
        Assert.assertEquals((String)"Data sequence number", (Object)expectedSequenceNumber, (Object)entry.dataSequenceNumber());
        this.checkDataFile(entry.file(), content);
    }

    void checkDataFile(ContentFile<?> dataFile, FileContent content) {
        Assert.assertEquals((String)"Content", (Object)content, (Object)dataFile.content());
        Assert.assertEquals((String)"Path", (Object)PATH, (Object)dataFile.path());
        Assert.assertEquals((String)"Format", (Object)FORMAT, (Object)dataFile.format());
        Assert.assertEquals((String)"Partition", (Object)PARTITION, (Object)dataFile.partition());
        Assert.assertEquals((String)"Record count", (Object)METRICS.recordCount(), (Object)dataFile.recordCount());
        Assert.assertEquals((String)"Column sizes", (Object)METRICS.columnSizes(), (Object)dataFile.columnSizes());
        Assert.assertEquals((String)"Value counts", (Object)METRICS.valueCounts(), (Object)dataFile.valueCounts());
        Assert.assertEquals((String)"Null value counts", (Object)METRICS.nullValueCounts(), (Object)dataFile.nullValueCounts());
        Assert.assertEquals((String)"NaN value counts", (Object)METRICS.nanValueCounts(), (Object)dataFile.nanValueCounts());
        Assert.assertEquals((String)"Lower bounds", (Object)METRICS.lowerBounds(), (Object)dataFile.lowerBounds());
        Assert.assertEquals((String)"Upper bounds", (Object)METRICS.upperBounds(), (Object)dataFile.upperBounds());
        Assert.assertEquals((String)"Sort order id", (Object)SORT_ORDER_ID, (Object)dataFile.sortOrderId());
        if (dataFile.content() == FileContent.EQUALITY_DELETES) {
            Assert.assertEquals(EQUALITY_IDS, (Object)dataFile.equalityFieldIds());
        } else {
            Assert.assertNull((Object)dataFile.equalityFieldIds());
        }
    }

    void checkManifest(ManifestFile manifest, long expectedSequenceNumber) {
        Assert.assertEquals((String)"Snapshot ID", (Object)987134631982734L, (Object)manifest.snapshotId());
        Assert.assertEquals((String)"Sequence number", (long)expectedSequenceNumber, (long)manifest.sequenceNumber());
        Assert.assertEquals((String)"Min sequence number", (long)expectedSequenceNumber, (long)manifest.minSequenceNumber());
        Assert.assertEquals((String)"Added files count", (Object)1, (Object)manifest.addedFilesCount());
        Assert.assertEquals((String)"Existing files count", (Object)0, (Object)manifest.existingFilesCount());
        Assert.assertEquals((String)"Deleted files count", (Object)0, (Object)manifest.deletedFilesCount());
        Assert.assertEquals((String)"Added rows count", (Object)METRICS.recordCount(), (Object)manifest.addedRowsCount());
        Assert.assertEquals((String)"Existing rows count", (Object)0L, (Object)manifest.existingRowsCount());
        Assert.assertEquals((String)"Deleted rows count", (Object)0L, (Object)manifest.deletedRowsCount());
    }

    void checkRewrittenManifest(ManifestFile manifest, long expectedSequenceNumber, long expectedMinSequenceNumber) {
        Assert.assertEquals((String)"Snapshot ID", (Object)987134631982734L, (Object)manifest.snapshotId());
        Assert.assertEquals((String)"Sequence number", (long)expectedSequenceNumber, (long)manifest.sequenceNumber());
        Assert.assertEquals((String)"Min sequence number", (long)expectedMinSequenceNumber, (long)manifest.minSequenceNumber());
        Assert.assertEquals((String)"Added files count", (Object)0, (Object)manifest.addedFilesCount());
        Assert.assertEquals((String)"Existing files count", (Object)1, (Object)manifest.existingFilesCount());
        Assert.assertEquals((String)"Deleted files count", (Object)0, (Object)manifest.deletedFilesCount());
        Assert.assertEquals((String)"Added rows count", (Object)0L, (Object)manifest.addedRowsCount());
        Assert.assertEquals((String)"Existing rows count", (Object)METRICS.recordCount(), (Object)manifest.existingRowsCount());
        Assert.assertEquals((String)"Deleted rows count", (Object)0L, (Object)manifest.deletedRowsCount());
    }

    private InputFile writeManifestList(ManifestFile manifest, int formatVersion) throws IOException {
        InMemoryOutputFile manifestList = new InMemoryOutputFile();
        try (ManifestListWriter writer = ManifestLists.write((int)formatVersion, (OutputFile)manifestList, (long)987134631982734L, (Long)987134631982733L, (long)(formatVersion > 1 ? 34L : 0L));){
            writer.add((Object)manifest);
        }
        return manifestList.toInputFile();
    }

    private ManifestFile writeAndReadManifestList(ManifestFile manifest, int formatVersion) throws IOException {
        List manifests = ManifestLists.read((InputFile)this.writeManifestList(manifest, formatVersion));
        Assert.assertEquals((String)"Should contain one manifest", (long)1L, (long)manifests.size());
        return (ManifestFile)manifests.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile rewriteManifest(ManifestFile manifest, int formatVersion) throws IOException {
        OutputFile manifestFile = Files.localOutput((String)FileFormat.AVRO.addExtension(this.temp.newFile().toString()));
        try (ManifestWriter writer = ManifestFiles.write((int)formatVersion, (PartitionSpec)SPEC, (OutputFile)manifestFile, (Long)987134631982734L);){
            writer.existing(this.readManifest(manifest));
        }
        return writer.toManifestFile();
    }

    private ManifestFile writeManifest(int formatVersion) throws IOException {
        return this.writeManifest(DATA_FILE, formatVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile writeManifest(DataFile file, int formatVersion) throws IOException {
        OutputFile manifestFile = Files.localOutput((String)FileFormat.AVRO.addExtension(this.temp.newFile().toString()));
        try (ManifestWriter writer = ManifestFiles.write((int)formatVersion, (PartitionSpec)SPEC, (OutputFile)manifestFile, (Long)987134631982734L);){
            writer.add((ContentFile)file);
        }
        return writer.toManifestFile();
    }

    private ManifestEntry<DataFile> readManifest(ManifestFile manifest) throws IOException {
        try (CloseableIterable reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).entries();){
            ArrayList files = Lists.newArrayList((Iterable)reader);
            Assert.assertEquals((String)"Should contain only one data file", (long)1L, (long)files.size());
            ManifestEntry manifestEntry = (ManifestEntry)files.get(0);
            return manifestEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile writeDeleteManifest(int formatVersion) throws IOException {
        OutputFile manifestFile = Files.localOutput((String)FileFormat.AVRO.addExtension(this.temp.newFile().toString()));
        try (ManifestWriter writer = ManifestFiles.writeDeleteManifest((int)formatVersion, (PartitionSpec)SPEC, (OutputFile)manifestFile, (Long)987134631982734L);){
            writer.add((ContentFile)DELETE_FILE);
        }
        return writer.toManifestFile();
    }

    private ManifestEntry<DeleteFile> readDeleteManifest(ManifestFile manifest) throws IOException {
        try (CloseableIterable reader = ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)FILE_IO, null).entries();){
            ArrayList entries = Lists.newArrayList((Iterable)reader);
            Assert.assertEquals((String)"Should contain only one data file", (long)1L, (long)entries.size());
            ManifestEntry manifestEntry = (ManifestEntry)entries.get(0);
            return manifestEntry;
        }
    }
}

