/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestManifestWriter
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestManifestWriter(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testManifestStats() throws IOException {
        ManifestFile manifest = this.writeManifest("manifest.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, this.newFile(10L)), this.manifestEntry(ManifestEntry.Status.ADDED, null, this.newFile(20L)), this.manifestEntry(ManifestEntry.Status.ADDED, null, this.newFile(5L)), this.manifestEntry(ManifestEntry.Status.ADDED, null, this.newFile(5L)), this.manifestEntry(ManifestEntry.Status.EXISTING, null, this.newFile(15L)), this.manifestEntry(ManifestEntry.Status.EXISTING, null, this.newFile(10L)), this.manifestEntry(ManifestEntry.Status.EXISTING, null, this.newFile(1L)), this.manifestEntry(ManifestEntry.Status.DELETED, null, this.newFile(5L)), this.manifestEntry(ManifestEntry.Status.DELETED, null, this.newFile(2L)));
        Assert.assertTrue((String)"Added files should be present", (boolean)manifest.hasAddedFiles());
        Assert.assertEquals((String)"Added files count should match", (long)4L, (long)manifest.addedFilesCount().intValue());
        Assert.assertEquals((String)"Added rows count should match", (long)40L, (long)manifest.addedRowsCount());
        Assert.assertTrue((String)"Existing files should be present", (boolean)manifest.hasExistingFiles());
        Assert.assertEquals((String)"Existing files count should match", (long)3L, (long)manifest.existingFilesCount().intValue());
        Assert.assertEquals((String)"Existing rows count should match", (long)26L, (long)manifest.existingRowsCount());
        Assert.assertTrue((String)"Deleted files should be present", (boolean)manifest.hasDeletedFiles());
        Assert.assertEquals((String)"Deleted files count should match", (long)2L, (long)manifest.deletedFilesCount().intValue());
        Assert.assertEquals((String)"Deleted rows count should match", (long)7L, (long)manifest.deletedRowsCount());
    }

    @Test
    public void testManifestPartitionStats() throws IOException {
        ManifestFile manifest = this.writeManifest("manifest.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, this.newFile(10L, (StructLike)TestHelpers.Row.of((Object[])new Object[]{1}))), this.manifestEntry(ManifestEntry.Status.EXISTING, null, this.newFile(15L, (StructLike)TestHelpers.Row.of((Object[])new Object[]{2}))), this.manifestEntry(ManifestEntry.Status.DELETED, null, this.newFile(2L, (StructLike)TestHelpers.Row.of((Object[])new Object[]{3}))));
        List partitions = manifest.partitions();
        Assert.assertEquals((String)"Partition field summaries count should match", (long)1L, (long)partitions.size());
        ManifestFile.PartitionFieldSummary partitionFieldSummary = (ManifestFile.PartitionFieldSummary)partitions.get(0);
        Assert.assertFalse((String)"contains_null should be false", (boolean)partitionFieldSummary.containsNull());
        Assert.assertFalse((String)"contains_nan should be false", (boolean)partitionFieldSummary.containsNaN());
        Assert.assertEquals((String)"Lower bound should match", (Object)1, (Object)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)partitionFieldSummary.lowerBound()));
        Assert.assertEquals((String)"Upper bound should match", (Object)3, (Object)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)partitionFieldSummary.upperBound()));
    }

    @Test
    public void testWriteManifestWithSequenceNumber() throws IOException {
        Assume.assumeTrue((String)"sequence number is only valid for format version > 1", (this.formatVersion > 1 ? 1 : 0) != 0);
        File manifestFile = this.temp.newFile("manifest.avro");
        Assert.assertTrue((boolean)manifestFile.delete());
        OutputFile outputFile = this.table.ops().io().newOutputFile(manifestFile.getCanonicalPath());
        ManifestWriter writer = ManifestFiles.write((int)this.formatVersion, (PartitionSpec)this.table.spec(), (OutputFile)outputFile, (Long)1L);
        writer.add((ContentFile)this.newFile(10L, (StructLike)TestHelpers.Row.of((Object[])new Object[]{1})), 1000L);
        writer.close();
        ManifestFile manifest = writer.toManifestFile();
        Assert.assertEquals((String)"Manifest should have no sequence number", (long)-1L, (long)manifest.sequenceNumber());
        ManifestReader manifestReader = ManifestFiles.read((ManifestFile)manifest, (FileIO)this.table.io());
        for (ManifestEntry entry : manifestReader.entries()) {
            Assert.assertEquals((String)"Custom data sequence number should be used for all manifest entries", (long)1000L, (long)entry.dataSequenceNumber());
            Assert.assertEquals((String)"File sequence number must be unassigned", (long)-1L, (long)entry.fileSequenceNumber());
        }
    }

    @Test
    public void testCommitManifestWithExplicitDataSequenceNumber() throws IOException {
        Assume.assumeTrue((String)"Sequence numbers are valid for format version > 1", (this.formatVersion > 1 ? 1 : 0) != 0);
        DataFile file1 = this.newFile(50L);
        DataFile file2 = this.newFile(50L);
        long dataSequenceNumber = 25L;
        ManifestFile manifest = this.writeManifest("manifest.avro", this.manifestEntry(ManifestEntry.Status.ADDED, null, dataSequenceNumber, null, file1), this.manifestEntry(ManifestEntry.Status.ADDED, null, dataSequenceNumber, null, file2));
        Assert.assertEquals((String)"Manifest should have no sequence number before commit", (long)-1L, (long)manifest.sequenceNumber());
        this.table.newFastAppend().appendManifest(manifest).commit();
        long commitSnapshotId = this.table.currentSnapshot().snapshotId();
        ManifestFile committedManifest = (ManifestFile)this.table.currentSnapshot().dataManifests(this.table.io()).get(0);
        Assert.assertEquals((String)"Committed manifest sequence number must be correct", (long)1L, (long)committedManifest.sequenceNumber());
        Assert.assertEquals((String)"Committed manifest min sequence number must be correct", (long)dataSequenceNumber, (long)committedManifest.minSequenceNumber());
        this.validateManifest(committedManifest, TestManifestWriter.dataSeqs(dataSequenceNumber, dataSequenceNumber), TestManifestWriter.fileSeqs(1L, 1L), TestManifestWriter.ids(commitSnapshotId, commitSnapshotId), TestManifestWriter.files(file1, file2), TestManifestWriter.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
    }

    @Test
    public void testCommitManifestWithExistingEntriesWithoutFileSequenceNumber() throws IOException {
        Assume.assumeTrue((String)"Sequence numbers are valid for format version > 1", (this.formatVersion > 1 ? 1 : 0) != 0);
        DataFile file1 = this.newFile(50L);
        DataFile file2 = this.newFile(50L);
        this.table.newFastAppend().appendFile(file1).appendFile(file2).commit();
        Snapshot appendSnapshot = this.table.currentSnapshot();
        long appendSequenceNumber = appendSnapshot.sequenceNumber();
        long appendSnapshotId = appendSnapshot.snapshotId();
        ManifestFile originalManifest = (ManifestFile)appendSnapshot.dataManifests(this.table.io()).get(0);
        ManifestFile newManifest = this.writeManifest("manifest.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, appendSnapshotId, appendSequenceNumber, null, file1), this.manifestEntry(ManifestEntry.Status.EXISTING, appendSnapshotId, appendSequenceNumber, null, file2));
        Assert.assertEquals((String)"Manifest should have no sequence number before commit", (long)-1L, (long)newManifest.sequenceNumber());
        this.table.rewriteManifests().deleteManifest(originalManifest).addManifest(newManifest).commit();
        Snapshot rewriteSnapshot = this.table.currentSnapshot();
        ManifestFile committedManifest = (ManifestFile)this.table.currentSnapshot().dataManifests(this.table.io()).get(0);
        Assert.assertEquals((String)"Committed manifest sequence number must be correct", (long)rewriteSnapshot.sequenceNumber(), (long)committedManifest.sequenceNumber());
        Assert.assertEquals((String)"Committed manifest min sequence number must be correct", (long)appendSequenceNumber, (long)committedManifest.minSequenceNumber());
        this.validateManifest(committedManifest, TestManifestWriter.dataSeqs(appendSequenceNumber, appendSequenceNumber), TestManifestWriter.fileSeqs(null, null), TestManifestWriter.ids(appendSnapshotId, appendSnapshotId), TestManifestWriter.files(file1, file2), TestManifestWriter.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
    }

    private DataFile newFile(long recordCount) {
        return this.newFile(recordCount, null);
    }

    private DataFile newFile(long recordCount, StructLike partition) {
        String fileName = UUID.randomUUID().toString();
        DataFiles.Builder builder = DataFiles.builder((PartitionSpec)SPEC).withPath("data_bucket=0/" + fileName + ".parquet").withFileSizeInBytes(1024L).withRecordCount(recordCount);
        if (partition != null) {
            builder.withPartition(partition);
        }
        return builder.build();
    }
}

