/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestManifestReaderStats
extends TableTestBase {
    private static final Map<Integer, Long> VALUE_COUNT = ImmutableMap.of((Object)3, (Object)3L);
    private static final Map<Integer, Long> NULL_VALUE_COUNTS = ImmutableMap.of((Object)3, (Object)0L);
    private static final Map<Integer, Long> NAN_VALUE_COUNTS = ImmutableMap.of((Object)3, (Object)1L);
    private static final Map<Integer, ByteBuffer> LOWER_BOUNDS = ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)2));
    private static final Map<Integer, ByteBuffer> UPPER_BOUNDS = ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)4));
    private static final Metrics METRICS = new Metrics(Long.valueOf(3L), null, VALUE_COUNT, NULL_VALUE_COUNTS, NAN_VALUE_COUNTS, LOWER_BOUNDS, UPPER_BOUNDS);
    private static final String FILE_PATH = "/path/to/data-a.parquet";
    private static final DataFile FILE = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(3L).withMetrics(METRICS).build();

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestManifestReaderStats(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testReadIncludesFullStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO);){
            CloseableIterable entries = reader.entries();
            ManifestEntry entry = (ManifestEntry)entries.iterator().next();
            this.assertFullStats((DataFile)entry.file());
        }
    }

    @Test
    public void testReadEntriesWithFilterIncludesFullStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).filterRows((Expression)Expressions.equal((String)"id", (Object)3));){
            CloseableIterable entries = reader.entries();
            ManifestEntry entry = (ManifestEntry)entries.iterator().next();
            this.assertFullStats((DataFile)entry.file());
        }
    }

    @Test
    public void testReadIteratorWithFilterIncludesFullStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).filterRows((Expression)Expressions.equal((String)"id", (Object)3));){
            DataFile entry = (DataFile)reader.iterator().next();
            this.assertFullStats(entry);
        }
    }

    @Test
    public void testReadEntriesWithFilterAndSelectIncludesFullStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).select((Collection)ImmutableList.of((Object)"file_path")).filterRows((Expression)Expressions.equal((String)"id", (Object)3));){
            CloseableIterable entries = reader.entries();
            ManifestEntry entry = (ManifestEntry)entries.iterator().next();
            this.assertFullStats((DataFile)entry.file());
        }
    }

    @Test
    public void testReadIteratorWithFilterAndSelectDropsStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).select((Collection)ImmutableList.of((Object)"file_path")).filterRows((Expression)Expressions.equal((String)"id", (Object)3));){
            DataFile entry = (DataFile)reader.iterator().next();
            this.assertStatsDropped(entry);
        }
    }

    @Test
    public void testReadIteratorWithFilterAndSelectRecordCountDropsStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).select((Collection)ImmutableList.of((Object)"file_path", (Object)"record_count")).filterRows((Expression)Expressions.equal((String)"id", (Object)3));){
            DataFile entry = (DataFile)reader.iterator().next();
            this.assertStatsDropped(entry);
        }
    }

    @Test
    public void testReadIteratorWithFilterAndSelectStatsIncludesFullStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).select((Collection)ImmutableList.of((Object)"file_path", (Object)"value_counts")).filterRows((Expression)Expressions.equal((String)"id", (Object)3));){
            DataFile entry = (DataFile)reader.iterator().next();
            this.assertFullStats(entry);
            this.assertStatsDropped((DataFile)entry.copyWithoutStats());
        }
    }

    @Test
    public void testReadIteratorWithProjectStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).project(new Schema((List)ImmutableList.of((Object)DataFile.FILE_PATH, (Object)DataFile.VALUE_COUNTS)));){
            DataFile entry = (DataFile)reader.iterator().next();
            Assert.assertEquals((Object)FILE_PATH, (Object)entry.path());
            Assert.assertEquals(VALUE_COUNT, (Object)entry.valueCounts());
            Assert.assertNull((Object)entry.columnSizes());
            Assert.assertNull((Object)entry.nullValueCounts());
            Assert.assertNull((Object)entry.nanValueCounts());
            Assert.assertNull((Object)entry.lowerBounds());
            Assert.assertNull((Object)entry.upperBounds());
            this.assertNullRecordCount(entry);
        }
    }

    @Test
    public void testReadEntriesWithSelectNotProjectStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).select((Collection)ImmutableList.of((Object)"file_path"));){
            CloseableIterable entries = reader.entries();
            ManifestEntry entry = (ManifestEntry)entries.iterator().next();
            DataFile dataFile = (DataFile)entry.file();
            Assert.assertEquals((Object)FILE_PATH, (Object)dataFile.path());
            Assert.assertNull((Object)dataFile.columnSizes());
            Assert.assertNull((Object)dataFile.valueCounts());
            Assert.assertNull((Object)dataFile.nullValueCounts());
            Assert.assertNull((Object)dataFile.lowerBounds());
            Assert.assertNull((Object)dataFile.upperBounds());
            Assert.assertNull((Object)dataFile.nanValueCounts());
            this.assertNullRecordCount(dataFile);
        }
    }

    @Test
    public void testReadEntriesWithSelectCertainStatNotProjectStats() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).select((Collection)ImmutableList.of((Object)"file_path", (Object)"value_counts"));){
            DataFile dataFile = (DataFile)reader.iterator().next();
            Assert.assertEquals(VALUE_COUNT, (Object)dataFile.valueCounts());
            Assert.assertEquals((Object)FILE_PATH, (Object)dataFile.path());
            Assert.assertNull((Object)dataFile.columnSizes());
            Assert.assertNull((Object)dataFile.nullValueCounts());
            Assert.assertNull((Object)dataFile.nanValueCounts());
            Assert.assertNull((Object)dataFile.lowerBounds());
            Assert.assertNull((Object)dataFile.upperBounds());
            this.assertNullRecordCount(dataFile);
        }
    }

    private void assertFullStats(DataFile dataFile) {
        Assert.assertEquals((long)3L, (long)dataFile.recordCount());
        Assert.assertNull((Object)dataFile.columnSizes());
        Assert.assertEquals(VALUE_COUNT, (Object)dataFile.valueCounts());
        Assert.assertEquals(NULL_VALUE_COUNTS, (Object)dataFile.nullValueCounts());
        Assert.assertEquals(NAN_VALUE_COUNTS, (Object)dataFile.nanValueCounts());
        Assert.assertEquals(LOWER_BOUNDS, (Object)dataFile.lowerBounds());
        Assert.assertEquals(UPPER_BOUNDS, (Object)dataFile.upperBounds());
        Assert.assertEquals((Object)FILE_PATH, (Object)dataFile.path());
    }

    private void assertStatsDropped(DataFile dataFile) {
        Assert.assertEquals((long)3L, (long)dataFile.recordCount());
        Assert.assertNull((Object)dataFile.columnSizes());
        Assert.assertNull((Object)dataFile.valueCounts());
        Assert.assertNull((Object)dataFile.nullValueCounts());
        Assert.assertNull((Object)dataFile.lowerBounds());
        Assert.assertNull((Object)dataFile.upperBounds());
        Assert.assertNull((Object)dataFile.nanValueCounts());
        Assert.assertEquals((Object)FILE_PATH, (Object)dataFile.path());
    }

    private void assertNullRecordCount(DataFile dataFile) {
        AssertHelpers.assertThrows((String)"Should throw NPE when accessing non-populated record count field", NullPointerException.class, () -> ((DataFile)dataFile).recordCount());
    }
}

