/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestManifestReader
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestManifestReader(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testManifestReaderWithEmptyInheritableMetadata() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, this.manifestEntry(ManifestEntry.Status.EXISTING, 1000L, FILE_A));
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO);){
            ManifestEntry entry = (ManifestEntry)Iterables.getOnlyElement((Iterable)reader.entries());
            Assert.assertEquals((Object)ManifestEntry.Status.EXISTING, (Object)entry.status());
            Assert.assertEquals((Object)FILE_A.path(), (Object)((DataFile)entry.file()).path());
            Assert.assertEquals((long)1000L, (long)entry.snapshotId());
        }
    }

    @Test
    public void testReaderWithFilterWithoutSelect() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE_A, FILE_B, FILE_C);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).filterRows((Expression)Expressions.equal((String)"id", (Object)0));){
            List files = Streams.stream((Iterable)reader).map(file -> file.path().toString()).collect(Collectors.toList());
            Assert.assertEquals((String)"Should read the expected files", (Object)Lists.newArrayList((Object[])new CharSequence[]{FILE_A.path(), FILE_B.path(), FILE_C.path()}), files);
        }
    }

    @Test
    public void testInvalidUsage() throws IOException {
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        AssertHelpers.assertThrows((String)"Should not be possible to read manifest without explicit snapshot ids and inheritable metadata", IllegalArgumentException.class, (String)"Cannot read from ManifestFile with null (unassigned) snapshot ID", () -> ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO));
    }

    @Test
    public void testManifestReaderWithPartitionMetadata() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, this.manifestEntry(ManifestEntry.Status.EXISTING, 123L, FILE_A));
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO);){
            ManifestEntry entry = (ManifestEntry)Iterables.getOnlyElement((Iterable)reader.entries());
            Assert.assertEquals((long)123L, (long)entry.snapshotId());
            List fields = ((PartitionData)((DataFile)entry.file()).partition()).getPartitionType().fields();
            Assert.assertEquals((long)1L, (long)fields.size());
            Assert.assertEquals((long)1000L, (long)((Types.NestedField)fields.get(0)).fieldId());
            Assert.assertEquals((Object)"data_bucket", (Object)((Types.NestedField)fields.get(0)).name());
            Assert.assertEquals((Object)Types.IntegerType.get(), (Object)((Types.NestedField)fields.get(0)).type());
        }
    }

    @Test
    public void testManifestReaderWithUpdatedPartitionMetadataForV1Table() throws IOException {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.table.schema()).bucket("id", 8).bucket("data", 16).build();
        this.table.ops().commit(this.table.ops().current(), this.table.ops().current().updatePartitionSpec(spec));
        ManifestFile manifest = this.writeManifest((Long)1000L, this.manifestEntry(ManifestEntry.Status.EXISTING, 123L, FILE_A));
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO);){
            ManifestEntry entry = (ManifestEntry)Iterables.getOnlyElement((Iterable)reader.entries());
            Assert.assertEquals((long)123L, (long)entry.snapshotId());
            List fields = ((PartitionData)((DataFile)entry.file()).partition()).getPartitionType().fields();
            Assert.assertEquals((long)2L, (long)fields.size());
            Assert.assertEquals((long)1000L, (long)((Types.NestedField)fields.get(0)).fieldId());
            Assert.assertEquals((Object)"id_bucket", (Object)((Types.NestedField)fields.get(0)).name());
            Assert.assertEquals((Object)Types.IntegerType.get(), (Object)((Types.NestedField)fields.get(0)).type());
            Assert.assertEquals((long)1001L, (long)((Types.NestedField)fields.get(1)).fieldId());
            Assert.assertEquals((Object)"data_bucket", (Object)((Types.NestedField)fields.get(1)).name());
            Assert.assertEquals((Object)Types.IntegerType.get(), (Object)((Types.NestedField)fields.get(1)).type());
        }
    }

    @Test
    public void testDataFilePositions() throws IOException {
        ManifestFile manifest = this.writeManifest((Long)1000L, FILE_A, FILE_B, FILE_C);
        try (ManifestReader reader = ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO);){
            long expectedPos = 0L;
            for (DataFile file : reader) {
                Assert.assertEquals((String)"Position should match", (Object)expectedPos, (Object)file.pos());
                Assert.assertEquals((String)"Position from field index should match", (Object)expectedPos, (Object)((BaseFile)file).get(17));
                ++expectedPos;
            }
        }
    }

    @Test
    public void testDeleteFilePositions() throws IOException {
        Assume.assumeTrue((String)"Delete files only work for format version 2", (this.formatVersion == 2 ? 1 : 0) != 0);
        ManifestFile manifest = this.writeDeleteManifest(this.formatVersion, 1000L, FILE_A_DELETES, FILE_B_DELETES);
        try (ManifestReader reader = ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)FILE_IO, null);){
            long expectedPos = 0L;
            for (DeleteFile file : reader) {
                Assert.assertEquals((String)"Position should match", (Object)expectedPos, (Object)file.pos());
                Assert.assertEquals((String)"Position from field index should match", (Object)expectedPos, (Object)((BaseFile)file).get(17));
                ++expectedPos;
            }
        }
    }
}

