/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Files;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.Schema;
import org.apache.iceberg.V1Metadata;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.inmemory.InMemoryOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestManifestListVersions {
    private static final String PATH = "s3://bucket/table/m1.avro";
    private static final long LENGTH = 1024L;
    private static final int SPEC_ID = 1;
    private static final long SEQ_NUM = 34L;
    private static final long MIN_SEQ_NUM = 10L;
    private static final long SNAPSHOT_ID = 987134631982734L;
    private static final int ADDED_FILES = 2;
    private static final long ADDED_ROWS = 5292L;
    private static final int EXISTING_FILES = 343;
    private static final long EXISTING_ROWS = 857273L;
    private static final int DELETED_FILES = 1;
    private static final long DELETED_ROWS = 22910L;
    private static final List<ManifestFile.PartitionFieldSummary> PARTITION_SUMMARIES = ImmutableList.of();
    private static final ByteBuffer KEY_METADATA = null;
    private static final ManifestFile TEST_MANIFEST = new GenericManifestFile("s3://bucket/table/m1.avro", 1024L, 1, ManifestContent.DATA, 34L, 10L, Long.valueOf(987134631982734L), 2, 5292L, 343, 857273L, 1, 22910L, PARTITION_SUMMARIES, KEY_METADATA);
    private static final ManifestFile TEST_DELETE_MANIFEST = new GenericManifestFile("s3://bucket/table/m1.avro", 1024L, 1, ManifestContent.DELETES, 34L, 10L, Long.valueOf(987134631982734L), 2, 5292L, 343, 857273L, 1, 22910L, PARTITION_SUMMARIES, KEY_METADATA);
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testV1WriteDeleteManifest() {
        AssertHelpers.assertThrows((String)"Should fail to write a DELETE manifest to v1", IllegalArgumentException.class, (String)"Cannot store delete manifests in a v1 table", () -> this.writeManifestList(TEST_DELETE_MANIFEST, 1));
    }

    @Test
    public void testV1Write() throws IOException {
        ManifestFile manifest = this.writeAndReadManifestList(1);
        Assert.assertEquals((String)"Should not contain sequence number, default to 0", (long)0L, (long)manifest.sequenceNumber());
        Assert.assertEquals((String)"Should not contain min sequence number, default to 0", (long)0L, (long)manifest.minSequenceNumber());
        Assert.assertEquals((String)"Path", (Object)PATH, (Object)manifest.path());
        Assert.assertEquals((String)"Length", (long)1024L, (long)manifest.length());
        Assert.assertEquals((String)"Spec id", (long)1L, (long)manifest.partitionSpecId());
        Assert.assertEquals((String)"Content", (Object)ManifestContent.DATA, (Object)manifest.content());
        Assert.assertEquals((String)"Snapshot id", (long)987134631982734L, (long)manifest.snapshotId());
        Assert.assertEquals((String)"Added files count", (long)2L, (long)manifest.addedFilesCount().intValue());
        Assert.assertEquals((String)"Existing files count", (long)343L, (long)manifest.existingFilesCount().intValue());
        Assert.assertEquals((String)"Deleted files count", (long)1L, (long)manifest.deletedFilesCount().intValue());
        Assert.assertEquals((String)"Added rows count", (long)5292L, (long)manifest.addedRowsCount());
        Assert.assertEquals((String)"Existing rows count", (long)857273L, (long)manifest.existingRowsCount());
        Assert.assertEquals((String)"Deleted rows count", (long)22910L, (long)manifest.deletedRowsCount());
    }

    @Test
    public void testV2Write() throws IOException {
        ManifestFile manifest = this.writeAndReadManifestList(2);
        Assert.assertEquals((String)"Path", (Object)PATH, (Object)manifest.path());
        Assert.assertEquals((String)"Length", (long)1024L, (long)manifest.length());
        Assert.assertEquals((String)"Spec id", (long)1L, (long)manifest.partitionSpecId());
        Assert.assertEquals((String)"Content", (Object)ManifestContent.DATA, (Object)manifest.content());
        Assert.assertEquals((String)"Sequence number", (long)34L, (long)manifest.sequenceNumber());
        Assert.assertEquals((String)"Min sequence number", (long)10L, (long)manifest.minSequenceNumber());
        Assert.assertEquals((String)"Snapshot id", (long)987134631982734L, (long)manifest.snapshotId());
        Assert.assertEquals((String)"Added files count", (long)2L, (long)manifest.addedFilesCount().intValue());
        Assert.assertEquals((String)"Added rows count", (long)5292L, (long)manifest.addedRowsCount());
        Assert.assertEquals((String)"Existing files count", (long)343L, (long)manifest.existingFilesCount().intValue());
        Assert.assertEquals((String)"Existing rows count", (long)857273L, (long)manifest.existingRowsCount());
        Assert.assertEquals((String)"Deleted files count", (long)1L, (long)manifest.deletedFilesCount().intValue());
        Assert.assertEquals((String)"Deleted rows count", (long)22910L, (long)manifest.deletedRowsCount());
    }

    @Test
    public void testV1ForwardCompatibility() throws IOException {
        InputFile manifestList = this.writeManifestList(TEST_MANIFEST, 1);
        GenericData.Record generic = this.readGeneric(manifestList, V1Metadata.MANIFEST_LIST_SCHEMA);
        Assert.assertEquals((String)"Path", (Object)PATH, (Object)generic.get("manifest_path").toString());
        Assert.assertEquals((String)"Length", (Object)1024L, (Object)generic.get("manifest_length"));
        Assert.assertEquals((String)"Spec id", (Object)1, (Object)generic.get("partition_spec_id"));
        Assert.assertEquals((String)"Snapshot id", (long)987134631982734L, (long)((Long)generic.get("added_snapshot_id")));
        Assert.assertEquals((String)"Added files count", (long)2L, (long)((Integer)generic.get("added_data_files_count")).intValue());
        Assert.assertEquals((String)"Existing files count", (long)343L, (long)((Integer)generic.get("existing_data_files_count")).intValue());
        Assert.assertEquals((String)"Deleted files count", (long)1L, (long)((Integer)generic.get("deleted_data_files_count")).intValue());
        Assert.assertEquals((String)"Added rows count", (long)5292L, (long)((Long)generic.get("added_rows_count")));
        Assert.assertEquals((String)"Existing rows count", (long)857273L, (long)((Long)generic.get("existing_rows_count")));
        Assert.assertEquals((String)"Deleted rows count", (long)22910L, (long)((Long)generic.get("deleted_rows_count")));
        AssertHelpers.assertEmptyAvroField((GenericRecord)generic, (String)ManifestFile.MANIFEST_CONTENT.name());
        AssertHelpers.assertEmptyAvroField((GenericRecord)generic, (String)ManifestFile.SEQUENCE_NUMBER.name());
        AssertHelpers.assertEmptyAvroField((GenericRecord)generic, (String)ManifestFile.MIN_SEQUENCE_NUMBER.name());
    }

    @Test
    public void testV2ForwardCompatibility() throws IOException {
        InputFile manifestList = this.writeManifestList(TEST_MANIFEST, 2);
        GenericData.Record generic = this.readGeneric(manifestList, V1Metadata.MANIFEST_LIST_SCHEMA);
        Assert.assertEquals((String)"Path", (Object)PATH, (Object)generic.get("manifest_path").toString());
        Assert.assertEquals((String)"Length", (Object)1024L, (Object)generic.get("manifest_length"));
        Assert.assertEquals((String)"Spec id", (Object)1, (Object)generic.get("partition_spec_id"));
        Assert.assertEquals((String)"Snapshot id", (long)987134631982734L, (long)((Long)generic.get("added_snapshot_id")));
        Assert.assertEquals((String)"Added files count", (long)2L, (long)((Integer)generic.get("added_data_files_count")).intValue());
        Assert.assertEquals((String)"Existing files count", (long)343L, (long)((Integer)generic.get("existing_data_files_count")).intValue());
        Assert.assertEquals((String)"Deleted files count", (long)1L, (long)((Integer)generic.get("deleted_data_files_count")).intValue());
        Assert.assertEquals((String)"Added rows count", (long)5292L, (long)((Long)generic.get("added_rows_count")));
        Assert.assertEquals((String)"Existing rows count", (long)857273L, (long)((Long)generic.get("existing_rows_count")));
        Assert.assertEquals((String)"Deleted rows count", (long)22910L, (long)((Long)generic.get("deleted_rows_count")));
        AssertHelpers.assertEmptyAvroField((GenericRecord)generic, (String)ManifestFile.MANIFEST_CONTENT.name());
        AssertHelpers.assertEmptyAvroField((GenericRecord)generic, (String)ManifestFile.SEQUENCE_NUMBER.name());
        AssertHelpers.assertEmptyAvroField((GenericRecord)generic, (String)ManifestFile.MIN_SEQUENCE_NUMBER.name());
    }

    @Test
    public void testManifestsWithoutRowStats() throws IOException {
        File manifestListFile = this.temp.newFile("manifest-list.avro");
        Assert.assertTrue((boolean)manifestListFile.delete());
        ImmutableList columnNamesWithoutRowStats = ImmutableList.of((Object)"manifest_path", (Object)"manifest_length", (Object)"partition_spec_id", (Object)"added_snapshot_id", (Object)"added_data_files_count", (Object)"existing_data_files_count", (Object)"deleted_data_files_count", (Object)"partitions");
        Schema schemaWithoutRowStats = V1Metadata.MANIFEST_LIST_SCHEMA.select((Collection)columnNamesWithoutRowStats);
        OutputFile outputFile = Files.localOutput((File)manifestListFile);
        try (FileAppender appender = Avro.write((OutputFile)outputFile).schema(schemaWithoutRowStats).named("manifest_file").overwrite().build();){
            org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Schema)schemaWithoutRowStats, (String)"manifest_file");
            GenericData.Record withoutRowStats = new GenericRecordBuilder(avroSchema).set("manifest_path", (Object)"path/to/manifest.avro").set("manifest_length", (Object)1024L).set("partition_spec_id", (Object)1).set("added_snapshot_id", (Object)100L).set("added_data_files_count", (Object)2).set("existing_data_files_count", (Object)3).set("deleted_data_files_count", (Object)4).set("partitions", null).build();
            appender.add((Object)withoutRowStats);
        }
        List files = ManifestLists.read((InputFile)outputFile.toInputFile());
        ManifestFile manifest = (ManifestFile)Iterables.getOnlyElement((Iterable)files);
        Assert.assertTrue((String)"Added files should be present", (boolean)manifest.hasAddedFiles());
        Assert.assertEquals((String)"Added files count should match", (long)2L, (long)manifest.addedFilesCount().intValue());
        Assert.assertNull((String)"Added rows count should be null", (Object)manifest.addedRowsCount());
        Assert.assertTrue((String)"Existing files should be present", (boolean)manifest.hasExistingFiles());
        Assert.assertEquals((String)"Existing files count should match", (long)3L, (long)manifest.existingFilesCount().intValue());
        Assert.assertNull((String)"Existing rows count should be null", (Object)manifest.existingRowsCount());
        Assert.assertTrue((String)"Deleted files should be present", (boolean)manifest.hasDeletedFiles());
        Assert.assertEquals((String)"Deleted files count should match", (long)4L, (long)manifest.deletedFilesCount().intValue());
        Assert.assertNull((String)"Deleted rows count should be null", (Object)manifest.deletedRowsCount());
    }

    @Test
    public void testManifestsPartitionSummary() throws IOException {
        ByteBuffer firstSummaryLowerBound = Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)10);
        ByteBuffer firstSummaryUpperBound = Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)100);
        ByteBuffer secondSummaryLowerBound = Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)20);
        ByteBuffer secondSummaryUpperBound = Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)200);
        ArrayList partitionFieldSummaries = Lists.newArrayList((Object[])new ManifestFile.PartitionFieldSummary[]{new GenericPartitionFieldSummary(false, firstSummaryLowerBound, firstSummaryUpperBound), new GenericPartitionFieldSummary(true, false, secondSummaryLowerBound, secondSummaryUpperBound)});
        GenericManifestFile manifest = new GenericManifestFile(PATH, 1024L, 1, ManifestContent.DATA, 34L, 10L, Long.valueOf(987134631982734L), 2, 5292L, 343, 857273L, 1, 22910L, (List)partitionFieldSummaries, KEY_METADATA);
        InputFile manifestList = this.writeManifestList((ManifestFile)manifest, 2);
        List files = ManifestLists.read((InputFile)manifestList);
        ManifestFile returnedManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)files);
        Assert.assertEquals((String)"Number of partition field summaries should match", (long)2L, (long)returnedManifest.partitions().size());
        ManifestFile.PartitionFieldSummary first = (ManifestFile.PartitionFieldSummary)returnedManifest.partitions().get(0);
        Assert.assertFalse((String)"First partition field summary should not contain null", (boolean)first.containsNull());
        Assert.assertNull((String)"First partition field summary has unknown NaN", (Object)first.containsNaN());
        Assert.assertEquals((String)"Lower bound for first partition field summary should match", (Object)firstSummaryLowerBound, (Object)first.lowerBound());
        Assert.assertEquals((String)"Upper bound for first partition field summary should match", (Object)firstSummaryUpperBound, (Object)first.upperBound());
        ManifestFile.PartitionFieldSummary second = (ManifestFile.PartitionFieldSummary)returnedManifest.partitions().get(1);
        Assert.assertTrue((String)"Second partition field summary should contain null", (boolean)second.containsNull());
        Assert.assertFalse((String)"Second partition field summary should not contain NaN", (boolean)second.containsNaN());
        Assert.assertEquals((String)"Lower bound for second partition field summary should match", (Object)secondSummaryLowerBound, (Object)second.lowerBound());
        Assert.assertEquals((String)"Upper bound for second partition field summary should match", (Object)secondSummaryUpperBound, (Object)second.upperBound());
    }

    private InputFile writeManifestList(ManifestFile manifest, int formatVersion) throws IOException {
        InMemoryOutputFile manifestList = new InMemoryOutputFile();
        try (ManifestListWriter writer = ManifestLists.write((int)formatVersion, (OutputFile)manifestList, (long)987134631982734L, (Long)987134631982733L, (long)(formatVersion > 1 ? 34L : 0L));){
            writer.add((Object)manifest);
        }
        return manifestList.toInputFile();
    }

    private GenericData.Record readGeneric(InputFile manifestList, Schema schema) throws IOException {
        try (AvroIterable files = Avro.read((InputFile)manifestList).project(schema).reuseContainers(false).build();){
            LinkedList records = Lists.newLinkedList((Iterable)files);
            Assert.assertEquals((String)"Should contain one manifest", (long)1L, (long)records.size());
            GenericData.Record record = (GenericData.Record)records.get(0);
            return record;
        }
    }

    private ManifestFile writeAndReadManifestList(int formatVersion) throws IOException {
        List manifests = ManifestLists.read((InputFile)this.writeManifestList(TEST_MANIFEST, formatVersion));
        Assert.assertEquals((String)"Should contain one manifest", (long)1L, (long)manifests.size());
        return (ManifestFile)manifests.get(0);
    }
}

