/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestManifestCleanup
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestManifestCleanup(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testDelete() {
        Assert.assertEquals((String)"Table should start with no manifests", (long)0L, (long)this.listManifestFiles().size());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Table should have one append manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        this.table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        Assert.assertEquals((String)"Table should have one delete manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        this.table.newAppend().commit();
        Assert.assertEquals((String)"Table should have no manifests", (long)0L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
    }

    @Test
    public void testPartialDelete() {
        Assert.assertEquals((String)"Table should start with no manifests", (long)0L, (long)this.listManifestFiles().size());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot s1 = this.table.currentSnapshot();
        Assert.assertEquals((String)"Table should have one append manifest", (long)1L, (long)s1.allManifests(this.table.io()).size());
        this.table.newDelete().deleteFile(FILE_B).commit();
        Snapshot s2 = this.table.currentSnapshot();
        Assert.assertEquals((String)"Table should have one mixed manifest", (long)1L, (long)s2.allManifests(this.table.io()).size());
        this.table.newAppend().commit();
        Snapshot s3 = this.table.currentSnapshot();
        Assert.assertEquals((String)"Table should have the same manifests", (Object)s2.allManifests(this.table.io()), (Object)s3.allManifests(this.table.io()));
    }

    @Test
    public void testOverwrite() {
        Assert.assertEquals((String)"Table should start with no manifests", (long)0L, (long)this.listManifestFiles().size());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Table should have one append manifest", (long)1L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        this.table.newOverwrite().overwriteByRowFilter((Expression)Expressions.alwaysTrue()).addFile(FILE_C).addFile(FILE_D).commit();
        Assert.assertEquals((String)"Table should have one delete manifest and one append manifest", (long)2L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
        this.table.newOverwrite().overwriteByRowFilter((Expression)Expressions.alwaysTrue()).addFile(FILE_A).addFile(FILE_B).commit();
        Assert.assertEquals((String)"Table should have one delete manifest and one append manifest", (long)2L, (long)this.table.currentSnapshot().allManifests(this.table.io()).size());
    }
}

