/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.testing.GcFinalization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.ContentCache;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestManifestCaching {
    static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testPlanWithCache() throws Exception {
        ImmutableMap properties = ImmutableMap.of((Object)"io-impl", (Object)HadoopFileIO.class.getName(), (Object)"io.manifest.cache-enabled", (Object)"true");
        Table table = this.createTable((Map<String, String>)properties);
        ContentCache cache = ManifestFiles.contentCache((FileIO)table.io());
        Assert.assertEquals((long)0L, (long)cache.estimatedCacheSize());
        int numFiles = 4;
        List<DataFile> files16Mb = this.newFiles(numFiles, 0x1000000L);
        this.appendFiles(files16Mb, table);
        TableScan scan1 = (TableScan)table.newScan().option("read.split.target-size", String.valueOf(0x800000));
        Assert.assertEquals((String)"Should get 2 tasks per file", (long)(numFiles * 2), (long)Iterables.size((Iterable)scan1.planTasks()));
        Assert.assertEquals((String)"All manifest files should be cached", (long)numFiles, (long)cache.estimatedCacheSize());
        Assert.assertEquals((String)"All manifest files should be recently loaded", (long)numFiles, (long)cache.stats().loadCount());
        long missCount = cache.stats().missCount();
        TableScan scan2 = table.newScan();
        Assert.assertEquals((String)"Should get 1 tasks per file", (long)numFiles, (long)Iterables.size((Iterable)scan2.planFiles()));
        Assert.assertEquals((String)"Cache size should remain the same", (long)numFiles, (long)cache.estimatedCacheSize());
        Assert.assertEquals((String)"All manifest file reads should hit cache", (long)missCount, (long)cache.stats().missCount());
        ManifestFiles.dropCache((FileIO)table.io());
    }

    @Test
    public void testPlanWithSmallCache() throws Exception {
        ImmutableMap properties = ImmutableMap.of((Object)"io-impl", (Object)HadoopFileIO.class.getName(), (Object)"io.manifest.cache-enabled", (Object)"true", (Object)"io.manifest.cache.max-total-bytes", (Object)"1", (Object)"io.manifest.cache.max-content-length", (Object)"1");
        Table table = this.createTable((Map<String, String>)properties);
        int numFiles = 4;
        List<DataFile> files16Mb = this.newFiles(numFiles, 0x1000000L);
        this.appendFiles(files16Mb, table);
        TableScan scan = table.newScan();
        ContentCache cache = ManifestFiles.contentCache((FileIO)scan.table().io());
        Assert.assertEquals((long)1L, (long)cache.maxContentLength());
        Assert.assertEquals((long)1L, (long)cache.maxTotalBytes());
        Assert.assertEquals((String)"Should get 1 tasks per file", (long)numFiles, (long)Iterables.size((Iterable)scan.planFiles()));
        Assert.assertEquals((String)"Cache should be empty", (long)0L, (long)cache.estimatedCacheSize());
        Assert.assertEquals((String)"File should not be loaded through cache", (long)0L, (long)cache.stats().loadCount());
        Assert.assertEquals((String)"Cache should not serve file", (long)0L, (long)cache.stats().requestCount());
        ManifestFiles.dropCache((FileIO)scan.table().io());
    }

    @Test
    public void testUniqueCache() throws Exception {
        ImmutableMap properties1 = ImmutableMap.of((Object)"io-impl", (Object)HadoopFileIO.class.getName(), (Object)"io.manifest.cache-enabled", (Object)"true");
        Table table1 = this.createTable((Map<String, String>)properties1);
        ImmutableMap properties2 = ImmutableMap.of((Object)"io-impl", (Object)HadoopFileIO.class.getName(), (Object)"io.manifest.cache-enabled", (Object)"true", (Object)"io.manifest.cache.max-total-bytes", (Object)"1", (Object)"io.manifest.cache.max-content-length", (Object)"1");
        Table table2 = this.createTable((Map<String, String>)properties2);
        ContentCache cache1 = ManifestFiles.contentCache((FileIO)table1.io());
        ContentCache cache2 = ManifestFiles.contentCache((FileIO)table2.io());
        ContentCache cache3 = ManifestFiles.contentCache((FileIO)table2.io());
        Assert.assertNotSame((Object)cache1, (Object)cache2);
        Assert.assertSame((Object)cache2, (Object)cache3);
        ManifestFiles.dropCache((FileIO)table1.io());
        ManifestFiles.dropCache((FileIO)table2.io());
    }

    @Test
    public void testRecreateCache() throws Exception {
        ImmutableMap properties = ImmutableMap.of((Object)"io-impl", (Object)HadoopFileIO.class.getName(), (Object)"io.manifest.cache-enabled", (Object)"true");
        Table table = this.createTable((Map<String, String>)properties);
        ContentCache cache1 = ManifestFiles.contentCache((FileIO)table.io());
        ManifestFiles.dropCache((FileIO)table.io());
        ContentCache cache2 = ManifestFiles.contentCache((FileIO)table.io());
        Assert.assertNotSame((Object)cache1, (Object)cache2);
        ManifestFiles.dropCache((FileIO)table.io());
    }

    @Test
    public void testWeakFileIOReferenceCleanUp() {
        Cache manifestCache = ManifestFiles.newManifestCacheBuilder().executor(Runnable::run).build();
        int maxIO = 8;
        FileIO firstIO = null;
        ContentCache firstCache = null;
        for (int i = 0; i < maxIO - 1; ++i) {
            FileIO io = this.cacheEnabledHadoopFileIO();
            ContentCache cache = TestManifestCaching.contentCache((Cache<FileIO, ContentCache>)manifestCache, io);
            if (i != 0) continue;
            firstIO = io;
            firstCache = cache;
        }
        FileIO lastIO = this.cacheEnabledHadoopFileIO();
        ContentCache lastCache = TestManifestCaching.contentCache((Cache<FileIO, ContentCache>)manifestCache, lastIO);
        GcFinalization.awaitDone(() -> {
            manifestCache.cleanUp();
            return manifestCache.estimatedSize() == 2L;
        });
        ContentCache cache1 = TestManifestCaching.contentCache((Cache<FileIO, ContentCache>)manifestCache, firstIO);
        ContentCache cacheN = TestManifestCaching.contentCache((Cache<FileIO, ContentCache>)manifestCache, lastIO);
        Assert.assertSame((Object)firstCache, (Object)cache1);
        Assert.assertSame((Object)lastCache, (Object)cacheN);
        Assert.assertEquals((long)maxIO, (long)manifestCache.stats().loadCount());
        Assert.assertEquals((long)(maxIO - 2), (long)manifestCache.stats().evictionCount());
    }

    private static ContentCache contentCache(Cache<FileIO, ContentCache> manifestCache, FileIO io) {
        return (ContentCache)manifestCache.get((Object)io, fileIO -> new ContentCache(ManifestFiles.cacheDurationMs((FileIO)fileIO), ManifestFiles.cacheTotalBytes((FileIO)fileIO), ManifestFiles.cacheMaxContentLength((FileIO)fileIO)));
    }

    private FileIO cacheEnabledHadoopFileIO() {
        ImmutableMap properties = ImmutableMap.of((Object)"io-impl", (Object)HadoopFileIO.class.getName(), (Object)"io.manifest.cache-enabled", (Object)"true");
        HadoopFileIO io = new HadoopFileIO(new Configuration());
        io.initialize((Map)properties);
        return io;
    }

    private Table createTable(Map<String, String> properties) throws Exception {
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"db", "ns1", "ns2", "tbl"});
        return this.hadoopCatalog(properties).buildTable(tableIdent, SCHEMA).withPartitionSpec(SPEC).create();
    }

    private HadoopCatalog hadoopCatalog(Map<String, String> catalogProperties) throws IOException {
        HadoopCatalog hadoopCatalog = new HadoopCatalog();
        hadoopCatalog.setConf(new Configuration());
        hadoopCatalog.initialize("hadoop", (Map)ImmutableMap.builder().putAll(catalogProperties).put((Object)"warehouse", (Object)this.temp.newFolder().getAbsolutePath()).buildOrThrow());
        return hadoopCatalog;
    }

    private void appendFiles(Iterable<DataFile> files, Table table) {
        for (DataFile file : files) {
            AppendFiles appendFile = table.newAppend();
            appendFile.appendFile(file);
            appendFile.commit();
        }
    }

    private List<DataFile> newFiles(int numFiles, long sizeInBytes) {
        return this.newFiles(numFiles, sizeInBytes, FileFormat.PARQUET, 1);
    }

    private List<DataFile> newFiles(int numFiles, long sizeInBytes, FileFormat fileFormat, int numOffset) {
        ArrayList files = Lists.newArrayList();
        for (int fileNum = 0; fileNum < numFiles; ++fileNum) {
            files.add(this.newFile(sizeInBytes, fileFormat, numOffset));
        }
        return files;
    }

    private DataFile newFile(long sizeInBytes, FileFormat fileFormat, int numOffsets) {
        String fileName = UUID.randomUUID().toString();
        DataFiles.Builder builder = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath(fileFormat.addExtension(fileName)).withFileSizeInBytes(sizeInBytes).withRecordCount(2L);
        if (numOffsets > 1) {
            long stepSize = sizeInBytes / (long)numOffsets;
            List offsets = LongStream.range(0L, numOffsets).map(i -> i * stepSize).boxed().collect(Collectors.toList());
            builder.withSplitOffsets(offsets);
        }
        return builder.build();
    }
}

