/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestLocationProvider
extends TableTestBase {
    @Parameterized.Parameters
    public static Object[][] parameters() {
        return new Object[][]{{1}, {2}};
    }

    public TestLocationProvider(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testDefaultLocationProvider() {
        this.table.updateProperties().commit();
        this.table.locationProvider().newDataLocation("my_file");
        Assert.assertEquals((String)"Default data path should have table location as root", (Object)String.format("%s/data/%s", this.table.location(), "my_file"), (Object)this.table.locationProvider().newDataLocation("my_file"));
    }

    @Test
    public void testDefaultLocationProviderWithCustomDataLocation() {
        this.table.updateProperties().set("write.data.path", "new_location").commit();
        this.table.locationProvider().newDataLocation("my_file");
        Assert.assertEquals((String)"Default location provider should allow custom path location", (Object)"new_location/my_file", (Object)this.table.locationProvider().newDataLocation("my_file"));
    }

    @Test
    public void testNoArgDynamicallyLoadedLocationProvider() {
        String invalidImpl = String.format("%s$%s", this.getClass().getCanonicalName(), NoArgDynamicallyLoadedLocationProvider.class.getSimpleName());
        this.table.updateProperties().set("write.location-provider.impl", invalidImpl).commit();
        Assert.assertEquals((String)"Custom provider should take base table location", (Object)"test_no_arg_provider/my_file", (Object)this.table.locationProvider().newDataLocation("my_file"));
    }

    @Test
    public void testTwoArgDynamicallyLoadedLocationProvider() {
        this.table.updateProperties().set("write.location-provider.impl", String.format("%s$%s", this.getClass().getCanonicalName(), TwoArgDynamicallyLoadedLocationProvider.class.getSimpleName())).commit();
        Assert.assertTrue((String)String.format("Table should load impl defined in its properties", new Object[0]), (boolean)(this.table.locationProvider() instanceof TwoArgDynamicallyLoadedLocationProvider));
        Assert.assertEquals((String)"Custom provider should take base table location", (Object)String.format("%s/test_custom_provider/%s", this.table.location(), "my_file"), (Object)this.table.locationProvider().newDataLocation("my_file"));
    }

    @Test
    public void testDynamicallyLoadedLocationProviderNotFound() {
        String nonExistentImpl = String.format("%s$NonExistent%s", this.getClass().getCanonicalName(), TwoArgDynamicallyLoadedLocationProvider.class.getSimpleName());
        this.table.updateProperties().set("write.location-provider.impl", nonExistentImpl).commit();
        AssertHelpers.assertThrows((String)"Non-existent implementation should fail on finding constructor", IllegalArgumentException.class, (String)String.format("Unable to find a constructor for implementation %s of %s. ", nonExistentImpl, LocationProvider.class), () -> this.table.locationProvider());
    }

    @Test
    public void testInvalidNoInterfaceDynamicallyLoadedLocationProvider() {
        String invalidImpl = String.format("%s$%s", this.getClass().getCanonicalName(), InvalidNoInterfaceDynamicallyLoadedLocationProvider.class.getSimpleName());
        this.table.updateProperties().set("write.location-provider.impl", invalidImpl).commit();
        AssertHelpers.assertThrows((String)"Class with missing interface implementation should fail on instantiation.", IllegalArgumentException.class, (String)String.format("Provided implementation for dynamic instantiation should implement %s", LocationProvider.class), () -> this.table.locationProvider());
    }

    @Test
    public void testInvalidArgTypesDynamicallyLoadedLocationProvider() {
        String invalidImpl = String.format("%s$%s", this.getClass().getCanonicalName(), InvalidArgTypesDynamicallyLoadedLocationProvider.class.getSimpleName());
        this.table.updateProperties().set("write.location-provider.impl", invalidImpl).commit();
        AssertHelpers.assertThrows((String)"Implementation with invalid arg types should fail on finding constructor", IllegalArgumentException.class, (String)String.format("Unable to find a constructor for implementation %s of %s. ", invalidImpl, LocationProvider.class), () -> this.table.locationProvider());
    }

    @Test
    public void testObjectStorageLocationProviderPathResolution() {
        this.table.updateProperties().set("write.object-storage.enabled", "true").commit();
        Assert.assertTrue((String)"default data location should be used when object storage path not set", (boolean)this.table.locationProvider().newDataLocation("file").contains(this.table.location() + "/data"));
        String folderPath = "s3://random/folder/location";
        this.table.updateProperties().set("write.folder-storage.path", folderPath).commit();
        Assert.assertTrue((String)"folder storage path should be used when set", (boolean)this.table.locationProvider().newDataLocation("file").contains(folderPath));
        String objectPath = "s3://random/object/location";
        this.table.updateProperties().set("write.object-storage.path", objectPath).commit();
        Assert.assertTrue((String)"object storage path should be used when set", (boolean)this.table.locationProvider().newDataLocation("file").contains(objectPath));
        String dataPath = "s3://random/data/location";
        this.table.updateProperties().set("write.data.path", dataPath).commit();
        Assert.assertTrue((String)"write data path should be used when set", (boolean)this.table.locationProvider().newDataLocation("file").contains(dataPath));
    }

    @Test
    public void testDefaultStorageLocationProviderPathResolution() {
        this.table.updateProperties().set("write.object-storage.enabled", "false").commit();
        Assert.assertTrue((String)"default data location should be used when object storage path not set", (boolean)this.table.locationProvider().newDataLocation("file").contains(this.table.location() + "/data"));
        String folderPath = "s3://random/folder/location";
        this.table.updateProperties().set("write.folder-storage.path", folderPath).commit();
        Assert.assertTrue((String)"folder storage path should be used when set", (boolean)this.table.locationProvider().newDataLocation("file").contains(folderPath));
        String dataPath = "s3://random/data/location";
        this.table.updateProperties().set("write.data.path", dataPath).commit();
        Assert.assertTrue((String)"write data path should be used when set", (boolean)this.table.locationProvider().newDataLocation("file").contains(dataPath));
    }

    @Test
    public void testObjectStorageWithinTableLocation() {
        this.table.updateProperties().set("write.object-storage.enabled", "true").commit();
        String fileLocation = this.table.locationProvider().newDataLocation("test.parquet");
        String relativeLocation = fileLocation.replaceFirst(this.table.location(), "");
        List parts = Splitter.on((String)"/").splitToList((CharSequence)relativeLocation);
        Assert.assertEquals((String)"Should contain 4 parts", (long)4L, (long)parts.size());
        Assert.assertTrue((String)"First part should be empty", (boolean)((String)parts.get(0)).isEmpty());
        Assert.assertEquals((String)"Second part should be data", (Object)"data", parts.get(1));
        Assert.assertFalse((String)"Third part should be a hash value", (boolean)((String)parts.get(2)).isEmpty());
        Assert.assertEquals((String)"Fourth part should be the file name passed in", (Object)"test.parquet", parts.get(3));
    }

    public static class InvalidNoInterfaceDynamicallyLoadedLocationProvider {
    }

    public static class InvalidArgTypesDynamicallyLoadedLocationProvider
    implements LocationProvider {
        public InvalidArgTypesDynamicallyLoadedLocationProvider(Integer bogusArg1, String bogusArg2) {
        }

        public String newDataLocation(String filename) {
            throw new RuntimeException("Invalid provider should have not been instantiated!");
        }

        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            throw new RuntimeException("Invalid provider should have not been instantiated!");
        }
    }

    public static class NoArgDynamicallyLoadedLocationProvider
    implements LocationProvider {
        public String newDataLocation(String filename) {
            return String.format("test_no_arg_provider/%s", filename);
        }

        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            throw new RuntimeException("Test custom provider does not expect any invocation");
        }
    }

    public static class TwoArgDynamicallyLoadedLocationProvider
    implements LocationProvider {
        String tableLocation;
        Map<String, String> properties;

        public TwoArgDynamicallyLoadedLocationProvider(String tableLocation, Map<String, String> properties) {
            this.tableLocation = tableLocation;
            this.properties = properties;
        }

        public String newDataLocation(String filename) {
            return String.format("%s/test_custom_provider/%s", this.tableLocation, filename);
        }

        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            throw new RuntimeException("Test custom provider does not expect any invocation");
        }
    }
}

