/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.events.IncrementalScanEvent;
import org.apache.iceberg.events.Listener;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIncrementalDataTableScan
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestIncrementalDataTableScan(int formatVersion) {
        super(formatVersion);
    }

    @Before
    public void setupTableProperties() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "3").commit();
    }

    @Test
    public void testInvalidScans() {
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("A"));
        AssertHelpers.assertThrows((String)"from and to snapshots cannot be the same, since from snapshot is exclusive and not part of the scan", IllegalArgumentException.class, (String)"from and to snapshot ids cannot be the same", () -> this.appendsBetweenScan(1L, 1L));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("B"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("C"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("D"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("E"));
        AssertHelpers.assertThrows((String)"Check refinement api", IllegalArgumentException.class, (String)"from snapshot id 1 not in existing snapshot ids range (2, 4]", () -> this.table.newScan().appendsBetween(2L, 5L).appendsBetween(1L, 4L));
        AssertHelpers.assertThrows((String)"Check refinement api", IllegalArgumentException.class, (String)"to snapshot id 3 not in existing snapshot ids range (1, 2]", () -> this.table.newScan().appendsBetween(1L, 2L).appendsBetween(1L, 3L));
    }

    @Test
    public void testAppends() {
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("A"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("B"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("C"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("D"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("E"));
        class MyListener
        implements Listener<IncrementalScanEvent> {
            IncrementalScanEvent lastEvent = null;

            MyListener() {
            }

            public void notify(IncrementalScanEvent event) {
                this.lastEvent = event;
            }

            public IncrementalScanEvent event() {
                return this.lastEvent;
            }
        }
        MyListener listener1 = new MyListener();
        Listeners.register((Listener)listener1, IncrementalScanEvent.class);
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E"}), this.appendsBetweenScan(1L, 5L));
        Assert.assertTrue((listener1.event().fromSnapshotId() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((listener1.event().toSnapshotId() == 5L ? 1 : 0) != 0);
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"C", "D", "E"}), this.appendsBetweenScan(2L, 5L));
        Assert.assertTrue((listener1.event().fromSnapshotId() == 2L ? 1 : 0) != 0);
        Assert.assertTrue((listener1.event().toSnapshotId() == 5L ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.table.schema(), (Object)listener1.event().projection());
        Assert.assertEquals((Object)Expressions.alwaysTrue(), (Object)listener1.event().filter());
        Assert.assertEquals((Object)"test", (Object)listener1.event().tableName());
        Assert.assertEquals((Object)false, (Object)listener1.event().isFromSnapshotInclusive());
    }

    @Test
    public void testReplaceOverwritesDeletes() {
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("A"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("B"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("C"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("D"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("E"));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E"}), this.appendsBetweenScan(1L, 5L));
        TestIncrementalDataTableScan.replace(this.table.newRewrite(), TestIncrementalDataTableScan.files("A", "B", "C"), TestIncrementalDataTableScan.files("F", "G"));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E"}), this.appendsBetweenScan(1L, 6L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"E"}), this.appendsBetweenScan(4L, 6L));
        Assert.assertTrue((String)"Replace commits are ignored", (boolean)this.appendsBetweenScan(5L, 6L).isEmpty());
        TestIncrementalDataTableScan.delete(this.table.newDelete(), TestIncrementalDataTableScan.files("D"));
        Assert.assertTrue((String)"Replace and delete commits are ignored", (boolean)this.appendsBetweenScan(5L, 7L).isEmpty());
        Assert.assertTrue((String)"Delete commits are ignored", (boolean)this.appendsBetweenScan(6L, 7L).isEmpty());
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("I"));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E", "I"}), this.appendsBetweenScan(1L, 8L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"I"}), this.appendsBetweenScan(6L, 8L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"I"}), this.appendsBetweenScan(7L, 8L));
        TestIncrementalDataTableScan.overwrite(this.table.newOverwrite(), TestIncrementalDataTableScan.files("H"), TestIncrementalDataTableScan.files("E"));
        AssertHelpers.assertThrows((String)"Overwrites are not supported for Incremental scan", UnsupportedOperationException.class, (String)"Found overwrite operation, cannot support incremental data in snapshots (8, 9]", () -> this.appendsBetweenScan(8L, 9L));
    }

    @Test
    public void testTransactions() {
        Transaction transaction = this.table.newTransaction();
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("A"));
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("B"));
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("C"));
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("D"));
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("E"));
        transaction.commitTransaction();
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E"}), this.appendsBetweenScan(1L, 5L));
        transaction = this.table.newTransaction();
        TestIncrementalDataTableScan.replace(transaction.newRewrite(), TestIncrementalDataTableScan.files("A", "B", "C"), TestIncrementalDataTableScan.files("F", "G"));
        transaction.commitTransaction();
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E"}), this.appendsBetweenScan(1L, 6L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"E"}), this.appendsBetweenScan(4L, 6L));
        Assert.assertTrue((String)"Replace commits are ignored", (boolean)this.appendsBetweenScan(5L, 6L).isEmpty());
        transaction = this.table.newTransaction();
        TestIncrementalDataTableScan.delete(transaction.newDelete(), TestIncrementalDataTableScan.files("D"));
        transaction.commitTransaction();
        Assert.assertTrue((String)"Replace and delete commits are ignored", (boolean)this.appendsBetweenScan(5L, 7L).isEmpty());
        Assert.assertTrue((String)"Delete commits are ignored", (boolean)this.appendsBetweenScan(6L, 7L).isEmpty());
        transaction = this.table.newTransaction();
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("I"));
        transaction.commitTransaction();
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "C", "D", "E", "I"}), this.appendsBetweenScan(1L, 8L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"I"}), this.appendsBetweenScan(6L, 8L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"I"}), this.appendsBetweenScan(7L, 8L));
    }

    @Test
    public void testRollbacks() {
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("A"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("B"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("C"));
        this.table.manageSnapshots().rollbackTo(2L).commit();
        Assert.assertEquals((long)2L, (long)this.table.currentSnapshot().snapshotId());
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B"}), this.appendsBetweenScan(1L, 2L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B"}), this.appendsAfterScan(1L));
        Transaction transaction = this.table.newTransaction();
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("D"));
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("E"));
        TestIncrementalDataTableScan.add(transaction.newAppend(), TestIncrementalDataTableScan.files("F"));
        transaction.commitTransaction();
        this.table.manageSnapshots().rollbackTo(5L).commit();
        Assert.assertEquals((long)5L, (long)this.table.currentSnapshot().snapshotId());
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "D", "E"}), this.appendsBetweenScan(1L, 5L));
        TestIncrementalDataTableScan.filesMatch(Lists.newArrayList((Object[])new String[]{"B", "D", "E"}), this.appendsAfterScan(1L));
    }

    @Test
    public void testIgnoreResiduals() throws IOException {
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("A"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("B"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("C"));
        TableScan scan1 = ((TableScan)this.table.newScan().filter((Expression)Expressions.equal((String)"id", (Object)5))).appendsBetween(1L, 3L);
        try (CloseableIterable tasks = scan1.planTasks();){
            Assert.assertTrue((String)"Tasks should not be empty", (com.google.common.collect.Iterables.size((Iterable)tasks) > 0 ? 1 : 0) != 0);
            for (CombinedScanTask combinedScanTask : tasks) {
                for (FileScanTask fileScanTask : combinedScanTask.files()) {
                    Assert.assertNotEquals((String)"Residuals must be preserved", (Object)Expressions.alwaysTrue(), (Object)fileScanTask.residual());
                }
            }
        }
        TableScan scan2 = (TableScan)((TableScan)this.table.newScan().filter((Expression)Expressions.equal((String)"id", (Object)5))).appendsBetween(1L, 3L).ignoreResiduals();
        Object object = null;
        try (CloseableIterable tasks = scan2.planTasks();){
            Assert.assertTrue((String)"Tasks should not be empty", (com.google.common.collect.Iterables.size((Iterable)tasks) > 0 ? 1 : 0) != 0);
            for (CombinedScanTask combinedScanTask : tasks) {
                for (FileScanTask fileScanTask : combinedScanTask.files()) {
                    Assert.assertEquals((String)"Residuals must be ignored", (Object)Expressions.alwaysTrue(), (Object)fileScanTask.residual());
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }

    @Test
    public void testPlanWithExecutor() throws IOException {
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("A"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("B"));
        TestIncrementalDataTableScan.add(this.table.newAppend(), TestIncrementalDataTableScan.files("C"));
        AtomicInteger planThreadsIndex = new AtomicInteger(0);
        TableScan scan = (TableScan)this.table.newScan().appendsAfter(1L).planWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("plan-" + planThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)scan.planFiles()));
        Assert.assertTrue((String)"Thread should be created in provided pool", (planThreadsIndex.get() > 0 ? 1 : 0) != 0);
    }

    private static DataFile file(String name) {
        return DataFiles.builder((PartitionSpec)SPEC).withPath(name + ".parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();
    }

    private static void add(AppendFiles appendFiles, List<DataFile> adds) {
        for (DataFile f : adds) {
            appendFiles.appendFile(f);
        }
        appendFiles.commit();
    }

    private static void delete(DeleteFiles deleteFiles, List<DataFile> deletes) {
        for (DataFile f : deletes) {
            deleteFiles.deleteFile(f);
        }
        deleteFiles.commit();
    }

    private static void replace(RewriteFiles rewriteFiles, List<DataFile> deletes, List<DataFile> adds) {
        rewriteFiles.rewriteFiles((Set)Sets.newHashSet(deletes), (Set)Sets.newHashSet(adds));
        rewriteFiles.commit();
    }

    private static void overwrite(OverwriteFiles overwriteFiles, List<DataFile> adds, List<DataFile> deletes) {
        for (DataFile f : adds) {
            overwriteFiles.addFile(f);
        }
        for (DataFile f : deletes) {
            overwriteFiles.deleteFile(f);
        }
        overwriteFiles.commit();
    }

    private static List<DataFile> files(String ... names) {
        return Lists.transform((List)Lists.newArrayList((Object[])names), TestIncrementalDataTableScan::file);
    }

    private List<String> appendsAfterScan(long fromSnapshotId) {
        TableScan appendsAfter = this.table.newScan().appendsAfter(fromSnapshotId);
        return TestIncrementalDataTableScan.filesToScan(appendsAfter);
    }

    private List<String> appendsBetweenScan(long fromSnapshotId, long toSnapshotId) {
        Snapshot s1 = this.table.snapshot(fromSnapshotId);
        Snapshot s2 = this.table.snapshot(toSnapshotId);
        TableScan appendsBetween = this.table.newScan().appendsBetween(s1.snapshotId(), s2.snapshotId());
        return TestIncrementalDataTableScan.filesToScan(appendsBetween);
    }

    private static List<String> filesToScan(TableScan tableScan) {
        Iterable filesToRead = Iterables.transform((Iterable)tableScan.planFiles(), t -> {
            String path = ((DataFile)t.file()).path().toString();
            return path.split("\\.")[0];
        });
        return Lists.newArrayList((Iterable)filesToRead);
    }

    private static void filesMatch(List<String> expected, List<String> actual) {
        Collections.sort(expected);
        Collections.sort(actual);
        Assert.assertEquals(expected, actual);
    }
}

