/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.junit.Assert;
import org.junit.Test;

public class TestFormatVersions
extends TableTestBase {
    public TestFormatVersions() {
        super(1);
    }

    @Test
    public void testDefaultFormatVersion() {
        Assert.assertEquals((String)"Should default to v1", (long)1L, (long)this.table.ops().current().formatVersion());
    }

    @Test
    public void testFormatVersionUpgrade() {
        TestTables.TestTableOperations ops = this.table.ops();
        TableMetadata base = ops.current();
        ops.commit(base, base.upgradeToFormatVersion(2));
        Assert.assertEquals((String)"Should report v2", (long)2L, (long)ops.current().formatVersion());
    }

    @Test
    public void testFormatVersionDowngrade() {
        TestTables.TestTableOperations ops = this.table.ops();
        TableMetadata base = ops.current();
        ops.commit(base, base.upgradeToFormatVersion(2));
        Assert.assertEquals((String)"Should report v2", (long)2L, (long)ops.current().formatVersion());
        AssertHelpers.assertThrows((String)"Should reject a version downgrade", IllegalArgumentException.class, (String)"Cannot downgrade", () -> ops.current().upgradeToFormatVersion(1));
        Assert.assertEquals((String)"Should report v2", (long)2L, (long)ops.current().formatVersion());
    }

    @Test
    public void testFormatVersionUpgradeNotSupported() {
        TestTables.TestTableOperations ops = this.table.ops();
        TableMetadata base = ops.current();
        AssertHelpers.assertThrows((String)"Should reject an unsupported version upgrade", IllegalArgumentException.class, (String)"Cannot upgrade table to unsupported format version", () -> ops.commit(base, base.upgradeToFormatVersion(3)));
        Assert.assertEquals((String)"Should report v1", (long)1L, (long)ops.current().formatVersion());
    }
}

