/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.FixedSizeSplitScanTaskIterator;
import org.apache.iceberg.MockFileScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class TestFixedSizeSplitScanTaskIterator {
    @Test
    public void testSplits() {
        TestFixedSizeSplitScanTaskIterator.verify(15L, 100L, this.asList(this.asList(0L, 15L), this.asList(15L, 15L), this.asList(30L, 15L), this.asList(45L, 15L), this.asList(60L, 15L), this.asList(75L, 15L), this.asList(90L, 10L)));
        TestFixedSizeSplitScanTaskIterator.verify(10L, 10L, this.asList(this.asList(0L, 10L)));
        TestFixedSizeSplitScanTaskIterator.verify(20L, 10L, this.asList(this.asList(0L, 10L)));
    }

    private static void verify(long splitSize, long fileLen, List<List<Long>> offsetLenPairs) {
        MockFileScanTask mockFileScanTask = new MockFileScanTask(fileLen);
        FixedSizeSplitScanTaskIterator splitTaskIterator = new FixedSizeSplitScanTaskIterator((ScanTask)mockFileScanTask, mockFileScanTask.length(), splitSize, TestFixedSizeSplitScanTaskIterator::createSplitTask);
        ArrayList tasks = Lists.newArrayList((Iterator)splitTaskIterator);
        for (int i = 0; i < tasks.size(); ++i) {
            FileScanTask task = (FileScanTask)tasks.get(i);
            List<Long> split = offsetLenPairs.get(i);
            long offset = split.get(0);
            long length = split.get(1);
            Assert.assertEquals((long)offset, (long)task.start());
            Assert.assertEquals((long)length, (long)task.length());
        }
    }

    private <T> List<T> asList(T ... items) {
        return Lists.newArrayList((Object[])items);
    }

    private static FileScanTask createSplitTask(FileScanTask parentTask, long offset, long length) {
        return new BaseFileScanTask.SplitScanTask(offset, length, parentTask);
    }
}

