/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.Files;
import org.apache.iceberg.FindFiles;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFindFiles
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestFindFiles(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testBasicBehavior() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).collect();
        Assert.assertEquals(this.pathSet(FILE_A, FILE_B), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testWithMetadataMatching() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).withMetadataMatching((Expression)Expressions.startsWith((String)"file_path", (String)"/path/to/data-a")).collect();
        Assert.assertEquals(this.pathSet(FILE_A), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testWithRecordsMatching() {
        this.table.newAppend().appendFile(DataFiles.builder((PartitionSpec)SPEC).withInputFile(Files.localInput((String)"/path/to/data-e.parquet")).withPartitionPath("data_bucket=4").withMetrics(new Metrics(Long.valueOf(3L), null, (Map)ImmutableMap.of((Object)1, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)1)), (Map)ImmutableMap.of((Object)1, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)5)))).build()).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).withRecordsMatching((Expression)Expressions.equal((String)"id", (Object)1)).collect();
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"/path/to/data-e.parquet"}), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testInPartition() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).inPartition(this.table.spec(), (StructLike)StaticDataTask.Row.of((Object[])new Object[]{1})).inPartition(this.table.spec(), (StructLike)StaticDataTask.Row.of((Object[])new Object[]{2})).collect();
        Assert.assertEquals(this.pathSet(FILE_B, FILE_C), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testInPartitions() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).inPartitions(this.table.spec(), new StructLike[]{StaticDataTask.Row.of((Object[])new Object[]{1}), StaticDataTask.Row.of((Object[])new Object[]{2})}).collect();
        Assert.assertEquals(this.pathSet(FILE_B, FILE_C), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testAsOfTimestamp() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        long timestamp = System.currentTimeMillis();
        this.table.newAppend().appendFile(FILE_C).commit();
        this.table.newAppend().appendFile(FILE_D).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).asOfTime(timestamp).collect();
        Assert.assertEquals(this.pathSet(FILE_A, FILE_B), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testSnapshotId() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        long snapshotId = this.table.currentSnapshot().snapshotId();
        this.table.newAppend().appendFile(FILE_D).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).inSnapshot(snapshotId).collect();
        Assert.assertEquals(this.pathSet(FILE_A, FILE_B, FILE_C), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testCaseSensitivity() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C).appendFile(FILE_D).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).caseInsensitive().withMetadataMatching((Expression)Expressions.startsWith((String)"FILE_PATH", (String)"/path/to/data-a")).collect();
        Assert.assertEquals(this.pathSet(FILE_A), this.pathSet((Iterable<DataFile>)files));
    }

    @Test
    public void testIncludeColumnStats() {
        this.table.newAppend().appendFile(FILE_WITH_STATS).commit();
        CloseableIterable files = FindFiles.in((Table)this.table).includeColumnStats().collect();
        DataFile file = (DataFile)files.iterator().next();
        Assert.assertEquals((Object)FILE_WITH_STATS.columnSizes(), (Object)file.columnSizes());
        Assert.assertEquals((Object)FILE_WITH_STATS.valueCounts(), (Object)file.valueCounts());
        Assert.assertEquals((Object)FILE_WITH_STATS.nullValueCounts(), (Object)file.nullValueCounts());
        Assert.assertEquals((Object)FILE_WITH_STATS.nanValueCounts(), (Object)file.nanValueCounts());
        Assert.assertEquals((Object)FILE_WITH_STATS.lowerBounds(), (Object)file.lowerBounds());
        Assert.assertEquals((Object)FILE_WITH_STATS.upperBounds(), (Object)file.upperBounds());
    }

    @Test
    public void testNoSnapshot() {
        CloseableIterable files = FindFiles.in((Table)this.table).collect();
        Assert.assertEquals((long)0L, (long)Sets.newHashSet((Iterable)files).size());
    }

    private Set<String> pathSet(DataFile ... files) {
        return Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(files), file -> file.path().toString()));
    }

    private Set<String> pathSet(Iterable<DataFile> files) {
        return Sets.newHashSet((Iterable)Iterables.transform(files, file -> file.path().toString()));
    }
}

