/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFilterFiles {
    public final int formatVersion;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private final Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    private File tableDir = null;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestFilterFiles(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    @Before
    public void setupTableDir() throws IOException {
        this.tableDir = this.temp.newFolder();
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    @Test
    public void testFilterFilesUnpartitionedTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        this.testFilterFiles((Table)table);
    }

    @Test
    public void testCaseInsensitiveFilterFilesUnpartitionedTable() {
        PartitionSpec spec = PartitionSpec.unpartitioned();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        this.testCaseInsensitiveFilterFiles((Table)table);
    }

    @Test
    public void testFilterFilesPartitionedTable() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.schema).bucket("data", 16).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        this.testFilterFiles((Table)table);
    }

    @Test
    public void testCaseInsensitiveFilterFilesPartitionedTable() {
        PartitionSpec spec = PartitionSpec.builderFor((Schema)this.schema).bucket("data", 16).build();
        TestTables.TestTable table = TestTables.create(this.tableDir, "test", this.schema, spec, this.formatVersion);
        this.testCaseInsensitiveFilterFiles((Table)table);
    }

    private void testFilterFiles(Table table) {
        HashMap lowerBounds = Maps.newHashMap();
        HashMap upperBounds = Maps.newHashMap();
        lowerBounds.put(1, Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)1));
        upperBounds.put(1, Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)2));
        Metrics metrics = new Metrics(Long.valueOf(2L), (Map)Maps.newHashMap(), (Map)Maps.newHashMap(), (Map)Maps.newHashMap(), null, (Map)lowerBounds, (Map)upperBounds);
        DataFile file = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/file.parquet").withFileSizeInBytes(0L).withMetrics(metrics).build();
        table.newAppend().appendFile(file).commit();
        table.refresh();
        TableScan emptyScan = (TableScan)table.newScan().filter((Expression)Expressions.equal((String)"id", (Object)5));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)emptyScan.planFiles()));
        TableScan nonEmptyScan = (TableScan)table.newScan().filter((Expression)Expressions.equal((String)"id", (Object)1));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nonEmptyScan.planFiles()));
    }

    private void testCaseInsensitiveFilterFiles(Table table) {
        HashMap lowerBounds = Maps.newHashMap();
        HashMap upperBounds = Maps.newHashMap();
        lowerBounds.put(1, Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)1));
        upperBounds.put(1, Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)2));
        Metrics metrics = new Metrics(Long.valueOf(2L), (Map)Maps.newHashMap(), (Map)Maps.newHashMap(), (Map)Maps.newHashMap(), null, (Map)lowerBounds, (Map)upperBounds);
        DataFile file = DataFiles.builder((PartitionSpec)table.spec()).withPath("/path/to/file.parquet").withFileSizeInBytes(0L).withMetrics(metrics).build();
        table.newAppend().appendFile(file).commit();
        table.refresh();
        TableScan emptyScan = (TableScan)((TableScan)table.newScan().caseSensitive(false)).filter((Expression)Expressions.equal((String)"ID", (Object)5));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)emptyScan.planFiles()));
        TableScan nonEmptyScan = (TableScan)((TableScan)table.newScan().caseSensitive(false)).filter((Expression)Expressions.equal((String)"ID", (Object)1));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)nonEmptyScan.planFiles()));
    }
}

