/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFastAppend
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestFastAppend(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testEmptyTableAppend() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Table should start with last-sequence-number 0", (long)0L, (long)base.lastSequenceNumber());
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot snap = this.table.currentSnapshot();
        this.validateSnapshot(base.currentSnapshot(), snap, 1L, new DataFile[]{FILE_A, FILE_B});
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
    }

    @Test
    public void testEmptyTableAppendManifest() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Table should start with last-sequence-number 0", (long)0L, (long)base.lastSequenceNumber());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        this.table.newFastAppend().appendManifest(manifest).commit();
        Snapshot snap = this.table.currentSnapshot();
        this.validateSnapshot(base.currentSnapshot(), snap, 1L, new DataFile[]{FILE_A, FILE_B});
        Assert.assertEquals((String)"Summary metadata should include 2 added files", (Object)"2", snap.summary().get("added-data-files"));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
    }

    @Test
    public void testEmptyTableAppendFilesAndManifest() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        Assert.assertEquals((String)"Table should start with last-sequence-number 0", (long)0L, (long)base.lastSequenceNumber());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        this.table.newFastAppend().appendFile(FILE_C).appendFile(FILE_D).appendManifest(manifest).commit();
        Snapshot snap = this.table.currentSnapshot();
        long commitId = snap.snapshotId();
        this.validateManifest((ManifestFile)snap.allManifests(FILE_IO).get(0), TestFastAppend.dataSeqs(1L, 1L), TestFastAppend.fileSeqs(1L, 1L), TestFastAppend.ids(commitId, commitId), TestFastAppend.files(FILE_C, FILE_D));
        this.validateManifest((ManifestFile)snap.allManifests(FILE_IO).get(1), TestFastAppend.dataSeqs(1L, 1L), TestFastAppend.fileSeqs(1L, 1L), TestFastAppend.ids(commitId, commitId), TestFastAppend.files(FILE_A, FILE_B));
        this.V2Assert.assertEquals("Snapshot sequence number should be 1", 1L, snap.sequenceNumber());
        this.V2Assert.assertEquals("Last sequence number should be 1", 1L, this.readMetadata().lastSequenceNumber());
        this.V1Assert.assertEquals("Table should end with last-sequence-number 0", 0L, base.lastSequenceNumber());
    }

    @Test
    public void testNonEmptyTableAppend() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        TableMetadata base = this.readMetadata();
        Assert.assertNotNull((String)"Should have a current snapshot", (Object)base.currentSnapshot());
        List v2manifests = base.currentSnapshot().allManifests(FILE_IO);
        Assert.assertEquals((String)"Should have one existing manifest", (long)1L, (long)v2manifests.size());
        Snapshot pending = (Snapshot)this.table.newFastAppend().appendFile(FILE_C).appendFile(FILE_D).apply();
        Assert.assertNotEquals((String)"Snapshots should have unique IDs", (long)base.currentSnapshot().snapshotId(), (long)pending.snapshotId());
        this.validateSnapshot(base.currentSnapshot(), pending, FILE_C, FILE_D);
    }

    @Test
    public void testNoMerge() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        TableMetadata base = this.readMetadata();
        Assert.assertNotNull((String)"Should have a current snapshot", (Object)base.currentSnapshot());
        List v3manifests = base.currentSnapshot().allManifests(FILE_IO);
        Assert.assertEquals((String)"Should have 2 existing manifests", (long)2L, (long)v3manifests.size());
        Snapshot pending = (Snapshot)this.table.newFastAppend().appendFile(FILE_C).appendFile(FILE_D).apply();
        HashSet ids = Sets.newHashSet();
        for (Snapshot snapshot : base.snapshots()) {
            ids.add(snapshot.snapshotId());
        }
        ids.add(pending.snapshotId());
        Assert.assertEquals((String)"Snapshots should have 3 unique IDs", (long)3L, (long)ids.size());
        this.validateSnapshot(base.currentSnapshot(), pending, FILE_C, FILE_D);
    }

    @Test
    public void testRefreshBeforeApply() {
        TestTables.TestTable stale = this.load();
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Assert.assertNotNull((String)"Should have a current snapshot", (Object)base.currentSnapshot());
        List v2manifests = base.currentSnapshot().allManifests(FILE_IO);
        Assert.assertEquals((String)"Should have 1 existing manifest", (long)1L, (long)v2manifests.size());
        AppendFiles append = stale.newFastAppend().appendFile(FILE_D);
        Snapshot pending = (Snapshot)append.apply();
        this.validateSnapshot(base.currentSnapshot(), pending, FILE_D);
    }

    @Test
    public void testRefreshBeforeCommit() {
        AppendFiles append = this.table.newFastAppend().appendFile(FILE_D);
        Snapshot pending = (Snapshot)append.apply();
        this.validateSnapshot(null, pending, FILE_D);
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.readMetadata();
        Assert.assertNotNull((String)"Should have a current snapshot", (Object)base.currentSnapshot());
        List v2manifests = base.currentSnapshot().allManifests(FILE_IO);
        Assert.assertEquals((String)"Should have 1 existing manifest", (long)1L, (long)v2manifests.size());
        append.commit();
        TableMetadata committed = this.readMetadata();
        this.validateSnapshot(base.currentSnapshot(), committed.currentSnapshot(), FILE_D);
        ArrayList committedManifests = Lists.newArrayList((Iterable)committed.currentSnapshot().allManifests(FILE_IO));
        committedManifests.removeAll(base.currentSnapshot().allManifests(FILE_IO));
        Assert.assertEquals((String)"Should reused manifest created by apply", pending.allManifests(FILE_IO).get(0), committedManifests.get(0));
    }

    @Test
    public void testFailure() {
        TestTables.TestTableOperations ops = this.table.ops();
        ops.failCommits(5);
        AppendFiles append = this.table.newFastAppend().appendFile(FILE_B);
        Snapshot pending = (Snapshot)append.apply();
        ManifestFile newManifest = (ManifestFile)pending.allManifests(FILE_IO).get(0);
        Assert.assertTrue((String)"Should create new manifest", (boolean)new File(newManifest.path()).exists());
        AssertHelpers.assertThrows((String)"Should retry 4 times and throw last failure", CommitFailedException.class, (String)"Injected failure", () -> ((AppendFiles)append).commit());
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(newManifest.path()).exists());
    }

    @Test
    public void testAppendManifestCleanup() throws IOException {
        TestTables.TestTableOperations ops = this.table.ops();
        ops.failCommits(5);
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        AppendFiles append = this.table.newFastAppend().appendManifest(manifest);
        Snapshot pending = (Snapshot)append.apply();
        ManifestFile newManifest = (ManifestFile)pending.allManifests(FILE_IO).get(0);
        Assert.assertTrue((String)"Should create new manifest", (boolean)new File(newManifest.path()).exists());
        AssertHelpers.assertThrows((String)"Should retry 4 times and throw last failure", CommitFailedException.class, (String)"Injected failure", () -> ((AppendFiles)append).commit());
        Assert.assertFalse((String)"Should clean up new manifest", (boolean)new File(newManifest.path()).exists());
    }

    @Test
    public void testRecoveryWithManifestList() {
        this.table.updateProperties().set("write.manifest-lists.enabled", "true").commit();
        TestTables.TestTableOperations ops = this.table.ops();
        ops.failCommits(3);
        AppendFiles append = this.table.newFastAppend().appendFile(FILE_B);
        Snapshot pending = (Snapshot)append.apply();
        ManifestFile newManifest = (ManifestFile)pending.allManifests(FILE_IO).get(0);
        Assert.assertTrue((String)"Should create new manifest", (boolean)new File(newManifest.path()).exists());
        append.commit();
        TableMetadata metadata = this.readMetadata();
        this.validateSnapshot(null, metadata.currentSnapshot(), FILE_B);
        Assert.assertTrue((String)"Should commit same new manifest", (boolean)new File(newManifest.path()).exists());
        Assert.assertTrue((String)"Should commit the same new manifest", (boolean)metadata.currentSnapshot().allManifests(FILE_IO).contains(newManifest));
    }

    @Test
    public void testRecoveryWithoutManifestList() {
        this.table.updateProperties().set("write.manifest-lists.enabled", "false").commit();
        TestTables.TestTableOperations ops = this.table.ops();
        ops.failCommits(3);
        AppendFiles append = this.table.newFastAppend().appendFile(FILE_B);
        Snapshot pending = (Snapshot)append.apply();
        ManifestFile newManifest = (ManifestFile)pending.allManifests(FILE_IO).get(0);
        Assert.assertTrue((String)"Should create new manifest", (boolean)new File(newManifest.path()).exists());
        append.commit();
        TableMetadata metadata = this.readMetadata();
        this.validateSnapshot(null, metadata.currentSnapshot(), FILE_B);
        Assert.assertTrue((String)"Should commit same new manifest", (boolean)new File(newManifest.path()).exists());
        Assert.assertTrue((String)"Should commit the same new manifest", (boolean)metadata.currentSnapshot().allManifests(FILE_IO).contains(newManifest));
    }

    @Test
    public void testAppendManifestWithSnapshotIdInheritance() throws IOException {
        this.table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        this.table.newFastAppend().appendManifest(manifest).commit();
        Snapshot snapshot = this.table.currentSnapshot();
        List manifests = this.table.currentSnapshot().allManifests(FILE_IO);
        Assert.assertEquals((String)"Should have 1 committed manifest", (long)1L, (long)manifests.size());
        TestFastAppend.validateManifestEntries((ManifestFile)manifests.get(0), TestFastAppend.ids(snapshot.snapshotId(), snapshot.snapshotId()), TestFastAppend.files(FILE_A, FILE_B), TestFastAppend.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Assert.assertEquals((String)"Summary metadata should include 2 added files", (Object)"2", snapshot.summary().get("added-data-files"));
        Assert.assertEquals((String)"Summary metadata should include 2 added records", (Object)"2", snapshot.summary().get("added-records"));
        Assert.assertEquals((String)"Summary metadata should include 2 files in total", (Object)"2", snapshot.summary().get("total-data-files"));
        Assert.assertEquals((String)"Summary metadata should include 2 records in total", (Object)"2", snapshot.summary().get("total-records"));
    }

    @Test
    public void testAppendManifestFailureWithSnapshotIdInheritance() throws IOException {
        this.table.updateProperties().set("compatibility.snapshot-id-inheritance.enabled", "true").commit();
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        this.table.updateProperties().set("commit.retry.num-retries", "1").commit();
        this.table.ops().failCommits(5);
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        AppendFiles append = this.table.newAppend();
        append.appendManifest(manifest);
        AssertHelpers.assertThrows((String)"Should reject commit", CommitFailedException.class, (String)"Injected failure", () -> ((AppendFiles)append).commit());
        Assert.assertTrue((String)"Append manifest should not be deleted", (boolean)new File(manifest.path()).exists());
    }

    @Test
    public void testInvalidAppendManifest() throws IOException {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        TableMetadata base = this.readMetadata();
        Assert.assertNull((String)"Should not have a current snapshot", (Object)base.currentSnapshot());
        ManifestFile manifestWithExistingFiles = this.writeManifest("manifest-file-1.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, null, FILE_A));
        AssertHelpers.assertThrows((String)"Should reject commit", IllegalArgumentException.class, (String)"Cannot append manifest with existing files", () -> this.table.newFastAppend().appendManifest(manifestWithExistingFiles).commit());
        ManifestFile manifestWithDeletedFiles = this.writeManifest("manifest-file-2.avro", this.manifestEntry(ManifestEntry.Status.DELETED, null, FILE_A));
        AssertHelpers.assertThrows((String)"Should reject commit", IllegalArgumentException.class, (String)"Cannot append manifest with deleted files", () -> this.table.newFastAppend().appendManifest(manifestWithDeletedFiles).commit());
    }

    @Test
    public void testPartitionSummariesOnUnpartitionedTable() {
        TestTables.TestTable table = TestTables.create(this.tableDir, "x", SCHEMA, PartitionSpec.unpartitioned(), SortOrder.unsorted(), this.formatVersion);
        table.updateProperties().set("write.summary.partition-limit", "1").commit();
        table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build()).commit();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)table.currentSnapshot().summary().keySet().stream().filter(key -> key.startsWith("partitions.")).collect(Collectors.toSet())).as("Should not include any partition summaries", new Object[0])).isEmpty();
    }

    @Test
    public void testDefaultPartitionSummaries() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Set partitionSummaryKeys = this.table.currentSnapshot().summary().keySet().stream().filter(key -> key.startsWith("partitions.")).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should include no partition summaries by default", (long)0L, (long)partitionSummaryKeys.size());
        String summariesIncluded = this.table.currentSnapshot().summary().getOrDefault("partition-summaries-included", "false");
        Assert.assertEquals((String)"Should not set partition-summaries-included to true", (Object)"false", (Object)summariesIncluded);
        String changedPartitions = (String)this.table.currentSnapshot().summary().get("changed-partition-count");
        Assert.assertEquals((String)"Should set changed partition count", (Object)"1", (Object)changedPartitions);
    }

    @Test
    public void testIncludedPartitionSummaries() {
        this.table.updateProperties().set("write.summary.partition-limit", "1").commit();
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Set partitionSummaryKeys = this.table.currentSnapshot().summary().keySet().stream().filter(key -> key.startsWith("partitions.")).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should include a partition summary", (long)1L, (long)partitionSummaryKeys.size());
        String summariesIncluded = this.table.currentSnapshot().summary().getOrDefault("partition-summaries-included", "false");
        Assert.assertEquals((String)"Should set partition-summaries-included to true", (Object)"true", (Object)summariesIncluded);
        String changedPartitions = (String)this.table.currentSnapshot().summary().get("changed-partition-count");
        Assert.assertEquals((String)"Should set changed partition count", (Object)"1", (Object)changedPartitions);
        String partitionSummary = (String)this.table.currentSnapshot().summary().get("partitions.data_bucket=0");
        Assert.assertEquals((String)"Summary should include 1 file with 1 record that is 10 bytes", (Object)"added-data-files=1,added-records=1,added-files-size=10", (Object)partitionSummary);
    }

    @Test
    public void testIncludedPartitionSummaryLimit() {
        this.table.updateProperties().set("write.summary.partition-limit", "1").commit();
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Set partitionSummaryKeys = this.table.currentSnapshot().summary().keySet().stream().filter(key -> key.startsWith("partitions.")).collect(Collectors.toSet());
        Assert.assertEquals((String)"Should include no partition summaries, over limit", (long)0L, (long)partitionSummaryKeys.size());
        String summariesIncluded = this.table.currentSnapshot().summary().getOrDefault("partition-summaries-included", "false");
        Assert.assertEquals((String)"Should not set partition-summaries-included to true", (Object)"false", (Object)summariesIncluded);
        String changedPartitions = (String)this.table.currentSnapshot().summary().get("changed-partition-count");
        Assert.assertEquals((String)"Should set changed partition count", (Object)"2", (Object)changedPartitions);
    }

    @Test
    public void testAppendToExistingBranch() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.manageSnapshots().createBranch("branch", this.table.currentSnapshot().snapshotId()).commit();
        ((AppendFiles)this.table.newFastAppend().appendFile(FILE_B).toBranch("branch")).commit();
        int branchSnapshot = 2;
        Assert.assertEquals((long)this.table.currentSnapshot().snapshotId(), (long)1L);
        Assert.assertEquals((long)this.table.ops().current().ref("branch").snapshotId(), (long)branchSnapshot);
    }

    @Test
    public void testAppendCreatesBranchIfNeeded() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        ((AppendFiles)this.table.newFastAppend().appendFile(FILE_B).toBranch("branch")).commit();
        int branchSnapshot = 2;
        Assert.assertEquals((long)this.table.currentSnapshot().snapshotId(), (long)1L);
        Assert.assertNotNull((Object)this.table.ops().current().ref("branch"));
        Assert.assertEquals((long)this.table.ops().current().ref("branch").snapshotId(), (long)branchSnapshot);
    }

    @Test
    public void testAppendToBranchEmptyTable() {
        ((AppendFiles)this.table.newFastAppend().appendFile(FILE_B).toBranch("branch")).commit();
        int branchSnapshot = 1;
        Assert.assertNull((Object)this.table.currentSnapshot());
        Assert.assertNotNull((Object)this.table.ops().current().ref("branch"));
        Assert.assertEquals((long)this.table.ops().current().ref("branch").snapshotId(), (long)branchSnapshot);
    }

    @Test
    public void testAppendToNullBranchFails() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            AppendFiles cfr_ignored_0 = (AppendFiles)this.table.newFastAppend().appendFile(FILE_A).toBranch(null);
        }).as("Invalid branch", new Object[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid branch name: null");
    }

    @Test
    public void testAppendToTagFails() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.manageSnapshots().createTag("some-tag", this.table.currentSnapshot().snapshotId()).commit();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((AppendFiles)this.table.newFastAppend().appendFile(FILE_A).toBranch("some-tag")).commit()).as("Invalid branch", new Object[0])).isInstanceOf(IllegalArgumentException.class)).hasMessage("some-tag is a tag, not a branch. Tags cannot be targets for producing snapshots");
    }
}

